// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ShareACL The permissions that users and groups have on a CIFS share.
//
// swagger:model share_acl
type ShareACL struct {

	// links
	Links *ShareACLInlineLinks `json:"_links,omitempty"`

	// Specifies the access rights that a user or group has on the defined CIFS Share.
	// The following values are allowed:
	// * no_access    - User does not have CIFS share access
	// * read         - User has only read access
	// * change       - User has change access
	// * full_control - User has full_control access
	//
	// Enum: ["no_access","read","change","full_control"]
	Permission *string `json:"permission,omitempty"`

	// Specifies the type of the user or group to add to the access control
	// list of a CIFS share. The following values are allowed:
	// * windows    - Windows user or group
	// * unix_user  - UNIX user
	// * unix_group - UNIX group
	//
	// Enum: ["windows","unix_user","unix_group"]
	Type *string `json:"type,omitempty"`

	// Specifies the user or group name to add to the access control list of a CIFS share.
	// Example: ENGDOMAIN\\ad_user
	UserOrGroup *string `json:"user_or_group,omitempty"`

	// Windows SID/UNIX ID depending on access-control type.
	WinSidUnixID *string `json:"win_sid_unix_id,omitempty"`
}

// Validate validates this share acl
func (m *ShareACL) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShareACL) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var shareAclTypePermissionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_access","read","change","full_control"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shareAclTypePermissionPropEnum = append(shareAclTypePermissionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// share_acl
	// ShareACL
	// permission
	// Permission
	// no_access
	// END DEBUGGING
	// ShareACLPermissionNoAccess captures enum value "no_access"
	ShareACLPermissionNoAccess string = "no_access"

	// BEGIN DEBUGGING
	// share_acl
	// ShareACL
	// permission
	// Permission
	// read
	// END DEBUGGING
	// ShareACLPermissionRead captures enum value "read"
	ShareACLPermissionRead string = "read"

	// BEGIN DEBUGGING
	// share_acl
	// ShareACL
	// permission
	// Permission
	// change
	// END DEBUGGING
	// ShareACLPermissionChange captures enum value "change"
	ShareACLPermissionChange string = "change"

	// BEGIN DEBUGGING
	// share_acl
	// ShareACL
	// permission
	// Permission
	// full_control
	// END DEBUGGING
	// ShareACLPermissionFullControl captures enum value "full_control"
	ShareACLPermissionFullControl string = "full_control"
)

// prop value enum
func (m *ShareACL) validatePermissionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shareAclTypePermissionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShareACL) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(m.Permission) { // not required
		return nil
	}

	// value enum
	if err := m.validatePermissionEnum("permission", "body", *m.Permission); err != nil {
		return err
	}

	return nil
}

var shareAclTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["windows","unix_user","unix_group"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shareAclTypeTypePropEnum = append(shareAclTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// share_acl
	// ShareACL
	// type
	// Type
	// windows
	// END DEBUGGING
	// ShareACLTypeWindows captures enum value "windows"
	ShareACLTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// share_acl
	// ShareACL
	// type
	// Type
	// unix_user
	// END DEBUGGING
	// ShareACLTypeUnixUser captures enum value "unix_user"
	ShareACLTypeUnixUser string = "unix_user"

	// BEGIN DEBUGGING
	// share_acl
	// ShareACL
	// type
	// Type
	// unix_group
	// END DEBUGGING
	// ShareACLTypeUnixGroup captures enum value "unix_group"
	ShareACLTypeUnixGroup string = "unix_group"
)

// prop value enum
func (m *ShareACL) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shareAclTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShareACL) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this share acl based on the context it is used
func (m *ShareACL) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShareACL) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShareACL) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShareACL) UnmarshalBinary(b []byte) error {
	var res ShareACL
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShareACLInlineLinks share acl inline links
//
// swagger:model share_acl_inline__links
type ShareACLInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this share acl inline links
func (m *ShareACLInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShareACLInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this share acl inline links based on the context it is used
func (m *ShareACLInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShareACLInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShareACLInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShareACLInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShareACLInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
