// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Shelf shelf
//
// swagger:model shelf
type Shelf struct {

	// connection type
	// Example: sas
	// Read Only: true
	// Enum: ["unknown","fc","sas","nvme"]
	ConnectionType *string `json:"connection_type,omitempty"`

	// disk count
	// Example: 12
	// Read Only: true
	DiskCount *int64 `json:"disk_count,omitempty"`

	// id
	// Example: 1
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// internal
	// Read Only: true
	Internal *bool `json:"internal,omitempty"`

	// local
	// Read Only: true
	Local *bool `json:"local,omitempty"`

	// location led
	// Example: off
	// Enum: ["off","on","unsupported"]
	LocationLed *string `json:"location_led,omitempty"`

	// manufacturer
	Manufacturer *ShelfInlineManufacturer `json:"manufacturer,omitempty"`

	// model
	// Example: DS2246
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// module type
	// Example: iom6
	// Read Only: true
	// Enum: ["unknown","iom6","iom6e","iom12","iom12b","iom12c","iom12e","iom12f","iom12g","nsm100","nsm8e","nsm16e","psm3e","nsm100b","nsm140"]
	ModuleType *string `json:"module_type,omitempty"`

	// name
	// Example: 1.1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Raw capacity of drives in shelf in 4k blocks
	// Example: 5157308772
	// Read Only: true
	RawCapacity *int64 `json:"raw_capacity,omitempty"`

	// serial number
	// Example: SHFMS1514000895
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// Alternate Control Paths to ACP processors/functions in shelf modules and expanders
	// Read Only: true
	ShelfInlineAcps []*ShelfInlineAcpsInlineArrayItem `json:"acps,omitempty"`

	// shelf inline bays
	ShelfInlineBays []*ShelfInlineBaysInlineArrayItem `json:"bays,omitempty"`

	// shelf inline current sensors
	// Read Only: true
	ShelfInlineCurrentSensors []*ShelfInlineCurrentSensorsInlineArrayItem `json:"current_sensors,omitempty"`

	// shelf inline drawers
	// Read Only: true
	ShelfInlineDrawers []*ShelfInlineDrawersInlineArrayItem `json:"drawers,omitempty"`

	// shelf inline errors
	ShelfInlineErrors []*ShelfInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// shelf inline fans
	// Read Only: true
	ShelfInlineFans []*ShelfInlineFansInlineArrayItem `json:"fans,omitempty"`

	// shelf inline frus
	// Read Only: true
	ShelfInlineFrus []*ShelfInlineFrusInlineArrayItem `json:"frus,omitempty"`

	// shelf inline paths
	// Read Only: true
	ShelfInlinePaths []*ShelfInlinePathsInlineArrayItem `json:"paths,omitempty"`

	// shelf inline ports
	ShelfInlinePorts []*ShelfInlinePortsInlineArrayItem `json:"ports,omitempty"`

	// shelf inline temperature sensors
	// Read Only: true
	ShelfInlineTemperatureSensors []*ShelfInlineTemperatureSensorsInlineArrayItem `json:"temperature_sensors,omitempty"`

	// shelf inline voltage sensors
	// Read Only: true
	ShelfInlineVoltageSensors []*ShelfInlineVoltageSensorsInlineArrayItem `json:"voltage_sensors,omitempty"`

	// state
	// Example: ok
	// Read Only: true
	// Enum: ["unknown","ok","error"]
	State *string `json:"state,omitempty"`

	// uid
	// Example: 7777841915827391056
	// Read Only: true
	UID *string `json:"uid,omitempty"`

	// vendor
	Vendor *ShelfInlineVendor `json:"vendor,omitempty"`
}

// Validate validates this shelf
func (m *Shelf) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConnectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocationLed(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateManufacturer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateModuleType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineAcps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineBays(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineCurrentSensors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineDrawers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineFans(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineFrus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlinePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlinePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineTemperatureSensors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelfInlineVoltageSensors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVendor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfTypeConnectionTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","fc","sas","nvme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfTypeConnectionTypePropEnum = append(shelfTypeConnectionTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// connection_type
	// ConnectionType
	// unknown
	// END DEBUGGING
	// ShelfConnectionTypeUnknown captures enum value "unknown"
	ShelfConnectionTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// connection_type
	// ConnectionType
	// fc
	// END DEBUGGING
	// ShelfConnectionTypeFc captures enum value "fc"
	ShelfConnectionTypeFc string = "fc"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// connection_type
	// ConnectionType
	// sas
	// END DEBUGGING
	// ShelfConnectionTypeSas captures enum value "sas"
	ShelfConnectionTypeSas string = "sas"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// connection_type
	// ConnectionType
	// nvme
	// END DEBUGGING
	// ShelfConnectionTypeNvme captures enum value "nvme"
	ShelfConnectionTypeNvme string = "nvme"
)

// prop value enum
func (m *Shelf) validateConnectionTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfTypeConnectionTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Shelf) validateConnectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectionType) { // not required
		return nil
	}

	// value enum
	if err := m.validateConnectionTypeEnum("connection_type", "body", *m.ConnectionType); err != nil {
		return err
	}

	return nil
}

var shelfTypeLocationLedPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["off","on","unsupported"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfTypeLocationLedPropEnum = append(shelfTypeLocationLedPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// location_led
	// LocationLed
	// off
	// END DEBUGGING
	// ShelfLocationLedOff captures enum value "off"
	ShelfLocationLedOff string = "off"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// location_led
	// LocationLed
	// on
	// END DEBUGGING
	// ShelfLocationLedOn captures enum value "on"
	ShelfLocationLedOn string = "on"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// location_led
	// LocationLed
	// unsupported
	// END DEBUGGING
	// ShelfLocationLedUnsupported captures enum value "unsupported"
	ShelfLocationLedUnsupported string = "unsupported"
)

// prop value enum
func (m *Shelf) validateLocationLedEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfTypeLocationLedPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Shelf) validateLocationLed(formats strfmt.Registry) error {
	if swag.IsZero(m.LocationLed) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocationLedEnum("location_led", "body", *m.LocationLed); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) validateManufacturer(formats strfmt.Registry) error {
	if swag.IsZero(m.Manufacturer) { // not required
		return nil
	}

	if m.Manufacturer != nil {
		if err := m.Manufacturer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("manufacturer")
			}
			return err
		}
	}

	return nil
}

var shelfTypeModuleTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","iom6","iom6e","iom12","iom12b","iom12c","iom12e","iom12f","iom12g","nsm100","nsm8e","nsm16e","psm3e","nsm100b","nsm140"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfTypeModuleTypePropEnum = append(shelfTypeModuleTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// unknown
	// END DEBUGGING
	// ShelfModuleTypeUnknown captures enum value "unknown"
	ShelfModuleTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// iom6
	// END DEBUGGING
	// ShelfModuleTypeIom6 captures enum value "iom6"
	ShelfModuleTypeIom6 string = "iom6"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// iom6e
	// END DEBUGGING
	// ShelfModuleTypeIom6e captures enum value "iom6e"
	ShelfModuleTypeIom6e string = "iom6e"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// iom12
	// END DEBUGGING
	// ShelfModuleTypeIom12 captures enum value "iom12"
	ShelfModuleTypeIom12 string = "iom12"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// iom12b
	// END DEBUGGING
	// ShelfModuleTypeIom12b captures enum value "iom12b"
	ShelfModuleTypeIom12b string = "iom12b"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// iom12c
	// END DEBUGGING
	// ShelfModuleTypeIom12c captures enum value "iom12c"
	ShelfModuleTypeIom12c string = "iom12c"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// iom12e
	// END DEBUGGING
	// ShelfModuleTypeIom12e captures enum value "iom12e"
	ShelfModuleTypeIom12e string = "iom12e"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// iom12f
	// END DEBUGGING
	// ShelfModuleTypeIom12f captures enum value "iom12f"
	ShelfModuleTypeIom12f string = "iom12f"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// iom12g
	// END DEBUGGING
	// ShelfModuleTypeIom12g captures enum value "iom12g"
	ShelfModuleTypeIom12g string = "iom12g"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// nsm100
	// END DEBUGGING
	// ShelfModuleTypeNsm100 captures enum value "nsm100"
	ShelfModuleTypeNsm100 string = "nsm100"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// nsm8e
	// END DEBUGGING
	// ShelfModuleTypeNsm8e captures enum value "nsm8e"
	ShelfModuleTypeNsm8e string = "nsm8e"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// nsm16e
	// END DEBUGGING
	// ShelfModuleTypeNsm16e captures enum value "nsm16e"
	ShelfModuleTypeNsm16e string = "nsm16e"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// psm3e
	// END DEBUGGING
	// ShelfModuleTypePsm3e captures enum value "psm3e"
	ShelfModuleTypePsm3e string = "psm3e"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// nsm100b
	// END DEBUGGING
	// ShelfModuleTypeNsm100b captures enum value "nsm100b"
	ShelfModuleTypeNsm100b string = "nsm100b"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// module_type
	// ModuleType
	// nsm140
	// END DEBUGGING
	// ShelfModuleTypeNsm140 captures enum value "nsm140"
	ShelfModuleTypeNsm140 string = "nsm140"
)

// prop value enum
func (m *Shelf) validateModuleTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfTypeModuleTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Shelf) validateModuleType(formats strfmt.Registry) error {
	if swag.IsZero(m.ModuleType) { // not required
		return nil
	}

	// value enum
	if err := m.validateModuleTypeEnum("module_type", "body", *m.ModuleType); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) validateShelfInlineAcps(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineAcps) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineAcps); i++ {
		if swag.IsZero(m.ShelfInlineAcps[i]) { // not required
			continue
		}

		if m.ShelfInlineAcps[i] != nil {
			if err := m.ShelfInlineAcps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlineBays(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineBays) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineBays); i++ {
		if swag.IsZero(m.ShelfInlineBays[i]) { // not required
			continue
		}

		if m.ShelfInlineBays[i] != nil {
			if err := m.ShelfInlineBays[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("bays" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlineCurrentSensors(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineCurrentSensors) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineCurrentSensors); i++ {
		if swag.IsZero(m.ShelfInlineCurrentSensors[i]) { // not required
			continue
		}

		if m.ShelfInlineCurrentSensors[i] != nil {
			if err := m.ShelfInlineCurrentSensors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("current_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlineDrawers(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineDrawers) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineDrawers); i++ {
		if swag.IsZero(m.ShelfInlineDrawers[i]) { // not required
			continue
		}

		if m.ShelfInlineDrawers[i] != nil {
			if err := m.ShelfInlineDrawers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("drawers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineErrors); i++ {
		if swag.IsZero(m.ShelfInlineErrors[i]) { // not required
			continue
		}

		if m.ShelfInlineErrors[i] != nil {
			if err := m.ShelfInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlineFans(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineFans) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineFans); i++ {
		if swag.IsZero(m.ShelfInlineFans[i]) { // not required
			continue
		}

		if m.ShelfInlineFans[i] != nil {
			if err := m.ShelfInlineFans[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlineFrus(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineFrus) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineFrus); i++ {
		if swag.IsZero(m.ShelfInlineFrus[i]) { // not required
			continue
		}

		if m.ShelfInlineFrus[i] != nil {
			if err := m.ShelfInlineFrus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlinePaths(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlinePaths) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlinePaths); i++ {
		if swag.IsZero(m.ShelfInlinePaths[i]) { // not required
			continue
		}

		if m.ShelfInlinePaths[i] != nil {
			if err := m.ShelfInlinePaths[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlinePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlinePorts) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlinePorts); i++ {
		if swag.IsZero(m.ShelfInlinePorts[i]) { // not required
			continue
		}

		if m.ShelfInlinePorts[i] != nil {
			if err := m.ShelfInlinePorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlineTemperatureSensors(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineTemperatureSensors) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineTemperatureSensors); i++ {
		if swag.IsZero(m.ShelfInlineTemperatureSensors[i]) { // not required
			continue
		}

		if m.ShelfInlineTemperatureSensors[i] != nil {
			if err := m.ShelfInlineTemperatureSensors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("temperature_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) validateShelfInlineVoltageSensors(formats strfmt.Registry) error {
	if swag.IsZero(m.ShelfInlineVoltageSensors) { // not required
		return nil
	}

	for i := 0; i < len(m.ShelfInlineVoltageSensors); i++ {
		if swag.IsZero(m.ShelfInlineVoltageSensors[i]) { // not required
			continue
		}

		if m.ShelfInlineVoltageSensors[i] != nil {
			if err := m.ShelfInlineVoltageSensors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("voltage_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var shelfTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfTypeStatePropEnum = append(shelfTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// state
	// State
	// unknown
	// END DEBUGGING
	// ShelfStateUnknown captures enum value "unknown"
	ShelfStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfStateOk captures enum value "ok"
	ShelfStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf
	// Shelf
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfStateError captures enum value "error"
	ShelfStateError string = "error"
)

// prop value enum
func (m *Shelf) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Shelf) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) validateVendor(formats strfmt.Registry) error {
	if swag.IsZero(m.Vendor) { // not required
		return nil
	}

	if m.Vendor != nil {
		if err := m.Vendor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vendor")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf based on the context it is used
func (m *Shelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConnectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDiskCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInternal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateManufacturer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModuleType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRawCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineAcps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineBays(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineCurrentSensors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineDrawers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineFans(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineFrus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlinePaths(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlinePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineTemperatureSensors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelfInlineVoltageSensors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVendor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Shelf) contextValidateConnectionType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connection_type", "body", m.ConnectionType); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateDiskCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "disk_count", "body", m.DiskCount); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateInternal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "internal", "body", m.Internal); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local", "body", m.Local); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateManufacturer(ctx context.Context, formats strfmt.Registry) error {

	if m.Manufacturer != nil {
		if err := m.Manufacturer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("manufacturer")
			}
			return err
		}
	}

	return nil
}

func (m *Shelf) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateModuleType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "module_type", "body", m.ModuleType); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateRawCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "raw_capacity", "body", m.RawCapacity); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineAcps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "acps", "body", []*ShelfInlineAcpsInlineArrayItem(m.ShelfInlineAcps)); err != nil {
		return err
	}

	for i := 0; i < len(m.ShelfInlineAcps); i++ {

		if m.ShelfInlineAcps[i] != nil {
			if err := m.ShelfInlineAcps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineBays(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ShelfInlineBays); i++ {

		if m.ShelfInlineBays[i] != nil {
			if err := m.ShelfInlineBays[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("bays" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineCurrentSensors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "current_sensors", "body", []*ShelfInlineCurrentSensorsInlineArrayItem(m.ShelfInlineCurrentSensors)); err != nil {
		return err
	}

	for i := 0; i < len(m.ShelfInlineCurrentSensors); i++ {

		if m.ShelfInlineCurrentSensors[i] != nil {
			if err := m.ShelfInlineCurrentSensors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("current_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineDrawers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "drawers", "body", []*ShelfInlineDrawersInlineArrayItem(m.ShelfInlineDrawers)); err != nil {
		return err
	}

	for i := 0; i < len(m.ShelfInlineDrawers); i++ {

		if m.ShelfInlineDrawers[i] != nil {
			if err := m.ShelfInlineDrawers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("drawers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ShelfInlineErrors); i++ {

		if m.ShelfInlineErrors[i] != nil {
			if err := m.ShelfInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineFans(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fans", "body", []*ShelfInlineFansInlineArrayItem(m.ShelfInlineFans)); err != nil {
		return err
	}

	for i := 0; i < len(m.ShelfInlineFans); i++ {

		if m.ShelfInlineFans[i] != nil {
			if err := m.ShelfInlineFans[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineFrus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "frus", "body", []*ShelfInlineFrusInlineArrayItem(m.ShelfInlineFrus)); err != nil {
		return err
	}

	for i := 0; i < len(m.ShelfInlineFrus); i++ {

		if m.ShelfInlineFrus[i] != nil {
			if err := m.ShelfInlineFrus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlinePaths(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "paths", "body", []*ShelfInlinePathsInlineArrayItem(m.ShelfInlinePaths)); err != nil {
		return err
	}

	for i := 0; i < len(m.ShelfInlinePaths); i++ {

		if m.ShelfInlinePaths[i] != nil {
			if err := m.ShelfInlinePaths[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlinePorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ShelfInlinePorts); i++ {

		if m.ShelfInlinePorts[i] != nil {
			if err := m.ShelfInlinePorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineTemperatureSensors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "temperature_sensors", "body", []*ShelfInlineTemperatureSensorsInlineArrayItem(m.ShelfInlineTemperatureSensors)); err != nil {
		return err
	}

	for i := 0; i < len(m.ShelfInlineTemperatureSensors); i++ {

		if m.ShelfInlineTemperatureSensors[i] != nil {
			if err := m.ShelfInlineTemperatureSensors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("temperature_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateShelfInlineVoltageSensors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "voltage_sensors", "body", []*ShelfInlineVoltageSensorsInlineArrayItem(m.ShelfInlineVoltageSensors)); err != nil {
		return err
	}

	for i := 0; i < len(m.ShelfInlineVoltageSensors); i++ {

		if m.ShelfInlineVoltageSensors[i] != nil {
			if err := m.ShelfInlineVoltageSensors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("voltage_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Shelf) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uid", "body", m.UID); err != nil {
		return err
	}

	return nil
}

func (m *Shelf) contextValidateVendor(ctx context.Context, formats strfmt.Registry) error {

	if m.Vendor != nil {
		if err := m.Vendor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vendor")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Shelf) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Shelf) UnmarshalBinary(b []byte) error {
	var res Shelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineAcpsInlineArrayItem shelf inline acps inline array item
//
// swagger:model shelf_inline_acps_inline_array_item
type ShelfInlineAcpsInlineArrayItem struct {

	// address
	// Example: 192.168.1.104
	Address *string `json:"address,omitempty"`

	// channel
	// Example: out_of_band
	// Enum: ["unknown","out_of_band","in_band"]
	Channel *string `json:"channel,omitempty"`

	// connection state
	// Example: full_connectivity
	// Enum: ["no_connectivity","partial_connectivity","full_connectivity","additional_connectivity","unknown_connectivity","not_available","active","disabled"]
	ConnectionState *string `json:"connection_state,omitempty"`

	// enabled
	Enabled *bool `json:"enabled,omitempty"`

	// error
	Error *ShelfInlineAcpsInlineArrayItemInlineError `json:"error,omitempty"`

	// netmask
	// Example: 255.255.252.0
	Netmask *string `json:"netmask,omitempty"`

	// node
	Node *ShelfInlineAcpsInlineArrayItemInlineNode `json:"node,omitempty"`

	// port
	// Example: e0P
	Port *string `json:"port,omitempty"`

	// subnet
	// Example: 192.168.0.1
	Subnet *string `json:"subnet,omitempty"`
}

// Validate validates this shelf inline acps inline array item
func (m *ShelfInlineAcpsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChannel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectionState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineAcpsInlineArrayItemTypeChannelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","out_of_band","in_band"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineAcpsInlineArrayItemTypeChannelPropEnum = append(shelfInlineAcpsInlineArrayItemTypeChannelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// channel
	// Channel
	// unknown
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemChannelUnknown captures enum value "unknown"
	ShelfInlineAcpsInlineArrayItemChannelUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// channel
	// Channel
	// out_of_band
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemChannelOutOfBand captures enum value "out_of_band"
	ShelfInlineAcpsInlineArrayItemChannelOutOfBand string = "out_of_band"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// channel
	// Channel
	// in_band
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemChannelInBand captures enum value "in_band"
	ShelfInlineAcpsInlineArrayItemChannelInBand string = "in_band"
)

// prop value enum
func (m *ShelfInlineAcpsInlineArrayItem) validateChannelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineAcpsInlineArrayItemTypeChannelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItem) validateChannel(formats strfmt.Registry) error {
	if swag.IsZero(m.Channel) { // not required
		return nil
	}

	// value enum
	if err := m.validateChannelEnum("channel", "body", *m.Channel); err != nil {
		return err
	}

	return nil
}

var shelfInlineAcpsInlineArrayItemTypeConnectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_connectivity","partial_connectivity","full_connectivity","additional_connectivity","unknown_connectivity","not_available","active","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineAcpsInlineArrayItemTypeConnectionStatePropEnum = append(shelfInlineAcpsInlineArrayItemTypeConnectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// no_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateNoConnectivity captures enum value "no_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStateNoConnectivity string = "no_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// partial_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStatePartialConnectivity captures enum value "partial_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStatePartialConnectivity string = "partial_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// full_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateFullConnectivity captures enum value "full_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStateFullConnectivity string = "full_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// additional_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateAdditionalConnectivity captures enum value "additional_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStateAdditionalConnectivity string = "additional_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// unknown_connectivity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateUnknownConnectivity captures enum value "unknown_connectivity"
	ShelfInlineAcpsInlineArrayItemConnectionStateUnknownConnectivity string = "unknown_connectivity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// not_available
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateNotAvailable captures enum value "not_available"
	ShelfInlineAcpsInlineArrayItemConnectionStateNotAvailable string = "not_available"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// active
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateActive captures enum value "active"
	ShelfInlineAcpsInlineArrayItemConnectionStateActive string = "active"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item
	// ShelfInlineAcpsInlineArrayItem
	// connection_state
	// ConnectionState
	// disabled
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemConnectionStateDisabled captures enum value "disabled"
	ShelfInlineAcpsInlineArrayItemConnectionStateDisabled string = "disabled"
)

// prop value enum
func (m *ShelfInlineAcpsInlineArrayItem) validateConnectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineAcpsInlineArrayItemTypeConnectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItem) validateConnectionState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectionState) { // not required
		return nil
	}

	// value enum
	if err := m.validateConnectionStateEnum("connection_state", "body", *m.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (m *ShelfInlineAcpsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *ShelfInlineAcpsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline acps inline array item based on the context it is used
func (m *ShelfInlineAcpsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *ShelfInlineAcpsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineAcpsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineAcpsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineAcpsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineAcpsInlineArrayItemInlineError Error object is populated when connection_state becomes non-optimal
//
// swagger:model shelf_inline_acps_inline_array_item_inline_error
type ShelfInlineAcpsInlineArrayItemInlineError struct {

	// reason
	Reason *Error `json:"reason,omitempty"`

	// severity
	// Enum: ["unknown","notice","warning","error","critical"]
	Severity *string `json:"severity,omitempty"`

	// type
	// Enum: ["not_applicable","connection_issue","connection_activity","module_error","shelf_error"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this shelf inline acps inline array item inline error
func (m *ShelfInlineAcpsInlineArrayItemInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItemInlineError) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	if m.Reason != nil {
		if err := m.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error" + "." + "reason")
			}
			return err
		}
	}

	return nil
}

var shelfInlineAcpsInlineArrayItemInlineErrorTypeSeverityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","notice","warning","error","critical"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineAcpsInlineArrayItemInlineErrorTypeSeverityPropEnum = append(shelfInlineAcpsInlineArrayItemInlineErrorTypeSeverityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// unknown
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityUnknown captures enum value "unknown"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// notice
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityNotice captures enum value "notice"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityNotice string = "notice"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// warning
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityWarning captures enum value "warning"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityWarning string = "warning"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// error
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityError captures enum value "error"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityError string = "error"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// severity
	// Severity
	// critical
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorSeverityCritical captures enum value "critical"
	ShelfInlineAcpsInlineArrayItemInlineErrorSeverityCritical string = "critical"
)

// prop value enum
func (m *ShelfInlineAcpsInlineArrayItemInlineError) validateSeverityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineAcpsInlineArrayItemInlineErrorTypeSeverityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItemInlineError) validateSeverity(formats strfmt.Registry) error {
	if swag.IsZero(m.Severity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSeverityEnum("error"+"."+"severity", "body", *m.Severity); err != nil {
		return err
	}

	return nil
}

var shelfInlineAcpsInlineArrayItemInlineErrorTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_applicable","connection_issue","connection_activity","module_error","shelf_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineAcpsInlineArrayItemInlineErrorTypeTypePropEnum = append(shelfInlineAcpsInlineArrayItemInlineErrorTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// not_applicable
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeNotApplicable captures enum value "not_applicable"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeNotApplicable string = "not_applicable"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// connection_issue
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeConnectionIssue captures enum value "connection_issue"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeConnectionIssue string = "connection_issue"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// connection_activity
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeConnectionActivity captures enum value "connection_activity"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeConnectionActivity string = "connection_activity"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// module_error
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeModuleError captures enum value "module_error"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeModuleError string = "module_error"

	// BEGIN DEBUGGING
	// shelf_inline_acps_inline_array_item_inline_error
	// ShelfInlineAcpsInlineArrayItemInlineError
	// type
	// Type
	// shelf_error
	// END DEBUGGING
	// ShelfInlineAcpsInlineArrayItemInlineErrorTypeShelfError captures enum value "shelf_error"
	ShelfInlineAcpsInlineArrayItemInlineErrorTypeShelfError string = "shelf_error"
)

// prop value enum
func (m *ShelfInlineAcpsInlineArrayItemInlineError) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineAcpsInlineArrayItemInlineErrorTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItemInlineError) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("error"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this shelf inline acps inline array item inline error based on the context it is used
func (m *ShelfInlineAcpsInlineArrayItemInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItemInlineError) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if m.Reason != nil {
		if err := m.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error" + "." + "reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineAcpsInlineArrayItemInlineError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineAcpsInlineArrayItemInlineError) UnmarshalBinary(b []byte) error {
	var res ShelfInlineAcpsInlineArrayItemInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineAcpsInlineArrayItemInlineNode shelf inline acps inline array item inline node
//
// swagger:model shelf_inline_acps_inline_array_item_inline_node
type ShelfInlineAcpsInlineArrayItemInlineNode struct {

	// links
	Links *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shelf inline acps inline array item inline node
func (m *ShelfInlineAcpsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline acps inline array item inline node based on the context it is used
func (m *ShelfInlineAcpsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineAcpsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineAcpsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res ShelfInlineAcpsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks shelf inline acps inline array item inline node inline links
//
// swagger:model shelf_inline_acps_inline_array_item_inline_node_inline__links
type ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this shelf inline acps inline array item inline node inline links
func (m *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline acps inline array item inline node inline links based on the context it is used
func (m *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShelfInlineAcpsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineBaysInlineArrayItem shelf inline bays inline array item
//
// swagger:model shelf_inline_bays_inline_array_item
type ShelfInlineBaysInlineArrayItem struct {

	// drawer
	Drawer *ShelfInlineBaysInlineArrayItemInlineDrawer `json:"drawer,omitempty"`

	// has disk
	HasDisk *bool `json:"has_disk,omitempty"`

	// id
	// Example: 0
	ID *int64 `json:"id,omitempty"`

	// state
	// Example: ok
	// Enum: ["unknown","ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Example: single_disk
	// Enum: ["unknown","single_disk","multi_lun"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this shelf inline bays inline array item
func (m *ShelfInlineBaysInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDrawer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineBaysInlineArrayItem) validateDrawer(formats strfmt.Registry) error {
	if swag.IsZero(m.Drawer) { // not required
		return nil
	}

	if m.Drawer != nil {
		if err := m.Drawer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("drawer")
			}
			return err
		}
	}

	return nil
}

var shelfInlineBaysInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineBaysInlineArrayItemTypeStatePropEnum = append(shelfInlineBaysInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// state
	// State
	// unknown
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemStateUnknown captures enum value "unknown"
	ShelfInlineBaysInlineArrayItemStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineBaysInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemStateError captures enum value "error"
	ShelfInlineBaysInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *ShelfInlineBaysInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineBaysInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineBaysInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var shelfInlineBaysInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","single_disk","multi_lun"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineBaysInlineArrayItemTypeTypePropEnum = append(shelfInlineBaysInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// type
	// Type
	// unknown
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemTypeUnknown captures enum value "unknown"
	ShelfInlineBaysInlineArrayItemTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// type
	// Type
	// single_disk
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemTypeSingleDisk captures enum value "single_disk"
	ShelfInlineBaysInlineArrayItemTypeSingleDisk string = "single_disk"

	// BEGIN DEBUGGING
	// shelf_inline_bays_inline_array_item
	// ShelfInlineBaysInlineArrayItem
	// type
	// Type
	// multi_lun
	// END DEBUGGING
	// ShelfInlineBaysInlineArrayItemTypeMultiLun captures enum value "multi_lun"
	ShelfInlineBaysInlineArrayItemTypeMultiLun string = "multi_lun"
)

// prop value enum
func (m *ShelfInlineBaysInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineBaysInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineBaysInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this shelf inline bays inline array item based on the context it is used
func (m *ShelfInlineBaysInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDrawer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineBaysInlineArrayItem) contextValidateDrawer(ctx context.Context, formats strfmt.Registry) error {

	if m.Drawer != nil {
		if err := m.Drawer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("drawer")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineBaysInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineBaysInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineBaysInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineBaysInlineArrayItemInlineDrawer shelf inline bays inline array item inline drawer
//
// swagger:model shelf_inline_bays_inline_array_item_inline_drawer
type ShelfInlineBaysInlineArrayItemInlineDrawer struct {

	// The drawer containing this bay
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// The drawer slot for this bay
	// Example: 0
	Slot *int64 `json:"slot,omitempty"`
}

// Validate validates this shelf inline bays inline array item inline drawer
func (m *ShelfInlineBaysInlineArrayItemInlineDrawer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline bays inline array item inline drawer based on context it is used
func (m *ShelfInlineBaysInlineArrayItemInlineDrawer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineBaysInlineArrayItemInlineDrawer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineBaysInlineArrayItemInlineDrawer) UnmarshalBinary(b []byte) error {
	var res ShelfInlineBaysInlineArrayItemInlineDrawer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineCurrentSensorsInlineArrayItem shelf inline current sensors inline array item
//
// swagger:model shelf_inline_current_sensors_inline_array_item
type ShelfInlineCurrentSensorsInlineArrayItem struct {

	// Current, in milliamps
	// Example: 14410
	Current *int64 `json:"current,omitempty"`

	// id
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// location
	// Example: rear of the shelf on the lower left power supply
	Location *string `json:"location,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this shelf inline current sensors inline array item
func (m *ShelfInlineCurrentSensorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineCurrentSensorsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineCurrentSensorsInlineArrayItemTypeStatePropEnum = append(shelfInlineCurrentSensorsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_current_sensors_inline_array_item
	// ShelfInlineCurrentSensorsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineCurrentSensorsInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineCurrentSensorsInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_current_sensors_inline_array_item
	// ShelfInlineCurrentSensorsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineCurrentSensorsInlineArrayItemStateError captures enum value "error"
	ShelfInlineCurrentSensorsInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *ShelfInlineCurrentSensorsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineCurrentSensorsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineCurrentSensorsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this shelf inline current sensors inline array item based on context it is used
func (m *ShelfInlineCurrentSensorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineCurrentSensorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineCurrentSensorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineCurrentSensorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineDrawersInlineArrayItem shelf inline drawers inline array item
//
// swagger:model shelf_inline_drawers_inline_array_item
type ShelfInlineDrawersInlineArrayItem struct {

	// closed
	Closed *bool `json:"closed,omitempty"`

	// disk count
	// Example: 12
	DiskCount *int64 `json:"disk_count,omitempty"`

	// error
	Error *string `json:"error,omitempty"`

	// id
	ID *int64 `json:"id,omitempty"`

	// part number
	// Example: 111-03071
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: 21604008263
	SerialNumber *string `json:"serial_number,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this shelf inline drawers inline array item
func (m *ShelfInlineDrawersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineDrawersInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineDrawersInlineArrayItemTypeStatePropEnum = append(shelfInlineDrawersInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_drawers_inline_array_item
	// ShelfInlineDrawersInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineDrawersInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineDrawersInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_drawers_inline_array_item
	// ShelfInlineDrawersInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineDrawersInlineArrayItemStateError captures enum value "error"
	ShelfInlineDrawersInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *ShelfInlineDrawersInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineDrawersInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineDrawersInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this shelf inline drawers inline array item based on context it is used
func (m *ShelfInlineDrawersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineDrawersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineDrawersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineDrawersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineErrorsInlineArrayItem shelf inline errors inline array item
//
// swagger:model shelf_inline_errors_inline_array_item
type ShelfInlineErrorsInlineArrayItem struct {

	// reason
	Reason *Error `json:"reason,omitempty"`
}

// Validate validates this shelf inline errors inline array item
func (m *ShelfInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineErrorsInlineArrayItem) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	if m.Reason != nil {
		if err := m.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline errors inline array item based on the context it is used
func (m *ShelfInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineErrorsInlineArrayItem) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if m.Reason != nil {
		if err := m.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineFansInlineArrayItem shelf inline fans inline array item
//
// swagger:model shelf_inline_fans_inline_array_item
type ShelfInlineFansInlineArrayItem struct {

	// id
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// location
	// Example: rear of the shelf on the lower left power supply
	Location *string `json:"location,omitempty"`

	// rpm
	// Example: 3020
	Rpm *int64 `json:"rpm,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this shelf inline fans inline array item
func (m *ShelfInlineFansInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineFansInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineFansInlineArrayItemTypeStatePropEnum = append(shelfInlineFansInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_fans_inline_array_item
	// ShelfInlineFansInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineFansInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineFansInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_fans_inline_array_item
	// ShelfInlineFansInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineFansInlineArrayItemStateError captures enum value "error"
	ShelfInlineFansInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *ShelfInlineFansInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineFansInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineFansInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this shelf inline fans inline array item based on context it is used
func (m *ShelfInlineFansInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineFansInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineFansInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineFansInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineFrusInlineArrayItem shelf inline frus inline array item
//
// swagger:model shelf_inline_frus_inline_array_item
type ShelfInlineFrusInlineArrayItem struct {

	// firmware version
	// Example: 191
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// id
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// part number
	// Example: 111-00690+A2
	PartNumber *string `json:"part_number,omitempty"`

	// psu
	Psu *ShelfInlineFrusInlineArrayItemInlinePsu `json:"psu,omitempty"`

	// serial number
	// Example: 8000166294
	SerialNumber *string `json:"serial_number,omitempty"`

	// state
	// Example: error
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Example: module
	// Enum: ["module","psu"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this shelf inline frus inline array item
func (m *ShelfInlineFrusInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePsu(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineFrusInlineArrayItem) validatePsu(formats strfmt.Registry) error {
	if swag.IsZero(m.Psu) { // not required
		return nil
	}

	if m.Psu != nil {
		if err := m.Psu.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("psu")
			}
			return err
		}
	}

	return nil
}

var shelfInlineFrusInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineFrusInlineArrayItemTypeStatePropEnum = append(shelfInlineFrusInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_frus_inline_array_item
	// ShelfInlineFrusInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineFrusInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineFrusInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_frus_inline_array_item
	// ShelfInlineFrusInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineFrusInlineArrayItemStateError captures enum value "error"
	ShelfInlineFrusInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *ShelfInlineFrusInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineFrusInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineFrusInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var shelfInlineFrusInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["module","psu"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineFrusInlineArrayItemTypeTypePropEnum = append(shelfInlineFrusInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_frus_inline_array_item
	// ShelfInlineFrusInlineArrayItem
	// type
	// Type
	// module
	// END DEBUGGING
	// ShelfInlineFrusInlineArrayItemTypeModule captures enum value "module"
	ShelfInlineFrusInlineArrayItemTypeModule string = "module"

	// BEGIN DEBUGGING
	// shelf_inline_frus_inline_array_item
	// ShelfInlineFrusInlineArrayItem
	// type
	// Type
	// psu
	// END DEBUGGING
	// ShelfInlineFrusInlineArrayItemTypePsu captures enum value "psu"
	ShelfInlineFrusInlineArrayItemTypePsu string = "psu"
)

// prop value enum
func (m *ShelfInlineFrusInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineFrusInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineFrusInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this shelf inline frus inline array item based on the context it is used
func (m *ShelfInlineFrusInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePsu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineFrusInlineArrayItem) contextValidatePsu(ctx context.Context, formats strfmt.Registry) error {

	if m.Psu != nil {
		if err := m.Psu.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("psu")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineFrusInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineFrusInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineFrusInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineFrusInlineArrayItemInlinePsu shelf inline frus inline array item inline psu
//
// swagger:model shelf_inline_frus_inline_array_item_inline_psu
type ShelfInlineFrusInlineArrayItemInlinePsu struct {

	// The ratio of the peak voltage to the root-mean-square voltage
	// Example: 92
	CrestFactor *int64 `json:"crest_factor,omitempty"`

	// model
	// Example: 00
	Model *string `json:"model,omitempty"`

	// Power drawn, in watts
	// Example: 210
	PowerDrawn *int64 `json:"power_drawn,omitempty"`

	// Power rating, in watts
	// Example: 1600
	PowerRating *int64 `json:"power_rating,omitempty"`
}

// Validate validates this shelf inline frus inline array item inline psu
func (m *ShelfInlineFrusInlineArrayItemInlinePsu) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline frus inline array item inline psu based on context it is used
func (m *ShelfInlineFrusInlineArrayItemInlinePsu) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineFrusInlineArrayItemInlinePsu) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineFrusInlineArrayItemInlinePsu) UnmarshalBinary(b []byte) error {
	var res ShelfInlineFrusInlineArrayItemInlinePsu
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineManufacturer shelf inline manufacturer
//
// swagger:model shelf_inline_manufacturer
type ShelfInlineManufacturer struct {

	// name
	// Example: NETAPP
	Name *string `json:"name,omitempty"`
}

// Validate validates this shelf inline manufacturer
func (m *ShelfInlineManufacturer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this shelf inline manufacturer based on the context it is used
func (m *ShelfInlineManufacturer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineManufacturer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineManufacturer) UnmarshalBinary(b []byte) error {
	var res ShelfInlineManufacturer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlinePathsInlineArrayItem Storage port
//
// swagger:model shelf_inline_paths_inline_array_item
type ShelfInlinePathsInlineArrayItem struct {

	// links
	Links *ShelfInlinePathsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: 2a
	Name *string `json:"name,omitempty"`

	// node
	Node *ShelfInlinePathsInlineArrayItemInlineNode `json:"node,omitempty"`
}

// Validate validates this shelf inline paths inline array item
func (m *ShelfInlinePathsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePathsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ShelfInlinePathsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline paths inline array item based on the context it is used
func (m *ShelfInlinePathsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePathsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ShelfInlinePathsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlinePathsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlinePathsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePathsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlinePathsInlineArrayItemInlineLinks shelf inline paths inline array item inline links
//
// swagger:model shelf_inline_paths_inline_array_item_inline__links
type ShelfInlinePathsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this shelf inline paths inline array item inline links
func (m *ShelfInlinePathsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePathsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline paths inline array item inline links based on the context it is used
func (m *ShelfInlinePathsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePathsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlinePathsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlinePathsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePathsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlinePathsInlineArrayItemInlineNode shelf inline paths inline array item inline node
//
// swagger:model shelf_inline_paths_inline_array_item_inline_node
type ShelfInlinePathsInlineArrayItemInlineNode struct {

	// links
	Links *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shelf inline paths inline array item inline node
func (m *ShelfInlinePathsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePathsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline paths inline array item inline node based on the context it is used
func (m *ShelfInlinePathsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePathsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlinePathsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlinePathsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePathsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks shelf inline paths inline array item inline node inline links
//
// swagger:model shelf_inline_paths_inline_array_item_inline_node_inline__links
type ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this shelf inline paths inline array item inline node inline links
func (m *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline paths inline array item inline node inline links based on the context it is used
func (m *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePathsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlinePortsInlineArrayItem shelf inline ports inline array item
//
// swagger:model shelf_inline_ports_inline_array_item
type ShelfInlinePortsInlineArrayItem struct {

	// cable
	Cable *ShelfInlinePortsInlineArrayItemInlineCable `json:"cable,omitempty"`

	// designator
	// Example: square
	// Enum: ["circle","square","1","2","3","4"]
	Designator *string `json:"designator,omitempty"`

	// id
	// Example: 0
	ID *int64 `json:"id,omitempty"`

	// internal
	Internal *bool `json:"internal,omitempty"`

	// mac address
	MacAddress *string `json:"mac_address,omitempty"`

	// module id
	// Example: a
	// Enum: ["a","b"]
	ModuleID *string `json:"module_id,omitempty"`

	// remote
	Remote *ShelfInlinePortsInlineArrayItemInlineRemote `json:"remote,omitempty"`

	// speed
	// Example: 100
	Speed *int64 `json:"speed,omitempty"`

	// state
	// Example: connected
	// Enum: ["connected","disconnected","error"]
	State *string `json:"state,omitempty"`

	// wwn
	// Example: 500A0980000B6C3F
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this shelf inline ports inline array item
func (m *ShelfInlinePortsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDesignator(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateModuleID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePortsInlineArrayItem) validateCable(formats strfmt.Registry) error {
	if swag.IsZero(m.Cable) { // not required
		return nil
	}

	if m.Cable != nil {
		if err := m.Cable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cable")
			}
			return err
		}
	}

	return nil
}

var shelfInlinePortsInlineArrayItemTypeDesignatorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["circle","square","1","2","3","4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlinePortsInlineArrayItemTypeDesignatorPropEnum = append(shelfInlinePortsInlineArrayItemTypeDesignatorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// circle
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorCircle captures enum value "circle"
	ShelfInlinePortsInlineArrayItemDesignatorCircle string = "circle"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// square
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorSquare captures enum value "square"
	ShelfInlinePortsInlineArrayItemDesignatorSquare string = "square"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// 1
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorNr1 captures enum value "1"
	ShelfInlinePortsInlineArrayItemDesignatorNr1 string = "1"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// 2
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorNr2 captures enum value "2"
	ShelfInlinePortsInlineArrayItemDesignatorNr2 string = "2"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// 3
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorNr3 captures enum value "3"
	ShelfInlinePortsInlineArrayItemDesignatorNr3 string = "3"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// designator
	// Designator
	// 4
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemDesignatorNr4 captures enum value "4"
	ShelfInlinePortsInlineArrayItemDesignatorNr4 string = "4"
)

// prop value enum
func (m *ShelfInlinePortsInlineArrayItem) validateDesignatorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlinePortsInlineArrayItemTypeDesignatorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlinePortsInlineArrayItem) validateDesignator(formats strfmt.Registry) error {
	if swag.IsZero(m.Designator) { // not required
		return nil
	}

	// value enum
	if err := m.validateDesignatorEnum("designator", "body", *m.Designator); err != nil {
		return err
	}

	return nil
}

var shelfInlinePortsInlineArrayItemTypeModuleIDPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["a","b"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlinePortsInlineArrayItemTypeModuleIDPropEnum = append(shelfInlinePortsInlineArrayItemTypeModuleIDPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// module_id
	// ModuleID
	// a
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemModuleIDA captures enum value "a"
	ShelfInlinePortsInlineArrayItemModuleIDA string = "a"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// module_id
	// ModuleID
	// b
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemModuleIDB captures enum value "b"
	ShelfInlinePortsInlineArrayItemModuleIDB string = "b"
)

// prop value enum
func (m *ShelfInlinePortsInlineArrayItem) validateModuleIDEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlinePortsInlineArrayItemTypeModuleIDPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlinePortsInlineArrayItem) validateModuleID(formats strfmt.Registry) error {
	if swag.IsZero(m.ModuleID) { // not required
		return nil
	}

	// value enum
	if err := m.validateModuleIDEnum("module_id", "body", *m.ModuleID); err != nil {
		return err
	}

	return nil
}

func (m *ShelfInlinePortsInlineArrayItem) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(m.Remote) { // not required
		return nil
	}

	if m.Remote != nil {
		if err := m.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

var shelfInlinePortsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["connected","disconnected","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlinePortsInlineArrayItemTypeStatePropEnum = append(shelfInlinePortsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// state
	// State
	// connected
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemStateConnected captures enum value "connected"
	ShelfInlinePortsInlineArrayItemStateConnected string = "connected"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// state
	// State
	// disconnected
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemStateDisconnected captures enum value "disconnected"
	ShelfInlinePortsInlineArrayItemStateDisconnected string = "disconnected"

	// BEGIN DEBUGGING
	// shelf_inline_ports_inline_array_item
	// ShelfInlinePortsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlinePortsInlineArrayItemStateError captures enum value "error"
	ShelfInlinePortsInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *ShelfInlinePortsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlinePortsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlinePortsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this shelf inline ports inline array item based on the context it is used
func (m *ShelfInlinePortsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlinePortsInlineArrayItem) contextValidateCable(ctx context.Context, formats strfmt.Registry) error {

	if m.Cable != nil {
		if err := m.Cable.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cable")
			}
			return err
		}
	}

	return nil
}

func (m *ShelfInlinePortsInlineArrayItem) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if m.Remote != nil {
		if err := m.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlinePortsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlinePortsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePortsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlinePortsInlineArrayItemInlineCable shelf inline ports inline array item inline cable
//
// swagger:model shelf_inline_ports_inline_array_item_inline_cable
type ShelfInlinePortsInlineArrayItemInlineCable struct {

	// identifier
	// Example: 500a0980000b6c3f-50000d1703544b80
	Identifier *string `json:"identifier,omitempty"`

	// length
	// Example: 2m
	Length *string `json:"length,omitempty"`

	// part number
	// Example: 112-00431+A0
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: 616930439
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this shelf inline ports inline array item inline cable
func (m *ShelfInlinePortsInlineArrayItemInlineCable) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline ports inline array item inline cable based on context it is used
func (m *ShelfInlinePortsInlineArrayItemInlineCable) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlinePortsInlineArrayItemInlineCable) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlinePortsInlineArrayItemInlineCable) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePortsInlineArrayItemInlineCable
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlinePortsInlineArrayItemInlineRemote shelf inline ports inline array item inline remote
//
// swagger:model shelf_inline_ports_inline_array_item_inline_remote
type ShelfInlinePortsInlineArrayItemInlineRemote struct {

	// chassis
	Chassis *string `json:"chassis,omitempty"`

	// device
	Device *string `json:"device,omitempty"`

	// mac address
	MacAddress *string `json:"mac_address,omitempty"`

	// phy
	// Example: 12
	Phy *string `json:"phy,omitempty"`

	// port
	Port *string `json:"port,omitempty"`

	// wwn
	// Example: 50000D1703544B80
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this shelf inline ports inline array item inline remote
func (m *ShelfInlinePortsInlineArrayItemInlineRemote) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline ports inline array item inline remote based on context it is used
func (m *ShelfInlinePortsInlineArrayItemInlineRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlinePortsInlineArrayItemInlineRemote) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlinePortsInlineArrayItemInlineRemote) UnmarshalBinary(b []byte) error {
	var res ShelfInlinePortsInlineArrayItemInlineRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineTemperatureSensorsInlineArrayItem shelf inline temperature sensors inline array item
//
// swagger:model shelf_inline_temperature_sensors_inline_array_item
type ShelfInlineTemperatureSensorsInlineArrayItem struct {

	// Sensor that measures the ambient temperature
	// Example: false
	Ambient *bool `json:"ambient,omitempty"`

	// id
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// location
	// Example: temp sensor on midplane left
	Location *string `json:"location,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// Temperature, in degrees Celsius
	// Example: 32
	Temperature *int64 `json:"temperature,omitempty"`

	// threshold
	Threshold *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold `json:"threshold,omitempty"`
}

// Validate validates this shelf inline temperature sensors inline array item
func (m *ShelfInlineTemperatureSensorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThreshold(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum = append(shelfInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_temperature_sensors_inline_array_item
	// ShelfInlineTemperatureSensorsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineTemperatureSensorsInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineTemperatureSensorsInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_temperature_sensors_inline_array_item
	// ShelfInlineTemperatureSensorsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineTemperatureSensorsInlineArrayItemStateError captures enum value "error"
	ShelfInlineTemperatureSensorsInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *ShelfInlineTemperatureSensorsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineTemperatureSensorsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *ShelfInlineTemperatureSensorsInlineArrayItem) validateThreshold(formats strfmt.Registry) error {
	if swag.IsZero(m.Threshold) { // not required
		return nil
	}

	if m.Threshold != nil {
		if err := m.Threshold.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline temperature sensors inline array item based on the context it is used
func (m *ShelfInlineTemperatureSensorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateThreshold(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineTemperatureSensorsInlineArrayItem) contextValidateThreshold(ctx context.Context, formats strfmt.Registry) error {

	if m.Threshold != nil {
		if err := m.Threshold.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineTemperatureSensorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineTemperatureSensorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineTemperatureSensorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold shelf inline temperature sensors inline array item inline threshold
//
// swagger:model shelf_inline_temperature_sensors_inline_array_item_inline_threshold
type ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold struct {

	// high
	High *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh `json:"high,omitempty"`

	// low
	Low *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow `json:"low,omitempty"`
}

// Validate validates this shelf inline temperature sensors inline array item inline threshold
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHigh(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLow(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) validateHigh(formats strfmt.Registry) error {
	if swag.IsZero(m.High) { // not required
		return nil
	}

	if m.High != nil {
		if err := m.High.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold" + "." + "high")
			}
			return err
		}
	}

	return nil
}

func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) validateLow(formats strfmt.Registry) error {
	if swag.IsZero(m.Low) { // not required
		return nil
	}

	if m.Low != nil {
		if err := m.Low.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold" + "." + "low")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shelf inline temperature sensors inline array item inline threshold based on the context it is used
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHigh(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) contextValidateHigh(ctx context.Context, formats strfmt.Registry) error {

	if m.High != nil {
		if err := m.High.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold" + "." + "high")
			}
			return err
		}
	}

	return nil
}

func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) contextValidateLow(ctx context.Context, formats strfmt.Registry) error {

	if m.Low != nil {
		if err := m.Low.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("threshold" + "." + "low")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold) UnmarshalBinary(b []byte) error {
	var res ShelfInlineTemperatureSensorsInlineArrayItemInlineThreshold
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh shelf inline temperature sensors inline array item inline threshold inline high
//
// swagger:model shelf_inline_temperature_sensors_inline_array_item_inline_threshold_inline_high
type ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh struct {

	// High critical threshold, in degrees Celsius
	// Example: 60
	Critical *int64 `json:"critical,omitempty"`

	// High warning threshold, in degrees Celsius
	// Example: 55
	Warning *int64 `json:"warning,omitempty"`
}

// Validate validates this shelf inline temperature sensors inline array item inline threshold inline high
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline temperature sensors inline array item inline threshold inline high based on context it is used
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh) UnmarshalBinary(b []byte) error {
	var res ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineHigh
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow shelf inline temperature sensors inline array item inline threshold inline low
//
// swagger:model shelf_inline_temperature_sensors_inline_array_item_inline_threshold_inline_low
type ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow struct {

	// Low critical threshold, in degrees Celsius
	// Example: 0
	Critical *int64 `json:"critical,omitempty"`

	// Low warning threshold, in degrees Celsius
	// Example: 5
	Warning *int64 `json:"warning,omitempty"`
}

// Validate validates this shelf inline temperature sensors inline array item inline threshold inline low
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this shelf inline temperature sensors inline array item inline threshold inline low based on context it is used
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow) UnmarshalBinary(b []byte) error {
	var res ShelfInlineTemperatureSensorsInlineArrayItemInlineThresholdInlineLow
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineVendor shelf inline vendor
//
// swagger:model shelf_inline_vendor
type ShelfInlineVendor struct {

	// Support for this field will be removed in a future release. Please use vendor.name for this field.
	// Example: XYZ
	Manufacturer *string `json:"manufacturer,omitempty"`

	// name
	// Example: XYZ
	Name *string `json:"name,omitempty"`

	// Part number
	// Example: A92831142733
	PartNumber *string `json:"part_number,omitempty"`

	// Product name
	// Example: LS2246
	Product *string `json:"product,omitempty"`

	// Serial number
	// Example: 891234572210221
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this shelf inline vendor
func (m *ShelfInlineVendor) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this shelf inline vendor based on the context it is used
func (m *ShelfInlineVendor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineVendor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineVendor) UnmarshalBinary(b []byte) error {
	var res ShelfInlineVendor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ShelfInlineVoltageSensorsInlineArrayItem shelf inline voltage sensors inline array item
//
// swagger:model shelf_inline_voltage_sensors_inline_array_item
type ShelfInlineVoltageSensorsInlineArrayItem struct {

	// id
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// installed
	// Example: true
	Installed *bool `json:"installed,omitempty"`

	// location
	// Example: rear of the shelf on the lower left power supply
	Location *string `json:"location,omitempty"`

	// state
	// Example: ok
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// Voltage, in volts
	// Example: 12.18
	Voltage *float64 `json:"voltage,omitempty"`
}

// Validate validates this shelf inline voltage sensors inline array item
func (m *ShelfInlineVoltageSensorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var shelfInlineVoltageSensorsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		shelfInlineVoltageSensorsInlineArrayItemTypeStatePropEnum = append(shelfInlineVoltageSensorsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// shelf_inline_voltage_sensors_inline_array_item
	// ShelfInlineVoltageSensorsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// ShelfInlineVoltageSensorsInlineArrayItemStateOk captures enum value "ok"
	ShelfInlineVoltageSensorsInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// shelf_inline_voltage_sensors_inline_array_item
	// ShelfInlineVoltageSensorsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// ShelfInlineVoltageSensorsInlineArrayItemStateError captures enum value "error"
	ShelfInlineVoltageSensorsInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *ShelfInlineVoltageSensorsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, shelfInlineVoltageSensorsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ShelfInlineVoltageSensorsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this shelf inline voltage sensors inline array item based on context it is used
func (m *ShelfInlineVoltageSensorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ShelfInlineVoltageSensorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ShelfInlineVoltageSensorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ShelfInlineVoltageSensorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
