// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Smb smb
//
// swagger:model smb
type Smb struct {

	// SMB connection state.
	// Read Only: true
	// Enum: ["connected","disconnected","reconnecting","timedout"]
	ConnectState *string `json:"connect_state,omitempty"`

	// SMB open group ID.
	// Read Only: true
	OpenGroupID *string `json:"open_group_id,omitempty"`

	// SMB open type.
	// Read Only: true
	// Enum: ["none","durable","persistent"]
	OpenType *string `json:"open_type,omitempty"`
}

// Validate validates this smb
func (m *Smb) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConnectState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpenType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var smbTypeConnectStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["connected","disconnected","reconnecting","timedout"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		smbTypeConnectStatePropEnum = append(smbTypeConnectStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// smb
	// Smb
	// connect_state
	// ConnectState
	// connected
	// END DEBUGGING
	// SmbConnectStateConnected captures enum value "connected"
	SmbConnectStateConnected string = "connected"

	// BEGIN DEBUGGING
	// smb
	// Smb
	// connect_state
	// ConnectState
	// disconnected
	// END DEBUGGING
	// SmbConnectStateDisconnected captures enum value "disconnected"
	SmbConnectStateDisconnected string = "disconnected"

	// BEGIN DEBUGGING
	// smb
	// Smb
	// connect_state
	// ConnectState
	// reconnecting
	// END DEBUGGING
	// SmbConnectStateReconnecting captures enum value "reconnecting"
	SmbConnectStateReconnecting string = "reconnecting"

	// BEGIN DEBUGGING
	// smb
	// Smb
	// connect_state
	// ConnectState
	// timedout
	// END DEBUGGING
	// SmbConnectStateTimedout captures enum value "timedout"
	SmbConnectStateTimedout string = "timedout"
)

// prop value enum
func (m *Smb) validateConnectStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, smbTypeConnectStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Smb) validateConnectState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectState) { // not required
		return nil
	}

	// value enum
	if err := m.validateConnectStateEnum("connect_state", "body", *m.ConnectState); err != nil {
		return err
	}

	return nil
}

var smbTypeOpenTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","durable","persistent"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		smbTypeOpenTypePropEnum = append(smbTypeOpenTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// smb
	// Smb
	// open_type
	// OpenType
	// none
	// END DEBUGGING
	// SmbOpenTypeNone captures enum value "none"
	SmbOpenTypeNone string = "none"

	// BEGIN DEBUGGING
	// smb
	// Smb
	// open_type
	// OpenType
	// durable
	// END DEBUGGING
	// SmbOpenTypeDurable captures enum value "durable"
	SmbOpenTypeDurable string = "durable"

	// BEGIN DEBUGGING
	// smb
	// Smb
	// open_type
	// OpenType
	// persistent
	// END DEBUGGING
	// SmbOpenTypePersistent captures enum value "persistent"
	SmbOpenTypePersistent string = "persistent"
)

// prop value enum
func (m *Smb) validateOpenTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, smbTypeOpenTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Smb) validateOpenType(formats strfmt.Registry) error {
	if swag.IsZero(m.OpenType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOpenTypeEnum("open_type", "body", *m.OpenType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this smb based on the context it is used
func (m *Smb) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConnectState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpenGroupID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpenType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Smb) contextValidateConnectState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connect_state", "body", m.ConnectState); err != nil {
		return err
	}

	return nil
}

func (m *Smb) contextValidateOpenGroupID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "open_group_id", "body", m.OpenGroupID); err != nil {
		return err
	}

	return nil
}

func (m *Smb) contextValidateOpenType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "open_type", "body", m.OpenType); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Smb) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Smb) UnmarshalBinary(b []byte) error {
	var res Smb
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
