// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SnaplockFileFingerprint snaplock file fingerprint
//
// swagger:model snaplock_file_fingerprint
type SnaplockFileFingerprint struct {

	// links
	Links *SnaplockFileFingerprintInlineLinks `json:"_links,omitempty"`

	// The digest algorithm which is used for the fingerprint computation
	// Example: sha256
	// Enum: ["md5","sha256"]
	Algorithm *string `json:"algorithm,omitempty"`

	// The digest value of data of the file. The fingerprint is base64 encoded. This field is not included if the scope is metadata-only.
	// Example: MOFJVevxNSJm3C/4Bn5oEEYH51CrudOzZYK4r5Cfy1g=
	// Read Only: true
	DataFingerprint *string `json:"data_fingerprint,omitempty"`

	// The size of the file in bytes.
	// Example: 1048576
	// Read Only: true
	FileSize *int64 `json:"file_size,omitempty"`

	// The type of the file.
	// Example: worm
	// Read Only: true
	// Enum: ["worm","worm_appendable","worm_active_log","worm_log","regular"]
	FileType *string `json:"file_type,omitempty"`

	// A unique identifier for the fingerprint operation
	// Example: 17039367
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// The digest value of metadata of the file. The metadata fingerprint is calculated for file size, file ctime, file mtime, file crtime, file retention time, file uid, file gid, and file type. The fingerprint is base64 encoded. This field is not included if the scope is data-only.
	// Example: 8iMjqJXiNcqgXT5XuRhLiEwIrJEihDmwS0hrexnjgmc=
	// Read Only: true
	MetadataFingerprint *string `json:"metadata_fingerprint,omitempty"`

	// Specifies the path on which file fingerprint operation is running or has completed. Specifies the path relative to the output volume root, of the form "/path". The path can be path to a file or a directory.
	// Example: /homedir/dir1
	Path *string `json:"path,omitempty"`

	// The scope of the file which is used for the fingerprint computation
	// Example: data_only
	// Read Only: true
	// Enum: ["data_and_metadata","data_only","metadata_only"]
	Scope *string `json:"scope,omitempty"`

	// Specifies the status of fingerprint operation.
	// Example: completed
	// Read Only: true
	// Enum: ["in_progress","failed","aborting","completed"]
	State *string `json:"state,omitempty"`

	// svm
	Svm *SnaplockFileFingerprintInlineSvm `json:"svm,omitempty"`

	// volume
	Volume *SnaplockFileFingerprintInlineVolume `json:"volume,omitempty"`
}

// Validate validates this snaplock file fingerprint
func (m *SnaplockFileFingerprint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAlgorithm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFileType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprint) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var snaplockFileFingerprintTypeAlgorithmPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["md5","sha256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snaplockFileFingerprintTypeAlgorithmPropEnum = append(snaplockFileFingerprintTypeAlgorithmPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// algorithm
	// Algorithm
	// md5
	// END DEBUGGING
	// SnaplockFileFingerprintAlgorithmMd5 captures enum value "md5"
	SnaplockFileFingerprintAlgorithmMd5 string = "md5"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// algorithm
	// Algorithm
	// sha256
	// END DEBUGGING
	// SnaplockFileFingerprintAlgorithmSha256 captures enum value "sha256"
	SnaplockFileFingerprintAlgorithmSha256 string = "sha256"
)

// prop value enum
func (m *SnaplockFileFingerprint) validateAlgorithmEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snaplockFileFingerprintTypeAlgorithmPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnaplockFileFingerprint) validateAlgorithm(formats strfmt.Registry) error {
	if swag.IsZero(m.Algorithm) { // not required
		return nil
	}

	// value enum
	if err := m.validateAlgorithmEnum("algorithm", "body", *m.Algorithm); err != nil {
		return err
	}

	return nil
}

var snaplockFileFingerprintTypeFileTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["worm","worm_appendable","worm_active_log","worm_log","regular"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snaplockFileFingerprintTypeFileTypePropEnum = append(snaplockFileFingerprintTypeFileTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// file_type
	// FileType
	// worm
	// END DEBUGGING
	// SnaplockFileFingerprintFileTypeWorm captures enum value "worm"
	SnaplockFileFingerprintFileTypeWorm string = "worm"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// file_type
	// FileType
	// worm_appendable
	// END DEBUGGING
	// SnaplockFileFingerprintFileTypeWormAppendable captures enum value "worm_appendable"
	SnaplockFileFingerprintFileTypeWormAppendable string = "worm_appendable"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// file_type
	// FileType
	// worm_active_log
	// END DEBUGGING
	// SnaplockFileFingerprintFileTypeWormActiveLog captures enum value "worm_active_log"
	SnaplockFileFingerprintFileTypeWormActiveLog string = "worm_active_log"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// file_type
	// FileType
	// worm_log
	// END DEBUGGING
	// SnaplockFileFingerprintFileTypeWormLog captures enum value "worm_log"
	SnaplockFileFingerprintFileTypeWormLog string = "worm_log"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// file_type
	// FileType
	// regular
	// END DEBUGGING
	// SnaplockFileFingerprintFileTypeRegular captures enum value "regular"
	SnaplockFileFingerprintFileTypeRegular string = "regular"
)

// prop value enum
func (m *SnaplockFileFingerprint) validateFileTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snaplockFileFingerprintTypeFileTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnaplockFileFingerprint) validateFileType(formats strfmt.Registry) error {
	if swag.IsZero(m.FileType) { // not required
		return nil
	}

	// value enum
	if err := m.validateFileTypeEnum("file_type", "body", *m.FileType); err != nil {
		return err
	}

	return nil
}

var snaplockFileFingerprintTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data_and_metadata","data_only","metadata_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snaplockFileFingerprintTypeScopePropEnum = append(snaplockFileFingerprintTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// scope
	// Scope
	// data_and_metadata
	// END DEBUGGING
	// SnaplockFileFingerprintScopeDataAndMetadata captures enum value "data_and_metadata"
	SnaplockFileFingerprintScopeDataAndMetadata string = "data_and_metadata"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// scope
	// Scope
	// data_only
	// END DEBUGGING
	// SnaplockFileFingerprintScopeDataOnly captures enum value "data_only"
	SnaplockFileFingerprintScopeDataOnly string = "data_only"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// scope
	// Scope
	// metadata_only
	// END DEBUGGING
	// SnaplockFileFingerprintScopeMetadataOnly captures enum value "metadata_only"
	SnaplockFileFingerprintScopeMetadataOnly string = "metadata_only"
)

// prop value enum
func (m *SnaplockFileFingerprint) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snaplockFileFingerprintTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnaplockFileFingerprint) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

var snaplockFileFingerprintTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["in_progress","failed","aborting","completed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snaplockFileFingerprintTypeStatePropEnum = append(snaplockFileFingerprintTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// state
	// State
	// in_progress
	// END DEBUGGING
	// SnaplockFileFingerprintStateInProgress captures enum value "in_progress"
	SnaplockFileFingerprintStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// state
	// State
	// failed
	// END DEBUGGING
	// SnaplockFileFingerprintStateFailed captures enum value "failed"
	SnaplockFileFingerprintStateFailed string = "failed"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// state
	// State
	// aborting
	// END DEBUGGING
	// SnaplockFileFingerprintStateAborting captures enum value "aborting"
	SnaplockFileFingerprintStateAborting string = "aborting"

	// BEGIN DEBUGGING
	// snaplock_file_fingerprint
	// SnaplockFileFingerprint
	// state
	// State
	// completed
	// END DEBUGGING
	// SnaplockFileFingerprintStateCompleted captures enum value "completed"
	SnaplockFileFingerprintStateCompleted string = "completed"
)

// prop value enum
func (m *SnaplockFileFingerprint) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snaplockFileFingerprintTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnaplockFileFingerprint) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockFileFingerprint) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SnaplockFileFingerprint) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock file fingerprint based on the context it is used
func (m *SnaplockFileFingerprint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataFingerprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetadataFingerprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprint) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateDataFingerprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_fingerprint", "body", m.DataFingerprint); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateFileSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "file_size", "body", m.FileSize); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateFileType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "file_type", "body", m.FileType); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateMetadataFingerprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metadata_fingerprint", "body", m.MetadataFingerprint); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SnaplockFileFingerprint) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnaplockFileFingerprint) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnaplockFileFingerprint) UnmarshalBinary(b []byte) error {
	var res SnaplockFileFingerprint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnaplockFileFingerprintInlineLinks snaplock file fingerprint inline links
//
// swagger:model snaplock_file_fingerprint_inline__links
type SnaplockFileFingerprintInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snaplock file fingerprint inline links
func (m *SnaplockFileFingerprintInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock file fingerprint inline links based on the context it is used
func (m *SnaplockFileFingerprintInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnaplockFileFingerprintInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnaplockFileFingerprintInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model snaplock_file_fingerprint_inline_svm
type SnaplockFileFingerprintInlineSvm struct {

	// links
	Links *SnaplockFileFingerprintInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snaplock file fingerprint inline svm
func (m *SnaplockFileFingerprintInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock file fingerprint inline svm based on the context it is used
func (m *SnaplockFileFingerprintInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineSvm) UnmarshalBinary(b []byte) error {
	var res SnaplockFileFingerprintInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnaplockFileFingerprintInlineSvmInlineLinks snaplock file fingerprint inline svm inline links
//
// swagger:model snaplock_file_fingerprint_inline_svm_inline__links
type SnaplockFileFingerprintInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snaplock file fingerprint inline svm inline links
func (m *SnaplockFileFingerprintInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock file fingerprint inline svm inline links based on the context it is used
func (m *SnaplockFileFingerprintInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnaplockFileFingerprintInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnaplockFileFingerprintInlineVolume snaplock file fingerprint inline volume
//
// swagger:model snaplock_file_fingerprint_inline_volume
type SnaplockFileFingerprintInlineVolume struct {

	// links
	Links *SnaplockFileFingerprintInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snaplock file fingerprint inline volume
func (m *SnaplockFileFingerprintInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock file fingerprint inline volume based on the context it is used
func (m *SnaplockFileFingerprintInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineVolume) UnmarshalBinary(b []byte) error {
	var res SnaplockFileFingerprintInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnaplockFileFingerprintInlineVolumeInlineLinks snaplock file fingerprint inline volume inline links
//
// swagger:model snaplock_file_fingerprint_inline_volume_inline__links
type SnaplockFileFingerprintInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snaplock file fingerprint inline volume inline links
func (m *SnaplockFileFingerprintInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock file fingerprint inline volume inline links based on the context it is used
func (m *SnaplockFileFingerprintInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockFileFingerprintInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnaplockFileFingerprintInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnaplockFileFingerprintInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
