// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SnaplockLegalHoldOperation snaplock legal hold operation
//
// swagger:model snaplock_legal_hold_operation
type SnaplockLegalHoldOperation struct {

	// links
	Links *SnaplockLegalHoldOperationInlineLinks `json:"_links,omitempty"`

	// Operation ID.
	// Example: 16842759
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Specifies the number of files on which legal-hold operation failed.
	// Example: 0
	// Read Only: true
	NumFilesFailed *string `json:"num_files_failed,omitempty"`

	// Specifies the number of files on which legal-hold operation was successful.
	// Example: 30
	// Read Only: true
	NumFilesProcessed *string `json:"num_files_processed,omitempty"`

	// Specifies the number of files on which legal-hold begin operation was skipped. The legal-hold begin operation is skipped on a file if it is already under hold for a given litigation.
	// Example: 10
	// Read Only: true
	NumFilesSkipped *string `json:"num_files_skipped,omitempty"`

	// Specifies the number of inodes on which the legal-hold operation was not attempted because they were not regular files.
	// Example: 10
	// Read Only: true
	NumInodesIgnored *string `json:"num_inodes_ignored,omitempty"`

	// Specifies the path on which legal-hold operation is applied.
	// Example: /dir1
	Path *string `json:"path,omitempty"`

	// Specifies the status of legal-hold operation.
	// Example: completed
	// Read Only: true
	// Enum: ["in_progress","failed","aborting","completed"]
	State *string `json:"state,omitempty"`

	// Specifies the type of legal-hold operation.
	// Example: begin
	// Enum: ["begin","end"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this snaplock legal hold operation
func (m *SnaplockLegalHoldOperation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockLegalHoldOperation) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var snaplockLegalHoldOperationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["in_progress","failed","aborting","completed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snaplockLegalHoldOperationTypeStatePropEnum = append(snaplockLegalHoldOperationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snaplock_legal_hold_operation
	// SnaplockLegalHoldOperation
	// state
	// State
	// in_progress
	// END DEBUGGING
	// SnaplockLegalHoldOperationStateInProgress captures enum value "in_progress"
	SnaplockLegalHoldOperationStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// snaplock_legal_hold_operation
	// SnaplockLegalHoldOperation
	// state
	// State
	// failed
	// END DEBUGGING
	// SnaplockLegalHoldOperationStateFailed captures enum value "failed"
	SnaplockLegalHoldOperationStateFailed string = "failed"

	// BEGIN DEBUGGING
	// snaplock_legal_hold_operation
	// SnaplockLegalHoldOperation
	// state
	// State
	// aborting
	// END DEBUGGING
	// SnaplockLegalHoldOperationStateAborting captures enum value "aborting"
	SnaplockLegalHoldOperationStateAborting string = "aborting"

	// BEGIN DEBUGGING
	// snaplock_legal_hold_operation
	// SnaplockLegalHoldOperation
	// state
	// State
	// completed
	// END DEBUGGING
	// SnaplockLegalHoldOperationStateCompleted captures enum value "completed"
	SnaplockLegalHoldOperationStateCompleted string = "completed"
)

// prop value enum
func (m *SnaplockLegalHoldOperation) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snaplockLegalHoldOperationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnaplockLegalHoldOperation) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var snaplockLegalHoldOperationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["begin","end"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snaplockLegalHoldOperationTypeTypePropEnum = append(snaplockLegalHoldOperationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snaplock_legal_hold_operation
	// SnaplockLegalHoldOperation
	// type
	// Type
	// begin
	// END DEBUGGING
	// SnaplockLegalHoldOperationTypeBegin captures enum value "begin"
	SnaplockLegalHoldOperationTypeBegin string = "begin"

	// BEGIN DEBUGGING
	// snaplock_legal_hold_operation
	// SnaplockLegalHoldOperation
	// type
	// Type
	// end
	// END DEBUGGING
	// SnaplockLegalHoldOperationTypeEnd captures enum value "end"
	SnaplockLegalHoldOperationTypeEnd string = "end"
)

// prop value enum
func (m *SnaplockLegalHoldOperation) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snaplockLegalHoldOperationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnaplockLegalHoldOperation) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snaplock legal hold operation based on the context it is used
func (m *SnaplockLegalHoldOperation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumFilesFailed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumFilesProcessed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumFilesSkipped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumInodesIgnored(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockLegalHoldOperation) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnaplockLegalHoldOperation) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockLegalHoldOperation) contextValidateNumFilesFailed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_files_failed", "body", m.NumFilesFailed); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockLegalHoldOperation) contextValidateNumFilesProcessed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_files_processed", "body", m.NumFilesProcessed); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockLegalHoldOperation) contextValidateNumFilesSkipped(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_files_skipped", "body", m.NumFilesSkipped); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockLegalHoldOperation) contextValidateNumInodesIgnored(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_inodes_ignored", "body", m.NumInodesIgnored); err != nil {
		return err
	}

	return nil
}

func (m *SnaplockLegalHoldOperation) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnaplockLegalHoldOperation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnaplockLegalHoldOperation) UnmarshalBinary(b []byte) error {
	var res SnaplockLegalHoldOperation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnaplockLegalHoldOperationInlineLinks snaplock legal hold operation inline links
//
// swagger:model snaplock_legal_hold_operation_inline__links
type SnaplockLegalHoldOperationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snaplock legal hold operation inline links
func (m *SnaplockLegalHoldOperationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockLegalHoldOperationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snaplock legal hold operation inline links based on the context it is used
func (m *SnaplockLegalHoldOperationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnaplockLegalHoldOperationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnaplockLegalHoldOperationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnaplockLegalHoldOperationInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnaplockLegalHoldOperationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
