// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SnapmirrorPolicy SnapMirror policy information. SnapMirror policy can either be of type "async", "sync" or "continuous".<br>The policy type "async" can be associated with a SnapMirror relationship that has either a FlexVol volume, FlexGroup volume or SVM as the endpoint.<br>The policy type "sync" along with "sync_type" as "sync" or "strict_sync" can be associated with a SnapMirror relationship that has a FlexVol volume as the endpoint. The policy type "sync" can have a "sync_type" of either "sync", "strict_sync", "automated_failover" or "automated_failover_duplex". If the "sync_type" is "sync", a write success is returned to the client after writing the data to the source endpoint and before writing the data to the destination endpoint. If the "sync_type" is "strict_sync", a write success is returned to the client after writing the data to both source and destination endpoints.<br>If the "sync_type" is "automated_failover", the policy can be associated with a SnapMirror active sync relationship that has a consistency group as the endpoint and provides asymmetric active active access to the two storage copies. If the "sync_type" is "automated_failover_duplex", the policy can be associated with a SnapMirror active sync relationship that has a consistency group as the endpoint and provides symmetric active active access to the two storage copies. Use the "sync" policy with "sync_type" as "automated_failover" or "automated_failover_duplex" to establish SnapMirror active sync relationships for business continuity use cases. SnapMirror relationships with policy types as "sync" and "sync_type" as "automated_failover" or "automated_failover_duplex" can be monitored by the Mediator, if configured. If the source Consistency Group endpoint is not reachable, the Mediator might trigger a failover to the destination consistency group endpoint.<br>A policy type of "continuous" can be associated with SnapMirror relationships that have either ONTAP S3 buckets or non-ONTAP object stores as endpoints. This type of policy is used for FabricLink owned targets.
//
// swagger:model snapmirror_policy
type SnapmirrorPolicy struct {

	// links
	Links *SnapmirrorPolicyInlineLinks `json:"_links,omitempty"`

	// Comment associated with the policy.
	Comment *string `json:"comment,omitempty"`

	// Specifies that all the source snapshots (including the one created by SnapMirror before the transfer begins) should be copied to the destination on a transfer. "Retention" properties cannot be specified along with this property. This is applicable only to async policies. Property can only be set to 'true'.
	// Example: true
	CopyAllSourceSnapshots *bool `json:"copy_all_source_snapshots,omitempty"`

	// Specifies that the latest source snapshot (created by SnapMirror before the transfer begins) should be copied to the destination on a transfer. "Retention" properties cannot be specified along with this property. This is applicable only to async policies. Property can only be set to 'true'.
	// Example: true
	CopyLatestSourceSnapshot *bool `json:"copy_latest_source_snapshot,omitempty"`

	// Specifies whether a new snapshot should be created on the source at the beginning of an update or resync operation. This is applicable only to async policies. Property can only be set to 'false'.
	// Example: false
	CreateSnapshotOnSource *bool `json:"create_snapshot_on_source,omitempty"`

	// Specifies which configuration of the source SVM is replicated to the destination SVM. This property is applicable only for SVM data protection with "async" policy type.
	// Enum: ["full","exclude_network_config","exclude_network_and_protocol_config"]
	IdentityPreservation *string `json:"identity_preservation,omitempty"`

	// Name of the policy.
	// Example: Asynchronous
	Name *string `json:"name,omitempty"`

	// Specifies whether network compression is enabled for transfers. This is applicable only to the policies of type "async".
	NetworkCompressionEnabled *bool `json:"network_compression_enabled,omitempty"`

	// Specifies the duration of time for which a change to be propagated to a mirror should be delayed, in seconds. This is an intentional propagation delay between mirrors and is configurable down to zero, which means an immediate propagation. This is supported for policies of type 'continuous'.
	Rpo *int64 `json:"rpo,omitempty"`

	// Set to "svm" for policies owned by an SVM, otherwise set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// Rules for snapshot retention.
	SnapmirrorPolicyInlineRetention []*SnapmirrorPolicyRule `json:"retention,omitempty"`

	// svm
	Svm *SnapmirrorPolicyInlineSvm `json:"svm,omitempty"`

	// sync common snapshot schedule
	SyncCommonSnapshotSchedule *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule `json:"sync_common_snapshot_schedule,omitempty"`

	// sync type
	// Enum: ["sync","strict_sync","automated_failover","automated_failover_duplex"]
	SyncType *string `json:"sync_type,omitempty"`

	// Throttle in KB/s. Default to unlimited.
	Throttle *int64 `json:"throttle,omitempty"`

	// transfer schedule
	TransferSchedule *SnapmirrorPolicyInlineTransferSchedule `json:"transfer_schedule,omitempty"`

	// type
	// Enum: ["async","sync","continuous"]
	Type *string `json:"type,omitempty"`

	// Unique identifier of the SnapMirror policy.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy
func (m *SnapmirrorPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdentityPreservation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapmirrorPolicyInlineRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSyncCommonSnapshotSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSyncType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransferSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var snapmirrorPolicyTypeIdentityPreservationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","exclude_network_config","exclude_network_and_protocol_config"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorPolicyTypeIdentityPreservationPropEnum = append(snapmirrorPolicyTypeIdentityPreservationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// identity_preservation
	// IdentityPreservation
	// full
	// END DEBUGGING
	// SnapmirrorPolicyIdentityPreservationFull captures enum value "full"
	SnapmirrorPolicyIdentityPreservationFull string = "full"

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// identity_preservation
	// IdentityPreservation
	// exclude_network_config
	// END DEBUGGING
	// SnapmirrorPolicyIdentityPreservationExcludeNetworkConfig captures enum value "exclude_network_config"
	SnapmirrorPolicyIdentityPreservationExcludeNetworkConfig string = "exclude_network_config"

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// identity_preservation
	// IdentityPreservation
	// exclude_network_and_protocol_config
	// END DEBUGGING
	// SnapmirrorPolicyIdentityPreservationExcludeNetworkAndProtocolConfig captures enum value "exclude_network_and_protocol_config"
	SnapmirrorPolicyIdentityPreservationExcludeNetworkAndProtocolConfig string = "exclude_network_and_protocol_config"
)

// prop value enum
func (m *SnapmirrorPolicy) validateIdentityPreservationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorPolicyTypeIdentityPreservationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorPolicy) validateIdentityPreservation(formats strfmt.Registry) error {
	if swag.IsZero(m.IdentityPreservation) { // not required
		return nil
	}

	// value enum
	if err := m.validateIdentityPreservationEnum("identity_preservation", "body", *m.IdentityPreservation); err != nil {
		return err
	}

	return nil
}

var snapmirrorPolicyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorPolicyTypeScopePropEnum = append(snapmirrorPolicyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// SnapmirrorPolicyScopeSvm captures enum value "svm"
	SnapmirrorPolicyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// SnapmirrorPolicyScopeCluster captures enum value "cluster"
	SnapmirrorPolicyScopeCluster string = "cluster"
)

// prop value enum
func (m *SnapmirrorPolicy) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorPolicyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorPolicy) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorPolicy) validateSnapmirrorPolicyInlineRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapmirrorPolicyInlineRetention) { // not required
		return nil
	}

	for i := 0; i < len(m.SnapmirrorPolicyInlineRetention); i++ {
		if swag.IsZero(m.SnapmirrorPolicyInlineRetention[i]) { // not required
			continue
		}

		if m.SnapmirrorPolicyInlineRetention[i] != nil {
			if err := m.SnapmirrorPolicyInlineRetention[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("retention" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SnapmirrorPolicy) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorPolicy) validateSyncCommonSnapshotSchedule(formats strfmt.Registry) error {
	if swag.IsZero(m.SyncCommonSnapshotSchedule) { // not required
		return nil
	}

	if m.SyncCommonSnapshotSchedule != nil {
		if err := m.SyncCommonSnapshotSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sync_common_snapshot_schedule")
			}
			return err
		}
	}

	return nil
}

var snapmirrorPolicyTypeSyncTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sync","strict_sync","automated_failover","automated_failover_duplex"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorPolicyTypeSyncTypePropEnum = append(snapmirrorPolicyTypeSyncTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// sync_type
	// SyncType
	// sync
	// END DEBUGGING
	// SnapmirrorPolicySyncTypeSync captures enum value "sync"
	SnapmirrorPolicySyncTypeSync string = "sync"

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// sync_type
	// SyncType
	// strict_sync
	// END DEBUGGING
	// SnapmirrorPolicySyncTypeStrictSync captures enum value "strict_sync"
	SnapmirrorPolicySyncTypeStrictSync string = "strict_sync"

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// sync_type
	// SyncType
	// automated_failover
	// END DEBUGGING
	// SnapmirrorPolicySyncTypeAutomatedFailover captures enum value "automated_failover"
	SnapmirrorPolicySyncTypeAutomatedFailover string = "automated_failover"

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// sync_type
	// SyncType
	// automated_failover_duplex
	// END DEBUGGING
	// SnapmirrorPolicySyncTypeAutomatedFailoverDuplex captures enum value "automated_failover_duplex"
	SnapmirrorPolicySyncTypeAutomatedFailoverDuplex string = "automated_failover_duplex"
)

// prop value enum
func (m *SnapmirrorPolicy) validateSyncTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorPolicyTypeSyncTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorPolicy) validateSyncType(formats strfmt.Registry) error {
	if swag.IsZero(m.SyncType) { // not required
		return nil
	}

	// value enum
	if err := m.validateSyncTypeEnum("sync_type", "body", *m.SyncType); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorPolicy) validateTransferSchedule(formats strfmt.Registry) error {
	if swag.IsZero(m.TransferSchedule) { // not required
		return nil
	}

	if m.TransferSchedule != nil {
		if err := m.TransferSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule")
			}
			return err
		}
	}

	return nil
}

var snapmirrorPolicyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["async","sync","continuous"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorPolicyTypeTypePropEnum = append(snapmirrorPolicyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// type
	// Type
	// async
	// END DEBUGGING
	// SnapmirrorPolicyTypeAsync captures enum value "async"
	SnapmirrorPolicyTypeAsync string = "async"

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// type
	// Type
	// sync
	// END DEBUGGING
	// SnapmirrorPolicyTypeSync captures enum value "sync"
	SnapmirrorPolicyTypeSync string = "sync"

	// BEGIN DEBUGGING
	// snapmirror_policy
	// SnapmirrorPolicy
	// type
	// Type
	// continuous
	// END DEBUGGING
	// SnapmirrorPolicyTypeContinuous captures enum value "continuous"
	SnapmirrorPolicyTypeContinuous string = "continuous"
)

// prop value enum
func (m *SnapmirrorPolicy) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorPolicyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorPolicy) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorPolicy) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror policy based on the context it is used
func (m *SnapmirrorPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapmirrorPolicyInlineRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSyncCommonSnapshotSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransferSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorPolicy) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorPolicy) contextValidateSnapmirrorPolicyInlineRetention(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SnapmirrorPolicyInlineRetention); i++ {

		if m.SnapmirrorPolicyInlineRetention[i] != nil {
			if err := m.SnapmirrorPolicyInlineRetention[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("retention" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SnapmirrorPolicy) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorPolicy) contextValidateSyncCommonSnapshotSchedule(ctx context.Context, formats strfmt.Registry) error {

	if m.SyncCommonSnapshotSchedule != nil {
		if err := m.SyncCommonSnapshotSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sync_common_snapshot_schedule")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorPolicy) contextValidateTransferSchedule(ctx context.Context, formats strfmt.Registry) error {

	if m.TransferSchedule != nil {
		if err := m.TransferSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicy) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyInlineLinks snapmirror policy inline links
//
// swagger:model snapmirror_policy_inline__links
type SnapmirrorPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy inline links
func (m *SnapmirrorPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline links based on the context it is used
func (m *SnapmirrorPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model snapmirror_policy_inline_svm
type SnapmirrorPolicyInlineSvm struct {

	// links
	Links *SnapmirrorPolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy inline svm
func (m *SnapmirrorPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline svm based on the context it is used
func (m *SnapmirrorPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyInlineSvmInlineLinks snapmirror policy inline svm inline links
//
// swagger:model snapmirror_policy_inline_svm_inline__links
type SnapmirrorPolicyInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy inline svm inline links
func (m *SnapmirrorPolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline svm inline links based on the context it is used
func (m *SnapmirrorPolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyInlineSyncCommonSnapshotSchedule Schedule used to create common snapshots for synchronous relationships.
//
// swagger:model snapmirror_policy_inline_sync_common_snapshot_schedule
type SnapmirrorPolicyInlineSyncCommonSnapshotSchedule struct {

	// links
	Links *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks `json:"_links,omitempty"`

	// Job schedule name
	// Example: weekly
	Name *string `json:"name,omitempty"`

	// Job schedule UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy inline sync common snapshot schedule
func (m *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sync_common_snapshot_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline sync common snapshot schedule based on the context it is used
func (m *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sync_common_snapshot_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineSyncCommonSnapshotSchedule) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineSyncCommonSnapshotSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks snapmirror policy inline sync common snapshot schedule inline links
//
// swagger:model snapmirror_policy_inline_sync_common_snapshot_schedule_inline__links
type SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy inline sync common snapshot schedule inline links
func (m *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sync_common_snapshot_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline sync common snapshot schedule inline links based on the context it is used
func (m *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sync_common_snapshot_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineSyncCommonSnapshotScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyInlineTransferSchedule The schedule used to update asynchronous relationships. Only cron schedules are supported for SnapMirror.
//
// swagger:model snapmirror_policy_inline_transfer_schedule
type SnapmirrorPolicyInlineTransferSchedule struct {

	// links
	Links *SnapmirrorPolicyInlineTransferScheduleInlineLinks `json:"_links,omitempty"`

	// Job schedule name
	// Example: weekly
	Name *string `json:"name,omitempty"`

	// Job schedule UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy inline transfer schedule
func (m *SnapmirrorPolicyInlineTransferSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineTransferSchedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline transfer schedule based on the context it is used
func (m *SnapmirrorPolicyInlineTransferSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineTransferSchedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineTransferSchedule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineTransferSchedule) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineTransferSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyInlineTransferScheduleInlineLinks snapmirror policy inline transfer schedule inline links
//
// swagger:model snapmirror_policy_inline_transfer_schedule_inline__links
type SnapmirrorPolicyInlineTransferScheduleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy inline transfer schedule inline links
func (m *SnapmirrorPolicyInlineTransferScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineTransferScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy inline transfer schedule inline links based on the context it is used
func (m *SnapmirrorPolicyInlineTransferScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyInlineTransferScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineTransferScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyInlineTransferScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyInlineTransferScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
