// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SnapmirrorPolicyRule SnapMirror policy rule for retention.
//
// swagger:model snapmirror_policy_rule
type SnapmirrorPolicyRule struct {

	// Number of snapshots to be kept for retention. Maximum value will differ based on type of relationship and scaling factor.
	// Example: 7
	Count *int64 `json:"count,omitempty"`

	// creation schedule
	CreationSchedule *SnapmirrorPolicyRuleInlineCreationSchedule `json:"creation_schedule,omitempty"`

	// Snapshot label
	// Example: hourly
	Label *string `json:"label,omitempty"`

	// Specifies the duration for which the snapshots are locked. The retention period value represents a duration and must be in the ISO-8601 duration format. Years, months, days, hours, minutes, and seconds are represented as "P<num>Y","P<num>M","P<num>D","PT<num>H","PT<num>M" and "PT<num>S". Value "infinite" is also a valid input for Flexvol volumes and FlexGroup volumes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. The range of supported retention period values is between 1 second to infinite.
	// Example: P30D
	Period *string `json:"period,omitempty"`

	// Specifies the prefix for the snapshot name to be created as per the schedule. If no value is specified, then the label is used as the prefix.
	Prefix *string `json:"prefix,omitempty"`

	// Specifies the behavior when the snapshot retention count is reached on the SnapMirror destination for the rule. The default value is false, which means that the oldest snapshot is deleted to make room for new ones but only if the number of snapshots has exceeded the retention count specified in the 'count' property. When set to true and where the snapshots have reached the retention count, an incremental SnapMirror transfer will fail or if the rule has a schedule, snapshots will be no longer be created on the SnapMirror destination.
	// Example: true
	Preserve *bool `json:"preserve,omitempty"`

	// Specifies the warning threshold count for the rule. The default value is zero. When set to a value greater than zero, an event is generated after the number of snapshots (for the particular rule) retained on a SnapMirror destination reaches the specified warning limit. The preserve property for the rule must be true in order to set the warn property to a value greater than zero.
	// Example: 4
	Warn *int64 `json:"warn,omitempty"`
}

// Validate validates this snapmirror policy rule
func (m *SnapmirrorPolicyRule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreationSchedule(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyRule) validateCreationSchedule(formats strfmt.Registry) error {
	if swag.IsZero(m.CreationSchedule) { // not required
		return nil
	}

	if m.CreationSchedule != nil {
		if err := m.CreationSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("creation_schedule")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy rule based on the context it is used
func (m *SnapmirrorPolicyRule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreationSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyRule) contextValidateCreationSchedule(ctx context.Context, formats strfmt.Registry) error {

	if m.CreationSchedule != nil {
		if err := m.CreationSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("creation_schedule")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyRule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyRule) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyRule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyRuleInlineCreationSchedule Schedule used to create snapshots on the destination for long term retention. Only cron schedules are supported for SnapMirror.
//
// swagger:model snapmirror_policy_rule_inline_creation_schedule
type SnapmirrorPolicyRuleInlineCreationSchedule struct {

	// links
	Links *SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks `json:"_links,omitempty"`

	// Job schedule name
	// Example: weekly
	Name *string `json:"name,omitempty"`

	// Job schedule UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror policy rule inline creation schedule
func (m *SnapmirrorPolicyRuleInlineCreationSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyRuleInlineCreationSchedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("creation_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy rule inline creation schedule based on the context it is used
func (m *SnapmirrorPolicyRuleInlineCreationSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyRuleInlineCreationSchedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("creation_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyRuleInlineCreationSchedule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyRuleInlineCreationSchedule) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyRuleInlineCreationSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks snapmirror policy rule inline creation schedule inline links
//
// swagger:model snapmirror_policy_rule_inline_creation_schedule_inline__links
type SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror policy rule inline creation schedule inline links
func (m *SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("creation_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror policy rule inline creation schedule inline links based on the context it is used
func (m *SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("creation_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorPolicyRuleInlineCreationScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
