// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SnapmirrorRelationship SnapMirror relationship information. The SnapMirror relationship can be either "async" or "sync" based on the type of SnapMirror policy associated with the relationship. The source and destination endpoints of a SnapMirror relationship must be of the same type, for example, if the source endpoint is a FlexVol volume then the destination endpoint must be a FlexVol volume.<br>The SnapMirror policy type "async" can be used when the SnapMirror relationship has FlexVol volume or FlexGroup volume or SVM as the endpoint. The SnapMirror policy type "sync" can be used when the SnapMirror relationship has FlexVol volume as the endpoint. The SnapMirror policy type "sync" with "sync_type" as "automated_failover" can be used when the SnapMirror relationship has Consistency Group as the endpoint.
//
// swagger:model snapmirror_relationship
type SnapmirrorRelationship struct {

	// links
	Links *SnapmirrorRelationshipInlineLinks `json:"_links,omitempty"`

	// Specifies the SnapMirror backoff level due to Client Ops for FlexVol SnapMirror relationships.
	// Example: medium
	// Enum: ["high","medium","none"]
	BackoffLevel *string `json:"backoff_level,omitempty"`

	// consistency group failover
	ConsistencyGroupFailover *SnapmirrorConsistencyGroupFailover `json:"consistency_group_failover,omitempty"`

	// create destination
	CreateDestination *SnapmirrorDestinationCreation `json:"create_destination,omitempty"`

	// This property is the destination endpoint of the relationship. The destination endpoint can be a FlexVol volume, FlexGroup volume, Consistency Group, or SVM. For the POST request, the destination endpoint must be of type "DP" when the endpoint is a FlexVol volume or a FlexGroup volume. When specifying a Consistency Group as the destination endpoint, the "destination.consistency_group_volumes" or "destination.luns" property must be specified with the FlexVol volumes or LUNs of type "DP". The POST request for SVM must have a destination endpoint of type "dp-destination". The destination endpoint path name must be specified in the "destination.path" property. For relationships of type "async", the destination endpoint for FlexVol volume and FlexGroup volume will change to type "RW" when the relationship status is "broken_off" and will revert to type "DP" when the relationship status is "snapmirrored" or "in_sync" using the PATCH request. The destination endpoint for SVM will change from "dp-destination" to type "default" when the relationship status is "broken_off" and will revert to type "dp-destination" when the relationship status is "snapmirrored" using the PATCH request. When the destination endpoint is a Consistency Group, the Consistency Group FlexVol volumes will change to type "RW" when the relationship status is "broken_off" and will revert to type "DP" when the relationship status is "in_sync" using the PATCH request.
	Destination *SnapmirrorEndpoint `json:"destination,omitempty"`

	// Snapshot exported to clients on destination.
	// Read Only: true
	ExportedSnapshot *string `json:"exported_snapshot,omitempty"`

	// Specifies the group type of the top level SnapMirror relationship. The volume relationships are shown as _none_, the SVMDR relationships are shown as _svm_dr_, the Consistency Group relationships are shown as _consistency_group_, and the FlexGroup volume relationships are shown as _flexgroup_.
	// Example: consistency_group
	// Read Only: true
	// Enum: ["none","svm_dr","consistency_group","flexgroup"]
	GroupType *string `json:"group_type,omitempty"`

	// Is the relationship healthy?
	// Read Only: true
	Healthy *bool `json:"healthy,omitempty"`

	// Specifies which configuration of the source SVM is replicated to the destination SVM. This property is applicable only for SVM data protection with "async" policy type. This "identity_preservation" overrides the "identity_preservation" set on the SnapMirror relationship's policy.
	// Enum: ["full","exclude_network_config","exclude_network_and_protocol_config"]
	IdentityPreservation *string `json:"identity_preservation,omitempty"`

	// Specifies the sites serving I/O for the SnapMirror active sync relationship.
	// Example: C1_sti85-vsim-ucs209a_cluster, C1_sti85-vsim-ucs209c_cluster
	IoServingCopy *string `json:"io_serving_copy,omitempty"`

	// Time since the exported snapshot was created.
	// Example: PT8H35M42S
	// Read Only: true
	LagTime *string `json:"lag_time,omitempty"`

	// Specifies the compression ratio achieved for the data sent over the wire with network compression enabled for the last successful transfer.
	// Example: 61
	// Read Only: true
	LastTransferNetworkCompressionRatio *string `json:"last_transfer_network_compression_ratio,omitempty"`

	// Specifies the operation type of the last transfer that occurred on the relationship. The _initialize_ transfer occurs when the relationship state changes from uninitialized to snapmirrored or in_sync. The _update_ transfer occurs when the snapshots are transferred from the source endpoint to the destination endpoint as part of scheduled or manual update. The _resync_ transfer occurs when the relationship state changes from broken_off to snapmirrored or in_sync. The _restore_ transfer occurs when the snapshot is restored from a destination endpoint to another endpoint.
	// Example: initialize
	// Read Only: true
	// Enum: ["initialize","update","resync","restore"]
	LastTransferType *string `json:"last_transfer_type,omitempty"`

	// Specifies the Master Bias Activated Site for the SnapMirror active sync relationship.
	// Example: C1_sti85-vsim-ucs209a_cluster
	MasterBiasActivatedSite *string `json:"master_bias_activated_site,omitempty"`

	// policy
	Policy *SnapmirrorRelationshipInlinePolicy `json:"policy,omitempty"`

	// Specifies the Primary Site of the SnapMirror active sync relationship.
	// Example: C1_sti85-vsim-ucs209a_cluster
	PreferredSite *string `json:"preferred_site,omitempty"`

	// Set to true on resync to preserve snapshots on the destination that are newer than the latest common snapshot. This property is applicable only for relationships with FlexVol volume or FlexGroup volume endpoints and when the PATCH state is being changed to "snapmirrored".
	Preserve *bool `json:"preserve,omitempty"`

	// Set to true to reduce resync time by not preserving storage efficiency. This property is applicable only for relationships with FlexVol volume endpoints and SVMDR relationships when the PATCH state is being changed to "snapmirrored".
	QuickResync *bool `json:"quick_resync,omitempty"`

	// Set to true to recover from a failed SnapMirror break operation on a FlexGroup volume relationship. This restores all destination FlexGroup constituent volumes to the latest snapshot, and any writes to the read-write constituents are lost. This property is applicable only for SnapMirror relationships with FlexGroup volume endpoints and when the PATCH state is being changed to "broken_off".
	RecoverAfterBreak *bool `json:"recover_after_break,omitempty"`

	// Set to true to create a relationship for restore. To trigger restore-transfer, use transfers POST on the restore relationship. SnapMirror relationships with the policy type "async" can be restored. SnapMirror relationships with the policy type "sync" cannot be restored.
	Restore *bool `json:"restore,omitempty"`

	// Specifies the snapshot to restore to on the destination during the break operation. This property is applicable only for SnapMirror relationships with FlexVol volume endpoints and when the PATCH state is being changed to "broken_off".
	RestoreToSnapshot *string `json:"restore_to_snapshot,omitempty"`

	// Specifies the list of constituent FlexVol volumes and FlexGroup volumes for an SVM DR SnapMirror relationship. FlexGroup constituents are not considered.
	SnapmirrorRelationshipInlineSvmdrVolumes []*SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem `json:"svmdr_volumes,omitempty"`

	// Reason the relationship is not healthy. It is a concatenation of up to four levels of error messages.
	// Example: [{"arguments":[],"code":"6621444","message":"Failed to complete update operation on one or more item relationships."},{"arguments":[],"code":"6621445","message":"Group Update failed"}]
	// Read Only: true
	SnapmirrorRelationshipInlineUnhealthyReason []*SnapmirrorError `json:"unhealthy_reason,omitempty"`

	// This property is the source endpoint of the relationship. The source endpoint can be a FlexVol volume, FlexGroup volume, Consistency Group, or SVM. To establish a SnapMirror relationship with SVM as source endpoint, the SVM must have only FlexVol volumes. For a Consistency Group this property identifies the source Consistency Group name. When specifying a Consistency Group as the source endpoint, the "source.consistency_group_volumes" property must be specified with the FlexVol volumes of type "RW". FlexVol volumes of type "DP" cannot be specified in the "source.consistency_group_volumes" list. Optionally, "source.luns" property of source endpoint can be specified with source LUN names during SnapMirror Consistency Group LUN Restore Operation.
	Source *SnapmirrorSourceEndpoint `json:"source,omitempty"`

	// State of the relationship.<br>To initialize the relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or to state "in_sync" for relationships with a policy of type "sync".<br>To break the relationship, PATCH the state to "broken_off" for relationships with a policy of type "async" or "sync". SnapMirror relationships with the policy type as "sync" and "sync_type" as "automated_failover" cannot be "broken_off".<br>To resync the relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or to state "in_sync" for relationships with a policy of type "sync". SnapMirror relationships with the policy type as "sync" and "sync_type" as "automated_failover" can be in "broken_off" state due to a failed attempt of SnapMirror failover.<br>To pause the relationship, suspending further transfers, PATCH the state to "paused" for relationships with a policy of type "async" or "sync". SnapMirror relationships with the policy type as "sync" and "sync_type" as "automated_failover" cannot be "paused".<br>To resume transfers for a paused relationship, PATCH the state to "snapmirrored" for relationships with a policy of type "async" or to state "in_sync" for relationships with a policy of type "sync".<br>The entries "in_sync", "out_of_sync", "synchronizing", "expanding", and "shrinking" are only applicable to relationships with a policy of type "sync". A PATCH call on the state change only triggers the transition to the specified state. You must poll on the "state", "healthy" and "unhealthy_reason" properties using a GET request to determine if the transition is successful. To automatically initialize the relationship when specifying "create_destination" property, set the state to "snapmirrored" for relationships with a policy of type "async" or to state "in_sync" for relationships with a policy of type "sync".
	// Example: snapmirrored
	// Enum: ["broken_off","paused","snapmirrored","uninitialized","in_sync","out_of_sync","synchronizing","expanding","shrinking"]
	State *string `json:"state,omitempty"`

	// Throttle, in KBs per second. This "throttle" overrides the "throttle" set on the SnapMirror relationship's policy. If neither of these are set, defaults to 0, which is interpreted as unlimited.
	Throttle *int64 `json:"throttle,omitempty"`

	// Cumulative bytes transferred for the relationship.
	// Example: 1098210312
	// Read Only: true
	TotalTransferBytes *int64 `json:"total_transfer_bytes,omitempty"`

	// Indicates the cumulative duration of all transfers since the last aggregate relocation, takeover/giveback, or metrocluster switchover/switchback involving the node that hosts the relationship.
	// Example: PT3M21S
	// Read Only: true
	TotalTransferDuration *string `json:"total_transfer_duration,omitempty"`

	// transfer
	Transfer *SnapmirrorRelationshipInlineTransfer `json:"transfer,omitempty"`

	// transfer schedule
	TransferSchedule *SnapmirrorRelationshipInlineTransferSchedule `json:"transfer_schedule,omitempty"`

	// Unique identifier of the SnapMirror relationship.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship
func (m *SnapmirrorRelationship) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackoffLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupFailover(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroupType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdentityPreservation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastTransferType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapmirrorRelationshipInlineSvmdrVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapmirrorRelationshipInlineUnhealthyReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransfer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransferSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationship) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var snapmirrorRelationshipTypeBackoffLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["high","medium","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipTypeBackoffLevelPropEnum = append(snapmirrorRelationshipTypeBackoffLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// backoff_level
	// BackoffLevel
	// high
	// END DEBUGGING
	// SnapmirrorRelationshipBackoffLevelHigh captures enum value "high"
	SnapmirrorRelationshipBackoffLevelHigh string = "high"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// backoff_level
	// BackoffLevel
	// medium
	// END DEBUGGING
	// SnapmirrorRelationshipBackoffLevelMedium captures enum value "medium"
	SnapmirrorRelationshipBackoffLevelMedium string = "medium"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// backoff_level
	// BackoffLevel
	// none
	// END DEBUGGING
	// SnapmirrorRelationshipBackoffLevelNone captures enum value "none"
	SnapmirrorRelationshipBackoffLevelNone string = "none"
)

// prop value enum
func (m *SnapmirrorRelationship) validateBackoffLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipTypeBackoffLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorRelationship) validateBackoffLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.BackoffLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateBackoffLevelEnum("backoff_level", "body", *m.BackoffLevel); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) validateConsistencyGroupFailover(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupFailover) { // not required
		return nil
	}

	if m.ConsistencyGroupFailover != nil {
		if err := m.ConsistencyGroupFailover.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group_failover")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) validateCreateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateDestination) { // not required
		return nil
	}

	if m.CreateDestination != nil {
		if err := m.CreateDestination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create_destination")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.Destination) { // not required
		return nil
	}

	if m.Destination != nil {
		if err := m.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination")
			}
			return err
		}
	}

	return nil
}

var snapmirrorRelationshipTypeGroupTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","svm_dr","consistency_group","flexgroup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipTypeGroupTypePropEnum = append(snapmirrorRelationshipTypeGroupTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// group_type
	// GroupType
	// none
	// END DEBUGGING
	// SnapmirrorRelationshipGroupTypeNone captures enum value "none"
	SnapmirrorRelationshipGroupTypeNone string = "none"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// group_type
	// GroupType
	// svm_dr
	// END DEBUGGING
	// SnapmirrorRelationshipGroupTypeSvmDr captures enum value "svm_dr"
	SnapmirrorRelationshipGroupTypeSvmDr string = "svm_dr"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// group_type
	// GroupType
	// consistency_group
	// END DEBUGGING
	// SnapmirrorRelationshipGroupTypeConsistencyGroup captures enum value "consistency_group"
	SnapmirrorRelationshipGroupTypeConsistencyGroup string = "consistency_group"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// group_type
	// GroupType
	// flexgroup
	// END DEBUGGING
	// SnapmirrorRelationshipGroupTypeFlexgroup captures enum value "flexgroup"
	SnapmirrorRelationshipGroupTypeFlexgroup string = "flexgroup"
)

// prop value enum
func (m *SnapmirrorRelationship) validateGroupTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipTypeGroupTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorRelationship) validateGroupType(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupType) { // not required
		return nil
	}

	// value enum
	if err := m.validateGroupTypeEnum("group_type", "body", *m.GroupType); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipTypeIdentityPreservationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","exclude_network_config","exclude_network_and_protocol_config"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipTypeIdentityPreservationPropEnum = append(snapmirrorRelationshipTypeIdentityPreservationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// identity_preservation
	// IdentityPreservation
	// full
	// END DEBUGGING
	// SnapmirrorRelationshipIdentityPreservationFull captures enum value "full"
	SnapmirrorRelationshipIdentityPreservationFull string = "full"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// identity_preservation
	// IdentityPreservation
	// exclude_network_config
	// END DEBUGGING
	// SnapmirrorRelationshipIdentityPreservationExcludeNetworkConfig captures enum value "exclude_network_config"
	SnapmirrorRelationshipIdentityPreservationExcludeNetworkConfig string = "exclude_network_config"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// identity_preservation
	// IdentityPreservation
	// exclude_network_and_protocol_config
	// END DEBUGGING
	// SnapmirrorRelationshipIdentityPreservationExcludeNetworkAndProtocolConfig captures enum value "exclude_network_and_protocol_config"
	SnapmirrorRelationshipIdentityPreservationExcludeNetworkAndProtocolConfig string = "exclude_network_and_protocol_config"
)

// prop value enum
func (m *SnapmirrorRelationship) validateIdentityPreservationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipTypeIdentityPreservationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorRelationship) validateIdentityPreservation(formats strfmt.Registry) error {
	if swag.IsZero(m.IdentityPreservation) { // not required
		return nil
	}

	// value enum
	if err := m.validateIdentityPreservationEnum("identity_preservation", "body", *m.IdentityPreservation); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipTypeLastTransferTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["initialize","update","resync","restore"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipTypeLastTransferTypePropEnum = append(snapmirrorRelationshipTypeLastTransferTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// last_transfer_type
	// LastTransferType
	// initialize
	// END DEBUGGING
	// SnapmirrorRelationshipLastTransferTypeInitialize captures enum value "initialize"
	SnapmirrorRelationshipLastTransferTypeInitialize string = "initialize"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// last_transfer_type
	// LastTransferType
	// update
	// END DEBUGGING
	// SnapmirrorRelationshipLastTransferTypeUpdate captures enum value "update"
	SnapmirrorRelationshipLastTransferTypeUpdate string = "update"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// last_transfer_type
	// LastTransferType
	// resync
	// END DEBUGGING
	// SnapmirrorRelationshipLastTransferTypeResync captures enum value "resync"
	SnapmirrorRelationshipLastTransferTypeResync string = "resync"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// last_transfer_type
	// LastTransferType
	// restore
	// END DEBUGGING
	// SnapmirrorRelationshipLastTransferTypeRestore captures enum value "restore"
	SnapmirrorRelationshipLastTransferTypeRestore string = "restore"
)

// prop value enum
func (m *SnapmirrorRelationship) validateLastTransferTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipTypeLastTransferTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorRelationship) validateLastTransferType(formats strfmt.Registry) error {
	if swag.IsZero(m.LastTransferType) { // not required
		return nil
	}

	// value enum
	if err := m.validateLastTransferTypeEnum("last_transfer_type", "body", *m.LastTransferType); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) validateSnapmirrorRelationshipInlineSvmdrVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapmirrorRelationshipInlineSvmdrVolumes) { // not required
		return nil
	}

	for i := 0; i < len(m.SnapmirrorRelationshipInlineSvmdrVolumes); i++ {
		if swag.IsZero(m.SnapmirrorRelationshipInlineSvmdrVolumes[i]) { // not required
			continue
		}

		if m.SnapmirrorRelationshipInlineSvmdrVolumes[i] != nil {
			if err := m.SnapmirrorRelationshipInlineSvmdrVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("svmdr_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SnapmirrorRelationship) validateSnapmirrorRelationshipInlineUnhealthyReason(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapmirrorRelationshipInlineUnhealthyReason) { // not required
		return nil
	}

	for i := 0; i < len(m.SnapmirrorRelationshipInlineUnhealthyReason); i++ {
		if swag.IsZero(m.SnapmirrorRelationshipInlineUnhealthyReason[i]) { // not required
			continue
		}

		if m.SnapmirrorRelationshipInlineUnhealthyReason[i] != nil {
			if err := m.SnapmirrorRelationshipInlineUnhealthyReason[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("unhealthy_reason" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SnapmirrorRelationship) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

var snapmirrorRelationshipTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["broken_off","paused","snapmirrored","uninitialized","in_sync","out_of_sync","synchronizing","expanding","shrinking"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipTypeStatePropEnum = append(snapmirrorRelationshipTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// broken_off
	// END DEBUGGING
	// SnapmirrorRelationshipStateBrokenOff captures enum value "broken_off"
	SnapmirrorRelationshipStateBrokenOff string = "broken_off"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// paused
	// END DEBUGGING
	// SnapmirrorRelationshipStatePaused captures enum value "paused"
	SnapmirrorRelationshipStatePaused string = "paused"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// snapmirrored
	// END DEBUGGING
	// SnapmirrorRelationshipStateSnapmirrored captures enum value "snapmirrored"
	SnapmirrorRelationshipStateSnapmirrored string = "snapmirrored"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// uninitialized
	// END DEBUGGING
	// SnapmirrorRelationshipStateUninitialized captures enum value "uninitialized"
	SnapmirrorRelationshipStateUninitialized string = "uninitialized"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// in_sync
	// END DEBUGGING
	// SnapmirrorRelationshipStateInSync captures enum value "in_sync"
	SnapmirrorRelationshipStateInSync string = "in_sync"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// out_of_sync
	// END DEBUGGING
	// SnapmirrorRelationshipStateOutOfSync captures enum value "out_of_sync"
	SnapmirrorRelationshipStateOutOfSync string = "out_of_sync"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// synchronizing
	// END DEBUGGING
	// SnapmirrorRelationshipStateSynchronizing captures enum value "synchronizing"
	SnapmirrorRelationshipStateSynchronizing string = "synchronizing"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// expanding
	// END DEBUGGING
	// SnapmirrorRelationshipStateExpanding captures enum value "expanding"
	SnapmirrorRelationshipStateExpanding string = "expanding"

	// BEGIN DEBUGGING
	// snapmirror_relationship
	// SnapmirrorRelationship
	// state
	// State
	// shrinking
	// END DEBUGGING
	// SnapmirrorRelationshipStateShrinking captures enum value "shrinking"
	SnapmirrorRelationshipStateShrinking string = "shrinking"
)

// prop value enum
func (m *SnapmirrorRelationship) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorRelationship) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) validateTransfer(formats strfmt.Registry) error {
	if swag.IsZero(m.Transfer) { // not required
		return nil
	}

	if m.Transfer != nil {
		if err := m.Transfer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) validateTransferSchedule(formats strfmt.Registry) error {
	if swag.IsZero(m.TransferSchedule) { // not required
		return nil
	}

	if m.TransferSchedule != nil {
		if err := m.TransferSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror relationship based on the context it is used
func (m *SnapmirrorRelationship) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupFailover(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportedSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGroupType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHealthy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLagTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastTransferNetworkCompressionRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastTransferType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapmirrorRelationshipInlineSvmdrVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapmirrorRelationshipInlineUnhealthyReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTransferBytes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalTransferDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransfer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransferSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationship) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateConsistencyGroupFailover(ctx context.Context, formats strfmt.Registry) error {

	if m.ConsistencyGroupFailover != nil {
		if err := m.ConsistencyGroupFailover.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group_failover")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateCreateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.CreateDestination != nil {
		if err := m.CreateDestination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("create_destination")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.Destination != nil {
		if err := m.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateExportedSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "exported_snapshot", "body", m.ExportedSnapshot); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateGroupType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "group_type", "body", m.GroupType); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateHealthy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "healthy", "body", m.Healthy); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateLagTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lag_time", "body", m.LagTime); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateLastTransferNetworkCompressionRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_transfer_network_compression_ratio", "body", m.LastTransferNetworkCompressionRatio); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateLastTransferType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_transfer_type", "body", m.LastTransferType); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateSnapmirrorRelationshipInlineSvmdrVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SnapmirrorRelationshipInlineSvmdrVolumes); i++ {

		if m.SnapmirrorRelationshipInlineSvmdrVolumes[i] != nil {
			if err := m.SnapmirrorRelationshipInlineSvmdrVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("svmdr_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateSnapmirrorRelationshipInlineUnhealthyReason(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "unhealthy_reason", "body", []*SnapmirrorError(m.SnapmirrorRelationshipInlineUnhealthyReason)); err != nil {
		return err
	}

	for i := 0; i < len(m.SnapmirrorRelationshipInlineUnhealthyReason); i++ {

		if m.SnapmirrorRelationshipInlineUnhealthyReason[i] != nil {
			if err := m.SnapmirrorRelationshipInlineUnhealthyReason[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("unhealthy_reason" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateTotalTransferBytes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_transfer_bytes", "body", m.TotalTransferBytes); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateTotalTransferDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_transfer_duration", "body", m.TotalTransferDuration); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateTransfer(ctx context.Context, formats strfmt.Registry) error {

	if m.Transfer != nil {
		if err := m.Transfer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateTransferSchedule(ctx context.Context, formats strfmt.Registry) error {

	if m.TransferSchedule != nil {
		if err := m.TransferSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationship) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationship) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationship) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationship
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorRelationshipInlineLinks snapmirror relationship inline links
//
// swagger:model snapmirror_relationship_inline__links
type SnapmirrorRelationshipInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror relationship inline links
func (m *SnapmirrorRelationshipInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline links based on the context it is used
func (m *SnapmirrorRelationshipInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorRelationshipInlinePolicy Basic policy information of the relationship.
//
// swagger:model snapmirror_relationship_inline_policy
type SnapmirrorRelationshipInlinePolicy struct {

	// links
	Links *SnapmirrorRelationshipInlinePolicyInlineLinks `json:"_links,omitempty"`

	// Name of the SnapMirror policy.
	// Example: Asynchronous
	Name *string `json:"name,omitempty"`

	// type
	// Read Only: true
	// Enum: ["async","sync","continuous"]
	Type *string `json:"type,omitempty"`

	// Unique identifier of the SnapMirror policy.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship inline policy
func (m *SnapmirrorRelationshipInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var snapmirrorRelationshipInlinePolicyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["async","sync","continuous"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipInlinePolicyTypeTypePropEnum = append(snapmirrorRelationshipInlinePolicyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_policy
	// SnapmirrorRelationshipInlinePolicy
	// type
	// Type
	// async
	// END DEBUGGING
	// SnapmirrorRelationshipInlinePolicyTypeAsync captures enum value "async"
	SnapmirrorRelationshipInlinePolicyTypeAsync string = "async"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_policy
	// SnapmirrorRelationshipInlinePolicy
	// type
	// Type
	// sync
	// END DEBUGGING
	// SnapmirrorRelationshipInlinePolicyTypeSync captures enum value "sync"
	SnapmirrorRelationshipInlinePolicyTypeSync string = "sync"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_policy
	// SnapmirrorRelationshipInlinePolicy
	// type
	// Type
	// continuous
	// END DEBUGGING
	// SnapmirrorRelationshipInlinePolicyTypeContinuous captures enum value "continuous"
	SnapmirrorRelationshipInlinePolicyTypeContinuous string = "continuous"
)

// prop value enum
func (m *SnapmirrorRelationshipInlinePolicy) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipInlinePolicyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorRelationshipInlinePolicy) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("policy"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationshipInlinePolicy) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("policy"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline policy based on the context it is used
func (m *SnapmirrorRelationshipInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationshipInlinePolicy) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "policy"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlinePolicy) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorRelationshipInlinePolicyInlineLinks snapmirror relationship inline policy inline links
//
// swagger:model snapmirror_relationship_inline_policy_inline__links
type SnapmirrorRelationshipInlinePolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror relationship inline policy inline links
func (m *SnapmirrorRelationshipInlinePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlinePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline policy inline links based on the context it is used
func (m *SnapmirrorRelationshipInlinePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlinePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlinePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlinePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlinePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem snapmirror relationship inline svmdr volumes inline array item
//
// swagger:model snapmirror_relationship_inline_svmdr_volumes_inline_array_item
type SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem struct {

	// The name of the volume.
	// Example: volume1
	Name *string `json:"name,omitempty"`
}

// Validate validates this snapmirror relationship inline svmdr volumes inline array item
func (m *SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this snapmirror relationship inline svmdr volumes inline array item based on context it is used
func (m *SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineSvmdrVolumesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorRelationshipInlineTransfer Basic information on the current transfer or the last transfer if there is no active transfer at the time of the request.
//
// swagger:model snapmirror_relationship_inline_transfer
type SnapmirrorRelationshipInlineTransfer struct {

	// links
	Links *SnapmirrorRelationshipInlineTransferInlineLinks `json:"_links,omitempty"`

	// Total bytes transferred in the current or last successful transfer.
	BytesTransferred *int64 `json:"bytes_transferred,omitempty"`

	// End time of the last transfer.
	// Example: 2020-12-02 18:36:19-08:00
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// Last updated time of the bytes transferred in the current transfer.
	// Example: 2023-09-14 15:39:19-07:00
	// Format: date-time
	LastUpdatedTime *strfmt.DateTime `json:"last_updated_time,omitempty"`

	// state
	// Enum: ["aborted","failed","hard_aborted","queued","success","transferring"]
	State *string `json:"state,omitempty"`

	// Elapsed time to transfer all snapshots for the last successful transfer.
	// Example: PT28M41S
	TotalDuration *string `json:"total_duration,omitempty"`

	// Specifies the operation type of the current transfer on the relationship. The _initialize_ transfer occurs when the relationship state changes from "uninitialized" to "snapmirrored" or "in_sync". The _update_ transfer occurs when snapshots are being transferred from the source endpoint to the destination endpoint as part of a scheduled or manual update. The _resync_ transfer occurs when the relationship state changes from "broken_off" to "snapmirrored" or "in_sync". The _restore_ transfer occurs when a snapshot is being restored from a destination endpoint to another endpoint.
	// Example: initialize
	// Enum: ["initialize","update","resync","restore"]
	Type *string `json:"type,omitempty"`

	// Transfer UUID. This property is applicable only for active transfers.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship inline transfer
func (m *SnapmirrorRelationshipInlineTransfer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdatedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransfer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorRelationshipInlineTransfer) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("transfer"+"."+"end_time", "body", "date-time", m.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationshipInlineTransfer) validateLastUpdatedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdatedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("transfer"+"."+"last_updated_time", "body", "date-time", m.LastUpdatedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipInlineTransferTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","failed","hard_aborted","queued","success","transferring"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipInlineTransferTypeStatePropEnum = append(snapmirrorRelationshipInlineTransferTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// aborted
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateAborted captures enum value "aborted"
	SnapmirrorRelationshipInlineTransferStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// failed
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateFailed captures enum value "failed"
	SnapmirrorRelationshipInlineTransferStateFailed string = "failed"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// hard_aborted
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateHardAborted captures enum value "hard_aborted"
	SnapmirrorRelationshipInlineTransferStateHardAborted string = "hard_aborted"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// queued
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateQueued captures enum value "queued"
	SnapmirrorRelationshipInlineTransferStateQueued string = "queued"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// success
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateSuccess captures enum value "success"
	SnapmirrorRelationshipInlineTransferStateSuccess string = "success"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// state
	// State
	// transferring
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferStateTransferring captures enum value "transferring"
	SnapmirrorRelationshipInlineTransferStateTransferring string = "transferring"
)

// prop value enum
func (m *SnapmirrorRelationshipInlineTransfer) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipInlineTransferTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransfer) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("transfer"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var snapmirrorRelationshipInlineTransferTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["initialize","update","resync","restore"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorRelationshipInlineTransferTypeTypePropEnum = append(snapmirrorRelationshipInlineTransferTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// type
	// Type
	// initialize
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferTypeInitialize captures enum value "initialize"
	SnapmirrorRelationshipInlineTransferTypeInitialize string = "initialize"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// type
	// Type
	// update
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferTypeUpdate captures enum value "update"
	SnapmirrorRelationshipInlineTransferTypeUpdate string = "update"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// type
	// Type
	// resync
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferTypeResync captures enum value "resync"
	SnapmirrorRelationshipInlineTransferTypeResync string = "resync"

	// BEGIN DEBUGGING
	// snapmirror_relationship_inline_transfer
	// SnapmirrorRelationshipInlineTransfer
	// type
	// Type
	// restore
	// END DEBUGGING
	// SnapmirrorRelationshipInlineTransferTypeRestore captures enum value "restore"
	SnapmirrorRelationshipInlineTransferTypeRestore string = "restore"
)

// prop value enum
func (m *SnapmirrorRelationshipInlineTransfer) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorRelationshipInlineTransferTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransfer) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("transfer"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorRelationshipInlineTransfer) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("transfer"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline transfer based on the context it is used
func (m *SnapmirrorRelationshipInlineTransfer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransfer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineTransfer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineTransfer) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineTransfer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorRelationshipInlineTransferInlineLinks snapmirror relationship inline transfer inline links
//
// swagger:model snapmirror_relationship_inline_transfer_inline__links
type SnapmirrorRelationshipInlineTransferInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror relationship inline transfer inline links
func (m *SnapmirrorRelationshipInlineTransferInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransferInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline transfer inline links based on the context it is used
func (m *SnapmirrorRelationshipInlineTransferInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransferInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineTransferInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineTransferInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineTransferInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorRelationshipInlineTransferSchedule Schedule used to update asynchronous relationships. This "transfer_schedule" overrides the "transfer_schedule" set on the SnapMirror relationship's policy. To remove the "transfer_schedule", set its value to null (no-quotes). Only cron schedules are supported for SnapMirror.
//
// swagger:model snapmirror_relationship_inline_transfer_schedule
type SnapmirrorRelationshipInlineTransferSchedule struct {

	// links
	Links *SnapmirrorRelationshipInlineTransferScheduleInlineLinks `json:"_links,omitempty"`

	// Job schedule name
	// Example: weekly
	Name *string `json:"name,omitempty"`

	// Job schedule UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapmirror relationship inline transfer schedule
func (m *SnapmirrorRelationshipInlineTransferSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransferSchedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline transfer schedule based on the context it is used
func (m *SnapmirrorRelationshipInlineTransferSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransferSchedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineTransferSchedule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineTransferSchedule) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineTransferSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorRelationshipInlineTransferScheduleInlineLinks snapmirror relationship inline transfer schedule inline links
//
// swagger:model snapmirror_relationship_inline_transfer_schedule_inline__links
type SnapmirrorRelationshipInlineTransferScheduleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror relationship inline transfer schedule inline links
func (m *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror relationship inline transfer schedule inline links based on the context it is used
func (m *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transfer_schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorRelationshipInlineTransferScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorRelationshipInlineTransferScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
