// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SnapmirrorTransfer SnapMirror transfer information
//
// swagger:model snapmirror_transfer
type SnapmirrorTransfer struct {

	// links
	Links *SnapmirrorTransferInlineLinks `json:"_links,omitempty"`

	// Bytes transferred
	// Read Only: true
	BytesTransferred *int64 `json:"bytes_transferred,omitempty"`

	// Amount of data transferred in bytes as recorded in the restart checkpoint.
	// Read Only: true
	CheckpointSize *int64 `json:"checkpoint_size,omitempty"`

	// End time of the transfer.
	// Example: 2020-12-02 18:36:19-08:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// error info
	ErrorInfo *SnapmirrorTransferInlineErrorInfo `json:"error_info,omitempty"`

	// Last updated time of the bytes transferred in an active transfer.
	// Example: 2023-09-15 16:58:39-07:00
	// Read Only: true
	// Format: date-time
	LastUpdatedTime *strfmt.DateTime `json:"last_updated_time,omitempty"`

	// Specifies the compression ratio achieved for the data sent over the wire with network compression enabled. This property is only valid for active transfers.
	// Example: 61
	// Read Only: true
	NetworkCompressionRatio *string `json:"network_compression_ratio,omitempty"`

	// Specifies whether or not an on-demand restore is being carried out. This is only supported for the transfer of restore relationships for entire volumes from the object store. A value for read_write_with_user_data_pull should be provided to start an on-demand restore. A file restore from the object store does not support this option.
	// Example: read_write_with_user_data_pull
	// Enum: ["off","read_write_with_user_data_pull"]
	OnDemandAttrs *string `json:"on_demand_attrs,omitempty"`

	// relationship
	Relationship *SnapmirrorTransferInlineRelationship `json:"relationship,omitempty"`

	// This is supported for transfer of restore relationship only. This specifies the list of files or LUNs to be restored. Can contain up to eight files or LUNs.
	SnapmirrorTransferInlineFiles []*SnapmirrorTransferInlineFilesInlineArrayItem `json:"files,omitempty"`

	// Options for snapmirror transfer.
	SnapmirrorTransferInlineOptions []interface{} `json:"options,omitempty"`

	// Name of snapshot being transferred.
	// Read Only: true
	Snapshot *string `json:"snapshot,omitempty"`

	// Specifies the snapshot on the source to be transferred to the destination.
	SourceSnapshot *string `json:"source_snapshot,omitempty"`

	// Status of the transfer. Set PATCH state to "aborted" to abort the transfer. Set PATCH state to "hard_aborted" to abort the transfer and discard the restart checkpoint. To find "queued" transfers refer to relationships GET API.
	// Enum: ["aborted","failed","hard_aborted","queued","success","transferring"]
	State *string `json:"state,omitempty"`

	// This is supported for transfer of restore relationship only. Set this property to "false" to turn off storage efficiency for data transferred over the wire and written to the destination.
	StorageEfficiencyEnabled *bool `json:"storage_efficiency_enabled,omitempty"`

	// Throttle, in KBs per second. This "throttle" overrides the "throttle" set on the SnapMirror relationship or SnapMirror relationship's policy. If neither of these are set, defaults to 0, which is interpreted as unlimited.
	Throttle *int64 `json:"throttle,omitempty"`

	// Elapsed transfer time.
	// Example: PT28M41S
	// Read Only: true
	TotalDuration *string `json:"total_duration,omitempty"`

	// Unique identifier of the SnapMirror transfer.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror transfer
func (m *SnapmirrorTransfer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdatedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnDemandAttrs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelationship(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapmirrorTransferInlineFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorTransfer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorTransfer) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("end_time", "body", "date-time", m.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) validateErrorInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.ErrorInfo) { // not required
		return nil
	}

	if m.ErrorInfo != nil {
		if err := m.ErrorInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error_info")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorTransfer) validateLastUpdatedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdatedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_updated_time", "body", "date-time", m.LastUpdatedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var snapmirrorTransferTypeOnDemandAttrsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["off","read_write_with_user_data_pull"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorTransferTypeOnDemandAttrsPropEnum = append(snapmirrorTransferTypeOnDemandAttrsPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_transfer
	// SnapmirrorTransfer
	// on_demand_attrs
	// OnDemandAttrs
	// off
	// END DEBUGGING
	// SnapmirrorTransferOnDemandAttrsOff captures enum value "off"
	SnapmirrorTransferOnDemandAttrsOff string = "off"

	// BEGIN DEBUGGING
	// snapmirror_transfer
	// SnapmirrorTransfer
	// on_demand_attrs
	// OnDemandAttrs
	// read_write_with_user_data_pull
	// END DEBUGGING
	// SnapmirrorTransferOnDemandAttrsReadWriteWithUserDataPull captures enum value "read_write_with_user_data_pull"
	SnapmirrorTransferOnDemandAttrsReadWriteWithUserDataPull string = "read_write_with_user_data_pull"
)

// prop value enum
func (m *SnapmirrorTransfer) validateOnDemandAttrsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorTransferTypeOnDemandAttrsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorTransfer) validateOnDemandAttrs(formats strfmt.Registry) error {
	if swag.IsZero(m.OnDemandAttrs) { // not required
		return nil
	}

	// value enum
	if err := m.validateOnDemandAttrsEnum("on_demand_attrs", "body", *m.OnDemandAttrs); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) validateRelationship(formats strfmt.Registry) error {
	if swag.IsZero(m.Relationship) { // not required
		return nil
	}

	if m.Relationship != nil {
		if err := m.Relationship.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relationship")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorTransfer) validateSnapmirrorTransferInlineFiles(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapmirrorTransferInlineFiles) { // not required
		return nil
	}

	for i := 0; i < len(m.SnapmirrorTransferInlineFiles); i++ {
		if swag.IsZero(m.SnapmirrorTransferInlineFiles[i]) { // not required
			continue
		}

		if m.SnapmirrorTransferInlineFiles[i] != nil {
			if err := m.SnapmirrorTransferInlineFiles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var snapmirrorTransferTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","failed","hard_aborted","queued","success","transferring"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapmirrorTransferTypeStatePropEnum = append(snapmirrorTransferTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapmirror_transfer
	// SnapmirrorTransfer
	// state
	// State
	// aborted
	// END DEBUGGING
	// SnapmirrorTransferStateAborted captures enum value "aborted"
	SnapmirrorTransferStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// snapmirror_transfer
	// SnapmirrorTransfer
	// state
	// State
	// failed
	// END DEBUGGING
	// SnapmirrorTransferStateFailed captures enum value "failed"
	SnapmirrorTransferStateFailed string = "failed"

	// BEGIN DEBUGGING
	// snapmirror_transfer
	// SnapmirrorTransfer
	// state
	// State
	// hard_aborted
	// END DEBUGGING
	// SnapmirrorTransferStateHardAborted captures enum value "hard_aborted"
	SnapmirrorTransferStateHardAborted string = "hard_aborted"

	// BEGIN DEBUGGING
	// snapmirror_transfer
	// SnapmirrorTransfer
	// state
	// State
	// queued
	// END DEBUGGING
	// SnapmirrorTransferStateQueued captures enum value "queued"
	SnapmirrorTransferStateQueued string = "queued"

	// BEGIN DEBUGGING
	// snapmirror_transfer
	// SnapmirrorTransfer
	// state
	// State
	// success
	// END DEBUGGING
	// SnapmirrorTransferStateSuccess captures enum value "success"
	SnapmirrorTransferStateSuccess string = "success"

	// BEGIN DEBUGGING
	// snapmirror_transfer
	// SnapmirrorTransfer
	// state
	// State
	// transferring
	// END DEBUGGING
	// SnapmirrorTransferStateTransferring captures enum value "transferring"
	SnapmirrorTransferStateTransferring string = "transferring"
)

// prop value enum
func (m *SnapmirrorTransfer) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapmirrorTransferTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapmirrorTransfer) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror transfer based on the context it is used
func (m *SnapmirrorTransfer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBytesTransferred(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCheckpointSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUpdatedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetworkCompressionRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelationship(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapmirrorTransferInlineFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorTransfer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateBytesTransferred(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "bytes_transferred", "body", m.BytesTransferred); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateCheckpointSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "checkpoint_size", "body", m.CheckpointSize); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "end_time", "body", m.EndTime); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateErrorInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.ErrorInfo != nil {
		if err := m.ErrorInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error_info")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateLastUpdatedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_updated_time", "body", m.LastUpdatedTime); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateNetworkCompressionRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "network_compression_ratio", "body", m.NetworkCompressionRatio); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateRelationship(ctx context.Context, formats strfmt.Registry) error {

	if m.Relationship != nil {
		if err := m.Relationship.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relationship")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateSnapmirrorTransferInlineFiles(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SnapmirrorTransferInlineFiles); i++ {

		if m.SnapmirrorTransferInlineFiles[i] != nil {
			if err := m.SnapmirrorTransferInlineFiles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot", "body", m.Snapshot); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateTotalDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_duration", "body", m.TotalDuration); err != nil {
		return err
	}

	return nil
}

func (m *SnapmirrorTransfer) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorTransfer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorTransfer) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransfer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorTransferInlineErrorInfo Error information for the transfer.
//
// swagger:model snapmirror_transfer_inline_error_info
type SnapmirrorTransferInlineErrorInfo struct {

	// Error code
	// Example: 6620046
	Code *int64 `json:"code,omitempty"`

	// Error message
	// Example: Transfer aborted
	Message *string `json:"message,omitempty"`
}

// Validate validates this snapmirror transfer inline error info
func (m *SnapmirrorTransferInlineErrorInfo) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this snapmirror transfer inline error info based on the context it is used
func (m *SnapmirrorTransferInlineErrorInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorTransferInlineErrorInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorTransferInlineErrorInfo) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransferInlineErrorInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorTransferInlineFilesInlineArrayItem Specifies a file or LUN consisting of a source_path and an optional destination_path. If not specified, the destination_path is the same as the source_path. File restore is not supported if the source_path or destination_path contains commas in its directory or file name.
//
// swagger:model snapmirror_transfer_inline_files_inline_array_item
type SnapmirrorTransferInlineFilesInlineArrayItem struct {

	// destination path
	// Example: /dirb/file2
	DestinationPath *string `json:"destination_path,omitempty"`

	// source path
	// Example: /dira/file1
	SourcePath *string `json:"source_path,omitempty"`
}

// Validate validates this snapmirror transfer inline files inline array item
func (m *SnapmirrorTransferInlineFilesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this snapmirror transfer inline files inline array item based on context it is used
func (m *SnapmirrorTransferInlineFilesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorTransferInlineFilesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorTransferInlineFilesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransferInlineFilesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorTransferInlineLinks snapmirror transfer inline links
//
// swagger:model snapmirror_transfer_inline__links
type SnapmirrorTransferInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapmirror transfer inline links
func (m *SnapmirrorTransferInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorTransferInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapmirror transfer inline links based on the context it is used
func (m *SnapmirrorTransferInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorTransferInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorTransferInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorTransferInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransferInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapmirrorTransferInlineRelationship snapmirror transfer inline relationship
//
// swagger:model snapmirror_transfer_inline_relationship
type SnapmirrorTransferInlineRelationship struct {

	// destination
	Destination *SnapmirrorEndpoint `json:"destination,omitempty"`

	// Is the relationship for restore?
	Restore *bool `json:"restore,omitempty"`

	// Unique identifier of the SnapMirror relationship.
	// Example: d2d7ceea-ab52-11e8-855e-00505682a4c7
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this snapmirror transfer inline relationship
func (m *SnapmirrorTransferInlineRelationship) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorTransferInlineRelationship) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.Destination) { // not required
		return nil
	}

	if m.Destination != nil {
		if err := m.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relationship" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (m *SnapmirrorTransferInlineRelationship) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("relationship"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapmirror transfer inline relationship based on the context it is used
func (m *SnapmirrorTransferInlineRelationship) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapmirrorTransferInlineRelationship) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.Destination != nil {
		if err := m.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relationship" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapmirrorTransferInlineRelationship) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapmirrorTransferInlineRelationship) UnmarshalBinary(b []byte) error {
	var res SnapmirrorTransferInlineRelationship
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
