// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Snapshot The snapshot object represents a point in time snapshot of a volume.
//
// swagger:model snapshot
type Snapshot struct {

	// links
	Links *SnapshotInlineLinks `json:"_links,omitempty"`

	// A comment associated with the snapshot. This is an optional attribute for POST or PATCH.
	Comment *string `json:"comment,omitempty"`

	// Savings due to compression at the time the snapshot was taken in bytes.
	// Example: 1131223
	// Read Only: true
	CompressSavings *int64 `json:"compress_savings,omitempty"`

	// Creation time of the snapshot. It is the volume access time when the snapshot was created.
	// Example: 2019-02-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Savings due to dedup at the time the snapshot was taken in bytes.
	// Example: 1131223
	// Read Only: true
	DedupSavings *int64 `json:"dedup_savings,omitempty"`

	// delta
	Delta *SnapshotDelta `json:"delta,omitempty"`

	// The expiry time for the snapshot. This is an optional attribute for POST or PATCH. Snapshots with an expiry time set are not allowed to be deleted until the retention time is reached.
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Size of the logical used file system at the time the snapshot is captured.
	// Example: 1228800
	// Read Only: true
	LogicalSize *int64 `json:"logical_size,omitempty"`

	// Snapshot. Valid in POST or PATCH.
	// Example: this_snapshot
	Name *string `json:"name,omitempty"`

	// owners
	// Read Only: true
	Owners []*string `json:"owners,omitempty"`

	// provenance volume
	ProvenanceVolume *SnapshotInlineProvenanceVolume `json:"provenance_volume,omitempty"`

	// Space reclaimed when the snapshot is deleted, in bytes.
	ReclaimableSpace *int64 `json:"reclaimable_space,omitempty"`

	// Size of the active file system at the time the snapshot is captured. The actual size of the snapshot also includes those blocks trapped by other snapshots. On a snapshot deletion, the "size" amount of blocks is the maximum number of blocks available. On a snapshot restore, the "afs-used size" value will match the snapshot "size" value.
	// Example: 122880
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// snaplock
	Snaplock *SnapshotInlineSnaplock `json:"snaplock,omitempty"`

	// SnapLock expiry time for the snapshot, if the snapshot is taken on a SnapLock volume. A snapshot is not allowed to be deleted or renamed until the SnapLock ComplianceClock time goes beyond this retention time. This option can be set during snapshot POST and snapshot PATCH on snapshot locking enabled volumes. This field will no longer be supported in a future release. Use snaplock.expiry_time instead.
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	SnaplockExpiryTime *strfmt.DateTime `json:"snaplock_expiry_time,omitempty"`

	// Label for SnapMirror operations
	SnapmirrorLabel *string `json:"snapmirror_label,omitempty"`

	// State of the FlexGroup volume snapshot. In the "pre_conversion" state, the snapshot was created before converting the FlexVol to a FlexGroup volume. A recently created snapshot can be in the "unknown" state while the system is calculating the state. In the "partial" state, the snapshot is consistent but exists only on the subset of the constituents that existed prior to the FlexGroup's expansion. Partial snapshots cannot be used for a snapshot restore operation. A snapshot is in an "invalid" state when it is present in some FlexGroup constituents but not in others. At all other times, a snapshot is valid.
	// Read Only: true
	// Enum: ["valid","invalid","partial","unknown","pre_conversion"]
	State *string `json:"state,omitempty"`

	// svm
	Svm *SnapshotInlineSvm `json:"svm,omitempty"`

	// The UUID of the snapshot in the volume that uniquely identifies the snapshot in that volume.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Savings due vbn0 at the time the snapshot was taken in bytes.
	// Example: 1131223
	// Read Only: true
	Vbn0Savings *int64 `json:"vbn0_savings,omitempty"`

	// The 128 bit identifier that uniquely identifies a snapshot and its logical data layout.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	VersionUUID *string `json:"version_uuid,omitempty"`

	// volume
	Volume *SnapshotInlineVolume `json:"volume,omitempty"`
}

// Validate validates this snapshot
func (m *Snapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDelta(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwners(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvenanceVolume(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplockExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Snapshot) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) validateDelta(formats strfmt.Registry) error {
	if swag.IsZero(m.Delta) { // not required
		return nil
	}

	if m.Delta != nil {
		if err := m.Delta.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("delta")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var snapshotOwnersItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","snapmirror","snapmirror_dependent","sync_mirror","volume_clone","volume_clone_dependent","snap_restore","snap_restore_dependent","dump","cifs_share","volume_copy","ndmp","worm_volume","sis_clone","s2c_iron","lun_clone","backup_dependent","snaplock_dependent","file_clone_dependent","volume_move_dependent","svmdr_dependent","anti_ransomware_backup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapshotOwnersItemsEnum = append(snapshotOwnersItemsEnum, v)
	}
}

func (m *Snapshot) validateOwnersItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapshotOwnersItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Snapshot) validateOwners(formats strfmt.Registry) error {
	if swag.IsZero(m.Owners) { // not required
		return nil
	}

	for i := 0; i < len(m.Owners); i++ {
		if swag.IsZero(m.Owners[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateOwnersItemsEnum("owners"+"."+strconv.Itoa(i), "body", *m.Owners[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *Snapshot) validateProvenanceVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvenanceVolume) { // not required
		return nil
	}

	if m.ProvenanceVolume != nil {
		if err := m.ProvenanceVolume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provenance_volume")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) validateSnaplockExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.SnaplockExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock_expiry_time", "body", "date-time", m.SnaplockExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var snapshotTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["valid","invalid","partial","unknown","pre_conversion"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapshotTypeStatePropEnum = append(snapshotTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snapshot
	// Snapshot
	// state
	// State
	// valid
	// END DEBUGGING
	// SnapshotStateValid captures enum value "valid"
	SnapshotStateValid string = "valid"

	// BEGIN DEBUGGING
	// snapshot
	// Snapshot
	// state
	// State
	// invalid
	// END DEBUGGING
	// SnapshotStateInvalid captures enum value "invalid"
	SnapshotStateInvalid string = "invalid"

	// BEGIN DEBUGGING
	// snapshot
	// Snapshot
	// state
	// State
	// partial
	// END DEBUGGING
	// SnapshotStatePartial captures enum value "partial"
	SnapshotStatePartial string = "partial"

	// BEGIN DEBUGGING
	// snapshot
	// Snapshot
	// state
	// State
	// unknown
	// END DEBUGGING
	// SnapshotStateUnknown captures enum value "unknown"
	SnapshotStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// snapshot
	// Snapshot
	// state
	// State
	// pre_conversion
	// END DEBUGGING
	// SnapshotStatePreConversion captures enum value "pre_conversion"
	SnapshotStatePreConversion string = "pre_conversion"
)

// prop value enum
func (m *Snapshot) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapshotTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Snapshot) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot based on the context it is used
func (m *Snapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompressSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDedupSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDelta(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwners(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvenanceVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVbn0Savings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersionUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Snapshot) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) contextValidateCompressSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "compress_savings", "body", m.CompressSavings); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateDedupSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dedup_savings", "body", m.DedupSavings); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateDelta(ctx context.Context, formats strfmt.Registry) error {

	if m.Delta != nil {
		if err := m.Delta.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("delta")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) contextValidateLogicalSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "logical_size", "body", m.LogicalSize); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateOwners(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owners", "body", []*string(m.Owners)); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateProvenanceVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvenanceVolume != nil {
		if err := m.ProvenanceVolume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provenance_volume")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Snapshot) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateVbn0Savings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vbn0_savings", "body", m.Vbn0Savings); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateVersionUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version_uuid", "body", m.VersionUUID); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Snapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Snapshot) UnmarshalBinary(b []byte) error {
	var res Snapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapshotInlineLinks snapshot inline links
//
// swagger:model snapshot_inline__links
type SnapshotInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapshot inline links
func (m *SnapshotInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline links based on the context it is used
func (m *SnapshotInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapshotInlineProvenanceVolume snapshot inline provenance volume
//
// swagger:model snapshot_inline_provenance_volume
type SnapshotInlineProvenanceVolume struct {

	// UUID for the volume that is used to identify the source volume in a mirroring relationship. When the mirroring relationship is broken, a volume's Instance UUID and Provenance UUID are made identical. An unmirrored volume's Provenance UUID is the same as its Instance UUID. This field is valid for flexible volumes only.
	// Example: 4cd8a442-86d1-11e0-ae1c-125648563413
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapshot inline provenance volume
func (m *SnapshotInlineProvenanceVolume) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this snapshot inline provenance volume based on the context it is used
func (m *SnapshotInlineProvenanceVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineProvenanceVolume) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "provenance_volume"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotInlineProvenanceVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotInlineProvenanceVolume) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineProvenanceVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapshotInlineSnaplock snapshot inline snaplock
//
// swagger:model snapshot_inline_snaplock
type SnapshotInlineSnaplock struct {

	// Indicates whether a SnapLock snapshot has expired.
	// Example: true
	// Read Only: true
	Expired *bool `json:"expired,omitempty"`

	// SnapLock expiry time for the snapshot, if the snapshot is taken on a SnapLock volume. A snapshot is not allowed to be deleted or renamed until the SnapLock ComplianceClock time goes beyond this retention time. This option can be set during snapshot POST and snapshot PATCH on snapshot locking enabled volumes. It can also be used to extend the expiry time of a locked snapshot on a SnapLock for SnapVault destination consistency-group.
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Indicates the remaining SnapLock expiry time of a locked snapshot, in seconds. This field is set only when the remaining time interval is less than 136 years.
	// Example: PT3H27M45S
	// Read Only: true
	TimeUntilExpiry *string `json:"time_until_expiry,omitempty"`
}

// Validate validates this snapshot inline snaplock
func (m *SnapshotInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snapshot inline snaplock based on the context it is used
func (m *SnapshotInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExpired(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeUntilExpiry(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineSnaplock) contextValidateExpired(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"expired", "body", m.Expired); err != nil {
		return err
	}

	return nil
}

func (m *SnapshotInlineSnaplock) contextValidateTimeUntilExpiry(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"time_until_expiry", "body", m.TimeUntilExpiry); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapshotInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model snapshot_inline_svm
type SnapshotInlineSvm struct {

	// links
	Links *SnapshotInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapshot inline svm
func (m *SnapshotInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline svm based on the context it is used
func (m *SnapshotInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotInlineSvm) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapshotInlineSvmInlineLinks snapshot inline svm inline links
//
// swagger:model snapshot_inline_svm_inline__links
type SnapshotInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapshot inline svm inline links
func (m *SnapshotInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline svm inline links based on the context it is used
func (m *SnapshotInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapshotInlineVolume snapshot inline volume
//
// swagger:model snapshot_inline_volume
type SnapshotInlineVolume struct {

	// links
	Links *SnapshotInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snapshot inline volume
func (m *SnapshotInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline volume based on the context it is used
func (m *SnapshotInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotInlineVolume) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapshotInlineVolumeInlineLinks snapshot inline volume inline links
//
// swagger:model snapshot_inline_volume_inline__links
type SnapshotInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapshot inline volume inline links
func (m *SnapshotInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot inline volume inline links based on the context it is used
func (m *SnapshotInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapshotInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
