// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SnapshotDelta Reports the amount of space consumed between two WAFL file systems, in bytes. The two WAFL file systems should be specified in a comma-separated format using the "name" parameter. To determine the space consumed between a snapshot and the Active File System, only the snapshot name needs to be mentioned.
//
// swagger:model snapshot_delta
type SnapshotDelta struct {

	// links
	Links *SnapshotDeltaInlineLinks `json:"_links,omitempty"`

	// Indicates the space that has changed between two specified WAFL file systems, in bytes.
	// Read Only: true
	SizeConsumed *int64 `json:"size_consumed,omitempty"`

	// Time elapsed between two specified WAFL file systems.
	// Read Only: true
	TimeElapsed *string `json:"time_elapsed,omitempty"`
}

// Validate validates this snapshot delta
func (m *SnapshotDelta) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotDelta) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot delta based on the context it is used
func (m *SnapshotDelta) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSizeConsumed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeElapsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotDelta) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SnapshotDelta) contextValidateSizeConsumed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size_consumed", "body", m.SizeConsumed); err != nil {
		return err
	}

	return nil
}

func (m *SnapshotDelta) contextValidateTimeElapsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_elapsed", "body", m.TimeElapsed); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotDelta) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotDelta) UnmarshalBinary(b []byte) error {
	var res SnapshotDelta
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SnapshotDeltaInlineLinks snapshot delta inline links
//
// swagger:model snapshot_delta_inline__links
type SnapshotDeltaInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this snapshot delta inline links
func (m *SnapshotDeltaInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotDeltaInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snapshot delta inline links based on the context it is used
func (m *SnapshotDeltaInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotDeltaInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotDeltaInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotDeltaInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnapshotDeltaInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
