// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SoftwareNodeReference software node reference
//
// swagger:model software_node_reference
type SoftwareNodeReference struct {

	// firmware
	Firmware *Firmware `json:"firmware,omitempty"`

	// Model number of the node.
	// Example: AFF-A800
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// Name of the node.
	// Example: node1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// software images
	SoftwareImages SoftwareImagesArrayInline `json:"software_images,omitempty"`

	// ONTAP version of the node.
	// Example: ONTAP_X
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this software node reference
func (m *SoftwareNodeReference) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFirmware(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSoftwareImages(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SoftwareNodeReference) validateFirmware(formats strfmt.Registry) error {
	if swag.IsZero(m.Firmware) { // not required
		return nil
	}

	if m.Firmware != nil {
		if err := m.Firmware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("firmware")
			}
			return err
		}
	}

	return nil
}

func (m *SoftwareNodeReference) validateSoftwareImages(formats strfmt.Registry) error {
	if swag.IsZero(m.SoftwareImages) { // not required
		return nil
	}

	if err := m.SoftwareImages.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("software_images")
		}
		return err
	}

	return nil
}

// ContextValidate validate this software node reference based on the context it is used
func (m *SoftwareNodeReference) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFirmware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSoftwareImages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SoftwareNodeReference) contextValidateFirmware(ctx context.Context, formats strfmt.Registry) error {

	if m.Firmware != nil {
		if err := m.Firmware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("firmware")
			}
			return err
		}
	}

	return nil
}

func (m *SoftwareNodeReference) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *SoftwareNodeReference) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *SoftwareNodeReference) contextValidateSoftwareImages(ctx context.Context, formats strfmt.Registry) error {

	if err := m.SoftwareImages.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("software_images")
		}
		return err
	}

	return nil
}

func (m *SoftwareNodeReference) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SoftwareNodeReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SoftwareNodeReference) UnmarshalBinary(b []byte) error {
	var res SoftwareNodeReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
