// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SpaceEfficiency space efficiency
//
// swagger:model space_efficiency
type SpaceEfficiency struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this space efficiency
func (m *SpaceEfficiency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this space efficiency based on the context it is used
func (m *SpaceEfficiency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SpaceEfficiency) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *SpaceEfficiency) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *SpaceEfficiency) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SpaceEfficiency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SpaceEfficiency) UnmarshalBinary(b []byte) error {
	var res SpaceEfficiency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
