// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SQLOnSanNewIgroups The list of initiator groups to create.
//
// swagger:model sql_on_san_new_igroups
type SQLOnSanNewIgroups struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The name of the new initiator group.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name"`

	// The name of the host OS accessing the application. The default value is the host OS that is running the application.
	// Enum: ["hyper_v","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// The protocol of the new initiator group.
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// sql on san new igroups inline igroups
	SQLOnSanNewIgroupsInlineIgroups []*SQLOnSanNewIgroupsInlineIgroupsInlineArrayItem `json:"igroups,omitempty"`

	// sql on san new igroups inline initiator objects
	SQLOnSanNewIgroupsInlineInitiatorObjects []*SQLOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem `json:"initiator_objects,omitempty"`

	// sql on san new igroups inline initiators
	SQLOnSanNewIgroupsInlineInitiators []*string `json:"initiators,omitempty"`
}

// Validate validates this sql on san new igroups
func (m *SQLOnSanNewIgroups) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSQLOnSanNewIgroupsInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSQLOnSanNewIgroupsInlineInitiatorObjects(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SQLOnSanNewIgroups) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var sqlOnSanNewIgroupsTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hyper_v","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sqlOnSanNewIgroupsTypeOsTypePropEnum = append(sqlOnSanNewIgroupsTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// sql_on_san_new_igroups
	// SQLOnSanNewIgroups
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// SQLOnSanNewIgroupsOsTypeHyperv captures enum value "hyper_v"
	SQLOnSanNewIgroupsOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// sql_on_san_new_igroups
	// SQLOnSanNewIgroups
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// SQLOnSanNewIgroupsOsTypeVmware captures enum value "vmware"
	SQLOnSanNewIgroupsOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// sql_on_san_new_igroups
	// SQLOnSanNewIgroups
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// SQLOnSanNewIgroupsOsTypeWindows captures enum value "windows"
	SQLOnSanNewIgroupsOsTypeWindows string = "windows"
)

// prop value enum
func (m *SQLOnSanNewIgroups) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sqlOnSanNewIgroupsTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SQLOnSanNewIgroups) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var sqlOnSanNewIgroupsTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sqlOnSanNewIgroupsTypeProtocolPropEnum = append(sqlOnSanNewIgroupsTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// sql_on_san_new_igroups
	// SQLOnSanNewIgroups
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// SQLOnSanNewIgroupsProtocolFcp captures enum value "fcp"
	SQLOnSanNewIgroupsProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// sql_on_san_new_igroups
	// SQLOnSanNewIgroups
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// SQLOnSanNewIgroupsProtocolIscsi captures enum value "iscsi"
	SQLOnSanNewIgroupsProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// sql_on_san_new_igroups
	// SQLOnSanNewIgroups
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// SQLOnSanNewIgroupsProtocolMixed captures enum value "mixed"
	SQLOnSanNewIgroupsProtocolMixed string = "mixed"
)

// prop value enum
func (m *SQLOnSanNewIgroups) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sqlOnSanNewIgroupsTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SQLOnSanNewIgroups) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *SQLOnSanNewIgroups) validateSQLOnSanNewIgroupsInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.SQLOnSanNewIgroupsInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.SQLOnSanNewIgroupsInlineIgroups); i++ {
		if swag.IsZero(m.SQLOnSanNewIgroupsInlineIgroups[i]) { // not required
			continue
		}

		if m.SQLOnSanNewIgroupsInlineIgroups[i] != nil {
			if err := m.SQLOnSanNewIgroupsInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SQLOnSanNewIgroups) validateSQLOnSanNewIgroupsInlineInitiatorObjects(formats strfmt.Registry) error {
	if swag.IsZero(m.SQLOnSanNewIgroupsInlineInitiatorObjects) { // not required
		return nil
	}

	for i := 0; i < len(m.SQLOnSanNewIgroupsInlineInitiatorObjects); i++ {
		if swag.IsZero(m.SQLOnSanNewIgroupsInlineInitiatorObjects[i]) { // not required
			continue
		}

		if m.SQLOnSanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.SQLOnSanNewIgroupsInlineInitiatorObjects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this sql on san new igroups based on the context it is used
func (m *SQLOnSanNewIgroups) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSQLOnSanNewIgroupsInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSQLOnSanNewIgroupsInlineInitiatorObjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SQLOnSanNewIgroups) contextValidateSQLOnSanNewIgroupsInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SQLOnSanNewIgroupsInlineIgroups); i++ {

		if m.SQLOnSanNewIgroupsInlineIgroups[i] != nil {
			if err := m.SQLOnSanNewIgroupsInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SQLOnSanNewIgroups) contextValidateSQLOnSanNewIgroupsInlineInitiatorObjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SQLOnSanNewIgroupsInlineInitiatorObjects); i++ {

		if m.SQLOnSanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.SQLOnSanNewIgroupsInlineInitiatorObjects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SQLOnSanNewIgroups) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SQLOnSanNewIgroups) UnmarshalBinary(b []byte) error {
	var res SQLOnSanNewIgroups
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SQLOnSanNewIgroupsInlineIgroupsInlineArrayItem sql on san new igroups inline igroups inline array item
//
// swagger:model sql_on_san_new_igroups_inline_igroups_inline_array_item
type SQLOnSanNewIgroupsInlineIgroupsInlineArrayItem struct {

	// The name of an igroup to nest within a parent igroup. Mutually exclusive with initiators and initiator_objects.
	Name *string `json:"name,omitempty"`

	// The UUID of an igroup to nest within a parent igroup Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this sql on san new igroups inline igroups inline array item
func (m *SQLOnSanNewIgroupsInlineIgroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this sql on san new igroups inline igroups inline array item based on context it is used
func (m *SQLOnSanNewIgroupsInlineIgroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SQLOnSanNewIgroupsInlineIgroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SQLOnSanNewIgroupsInlineIgroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SQLOnSanNewIgroupsInlineIgroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SQLOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem sql on san new igroups inline initiator objects inline array item
//
// swagger:model sql_on_san_new_igroups_inline_initiator_objects_inline_array_item
type SQLOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The WWPN, IQN, or Alias of the initiator. Mutually exclusive with nested igroups and the initiators array.
	Name *string `json:"name,omitempty"`
}

// Validate validates this sql on san new igroups inline initiator objects inline array item
func (m *SQLOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this sql on san new igroups inline initiator objects inline array item based on context it is used
func (m *SQLOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SQLOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SQLOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SQLOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
