// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Status Status of each of the DNS name server configured for the specified SVM.
//
// swagger:model status
type Status struct {

	// Code corresponding to the status message. Code is 0 when the state is 'up'.
	//
	// Example: 6684732
	Code *int64 `json:"code,omitempty"`

	// Detailed description of the validation state if the state is 'down' or
	// the response time of the DNS server if the state is 'up'.
	//
	Message *string `json:"message,omitempty"`

	// The IP address of the DNS server. The address can be either an IPv4 or an IPv6 address.
	//
	// Example: 10.10.10.10
	NameServer *string `json:"name_server,omitempty"`

	// The validation status of the DNS server.
	//
	// Example: up
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this status
func (m *Status) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var statusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		statusTypeStatePropEnum = append(statusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// status
	// Status
	// state
	// State
	// up
	// END DEBUGGING
	// StatusStateUp captures enum value "up"
	StatusStateUp string = "up"

	// BEGIN DEBUGGING
	// status
	// Status
	// state
	// State
	// down
	// END DEBUGGING
	// StatusStateDown captures enum value "down"
	StatusStateDown string = "down"
)

// prop value enum
func (m *Status) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, statusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Status) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this status based on context it is used
func (m *Status) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Status) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Status) UnmarshalBinary(b []byte) error {
	var res Status
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
