// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageAvailabilityZone Provides information on nodes and storage details for each availability zone present in the cluster. Storage details include storage efficiency and other storage related information.
//
// swagger:model storage_availability_zone
type StorageAvailabilityZone struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Availability zone name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// space
	Space *StorageAvailabilityZoneInlineSpace `json:"space,omitempty"`

	// Nodes in the availability zone.
	// Read Only: true
	StorageAvailabilityZoneInlineNodes []*StorageAvailabilityZoneInlineNodesInlineArrayItem `json:"nodes,omitempty"`

	// Availability zone UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage availability zone
func (m *StorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageAvailabilityZoneInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageAvailabilityZone) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *StorageAvailabilityZone) validateStorageAvailabilityZoneInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZoneInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageAvailabilityZoneInlineNodes); i++ {
		if swag.IsZero(m.StorageAvailabilityZoneInlineNodes[i]) { // not required
			continue
		}

		if m.StorageAvailabilityZoneInlineNodes[i] != nil {
			if err := m.StorageAvailabilityZoneInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage availability zone based on the context it is used
func (m *StorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageAvailabilityZoneInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageAvailabilityZone) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZone) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *StorageAvailabilityZone) contextValidateStorageAvailabilityZoneInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nodes", "body", []*StorageAvailabilityZoneInlineNodesInlineArrayItem(m.StorageAvailabilityZoneInlineNodes)); err != nil {
		return err
	}

	for i := 0; i < len(m.StorageAvailabilityZoneInlineNodes); i++ {

		if m.StorageAvailabilityZoneInlineNodes[i] != nil {
			if err := m.StorageAvailabilityZoneInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageAvailabilityZone) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageAvailabilityZoneInlineNodesInlineArrayItem storage availability zone inline nodes inline array item
//
// swagger:model storage_availability_zone_inline_nodes_inline_array_item
type StorageAvailabilityZoneInlineNodesInlineArrayItem struct {

	// links
	Links *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage availability zone inline nodes inline array item
func (m *StorageAvailabilityZoneInlineNodesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZoneInlineNodesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage availability zone inline nodes inline array item based on the context it is used
func (m *StorageAvailabilityZoneInlineNodesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZoneInlineNodesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageAvailabilityZoneInlineNodesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageAvailabilityZoneInlineNodesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneInlineNodesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks storage availability zone inline nodes inline array item inline links
//
// swagger:model storage_availability_zone_inline_nodes_inline_array_item_inline__links
type StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage availability zone inline nodes inline array item inline links
func (m *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage availability zone inline nodes inline array item inline links based on the context it is used
func (m *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneInlineNodesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageAvailabilityZoneInlineSpace storage availability zone inline space
//
// swagger:model storage_availability_zone_inline_space
type StorageAvailabilityZoneInlineSpace struct {

	// Available space in the availability zone.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total space used by the delayed frees in the availability zone.
	// Read Only: true
	DelayedFrees *int64 `json:"delayed_frees,omitempty"`

	// efficiency without snapshots
	EfficiencyWithoutSnapshots *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots `json:"efficiency_without_snapshots,omitempty"`

	// The availability zone full threshold percentage that triggers an EMS error.
	FullThresholdPercent *int64 `json:"full_threshold_percent,omitempty"`

	// Inactive data in the availability zone.
	// Read Only: true
	InactiveData *int64 `json:"inactive_data,omitempty"`

	// The total space consumed by system logs and cores in the availability zone.
	// Read Only: true
	LogAndRecoveryMetadata *int64 `json:"log_and_recovery_metadata,omitempty"`

	// The logical space used by user data excluding snapshots in the availability zone.
	// Read Only: true
	LogicalUserDataWithoutSnapshots *int64 `json:"logical_user_data_without_snapshots,omitempty"`

	// The availability zone nearly full threshold percentage that triggers an EMS warning.
	NearlyFullThresholdPercent *int64 `json:"nearly_full_threshold_percent,omitempty"`

	// Total physical used space in the availability zone.
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// The physical space used percentage in the availability zone.
	// Read Only: true
	PhysicalUsedPercent *int64 `json:"physical_used_percent,omitempty"`

	// The physical space used by user data excluding snapshots in the availability zone.
	// Read Only: true
	PhysicalUserDataWithoutSnapshots *int64 `json:"physical_user_data_without_snapshots,omitempty"`

	// Total space in the availability zone.
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// The total space consumed by metadata in the availability zone, which includes log and recovery metadata, delayed frees along with filesystem metadata and performance metadata.
	// Read Only: true
	TotalMetadataUsed *int64 `json:"total_metadata_used,omitempty"`

	// Total unusable space in the availability zone due to an aggregate being unavailable.
	// Read Only: true
	Unusable *int64 `json:"unusable,omitempty"`
}

// Validate validates this storage availability zone inline space
func (m *StorageAvailabilityZoneInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEfficiencyWithoutSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) validateEfficiencyWithoutSnapshots(formats strfmt.Registry) error {
	if swag.IsZero(m.EfficiencyWithoutSnapshots) { // not required
		return nil
	}

	if m.EfficiencyWithoutSnapshots != nil {
		if err := m.EfficiencyWithoutSnapshots.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage availability zone inline space based on the context it is used
func (m *StorageAvailabilityZoneInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDelayedFrees(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInactiveData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogAndRecoveryMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUserDataWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUserDataWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalMetadataUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnusable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateDelayedFrees(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"delayed_frees", "body", m.DelayedFrees); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateEfficiencyWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if m.EfficiencyWithoutSnapshots != nil {
		if err := m.EfficiencyWithoutSnapshots.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateInactiveData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"inactive_data", "body", m.InactiveData); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateLogAndRecoveryMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"log_and_recovery_metadata", "body", m.LogAndRecoveryMetadata); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateLogicalUserDataWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_user_data_without_snapshots", "body", m.LogicalUserDataWithoutSnapshots); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_used", "body", m.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidatePhysicalUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_used_percent", "body", m.PhysicalUsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidatePhysicalUserDataWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_user_data_without_snapshots", "body", m.PhysicalUserDataWithoutSnapshots); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateTotalMetadataUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_metadata_used", "body", m.TotalMetadataUsed); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpace) contextValidateUnusable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"unusable", "body", m.Unusable); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageAvailabilityZoneInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageAvailabilityZoneInlineSpace) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots Storage efficiency that does not include the savings provided by snapshots for the availability zone.
//
// swagger:model storage_availability_zone_inline_space_inline_efficiency_without_snapshots
type StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots struct {

	// Data reduction ratio (logical_used_without_snapshot / physical_used_without_snapshot)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used_without_snapshot - physical_used_without_snapshot)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this storage availability zone inline space inline efficiency without snapshots
func (m *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage availability zone inline space inline efficiency without snapshots based on the context it is used
func (m *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_without_snapshots"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_without_snapshots"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots) UnmarshalBinary(b []byte) error {
	var res StorageAvailabilityZoneInlineSpaceInlineEfficiencyWithoutSnapshots
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
