// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageBridge storage bridge
//
// swagger:model storage_bridge
type StorageBridge struct {

	// Chassis throughput status
	// Example: ok
	// Enum: ["ok","warning"]
	ChassisThroughputState *string `json:"chassis_throughput_state,omitempty"`

	// dram single bit error count
	DramSingleBitErrorCount *int64 `json:"dram_single_bit_error_count,omitempty"`

	// Bridge firmware version
	// Example: 4.10 007A
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// IP Address
	// Read Only: true
	IPAddress *string `json:"ip_address,omitempty"`

	// last reboot
	LastReboot *StorageBridgeInlineLastReboot `json:"last_reboot,omitempty"`

	// managed by
	// Enum: ["snmp","in_band"]
	ManagedBy *string `json:"managed_by,omitempty"`

	// Bridge model
	// Example: FibreBridge6500N
	Model *string `json:"model,omitempty"`

	// Indicates whether monitoring is enabled for the bridge.
	MonitoringEnabled *bool `json:"monitoring_enabled,omitempty"`

	// Bridge name
	// Example: ATTO_FibreBridge6500N_1
	Name *string `json:"name,omitempty"`

	// Indicates whether security is enabled for the bridge.
	SecurityEnabled *bool `json:"security_enabled,omitempty"`

	// Bridge serial number
	// Example: FB7600N100004
	SerialNumber *string `json:"serial_number,omitempty"`

	// Bridge state
	// Enum: ["unknown","ok","error"]
	State *string `json:"state,omitempty"`

	// storage bridge inline errors
	StorageBridgeInlineErrors []*StorageBridgeInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// storage bridge inline fc ports
	StorageBridgeInlineFcPorts []*StorageBridgeInlineFcPortsInlineArrayItem `json:"fc_ports,omitempty"`

	// storage bridge inline paths
	StorageBridgeInlinePaths []*StorageBridgeInlinePathsInlineArrayItem `json:"paths,omitempty"`

	// storage bridge inline power supply units
	StorageBridgeInlinePowerSupplyUnits []*StorageBridgeInlinePowerSupplyUnitsInlineArrayItem `json:"power_supply_units,omitempty"`

	// storage bridge inline sas ports
	StorageBridgeInlineSasPorts []*StorageBridgeInlineSasPortsInlineArrayItem `json:"sas_ports,omitempty"`

	// Bridge symbolic name
	// Example: rtp-fcsas03-41kk11
	SymbolicName *string `json:"symbolic_name,omitempty"`

	// temperature sensor
	TemperatureSensor *StorageBridgeInlineTemperatureSensor `json:"temperature_sensor,omitempty"`

	// Bridge vendor
	// Example: atto
	// Enum: ["unknown","atto"]
	Vendor *string `json:"vendor,omitempty"`

	// Bridge world wide name
	// Example: 2000001086600476
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage bridge
func (m *StorageBridge) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChassisThroughputState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastReboot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateManagedBy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageBridgeInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageBridgeInlineFcPorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageBridgeInlinePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageBridgeInlinePowerSupplyUnits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageBridgeInlineSasPorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTemperatureSensor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVendor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageBridgeTypeChassisThroughputStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeTypeChassisThroughputStatePropEnum = append(storageBridgeTypeChassisThroughputStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// chassis_throughput_state
	// ChassisThroughputState
	// ok
	// END DEBUGGING
	// StorageBridgeChassisThroughputStateOk captures enum value "ok"
	StorageBridgeChassisThroughputStateOk string = "ok"

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// chassis_throughput_state
	// ChassisThroughputState
	// warning
	// END DEBUGGING
	// StorageBridgeChassisThroughputStateWarning captures enum value "warning"
	StorageBridgeChassisThroughputStateWarning string = "warning"
)

// prop value enum
func (m *StorageBridge) validateChassisThroughputStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeTypeChassisThroughputStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridge) validateChassisThroughputState(formats strfmt.Registry) error {
	if swag.IsZero(m.ChassisThroughputState) { // not required
		return nil
	}

	// value enum
	if err := m.validateChassisThroughputStateEnum("chassis_throughput_state", "body", *m.ChassisThroughputState); err != nil {
		return err
	}

	return nil
}

func (m *StorageBridge) validateLastReboot(formats strfmt.Registry) error {
	if swag.IsZero(m.LastReboot) { // not required
		return nil
	}

	if m.LastReboot != nil {
		if err := m.LastReboot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("last_reboot")
			}
			return err
		}
	}

	return nil
}

var storageBridgeTypeManagedByPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["snmp","in_band"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeTypeManagedByPropEnum = append(storageBridgeTypeManagedByPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// managed_by
	// ManagedBy
	// snmp
	// END DEBUGGING
	// StorageBridgeManagedBySnmp captures enum value "snmp"
	StorageBridgeManagedBySnmp string = "snmp"

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// managed_by
	// ManagedBy
	// in_band
	// END DEBUGGING
	// StorageBridgeManagedByInBand captures enum value "in_band"
	StorageBridgeManagedByInBand string = "in_band"
)

// prop value enum
func (m *StorageBridge) validateManagedByEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeTypeManagedByPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridge) validateManagedBy(formats strfmt.Registry) error {
	if swag.IsZero(m.ManagedBy) { // not required
		return nil
	}

	// value enum
	if err := m.validateManagedByEnum("managed_by", "body", *m.ManagedBy); err != nil {
		return err
	}

	return nil
}

var storageBridgeTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeTypeStatePropEnum = append(storageBridgeTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// state
	// State
	// unknown
	// END DEBUGGING
	// StorageBridgeStateUnknown captures enum value "unknown"
	StorageBridgeStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// state
	// State
	// ok
	// END DEBUGGING
	// StorageBridgeStateOk captures enum value "ok"
	StorageBridgeStateOk string = "ok"

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// state
	// State
	// error
	// END DEBUGGING
	// StorageBridgeStateError captures enum value "error"
	StorageBridgeStateError string = "error"
)

// prop value enum
func (m *StorageBridge) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridge) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *StorageBridge) validateStorageBridgeInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageBridgeInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageBridgeInlineErrors); i++ {
		if swag.IsZero(m.StorageBridgeInlineErrors[i]) { // not required
			continue
		}

		if m.StorageBridgeInlineErrors[i] != nil {
			if err := m.StorageBridgeInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) validateStorageBridgeInlineFcPorts(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageBridgeInlineFcPorts) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageBridgeInlineFcPorts); i++ {
		if swag.IsZero(m.StorageBridgeInlineFcPorts[i]) { // not required
			continue
		}

		if m.StorageBridgeInlineFcPorts[i] != nil {
			if err := m.StorageBridgeInlineFcPorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fc_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) validateStorageBridgeInlinePaths(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageBridgeInlinePaths) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageBridgeInlinePaths); i++ {
		if swag.IsZero(m.StorageBridgeInlinePaths[i]) { // not required
			continue
		}

		if m.StorageBridgeInlinePaths[i] != nil {
			if err := m.StorageBridgeInlinePaths[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) validateStorageBridgeInlinePowerSupplyUnits(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageBridgeInlinePowerSupplyUnits) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageBridgeInlinePowerSupplyUnits); i++ {
		if swag.IsZero(m.StorageBridgeInlinePowerSupplyUnits[i]) { // not required
			continue
		}

		if m.StorageBridgeInlinePowerSupplyUnits[i] != nil {
			if err := m.StorageBridgeInlinePowerSupplyUnits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("power_supply_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) validateStorageBridgeInlineSasPorts(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageBridgeInlineSasPorts) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageBridgeInlineSasPorts); i++ {
		if swag.IsZero(m.StorageBridgeInlineSasPorts[i]) { // not required
			continue
		}

		if m.StorageBridgeInlineSasPorts[i] != nil {
			if err := m.StorageBridgeInlineSasPorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sas_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) validateTemperatureSensor(formats strfmt.Registry) error {
	if swag.IsZero(m.TemperatureSensor) { // not required
		return nil
	}

	if m.TemperatureSensor != nil {
		if err := m.TemperatureSensor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("temperature_sensor")
			}
			return err
		}
	}

	return nil
}

var storageBridgeTypeVendorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","atto"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeTypeVendorPropEnum = append(storageBridgeTypeVendorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// vendor
	// Vendor
	// unknown
	// END DEBUGGING
	// StorageBridgeVendorUnknown captures enum value "unknown"
	StorageBridgeVendorUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_bridge
	// StorageBridge
	// vendor
	// Vendor
	// atto
	// END DEBUGGING
	// StorageBridgeVendorAtto captures enum value "atto"
	StorageBridgeVendorAtto string = "atto"
)

// prop value enum
func (m *StorageBridge) validateVendorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeTypeVendorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridge) validateVendor(formats strfmt.Registry) error {
	if swag.IsZero(m.Vendor) { // not required
		return nil
	}

	// value enum
	if err := m.validateVendorEnum("vendor", "body", *m.Vendor); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage bridge based on the context it is used
func (m *StorageBridge) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastReboot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageBridgeInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageBridgeInlineFcPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageBridgeInlinePaths(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageBridgeInlinePowerSupplyUnits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageBridgeInlineSasPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTemperatureSensor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridge) contextValidateIPAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ip_address", "body", m.IPAddress); err != nil {
		return err
	}

	return nil
}

func (m *StorageBridge) contextValidateLastReboot(ctx context.Context, formats strfmt.Registry) error {

	if m.LastReboot != nil {
		if err := m.LastReboot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("last_reboot")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridge) contextValidateStorageBridgeInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageBridgeInlineErrors); i++ {

		if m.StorageBridgeInlineErrors[i] != nil {
			if err := m.StorageBridgeInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) contextValidateStorageBridgeInlineFcPorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageBridgeInlineFcPorts); i++ {

		if m.StorageBridgeInlineFcPorts[i] != nil {
			if err := m.StorageBridgeInlineFcPorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fc_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) contextValidateStorageBridgeInlinePaths(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageBridgeInlinePaths); i++ {

		if m.StorageBridgeInlinePaths[i] != nil {
			if err := m.StorageBridgeInlinePaths[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) contextValidateStorageBridgeInlinePowerSupplyUnits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageBridgeInlinePowerSupplyUnits); i++ {

		if m.StorageBridgeInlinePowerSupplyUnits[i] != nil {
			if err := m.StorageBridgeInlinePowerSupplyUnits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("power_supply_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) contextValidateStorageBridgeInlineSasPorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageBridgeInlineSasPorts); i++ {

		if m.StorageBridgeInlineSasPorts[i] != nil {
			if err := m.StorageBridgeInlineSasPorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sas_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageBridge) contextValidateTemperatureSensor(ctx context.Context, formats strfmt.Registry) error {

	if m.TemperatureSensor != nil {
		if err := m.TemperatureSensor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("temperature_sensor")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridge) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridge) UnmarshalBinary(b []byte) error {
	var res StorageBridge
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineErrorsInlineArrayItem storage bridge inline errors inline array item
//
// swagger:model storage_bridge_inline_errors_inline_array_item
type StorageBridgeInlineErrorsInlineArrayItem struct {

	// component
	Component *StorageBridgeInlineErrorsInlineArrayItemInlineComponent `json:"component,omitempty"`

	// reason
	Reason *Error `json:"reason,omitempty"`

	// Bridge error severity
	// Enum: ["unknown","notice","warning","error"]
	Severity *string `json:"severity,omitempty"`

	// Bridge error type
	// Enum: ["unknown","bridge_unreachable","temp_above_critical_level","temp_below_critical_level","temp_sensor_status_critical","temp_sensor_status_unavailable","invalid_configuration","sas_port_offline","link_failure","sas_port_online","power_supply_offline"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this storage bridge inline errors inline array item
func (m *StorageBridgeInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComponent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlineErrorsInlineArrayItem) validateComponent(formats strfmt.Registry) error {
	if swag.IsZero(m.Component) { // not required
		return nil
	}

	if m.Component != nil {
		if err := m.Component.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("component")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineErrorsInlineArrayItem) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	if m.Reason != nil {
		if err := m.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

var storageBridgeInlineErrorsInlineArrayItemTypeSeverityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","notice","warning","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineErrorsInlineArrayItemTypeSeverityPropEnum = append(storageBridgeInlineErrorsInlineArrayItemTypeSeverityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// severity
	// Severity
	// unknown
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemSeverityUnknown captures enum value "unknown"
	StorageBridgeInlineErrorsInlineArrayItemSeverityUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// severity
	// Severity
	// notice
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemSeverityNotice captures enum value "notice"
	StorageBridgeInlineErrorsInlineArrayItemSeverityNotice string = "notice"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// severity
	// Severity
	// warning
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemSeverityWarning captures enum value "warning"
	StorageBridgeInlineErrorsInlineArrayItemSeverityWarning string = "warning"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// severity
	// Severity
	// error
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemSeverityError captures enum value "error"
	StorageBridgeInlineErrorsInlineArrayItemSeverityError string = "error"
)

// prop value enum
func (m *StorageBridgeInlineErrorsInlineArrayItem) validateSeverityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineErrorsInlineArrayItemTypeSeverityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineErrorsInlineArrayItem) validateSeverity(formats strfmt.Registry) error {
	if swag.IsZero(m.Severity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSeverityEnum("severity", "body", *m.Severity); err != nil {
		return err
	}

	return nil
}

var storageBridgeInlineErrorsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","bridge_unreachable","temp_above_critical_level","temp_below_critical_level","temp_sensor_status_critical","temp_sensor_status_unavailable","invalid_configuration","sas_port_offline","link_failure","sas_port_online","power_supply_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineErrorsInlineArrayItemTypeTypePropEnum = append(storageBridgeInlineErrorsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// unknown
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeUnknown captures enum value "unknown"
	StorageBridgeInlineErrorsInlineArrayItemTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// bridge_unreachable
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeBridgeUnreachable captures enum value "bridge_unreachable"
	StorageBridgeInlineErrorsInlineArrayItemTypeBridgeUnreachable string = "bridge_unreachable"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_above_critical_level
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeTempAboveCriticalLevel captures enum value "temp_above_critical_level"
	StorageBridgeInlineErrorsInlineArrayItemTypeTempAboveCriticalLevel string = "temp_above_critical_level"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_below_critical_level
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeTempBelowCriticalLevel captures enum value "temp_below_critical_level"
	StorageBridgeInlineErrorsInlineArrayItemTypeTempBelowCriticalLevel string = "temp_below_critical_level"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_sensor_status_critical
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeTempSensorStatusCritical captures enum value "temp_sensor_status_critical"
	StorageBridgeInlineErrorsInlineArrayItemTypeTempSensorStatusCritical string = "temp_sensor_status_critical"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_sensor_status_unavailable
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeTempSensorStatusUnavailable captures enum value "temp_sensor_status_unavailable"
	StorageBridgeInlineErrorsInlineArrayItemTypeTempSensorStatusUnavailable string = "temp_sensor_status_unavailable"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// invalid_configuration
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeInvalidConfiguration captures enum value "invalid_configuration"
	StorageBridgeInlineErrorsInlineArrayItemTypeInvalidConfiguration string = "invalid_configuration"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// sas_port_offline
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeSasPortOffline captures enum value "sas_port_offline"
	StorageBridgeInlineErrorsInlineArrayItemTypeSasPortOffline string = "sas_port_offline"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// link_failure
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeLinkFailure captures enum value "link_failure"
	StorageBridgeInlineErrorsInlineArrayItemTypeLinkFailure string = "link_failure"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// sas_port_online
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypeSasPortOnline captures enum value "sas_port_online"
	StorageBridgeInlineErrorsInlineArrayItemTypeSasPortOnline string = "sas_port_online"

	// BEGIN DEBUGGING
	// storage_bridge_inline_errors_inline_array_item
	// StorageBridgeInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_offline
	// END DEBUGGING
	// StorageBridgeInlineErrorsInlineArrayItemTypePowerSupplyOffline captures enum value "power_supply_offline"
	StorageBridgeInlineErrorsInlineArrayItemTypePowerSupplyOffline string = "power_supply_offline"
)

// prop value enum
func (m *StorageBridgeInlineErrorsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineErrorsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineErrorsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage bridge inline errors inline array item based on the context it is used
func (m *StorageBridgeInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComponent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlineErrorsInlineArrayItem) contextValidateComponent(ctx context.Context, formats strfmt.Registry) error {

	if m.Component != nil {
		if err := m.Component.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("component")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineErrorsInlineArrayItem) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if m.Reason != nil {
		if err := m.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineErrorsInlineArrayItemInlineComponent storage bridge inline errors inline array item inline component
//
// swagger:model storage_bridge_inline_errors_inline_array_item_inline_component
type StorageBridgeInlineErrorsInlineArrayItemInlineComponent struct {

	// Bridge error component ID
	ID *int64 `json:"id,omitempty"`

	// Bridge error component name
	Name *string `json:"name,omitempty"`

	// Bridge error component unique ID
	UniqueID *string `json:"unique_id,omitempty"`
}

// Validate validates this storage bridge inline errors inline array item inline component
func (m *StorageBridgeInlineErrorsInlineArrayItemInlineComponent) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage bridge inline errors inline array item inline component based on context it is used
func (m *StorageBridgeInlineErrorsInlineArrayItemInlineComponent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineErrorsInlineArrayItemInlineComponent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineErrorsInlineArrayItemInlineComponent) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineErrorsInlineArrayItemInlineComponent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineFcPortsInlineArrayItem storage bridge inline fc ports inline array item
//
// swagger:model storage_bridge_inline_fc_ports_inline_array_item
type StorageBridgeInlineFcPortsInlineArrayItem struct {

	// Bridge FC port configured data rate, in Gbps
	// Enum: [0,2,4,8,16,32]
	ConfiguredDataRate *float64 `json:"configured_data_rate,omitempty"`

	// Bridge FC port configured connection mode
	// Enum: ["loop","ptp","loop_preferred","ptp_preferred"]
	ConnectionMode *string `json:"connection_mode,omitempty"`

	// Bridge FC port data rate capability, in Gbps
	// Enum: [2,4,8,16,32]
	DataRateCapability *float64 `json:"data_rate_capability,omitempty"`

	// Indicates whether the bridge FC port is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Bridge FC port index
	ID *int64 `json:"id,omitempty"`

	// Bridge FC port negotiated data rate, in Gbps
	// Enum: [0,2,4,8,16,32]
	NegotiatedDataRate *float64 `json:"negotiated_data_rate,omitempty"`

	// Bridge FC port peer port world wide name
	// Example: 200650eb1a238892
	PeerWwn *string `json:"peer_wwn,omitempty"`

	// sfp
	Sfp *StorageBridgeInlineFcPortsInlineArrayItemInlineSfp `json:"sfp,omitempty"`

	// Bridge FC port state
	// Enum: ["error","online","offline"]
	State *string `json:"state,omitempty"`

	// Bridge FC port world wide name
	// Example: 2100001086a54100
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage bridge inline fc ports inline array item
func (m *StorageBridgeInlineFcPortsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfiguredDataRate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectionMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataRateCapability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNegotiatedDataRate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSfp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageBridgeInlineFcPortsInlineArrayItemTypeConfiguredDataRatePropEnum []interface{}

func init() {
	var res []float64
	if err := json.Unmarshal([]byte(`[0,2,4,8,16,32]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineFcPortsInlineArrayItemTypeConfiguredDataRatePropEnum = append(storageBridgeInlineFcPortsInlineArrayItemTypeConfiguredDataRatePropEnum, v)
	}
}

// prop value enum
func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateConfiguredDataRateEnum(path, location string, value float64) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineFcPortsInlineArrayItemTypeConfiguredDataRatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateConfiguredDataRate(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfiguredDataRate) { // not required
		return nil
	}

	// value enum
	if err := m.validateConfiguredDataRateEnum("configured_data_rate", "body", *m.ConfiguredDataRate); err != nil {
		return err
	}

	return nil
}

var storageBridgeInlineFcPortsInlineArrayItemTypeConnectionModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["loop","ptp","loop_preferred","ptp_preferred"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineFcPortsInlineArrayItemTypeConnectionModePropEnum = append(storageBridgeInlineFcPortsInlineArrayItemTypeConnectionModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge_inline_fc_ports_inline_array_item
	// StorageBridgeInlineFcPortsInlineArrayItem
	// connection_mode
	// ConnectionMode
	// loop
	// END DEBUGGING
	// StorageBridgeInlineFcPortsInlineArrayItemConnectionModeLoop captures enum value "loop"
	StorageBridgeInlineFcPortsInlineArrayItemConnectionModeLoop string = "loop"

	// BEGIN DEBUGGING
	// storage_bridge_inline_fc_ports_inline_array_item
	// StorageBridgeInlineFcPortsInlineArrayItem
	// connection_mode
	// ConnectionMode
	// ptp
	// END DEBUGGING
	// StorageBridgeInlineFcPortsInlineArrayItemConnectionModePtp captures enum value "ptp"
	StorageBridgeInlineFcPortsInlineArrayItemConnectionModePtp string = "ptp"

	// BEGIN DEBUGGING
	// storage_bridge_inline_fc_ports_inline_array_item
	// StorageBridgeInlineFcPortsInlineArrayItem
	// connection_mode
	// ConnectionMode
	// loop_preferred
	// END DEBUGGING
	// StorageBridgeInlineFcPortsInlineArrayItemConnectionModeLoopPreferred captures enum value "loop_preferred"
	StorageBridgeInlineFcPortsInlineArrayItemConnectionModeLoopPreferred string = "loop_preferred"

	// BEGIN DEBUGGING
	// storage_bridge_inline_fc_ports_inline_array_item
	// StorageBridgeInlineFcPortsInlineArrayItem
	// connection_mode
	// ConnectionMode
	// ptp_preferred
	// END DEBUGGING
	// StorageBridgeInlineFcPortsInlineArrayItemConnectionModePtpPreferred captures enum value "ptp_preferred"
	StorageBridgeInlineFcPortsInlineArrayItemConnectionModePtpPreferred string = "ptp_preferred"
)

// prop value enum
func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateConnectionModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineFcPortsInlineArrayItemTypeConnectionModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateConnectionMode(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectionMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateConnectionModeEnum("connection_mode", "body", *m.ConnectionMode); err != nil {
		return err
	}

	return nil
}

var storageBridgeInlineFcPortsInlineArrayItemTypeDataRateCapabilityPropEnum []interface{}

func init() {
	var res []float64
	if err := json.Unmarshal([]byte(`[2,4,8,16,32]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineFcPortsInlineArrayItemTypeDataRateCapabilityPropEnum = append(storageBridgeInlineFcPortsInlineArrayItemTypeDataRateCapabilityPropEnum, v)
	}
}

// prop value enum
func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateDataRateCapabilityEnum(path, location string, value float64) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineFcPortsInlineArrayItemTypeDataRateCapabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateDataRateCapability(formats strfmt.Registry) error {
	if swag.IsZero(m.DataRateCapability) { // not required
		return nil
	}

	// value enum
	if err := m.validateDataRateCapabilityEnum("data_rate_capability", "body", *m.DataRateCapability); err != nil {
		return err
	}

	return nil
}

var storageBridgeInlineFcPortsInlineArrayItemTypeNegotiatedDataRatePropEnum []interface{}

func init() {
	var res []float64
	if err := json.Unmarshal([]byte(`[0,2,4,8,16,32]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineFcPortsInlineArrayItemTypeNegotiatedDataRatePropEnum = append(storageBridgeInlineFcPortsInlineArrayItemTypeNegotiatedDataRatePropEnum, v)
	}
}

// prop value enum
func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateNegotiatedDataRateEnum(path, location string, value float64) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineFcPortsInlineArrayItemTypeNegotiatedDataRatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateNegotiatedDataRate(formats strfmt.Registry) error {
	if swag.IsZero(m.NegotiatedDataRate) { // not required
		return nil
	}

	// value enum
	if err := m.validateNegotiatedDataRateEnum("negotiated_data_rate", "body", *m.NegotiatedDataRate); err != nil {
		return err
	}

	return nil
}

func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateSfp(formats strfmt.Registry) error {
	if swag.IsZero(m.Sfp) { // not required
		return nil
	}

	if m.Sfp != nil {
		if err := m.Sfp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sfp")
			}
			return err
		}
	}

	return nil
}

var storageBridgeInlineFcPortsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["error","online","offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineFcPortsInlineArrayItemTypeStatePropEnum = append(storageBridgeInlineFcPortsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge_inline_fc_ports_inline_array_item
	// StorageBridgeInlineFcPortsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// StorageBridgeInlineFcPortsInlineArrayItemStateError captures enum value "error"
	StorageBridgeInlineFcPortsInlineArrayItemStateError string = "error"

	// BEGIN DEBUGGING
	// storage_bridge_inline_fc_ports_inline_array_item
	// StorageBridgeInlineFcPortsInlineArrayItem
	// state
	// State
	// online
	// END DEBUGGING
	// StorageBridgeInlineFcPortsInlineArrayItemStateOnline captures enum value "online"
	StorageBridgeInlineFcPortsInlineArrayItemStateOnline string = "online"

	// BEGIN DEBUGGING
	// storage_bridge_inline_fc_ports_inline_array_item
	// StorageBridgeInlineFcPortsInlineArrayItem
	// state
	// State
	// offline
	// END DEBUGGING
	// StorageBridgeInlineFcPortsInlineArrayItemStateOffline captures enum value "offline"
	StorageBridgeInlineFcPortsInlineArrayItemStateOffline string = "offline"
)

// prop value enum
func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineFcPortsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineFcPortsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage bridge inline fc ports inline array item based on the context it is used
func (m *StorageBridgeInlineFcPortsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSfp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlineFcPortsInlineArrayItem) contextValidateSfp(ctx context.Context, formats strfmt.Registry) error {

	if m.Sfp != nil {
		if err := m.Sfp.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sfp")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineFcPortsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineFcPortsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineFcPortsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineFcPortsInlineArrayItemInlineSfp storage bridge inline fc ports inline array item inline sfp
//
// swagger:model storage_bridge_inline_fc_ports_inline_array_item_inline_sfp
type StorageBridgeInlineFcPortsInlineArrayItemInlineSfp struct {

	// Bridge FC port SFP data rate capability, in Gbps
	// Enum: [2,4,8,16,32]
	DataRateCapability *float64 `json:"data_rate_capability,omitempty"`

	// part number
	PartNumber *string `json:"part_number,omitempty"`

	// Bridge FC port SFP serial number
	SerialNumber *string `json:"serial_number,omitempty"`

	// Bridge FC port SFP vendor
	Vendor *string `json:"vendor,omitempty"`
}

// Validate validates this storage bridge inline fc ports inline array item inline sfp
func (m *StorageBridgeInlineFcPortsInlineArrayItemInlineSfp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDataRateCapability(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageBridgeInlineFcPortsInlineArrayItemInlineSfpTypeDataRateCapabilityPropEnum []interface{}

func init() {
	var res []float64
	if err := json.Unmarshal([]byte(`[2,4,8,16,32]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineFcPortsInlineArrayItemInlineSfpTypeDataRateCapabilityPropEnum = append(storageBridgeInlineFcPortsInlineArrayItemInlineSfpTypeDataRateCapabilityPropEnum, v)
	}
}

// prop value enum
func (m *StorageBridgeInlineFcPortsInlineArrayItemInlineSfp) validateDataRateCapabilityEnum(path, location string, value float64) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineFcPortsInlineArrayItemInlineSfpTypeDataRateCapabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineFcPortsInlineArrayItemInlineSfp) validateDataRateCapability(formats strfmt.Registry) error {
	if swag.IsZero(m.DataRateCapability) { // not required
		return nil
	}

	// value enum
	if err := m.validateDataRateCapabilityEnum("sfp"+"."+"data_rate_capability", "body", *m.DataRateCapability); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage bridge inline fc ports inline array item inline sfp based on context it is used
func (m *StorageBridgeInlineFcPortsInlineArrayItemInlineSfp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineFcPortsInlineArrayItemInlineSfp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineFcPortsInlineArrayItemInlineSfp) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineFcPortsInlineArrayItemInlineSfp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineLastReboot storage bridge inline last reboot
//
// swagger:model storage_bridge_inline_last_reboot
type StorageBridgeInlineLastReboot struct {

	// The error message and code explaining why the bridge rebooted.
	Reason *Error `json:"reason,omitempty"`

	// time
	// Example: 2020-12-09 00:47:58-05:00
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this storage bridge inline last reboot
func (m *StorageBridgeInlineLastReboot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlineLastReboot) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	if m.Reason != nil {
		if err := m.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("last_reboot" + "." + "reason")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineLastReboot) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("last_reboot"+"."+"time", "body", "date-time", m.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage bridge inline last reboot based on the context it is used
func (m *StorageBridgeInlineLastReboot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlineLastReboot) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if m.Reason != nil {
		if err := m.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("last_reboot" + "." + "reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineLastReboot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineLastReboot) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineLastReboot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlinePathsInlineArrayItem storage bridge inline paths inline array item
//
// swagger:model storage_bridge_inline_paths_inline_array_item
type StorageBridgeInlinePathsInlineArrayItem struct {

	// name
	// Example: 2c
	Name *string `json:"name,omitempty"`

	// node
	Node *StorageBridgeInlinePathsInlineArrayItemInlineNode `json:"node,omitempty"`

	// source port
	SourcePort *StorageBridgeInlinePathsInlineArrayItemInlineSourcePort `json:"source_port,omitempty"`

	// target port
	TargetPort *StorageBridgeInlinePathsInlineArrayItemInlineTargetPort `json:"target_port,omitempty"`
}

// Validate validates this storage bridge inline paths inline array item
func (m *StorageBridgeInlinePathsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSourcePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetPort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItem) validateSourcePort(formats strfmt.Registry) error {
	if swag.IsZero(m.SourcePort) { // not required
		return nil
	}

	if m.SourcePort != nil {
		if err := m.SourcePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source_port")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItem) validateTargetPort(formats strfmt.Registry) error {
	if swag.IsZero(m.TargetPort) { // not required
		return nil
	}

	if m.TargetPort != nil {
		if err := m.TargetPort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target_port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage bridge inline paths inline array item based on the context it is used
func (m *StorageBridgeInlinePathsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSourcePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetPort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItem) contextValidateSourcePort(ctx context.Context, formats strfmt.Registry) error {

	if m.SourcePort != nil {
		if err := m.SourcePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source_port")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItem) contextValidateTargetPort(ctx context.Context, formats strfmt.Registry) error {

	if m.TargetPort != nil {
		if err := m.TargetPort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target_port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlinePathsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlinePathsInlineArrayItemInlineNode storage bridge inline paths inline array item inline node
//
// swagger:model storage_bridge_inline_paths_inline_array_item_inline_node
type StorageBridgeInlinePathsInlineArrayItemInlineNode struct {

	// links
	Links *StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage bridge inline paths inline array item inline node
func (m *StorageBridgeInlinePathsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage bridge inline paths inline array item inline node based on the context it is used
func (m *StorageBridgeInlinePathsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlinePathsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks storage bridge inline paths inline array item inline node inline links
//
// swagger:model storage_bridge_inline_paths_inline_array_item_inline_node_inline__links
type StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage bridge inline paths inline array item inline node inline links
func (m *StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage bridge inline paths inline array item inline node inline links based on the context it is used
func (m *StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlinePathsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlinePathsInlineArrayItemInlineSourcePort storage bridge inline paths inline array item inline source port
//
// swagger:model storage_bridge_inline_paths_inline_array_item_inline_source_port
type StorageBridgeInlinePathsInlineArrayItemInlineSourcePort struct {

	// Initiator side switch port id
	// Example: 100050eb1a238892
	ID *string `json:"id,omitempty"`

	// Initiator side switch port name
	// Example: rtp-fc03-41kk11:1
	Name *string `json:"name,omitempty"`
}

// Validate validates this storage bridge inline paths inline array item inline source port
func (m *StorageBridgeInlinePathsInlineArrayItemInlineSourcePort) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage bridge inline paths inline array item inline source port based on context it is used
func (m *StorageBridgeInlinePathsInlineArrayItemInlineSourcePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItemInlineSourcePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItemInlineSourcePort) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlinePathsInlineArrayItemInlineSourcePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlinePathsInlineArrayItemInlineTargetPort storage bridge inline paths inline array item inline target port
//
// swagger:model storage_bridge_inline_paths_inline_array_item_inline_target_port
type StorageBridgeInlinePathsInlineArrayItemInlineTargetPort struct {

	// Target side switch port id
	// Example: 100050eb1a238892
	ID *string `json:"id,omitempty"`

	// Target side switch port name
	// Example: rtp-fc03-41kk11:6
	Name *string `json:"name,omitempty"`

	// Target side switch port world wide name
	// Example: 2100001086a54100
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage bridge inline paths inline array item inline target port
func (m *StorageBridgeInlinePathsInlineArrayItemInlineTargetPort) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage bridge inline paths inline array item inline target port based on context it is used
func (m *StorageBridgeInlinePathsInlineArrayItemInlineTargetPort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItemInlineTargetPort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlinePathsInlineArrayItemInlineTargetPort) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlinePathsInlineArrayItemInlineTargetPort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlinePowerSupplyUnitsInlineArrayItem storage bridge inline power supply units inline array item
//
// swagger:model storage_bridge_inline_power_supply_units_inline_array_item
type StorageBridgeInlinePowerSupplyUnitsInlineArrayItem struct {

	// Power supply unit name
	Name *string `json:"name,omitempty"`

	// Power supply unit state
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage bridge inline power supply units inline array item
func (m *StorageBridgeInlinePowerSupplyUnitsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageBridgeInlinePowerSupplyUnitsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlinePowerSupplyUnitsInlineArrayItemTypeStatePropEnum = append(storageBridgeInlinePowerSupplyUnitsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge_inline_power_supply_units_inline_array_item
	// StorageBridgeInlinePowerSupplyUnitsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// StorageBridgeInlinePowerSupplyUnitsInlineArrayItemStateOk captures enum value "ok"
	StorageBridgeInlinePowerSupplyUnitsInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// storage_bridge_inline_power_supply_units_inline_array_item
	// StorageBridgeInlinePowerSupplyUnitsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// StorageBridgeInlinePowerSupplyUnitsInlineArrayItemStateError captures enum value "error"
	StorageBridgeInlinePowerSupplyUnitsInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *StorageBridgeInlinePowerSupplyUnitsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlinePowerSupplyUnitsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlinePowerSupplyUnitsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage bridge inline power supply units inline array item based on context it is used
func (m *StorageBridgeInlinePowerSupplyUnitsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlinePowerSupplyUnitsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlinePowerSupplyUnitsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlinePowerSupplyUnitsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineSasPortsInlineArrayItem storage bridge inline sas ports inline array item
//
// swagger:model storage_bridge_inline_sas_ports_inline_array_item
type StorageBridgeInlineSasPortsInlineArrayItem struct {

	// cable
	Cable *StorageBridgeInlineSasPortsInlineArrayItemInlineCable `json:"cable,omitempty"`

	// Bridge SAS port data rate capability, in Gbps
	// Enum: [0,1.5,3,6,12]
	DataRateCapability *float64 `json:"data_rate_capability,omitempty"`

	// Indicates whether a bridge SAS port is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Bridge SAS port index
	ID *int64 `json:"id,omitempty"`

	// Bridge SAS port negotiated data rate, in Gbps
	// Enum: [0,1.5,3,6,12]
	NegotiatedDataRate *float64 `json:"negotiated_data_rate,omitempty"`

	// phy 1
	Phy1 *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy1 `json:"phy_1,omitempty"`

	// phy 2
	Phy2 *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy2 `json:"phy_2,omitempty"`

	// phy 3
	Phy3 *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy3 `json:"phy_3,omitempty"`

	// phy 4
	Phy4 *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy4 `json:"phy_4,omitempty"`

	// Bridge SAS port state
	// Enum: ["error","online","offline"]
	State *string `json:"state,omitempty"`

	// Bridge SAS port world wide name
	// Example: 2100001086a54100
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage bridge inline sas ports inline array item
func (m *StorageBridgeInlineSasPortsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataRateCapability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNegotiatedDataRate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePhy1(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePhy2(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePhy3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePhy4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) validateCable(formats strfmt.Registry) error {
	if swag.IsZero(m.Cable) { // not required
		return nil
	}

	if m.Cable != nil {
		if err := m.Cable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cable")
			}
			return err
		}
	}

	return nil
}

var storageBridgeInlineSasPortsInlineArrayItemTypeDataRateCapabilityPropEnum []interface{}

func init() {
	var res []float64
	if err := json.Unmarshal([]byte(`[0,1.5,3,6,12]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineSasPortsInlineArrayItemTypeDataRateCapabilityPropEnum = append(storageBridgeInlineSasPortsInlineArrayItemTypeDataRateCapabilityPropEnum, v)
	}
}

// prop value enum
func (m *StorageBridgeInlineSasPortsInlineArrayItem) validateDataRateCapabilityEnum(path, location string, value float64) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineSasPortsInlineArrayItemTypeDataRateCapabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) validateDataRateCapability(formats strfmt.Registry) error {
	if swag.IsZero(m.DataRateCapability) { // not required
		return nil
	}

	// value enum
	if err := m.validateDataRateCapabilityEnum("data_rate_capability", "body", *m.DataRateCapability); err != nil {
		return err
	}

	return nil
}

var storageBridgeInlineSasPortsInlineArrayItemTypeNegotiatedDataRatePropEnum []interface{}

func init() {
	var res []float64
	if err := json.Unmarshal([]byte(`[0,1.5,3,6,12]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineSasPortsInlineArrayItemTypeNegotiatedDataRatePropEnum = append(storageBridgeInlineSasPortsInlineArrayItemTypeNegotiatedDataRatePropEnum, v)
	}
}

// prop value enum
func (m *StorageBridgeInlineSasPortsInlineArrayItem) validateNegotiatedDataRateEnum(path, location string, value float64) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineSasPortsInlineArrayItemTypeNegotiatedDataRatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) validateNegotiatedDataRate(formats strfmt.Registry) error {
	if swag.IsZero(m.NegotiatedDataRate) { // not required
		return nil
	}

	// value enum
	if err := m.validateNegotiatedDataRateEnum("negotiated_data_rate", "body", *m.NegotiatedDataRate); err != nil {
		return err
	}

	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) validatePhy1(formats strfmt.Registry) error {
	if swag.IsZero(m.Phy1) { // not required
		return nil
	}

	if m.Phy1 != nil {
		if err := m.Phy1.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("phy_1")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) validatePhy2(formats strfmt.Registry) error {
	if swag.IsZero(m.Phy2) { // not required
		return nil
	}

	if m.Phy2 != nil {
		if err := m.Phy2.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("phy_2")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) validatePhy3(formats strfmt.Registry) error {
	if swag.IsZero(m.Phy3) { // not required
		return nil
	}

	if m.Phy3 != nil {
		if err := m.Phy3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("phy_3")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) validatePhy4(formats strfmt.Registry) error {
	if swag.IsZero(m.Phy4) { // not required
		return nil
	}

	if m.Phy4 != nil {
		if err := m.Phy4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("phy_4")
			}
			return err
		}
	}

	return nil
}

var storageBridgeInlineSasPortsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["error","online","offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineSasPortsInlineArrayItemTypeStatePropEnum = append(storageBridgeInlineSasPortsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge_inline_sas_ports_inline_array_item
	// StorageBridgeInlineSasPortsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// StorageBridgeInlineSasPortsInlineArrayItemStateError captures enum value "error"
	StorageBridgeInlineSasPortsInlineArrayItemStateError string = "error"

	// BEGIN DEBUGGING
	// storage_bridge_inline_sas_ports_inline_array_item
	// StorageBridgeInlineSasPortsInlineArrayItem
	// state
	// State
	// online
	// END DEBUGGING
	// StorageBridgeInlineSasPortsInlineArrayItemStateOnline captures enum value "online"
	StorageBridgeInlineSasPortsInlineArrayItemStateOnline string = "online"

	// BEGIN DEBUGGING
	// storage_bridge_inline_sas_ports_inline_array_item
	// StorageBridgeInlineSasPortsInlineArrayItem
	// state
	// State
	// offline
	// END DEBUGGING
	// StorageBridgeInlineSasPortsInlineArrayItemStateOffline captures enum value "offline"
	StorageBridgeInlineSasPortsInlineArrayItemStateOffline string = "offline"
)

// prop value enum
func (m *StorageBridgeInlineSasPortsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineSasPortsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage bridge inline sas ports inline array item based on the context it is used
func (m *StorageBridgeInlineSasPortsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhy1(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhy2(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhy3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhy4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) contextValidateCable(ctx context.Context, formats strfmt.Registry) error {

	if m.Cable != nil {
		if err := m.Cable.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cable")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) contextValidatePhy1(ctx context.Context, formats strfmt.Registry) error {

	if m.Phy1 != nil {
		if err := m.Phy1.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("phy_1")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) contextValidatePhy2(ctx context.Context, formats strfmt.Registry) error {

	if m.Phy2 != nil {
		if err := m.Phy2.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("phy_2")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) contextValidatePhy3(ctx context.Context, formats strfmt.Registry) error {

	if m.Phy3 != nil {
		if err := m.Phy3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("phy_3")
			}
			return err
		}
	}

	return nil
}

func (m *StorageBridgeInlineSasPortsInlineArrayItem) contextValidatePhy4(ctx context.Context, formats strfmt.Registry) error {

	if m.Phy4 != nil {
		if err := m.Phy4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("phy_4")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineSasPortsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineSasPortsInlineArrayItemInlineCable storage bridge inline sas ports inline array item inline cable
//
// swagger:model storage_bridge_inline_sas_ports_inline_array_item_inline_cable
type StorageBridgeInlineSasPortsInlineArrayItemInlineCable struct {

	// Bridge cable part number
	PartNumber *string `json:"part_number,omitempty"`

	// Bridge cable serial number
	SerialNumber *string `json:"serial_number,omitempty"`

	// Bridge cable type
	Technology *string `json:"technology,omitempty"`

	// Bridge cable vendor
	Vendor *string `json:"vendor,omitempty"`
}

// Validate validates this storage bridge inline sas ports inline array item inline cable
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlineCable) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage bridge inline sas ports inline array item inline cable based on context it is used
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlineCable) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlineCable) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlineCable) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineSasPortsInlineArrayItemInlineCable
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineSasPortsInlineArrayItemInlinePhy1 storage bridge inline sas ports inline array item inline phy 1
//
// swagger:model storage_bridge_inline_sas_ports_inline_array_item_inline_phy_1
type StorageBridgeInlineSasPortsInlineArrayItemInlinePhy1 struct {

	// Bridge SAS port PHY1 state
	State *string `json:"state,omitempty"`
}

// Validate validates this storage bridge inline sas ports inline array item inline phy 1
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy1) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage bridge inline sas ports inline array item inline phy 1 based on context it is used
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy1) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineSasPortsInlineArrayItemInlinePhy1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineSasPortsInlineArrayItemInlinePhy2 storage bridge inline sas ports inline array item inline phy 2
//
// swagger:model storage_bridge_inline_sas_ports_inline_array_item_inline_phy_2
type StorageBridgeInlineSasPortsInlineArrayItemInlinePhy2 struct {

	// Bridge SAS port PHY2 state
	State *string `json:"state,omitempty"`
}

// Validate validates this storage bridge inline sas ports inline array item inline phy 2
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy2) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage bridge inline sas ports inline array item inline phy 2 based on context it is used
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy2) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy2) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy2) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineSasPortsInlineArrayItemInlinePhy2
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineSasPortsInlineArrayItemInlinePhy3 storage bridge inline sas ports inline array item inline phy 3
//
// swagger:model storage_bridge_inline_sas_ports_inline_array_item_inline_phy_3
type StorageBridgeInlineSasPortsInlineArrayItemInlinePhy3 struct {

	// Bridge SAS port PHY3 state
	State *string `json:"state,omitempty"`
}

// Validate validates this storage bridge inline sas ports inline array item inline phy 3
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy3) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage bridge inline sas ports inline array item inline phy 3 based on context it is used
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy3) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineSasPortsInlineArrayItemInlinePhy3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineSasPortsInlineArrayItemInlinePhy4 storage bridge inline sas ports inline array item inline phy 4
//
// swagger:model storage_bridge_inline_sas_ports_inline_array_item_inline_phy_4
type StorageBridgeInlineSasPortsInlineArrayItemInlinePhy4 struct {

	// Bridge SAS port PHY4 state
	State *string `json:"state,omitempty"`
}

// Validate validates this storage bridge inline sas ports inline array item inline phy 4
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy4) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage bridge inline sas ports inline array item inline phy 4 based on context it is used
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineSasPortsInlineArrayItemInlinePhy4) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineSasPortsInlineArrayItemInlinePhy4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageBridgeInlineTemperatureSensor storage bridge inline temperature sensor
//
// swagger:model storage_bridge_inline_temperature_sensor
type StorageBridgeInlineTemperatureSensor struct {

	// Maximum safe operating temperature, in degrees Celsius.
	Maximum *int64 `json:"maximum,omitempty"`

	// Minimum safe operating temperature, in degrees Celsius.
	Minimum *int64 `json:"minimum,omitempty"`

	// Temperature sensor name
	// Example: Chassis temperature sensor
	Name *string `json:"name,omitempty"`

	// Chassis temperature sensor reading, in degrees Celsius.
	Reading *int64 `json:"reading,omitempty"`

	// state
	// Enum: ["ok","warning","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage bridge inline temperature sensor
func (m *StorageBridgeInlineTemperatureSensor) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageBridgeInlineTemperatureSensorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageBridgeInlineTemperatureSensorTypeStatePropEnum = append(storageBridgeInlineTemperatureSensorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_bridge_inline_temperature_sensor
	// StorageBridgeInlineTemperatureSensor
	// state
	// State
	// ok
	// END DEBUGGING
	// StorageBridgeInlineTemperatureSensorStateOk captures enum value "ok"
	StorageBridgeInlineTemperatureSensorStateOk string = "ok"

	// BEGIN DEBUGGING
	// storage_bridge_inline_temperature_sensor
	// StorageBridgeInlineTemperatureSensor
	// state
	// State
	// warning
	// END DEBUGGING
	// StorageBridgeInlineTemperatureSensorStateWarning captures enum value "warning"
	StorageBridgeInlineTemperatureSensorStateWarning string = "warning"

	// BEGIN DEBUGGING
	// storage_bridge_inline_temperature_sensor
	// StorageBridgeInlineTemperatureSensor
	// state
	// State
	// error
	// END DEBUGGING
	// StorageBridgeInlineTemperatureSensorStateError captures enum value "error"
	StorageBridgeInlineTemperatureSensorStateError string = "error"
)

// prop value enum
func (m *StorageBridgeInlineTemperatureSensor) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageBridgeInlineTemperatureSensorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageBridgeInlineTemperatureSensor) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("temperature_sensor"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage bridge inline temperature sensor based on context it is used
func (m *StorageBridgeInlineTemperatureSensor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageBridgeInlineTemperatureSensor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageBridgeInlineTemperatureSensor) UnmarshalBinary(b []byte) error {
	var res StorageBridgeInlineTemperatureSensor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
