// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StoragePool storage pool
//
// swagger:model storage_pool
type StoragePool struct {

	// links
	Links *StoragePoolInlineLinks `json:"_links,omitempty"`

	// capacity
	Capacity *StoragePoolInlineCapacity `json:"capacity,omitempty"`

	// health
	Health *StoragePoolInlineHealth `json:"health,omitempty"`

	// Storage pool name.
	Name *string `json:"name,omitempty"`

	// Nodes that can use this storage pool for their aggregates.
	StoragePoolInlineNodes []*NodeReference `json:"nodes,omitempty"`

	// Storage type for the disks used to create the storage pool.
	// Read Only: true
	// Enum: ["SSD"]
	StorageType *string `json:"storage_type,omitempty"`

	// Storage pool UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage pool
func (m *StoragePool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCapacity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealth(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStoragePoolInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePool) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePool) validateCapacity(formats strfmt.Registry) error {
	if swag.IsZero(m.Capacity) { // not required
		return nil
	}

	if m.Capacity != nil {
		if err := m.Capacity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePool) validateHealth(formats strfmt.Registry) error {
	if swag.IsZero(m.Health) { // not required
		return nil
	}

	if m.Health != nil {
		if err := m.Health.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("health")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePool) validateStoragePoolInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.StoragePoolInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(m.StoragePoolInlineNodes); i++ {
		if swag.IsZero(m.StoragePoolInlineNodes[i]) { // not required
			continue
		}

		if m.StoragePoolInlineNodes[i] != nil {
			if err := m.StoragePoolInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var storagePoolTypeStorageTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSD"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolTypeStorageTypePropEnum = append(storagePoolTypeStorageTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_pool
	// StoragePool
	// storage_type
	// StorageType
	// SSD
	// END DEBUGGING
	// StoragePoolStorageTypeSSD captures enum value "SSD"
	StoragePoolStorageTypeSSD string = "SSD"
)

// prop value enum
func (m *StoragePool) validateStorageTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolTypeStorageTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StoragePool) validateStorageType(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageType) { // not required
		return nil
	}

	// value enum
	if err := m.validateStorageTypeEnum("storage_type", "body", *m.StorageType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage pool based on the context it is used
func (m *StoragePool) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHealth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStoragePoolInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePool) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePool) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if m.Capacity != nil {
		if err := m.Capacity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePool) contextValidateHealth(ctx context.Context, formats strfmt.Registry) error {

	if m.Health != nil {
		if err := m.Health.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("health")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePool) contextValidateStoragePoolInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StoragePoolInlineNodes); i++ {

		if m.StoragePoolInlineNodes[i] != nil {
			if err := m.StoragePoolInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StoragePool) contextValidateStorageType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_type", "body", m.StorageType); err != nil {
		return err
	}

	return nil
}

func (m *StoragePool) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePool) UnmarshalBinary(b []byte) error {
	var res StoragePool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StoragePoolInlineCapacity storage pool inline capacity
//
// swagger:model storage_pool_inline_capacity
type StoragePoolInlineCapacity struct {

	// The number of disks in the storage pool.
	DiskCount *int64 `json:"disk_count,omitempty"`

	// Properties of each disk used in the shared storage pool.
	Disks []*StoragePoolDisk `json:"disks,omitempty"`

	// Remaining usable capacity in the flash pool, in bytes.
	// Read Only: true
	Remaining *int64 `json:"remaining,omitempty"`

	// Properties of spare allocation units.
	SpareAllocationUnits []*StoragePoolSpareAllocationUnit `json:"spare_allocation_units,omitempty"`

	// Total size of the flash pool, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// Information about the storage pool allocation units participating in the cache tier of an aggregate.
	UsedAllocationUnits []*StoragePoolUsedAllocationUnit `json:"used_allocation_units,omitempty"`
}

// Validate validates this storage pool inline capacity
func (m *StoragePoolInlineCapacity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDisks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpareAllocationUnits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsedAllocationUnits(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolInlineCapacity) validateDisks(formats strfmt.Registry) error {
	if swag.IsZero(m.Disks) { // not required
		return nil
	}

	for i := 0; i < len(m.Disks); i++ {
		if swag.IsZero(m.Disks[i]) { // not required
			continue
		}

		if m.Disks[i] != nil {
			if err := m.Disks[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capacity" + "." + "disks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StoragePoolInlineCapacity) validateSpareAllocationUnits(formats strfmt.Registry) error {
	if swag.IsZero(m.SpareAllocationUnits) { // not required
		return nil
	}

	for i := 0; i < len(m.SpareAllocationUnits); i++ {
		if swag.IsZero(m.SpareAllocationUnits[i]) { // not required
			continue
		}

		if m.SpareAllocationUnits[i] != nil {
			if err := m.SpareAllocationUnits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capacity" + "." + "spare_allocation_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StoragePoolInlineCapacity) validateUsedAllocationUnits(formats strfmt.Registry) error {
	if swag.IsZero(m.UsedAllocationUnits) { // not required
		return nil
	}

	for i := 0; i < len(m.UsedAllocationUnits); i++ {
		if swag.IsZero(m.UsedAllocationUnits[i]) { // not required
			continue
		}

		if m.UsedAllocationUnits[i] != nil {
			if err := m.UsedAllocationUnits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capacity" + "." + "used_allocation_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage pool inline capacity based on the context it is used
func (m *StoragePoolInlineCapacity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDisks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemaining(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpareAllocationUnits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedAllocationUnits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolInlineCapacity) contextValidateDisks(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Disks); i++ {

		if m.Disks[i] != nil {
			if err := m.Disks[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capacity" + "." + "disks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StoragePoolInlineCapacity) contextValidateRemaining(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"remaining", "body", m.Remaining); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolInlineCapacity) contextValidateSpareAllocationUnits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SpareAllocationUnits); i++ {

		if m.SpareAllocationUnits[i] != nil {
			if err := m.SpareAllocationUnits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capacity" + "." + "spare_allocation_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StoragePoolInlineCapacity) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolInlineCapacity) contextValidateUsedAllocationUnits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.UsedAllocationUnits); i++ {

		if m.UsedAllocationUnits[i] != nil {
			if err := m.UsedAllocationUnits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capacity" + "." + "used_allocation_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolInlineCapacity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolInlineCapacity) UnmarshalBinary(b []byte) error {
	var res StoragePoolInlineCapacity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StoragePoolInlineHealth Properties that outline shared storage pool health.
//
// swagger:model storage_pool_inline_health
type StoragePoolInlineHealth struct {

	// Indicates whether the storage pool is able to participate in provisioning operations.
	// Read Only: true
	IsHealthy *bool `json:"is_healthy,omitempty"`

	// The state of the shared storage pool.
	// Read Only: true
	// Enum: ["normal","degraded","creating","deleting","reassigning","growing"]
	State *string `json:"state,omitempty"`

	// Indicates why the storage pool is unhealthy. This property is not returned for healthy storage pools.
	// Read Only: true
	UnhealthyReason *Error `json:"unhealthy_reason,omitempty"`
}

// Validate validates this storage pool inline health
func (m *StoragePoolInlineHealth) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnhealthyReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storagePoolInlineHealthTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","degraded","creating","deleting","reassigning","growing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolInlineHealthTypeStatePropEnum = append(storagePoolInlineHealthTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// normal
	// END DEBUGGING
	// StoragePoolInlineHealthStateNormal captures enum value "normal"
	StoragePoolInlineHealthStateNormal string = "normal"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// degraded
	// END DEBUGGING
	// StoragePoolInlineHealthStateDegraded captures enum value "degraded"
	StoragePoolInlineHealthStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// creating
	// END DEBUGGING
	// StoragePoolInlineHealthStateCreating captures enum value "creating"
	StoragePoolInlineHealthStateCreating string = "creating"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// deleting
	// END DEBUGGING
	// StoragePoolInlineHealthStateDeleting captures enum value "deleting"
	StoragePoolInlineHealthStateDeleting string = "deleting"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// reassigning
	// END DEBUGGING
	// StoragePoolInlineHealthStateReassigning captures enum value "reassigning"
	StoragePoolInlineHealthStateReassigning string = "reassigning"

	// BEGIN DEBUGGING
	// storage_pool_inline_health
	// StoragePoolInlineHealth
	// state
	// State
	// growing
	// END DEBUGGING
	// StoragePoolInlineHealthStateGrowing captures enum value "growing"
	StoragePoolInlineHealthStateGrowing string = "growing"
)

// prop value enum
func (m *StoragePoolInlineHealth) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolInlineHealthTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StoragePoolInlineHealth) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("health"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolInlineHealth) validateUnhealthyReason(formats strfmt.Registry) error {
	if swag.IsZero(m.UnhealthyReason) { // not required
		return nil
	}

	if m.UnhealthyReason != nil {
		if err := m.UnhealthyReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("health" + "." + "unhealthy_reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool inline health based on the context it is used
func (m *StoragePoolInlineHealth) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsHealthy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnhealthyReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolInlineHealth) contextValidateIsHealthy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "health"+"."+"is_healthy", "body", m.IsHealthy); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolInlineHealth) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "health"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolInlineHealth) contextValidateUnhealthyReason(ctx context.Context, formats strfmt.Registry) error {

	if m.UnhealthyReason != nil {
		if err := m.UnhealthyReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("health" + "." + "unhealthy_reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolInlineHealth) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolInlineHealth) UnmarshalBinary(b []byte) error {
	var res StoragePoolInlineHealth
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StoragePoolInlineLinks storage pool inline links
//
// swagger:model storage_pool_inline__links
type StoragePoolInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage pool inline links
func (m *StoragePoolInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool inline links based on the context it is used
func (m *StoragePoolInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolInlineLinks) UnmarshalBinary(b []byte) error {
	var res StoragePoolInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
