// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StoragePoolDisk storage pool disk
//
// swagger:model storage_pool_disk
type StoragePoolDisk struct {

	// disk
	Disk *StoragePoolDiskInlineDisk `json:"disk,omitempty"`

	// Raw capacity of the disk, in bytes.
	// Read Only: true
	TotalSize *int64 `json:"total_size,omitempty"`

	// Usable capacity of this disk, in bytes.
	// Read Only: true
	UsableSize *int64 `json:"usable_size,omitempty"`
}

// Validate validates this storage pool disk
func (m *StoragePoolDisk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDisk(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolDisk) validateDisk(formats strfmt.Registry) error {
	if swag.IsZero(m.Disk) { // not required
		return nil
	}

	if m.Disk != nil {
		if err := m.Disk.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool disk based on the context it is used
func (m *StoragePoolDisk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDisk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsableSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolDisk) contextValidateDisk(ctx context.Context, formats strfmt.Registry) error {

	if m.Disk != nil {
		if err := m.Disk.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePoolDisk) contextValidateTotalSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_size", "body", m.TotalSize); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolDisk) contextValidateUsableSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "usable_size", "body", m.UsableSize); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolDisk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolDisk) UnmarshalBinary(b []byte) error {
	var res StoragePoolDisk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StoragePoolDiskInlineDisk Reference to the constituent disk object.
//
// swagger:model storage_pool_disk_inline_disk
type StoragePoolDiskInlineDisk struct {

	// links
	Links *StoragePoolDiskInlineDiskInlineLinks `json:"_links,omitempty"`

	// name
	// Example: 1.0.1
	Name *string `json:"name,omitempty"`
}

// Validate validates this storage pool disk inline disk
func (m *StoragePoolDiskInlineDisk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolDiskInlineDisk) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool disk inline disk based on the context it is used
func (m *StoragePoolDiskInlineDisk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolDiskInlineDisk) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolDiskInlineDisk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolDiskInlineDisk) UnmarshalBinary(b []byte) error {
	var res StoragePoolDiskInlineDisk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StoragePoolDiskInlineDiskInlineLinks storage pool disk inline disk inline links
//
// swagger:model storage_pool_disk_inline_disk_inline__links
type StoragePoolDiskInlineDiskInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage pool disk inline disk inline links
func (m *StoragePoolDiskInlineDiskInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolDiskInlineDiskInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool disk inline disk inline links based on the context it is used
func (m *StoragePoolDiskInlineDiskInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolDiskInlineDiskInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolDiskInlineDiskInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolDiskInlineDiskInlineLinks) UnmarshalBinary(b []byte) error {
	var res StoragePoolDiskInlineDiskInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
