// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// StoragePoolPatch storage pool patch
//
// swagger:model storage_pool_patch
type StoragePoolPatch struct {

	// job
	Job *JobLink `json:"job,omitempty"`

	// Number of shared storage pools in the cluster.
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// storage pool patch inline records
	StoragePoolPatchInlineRecords []*StoragePool `json:"records,omitempty"`
}

// Validate validates this storage pool patch
func (m *StoragePoolPatch) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStoragePoolPatchInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolPatch) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePoolPatch) validateStoragePoolPatchInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.StoragePoolPatchInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.StoragePoolPatchInlineRecords); i++ {
		if swag.IsZero(m.StoragePoolPatchInlineRecords[i]) { // not required
			continue
		}

		if m.StoragePoolPatchInlineRecords[i] != nil {
			if err := m.StoragePoolPatchInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage pool patch based on the context it is used
func (m *StoragePoolPatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStoragePoolPatchInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolPatch) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePoolPatch) contextValidateStoragePoolPatchInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StoragePoolPatchInlineRecords); i++ {

		if m.StoragePoolPatchInlineRecords[i] != nil {
			if err := m.StoragePoolPatchInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolPatch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolPatch) UnmarshalBinary(b []byte) error {
	var res StoragePoolPatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
