// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StoragePoolShowSpares Available spares for stoarge pool.
//
// swagger:model storage_pool_show_spares
type StoragePoolShowSpares struct {

	// The checksum type that has been assigned to the spares.
	// Read Only: true
	// Enum: ["block","advanced_zoned"]
	ChecksumStyle *string `json:"checksum_style,omitempty"`

	// Disk class of spares.
	// Example: solid_state
	// Read Only: true
	// Enum: ["unknown","capacity","performance","archive","solid_state","array","virtual","data_center","capacity_flash"]
	DiskClass *string `json:"disk_class,omitempty"`

	// Type of disk.
	// Read Only: true
	// Enum: ["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]
	DiskType *string `json:"disk_type,omitempty"`

	// Usable size of each spare, in bytes.
	// Example: 10156769280
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Nodes that can use the usable spares for storage pool.
	// Read Only: true
	StoragePoolShowSparesInlineNodes []*NodeReference `json:"nodes,omitempty"`

	// SyncMirror spare pool.
	// Read Only: true
	// Enum: ["pool0","pool1"]
	SyncmirrorPool *string `json:"syncmirror_pool,omitempty"`

	// Total number of usable spares in the bucket. The usable count for each class of spares does not include reserved spare capacity recommended by ONTAP best practices.
	// Example: 9
	// Read Only: true
	Usable *int64 `json:"usable,omitempty"`
}

// Validate validates this storage pool show spares
func (m *StoragePoolShowSpares) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChecksumStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDiskClass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDiskType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStoragePoolShowSparesInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSyncmirrorPool(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storagePoolShowSparesTypeChecksumStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["block","advanced_zoned"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolShowSparesTypeChecksumStylePropEnum = append(storagePoolShowSparesTypeChecksumStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// checksum_style
	// ChecksumStyle
	// block
	// END DEBUGGING
	// StoragePoolShowSparesChecksumStyleBlock captures enum value "block"
	StoragePoolShowSparesChecksumStyleBlock string = "block"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// checksum_style
	// ChecksumStyle
	// advanced_zoned
	// END DEBUGGING
	// StoragePoolShowSparesChecksumStyleAdvancedZoned captures enum value "advanced_zoned"
	StoragePoolShowSparesChecksumStyleAdvancedZoned string = "advanced_zoned"
)

// prop value enum
func (m *StoragePoolShowSpares) validateChecksumStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolShowSparesTypeChecksumStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StoragePoolShowSpares) validateChecksumStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.ChecksumStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateChecksumStyleEnum("checksum_style", "body", *m.ChecksumStyle); err != nil {
		return err
	}

	return nil
}

var storagePoolShowSparesTypeDiskClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","capacity","performance","archive","solid_state","array","virtual","data_center","capacity_flash"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolShowSparesTypeDiskClassPropEnum = append(storagePoolShowSparesTypeDiskClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// unknown
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassUnknown captures enum value "unknown"
	StoragePoolShowSparesDiskClassUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// capacity
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassCapacity captures enum value "capacity"
	StoragePoolShowSparesDiskClassCapacity string = "capacity"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// performance
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassPerformance captures enum value "performance"
	StoragePoolShowSparesDiskClassPerformance string = "performance"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// archive
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassArchive captures enum value "archive"
	StoragePoolShowSparesDiskClassArchive string = "archive"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// solid_state
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassSolidState captures enum value "solid_state"
	StoragePoolShowSparesDiskClassSolidState string = "solid_state"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// array
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassArray captures enum value "array"
	StoragePoolShowSparesDiskClassArray string = "array"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// virtual
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassVirtual captures enum value "virtual"
	StoragePoolShowSparesDiskClassVirtual string = "virtual"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// data_center
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassDataCenter captures enum value "data_center"
	StoragePoolShowSparesDiskClassDataCenter string = "data_center"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_class
	// DiskClass
	// capacity_flash
	// END DEBUGGING
	// StoragePoolShowSparesDiskClassCapacityFlash captures enum value "capacity_flash"
	StoragePoolShowSparesDiskClassCapacityFlash string = "capacity_flash"
)

// prop value enum
func (m *StoragePoolShowSpares) validateDiskClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolShowSparesTypeDiskClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StoragePoolShowSpares) validateDiskClass(formats strfmt.Registry) error {
	if swag.IsZero(m.DiskClass) { // not required
		return nil
	}

	// value enum
	if err := m.validateDiskClassEnum("disk_class", "body", *m.DiskClass); err != nil {
		return err
	}

	return nil
}

var storagePoolShowSparesTypeDiskTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolShowSparesTypeDiskTypePropEnum = append(storagePoolShowSparesTypeDiskTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// fc
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeFc captures enum value "fc"
	StoragePoolShowSparesDiskTypeFc string = "fc"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// lun
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeLun captures enum value "lun"
	StoragePoolShowSparesDiskTypeLun string = "lun"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// nl_sas
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeNlSas captures enum value "nl_sas"
	StoragePoolShowSparesDiskTypeNlSas string = "nl_sas"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// nvme_ssd
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeNvmeSsd captures enum value "nvme_ssd"
	StoragePoolShowSparesDiskTypeNvmeSsd string = "nvme_ssd"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// sas
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeSas captures enum value "sas"
	StoragePoolShowSparesDiskTypeSas string = "sas"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// sata
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeSata captures enum value "sata"
	StoragePoolShowSparesDiskTypeSata string = "sata"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// scsi
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeScsi captures enum value "scsi"
	StoragePoolShowSparesDiskTypeScsi string = "scsi"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// ssd
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeSsd captures enum value "ssd"
	StoragePoolShowSparesDiskTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// ssd_cap
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeSsdCap captures enum value "ssd_cap"
	StoragePoolShowSparesDiskTypeSsdCap string = "ssd_cap"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// ssd_zns
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeSsdZns captures enum value "ssd_zns"
	StoragePoolShowSparesDiskTypeSsdZns string = "ssd_zns"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// disk_type
	// DiskType
	// vm_disk
	// END DEBUGGING
	// StoragePoolShowSparesDiskTypeVMDisk captures enum value "vm_disk"
	StoragePoolShowSparesDiskTypeVMDisk string = "vm_disk"
)

// prop value enum
func (m *StoragePoolShowSpares) validateDiskTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolShowSparesTypeDiskTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StoragePoolShowSpares) validateDiskType(formats strfmt.Registry) error {
	if swag.IsZero(m.DiskType) { // not required
		return nil
	}

	// value enum
	if err := m.validateDiskTypeEnum("disk_type", "body", *m.DiskType); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolShowSpares) validateStoragePoolShowSparesInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.StoragePoolShowSparesInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(m.StoragePoolShowSparesInlineNodes); i++ {
		if swag.IsZero(m.StoragePoolShowSparesInlineNodes[i]) { // not required
			continue
		}

		if m.StoragePoolShowSparesInlineNodes[i] != nil {
			if err := m.StoragePoolShowSparesInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var storagePoolShowSparesTypeSyncmirrorPoolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pool0","pool1"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolShowSparesTypeSyncmirrorPoolPropEnum = append(storagePoolShowSparesTypeSyncmirrorPoolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// syncmirror_pool
	// SyncmirrorPool
	// pool0
	// END DEBUGGING
	// StoragePoolShowSparesSyncmirrorPoolPool0 captures enum value "pool0"
	StoragePoolShowSparesSyncmirrorPoolPool0 string = "pool0"

	// BEGIN DEBUGGING
	// storage_pool_show_spares
	// StoragePoolShowSpares
	// syncmirror_pool
	// SyncmirrorPool
	// pool1
	// END DEBUGGING
	// StoragePoolShowSparesSyncmirrorPoolPool1 captures enum value "pool1"
	StoragePoolShowSparesSyncmirrorPoolPool1 string = "pool1"
)

// prop value enum
func (m *StoragePoolShowSpares) validateSyncmirrorPoolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolShowSparesTypeSyncmirrorPoolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StoragePoolShowSpares) validateSyncmirrorPool(formats strfmt.Registry) error {
	if swag.IsZero(m.SyncmirrorPool) { // not required
		return nil
	}

	// value enum
	if err := m.validateSyncmirrorPoolEnum("syncmirror_pool", "body", *m.SyncmirrorPool); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage pool show spares based on the context it is used
func (m *StoragePoolShowSpares) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateChecksumStyle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDiskClass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDiskType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStoragePoolShowSparesInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSyncmirrorPool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolShowSpares) contextValidateChecksumStyle(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "checksum_style", "body", m.ChecksumStyle); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolShowSpares) contextValidateDiskClass(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "disk_class", "body", m.DiskClass); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolShowSpares) contextValidateDiskType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "disk_type", "body", m.DiskType); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolShowSpares) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolShowSpares) contextValidateStoragePoolShowSparesInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nodes", "body", []*NodeReference(m.StoragePoolShowSparesInlineNodes)); err != nil {
		return err
	}

	for i := 0; i < len(m.StoragePoolShowSparesInlineNodes); i++ {

		if m.StoragePoolShowSparesInlineNodes[i] != nil {
			if err := m.StoragePoolShowSparesInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StoragePoolShowSpares) contextValidateSyncmirrorPool(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "syncmirror_pool", "body", m.SyncmirrorPool); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolShowSpares) contextValidateUsable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "usable", "body", m.Usable); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolShowSpares) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolShowSpares) UnmarshalBinary(b []byte) error {
	var res StoragePoolShowSpares
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
