// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StoragePoolSpareAllocationUnit storage pool spare allocation unit
//
// swagger:model storage_pool_spare_allocation_unit
type StoragePoolSpareAllocationUnit struct {

	// The usable capacity of this set of allocation units.
	// Read Only: true
	AvailableSize *int64 `json:"available_size,omitempty"`

	// The number of spare allocation units on this node.
	Count *int64 `json:"count,omitempty"`

	// node
	Node *StoragePoolSpareAllocationUnitInlineNode `json:"node,omitempty"`

	// Size of each allocation unit.
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// The RAID SyncMirror Pool to which this allocation unit is assigned.
	// Read Only: true
	// Enum: ["pool0","pool1"]
	SyncmirrorPool *string `json:"syncmirror_pool,omitempty"`
}

// Validate validates this storage pool spare allocation unit
func (m *StoragePoolSpareAllocationUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSyncmirrorPool(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolSpareAllocationUnit) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var storagePoolSpareAllocationUnitTypeSyncmirrorPoolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pool0","pool1"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolSpareAllocationUnitTypeSyncmirrorPoolPropEnum = append(storagePoolSpareAllocationUnitTypeSyncmirrorPoolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_pool_spare_allocation_unit
	// StoragePoolSpareAllocationUnit
	// syncmirror_pool
	// SyncmirrorPool
	// pool0
	// END DEBUGGING
	// StoragePoolSpareAllocationUnitSyncmirrorPoolPool0 captures enum value "pool0"
	StoragePoolSpareAllocationUnitSyncmirrorPoolPool0 string = "pool0"

	// BEGIN DEBUGGING
	// storage_pool_spare_allocation_unit
	// StoragePoolSpareAllocationUnit
	// syncmirror_pool
	// SyncmirrorPool
	// pool1
	// END DEBUGGING
	// StoragePoolSpareAllocationUnitSyncmirrorPoolPool1 captures enum value "pool1"
	StoragePoolSpareAllocationUnitSyncmirrorPoolPool1 string = "pool1"
)

// prop value enum
func (m *StoragePoolSpareAllocationUnit) validateSyncmirrorPoolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storagePoolSpareAllocationUnitTypeSyncmirrorPoolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StoragePoolSpareAllocationUnit) validateSyncmirrorPool(formats strfmt.Registry) error {
	if swag.IsZero(m.SyncmirrorPool) { // not required
		return nil
	}

	// value enum
	if err := m.validateSyncmirrorPoolEnum("syncmirror_pool", "body", *m.SyncmirrorPool); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage pool spare allocation unit based on the context it is used
func (m *StoragePoolSpareAllocationUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailableSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSyncmirrorPool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolSpareAllocationUnit) contextValidateAvailableSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "available_size", "body", m.AvailableSize); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolSpareAllocationUnit) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *StoragePoolSpareAllocationUnit) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *StoragePoolSpareAllocationUnit) contextValidateSyncmirrorPool(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "syncmirror_pool", "body", m.SyncmirrorPool); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolSpareAllocationUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolSpareAllocationUnit) UnmarshalBinary(b []byte) error {
	var res StoragePoolSpareAllocationUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StoragePoolSpareAllocationUnitInlineNode Specifies what node can use this set of allocation units.
//
// swagger:model storage_pool_spare_allocation_unit_inline_node
type StoragePoolSpareAllocationUnitInlineNode struct {

	// links
	Links *StoragePoolSpareAllocationUnitInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage pool spare allocation unit inline node
func (m *StoragePoolSpareAllocationUnitInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolSpareAllocationUnitInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool spare allocation unit inline node based on the context it is used
func (m *StoragePoolSpareAllocationUnitInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolSpareAllocationUnitInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolSpareAllocationUnitInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolSpareAllocationUnitInlineNode) UnmarshalBinary(b []byte) error {
	var res StoragePoolSpareAllocationUnitInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StoragePoolSpareAllocationUnitInlineNodeInlineLinks storage pool spare allocation unit inline node inline links
//
// swagger:model storage_pool_spare_allocation_unit_inline_node_inline__links
type StoragePoolSpareAllocationUnitInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage pool spare allocation unit inline node inline links
func (m *StoragePoolSpareAllocationUnitInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolSpareAllocationUnitInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage pool spare allocation unit inline node inline links based on the context it is used
func (m *StoragePoolSpareAllocationUnitInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePoolSpareAllocationUnitInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePoolSpareAllocationUnitInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePoolSpareAllocationUnitInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res StoragePoolSpareAllocationUnitInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
