// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageSwitch The Storage switch object describes the storage switch properties, features and cabling.
//
// swagger:model storage_switch
type StorageSwitch struct {

	// director class
	DirectorClass *bool `json:"director_class,omitempty"`

	// Domain ID
	DomainID *int64 `json:"domain_id,omitempty"`

	// Storage switch fabric name
	FabricName *string `json:"fabric_name,omitempty"`

	// Storage switch firmware version
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// IP Address
	IPAddress *string `json:"ip_address,omitempty"`

	// Indicates whether the storage switch is directly connected to the reporting cluster.
	Local *bool `json:"local,omitempty"`

	// Storage switch model.
	Model *string `json:"model,omitempty"`

	// Indicates whether monitoring is enabled for the storage switch.
	MonitoringEnabled *bool `json:"monitoring_enabled,omitempty"`

	// Storage switch name
	Name *string `json:"name,omitempty"`

	// Storage switch role in fabric.
	// Enum: ["unknown","primary","subordinate"]
	Role *string `json:"role,omitempty"`

	// Storage switch state
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// storage switch inline connections
	StorageSwitchInlineConnections []*StorageSwitchInlineConnectionsInlineArrayItem `json:"connections,omitempty"`

	// storage switch inline errors
	StorageSwitchInlineErrors []*StorageSwitchInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// storage switch inline fans
	StorageSwitchInlineFans []*StorageSwitchInlineFansInlineArrayItem `json:"fans,omitempty"`

	// Indicates the blades that are being monitored for a director-class switch.
	StorageSwitchInlineMonitoredBlades []*int64 `json:"monitored_blades,omitempty"`

	// storage switch inline paths
	StorageSwitchInlinePaths []*StorageSwitchInlinePathsInlineArrayItem `json:"paths,omitempty"`

	// storage switch inline ports
	StorageSwitchInlinePorts []*StorageSwitchInlinePortsInlineArrayItem `json:"ports,omitempty"`

	// storage switch inline power supply units
	StorageSwitchInlinePowerSupplyUnits []*StorageSwitchInlinePowerSupplyUnitsInlineArrayItem `json:"power_supply_units,omitempty"`

	// storage switch inline temperature sensors
	StorageSwitchInlineTemperatureSensors []*StorageSwitchInlineTemperatureSensorsInlineArrayItem `json:"temperature_sensors,omitempty"`

	// storage switch inline vsans
	StorageSwitchInlineVsans []*StorageSwitchInlineVsansInlineArrayItem `json:"vsans,omitempty"`

	// storage switch inline zones
	StorageSwitchInlineZones []*StorageSwitchInlineZonesInlineArrayItem `json:"zones,omitempty"`

	// Storage switch symbolic name
	SymbolicName *string `json:"symbolic_name,omitempty"`

	// Storage switch vendor
	// Enum: ["unknown","brocade","cisco"]
	Vendor *string `json:"vendor,omitempty"`

	// Storage switch world wide name
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage switch
func (m *StorageSwitch) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlineConnections(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlineFans(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlinePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlinePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlinePowerSupplyUnits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlineTemperatureSensors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlineVsans(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageSwitchInlineZones(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVendor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","primary","subordinate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchTypeRolePropEnum = append(storageSwitchTypeRolePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch
	// StorageSwitch
	// role
	// Role
	// unknown
	// END DEBUGGING
	// StorageSwitchRoleUnknown captures enum value "unknown"
	StorageSwitchRoleUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch
	// StorageSwitch
	// role
	// Role
	// primary
	// END DEBUGGING
	// StorageSwitchRolePrimary captures enum value "primary"
	StorageSwitchRolePrimary string = "primary"

	// BEGIN DEBUGGING
	// storage_switch
	// StorageSwitch
	// role
	// Role
	// subordinate
	// END DEBUGGING
	// StorageSwitchRoleSubordinate captures enum value "subordinate"
	StorageSwitchRoleSubordinate string = "subordinate"
)

// prop value enum
func (m *StorageSwitch) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitch) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", *m.Role); err != nil {
		return err
	}

	return nil
}

var storageSwitchTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchTypeStatePropEnum = append(storageSwitchTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch
	// StorageSwitch
	// state
	// State
	// ok
	// END DEBUGGING
	// StorageSwitchStateOk captures enum value "ok"
	StorageSwitchStateOk string = "ok"

	// BEGIN DEBUGGING
	// storage_switch
	// StorageSwitch
	// state
	// State
	// error
	// END DEBUGGING
	// StorageSwitchStateError captures enum value "error"
	StorageSwitchStateError string = "error"
)

// prop value enum
func (m *StorageSwitch) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitch) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlineConnections(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlineConnections) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlineConnections); i++ {
		if swag.IsZero(m.StorageSwitchInlineConnections[i]) { // not required
			continue
		}

		if m.StorageSwitchInlineConnections[i] != nil {
			if err := m.StorageSwitchInlineConnections[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connections" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlineErrors); i++ {
		if swag.IsZero(m.StorageSwitchInlineErrors[i]) { // not required
			continue
		}

		if m.StorageSwitchInlineErrors[i] != nil {
			if err := m.StorageSwitchInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlineFans(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlineFans) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlineFans); i++ {
		if swag.IsZero(m.StorageSwitchInlineFans[i]) { // not required
			continue
		}

		if m.StorageSwitchInlineFans[i] != nil {
			if err := m.StorageSwitchInlineFans[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlinePaths(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlinePaths) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlinePaths); i++ {
		if swag.IsZero(m.StorageSwitchInlinePaths[i]) { // not required
			continue
		}

		if m.StorageSwitchInlinePaths[i] != nil {
			if err := m.StorageSwitchInlinePaths[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlinePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlinePorts) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlinePorts); i++ {
		if swag.IsZero(m.StorageSwitchInlinePorts[i]) { // not required
			continue
		}

		if m.StorageSwitchInlinePorts[i] != nil {
			if err := m.StorageSwitchInlinePorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlinePowerSupplyUnits(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlinePowerSupplyUnits) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlinePowerSupplyUnits); i++ {
		if swag.IsZero(m.StorageSwitchInlinePowerSupplyUnits[i]) { // not required
			continue
		}

		if m.StorageSwitchInlinePowerSupplyUnits[i] != nil {
			if err := m.StorageSwitchInlinePowerSupplyUnits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("power_supply_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlineTemperatureSensors(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlineTemperatureSensors) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlineTemperatureSensors); i++ {
		if swag.IsZero(m.StorageSwitchInlineTemperatureSensors[i]) { // not required
			continue
		}

		if m.StorageSwitchInlineTemperatureSensors[i] != nil {
			if err := m.StorageSwitchInlineTemperatureSensors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("temperature_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlineVsans(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlineVsans) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlineVsans); i++ {
		if swag.IsZero(m.StorageSwitchInlineVsans[i]) { // not required
			continue
		}

		if m.StorageSwitchInlineVsans[i] != nil {
			if err := m.StorageSwitchInlineVsans[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("vsans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) validateStorageSwitchInlineZones(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageSwitchInlineZones) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageSwitchInlineZones); i++ {
		if swag.IsZero(m.StorageSwitchInlineZones[i]) { // not required
			continue
		}

		if m.StorageSwitchInlineZones[i] != nil {
			if err := m.StorageSwitchInlineZones[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var storageSwitchTypeVendorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","brocade","cisco"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchTypeVendorPropEnum = append(storageSwitchTypeVendorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch
	// StorageSwitch
	// vendor
	// Vendor
	// unknown
	// END DEBUGGING
	// StorageSwitchVendorUnknown captures enum value "unknown"
	StorageSwitchVendorUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch
	// StorageSwitch
	// vendor
	// Vendor
	// brocade
	// END DEBUGGING
	// StorageSwitchVendorBrocade captures enum value "brocade"
	StorageSwitchVendorBrocade string = "brocade"

	// BEGIN DEBUGGING
	// storage_switch
	// StorageSwitch
	// vendor
	// Vendor
	// cisco
	// END DEBUGGING
	// StorageSwitchVendorCisco captures enum value "cisco"
	StorageSwitchVendorCisco string = "cisco"
)

// prop value enum
func (m *StorageSwitch) validateVendorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchTypeVendorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitch) validateVendor(formats strfmt.Registry) error {
	if swag.IsZero(m.Vendor) { // not required
		return nil
	}

	// value enum
	if err := m.validateVendorEnum("vendor", "body", *m.Vendor); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage switch based on the context it is used
func (m *StorageSwitch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageSwitchInlineConnections(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageSwitchInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageSwitchInlineFans(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageSwitchInlinePaths(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageSwitchInlinePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageSwitchInlinePowerSupplyUnits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageSwitchInlineTemperatureSensors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageSwitchInlineVsans(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageSwitchInlineZones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlineConnections(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlineConnections); i++ {

		if m.StorageSwitchInlineConnections[i] != nil {
			if err := m.StorageSwitchInlineConnections[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connections" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlineErrors); i++ {

		if m.StorageSwitchInlineErrors[i] != nil {
			if err := m.StorageSwitchInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlineFans(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlineFans); i++ {

		if m.StorageSwitchInlineFans[i] != nil {
			if err := m.StorageSwitchInlineFans[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlinePaths(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlinePaths); i++ {

		if m.StorageSwitchInlinePaths[i] != nil {
			if err := m.StorageSwitchInlinePaths[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlinePorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlinePorts); i++ {

		if m.StorageSwitchInlinePorts[i] != nil {
			if err := m.StorageSwitchInlinePorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlinePowerSupplyUnits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlinePowerSupplyUnits); i++ {

		if m.StorageSwitchInlinePowerSupplyUnits[i] != nil {
			if err := m.StorageSwitchInlinePowerSupplyUnits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("power_supply_units" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlineTemperatureSensors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlineTemperatureSensors); i++ {

		if m.StorageSwitchInlineTemperatureSensors[i] != nil {
			if err := m.StorageSwitchInlineTemperatureSensors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("temperature_sensors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlineVsans(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlineVsans); i++ {

		if m.StorageSwitchInlineVsans[i] != nil {
			if err := m.StorageSwitchInlineVsans[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("vsans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageSwitch) contextValidateStorageSwitchInlineZones(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageSwitchInlineZones); i++ {

		if m.StorageSwitchInlineZones[i] != nil {
			if err := m.StorageSwitchInlineZones[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitch) UnmarshalBinary(b []byte) error {
	var res StorageSwitch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineConnectionsInlineArrayItem storage switch inline connections inline array item
//
// swagger:model storage_switch_inline_connections_inline_array_item
type StorageSwitchInlineConnectionsInlineArrayItem struct {

	// peer port
	PeerPort *StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort `json:"peer_port,omitempty"`

	// source port
	SourcePort *StorageSwitchInlineConnectionsInlineArrayItemInlineSourcePort `json:"source_port,omitempty"`
}

// Validate validates this storage switch inline connections inline array item
func (m *StorageSwitchInlineConnectionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeerPort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSourcePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlineConnectionsInlineArrayItem) validatePeerPort(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerPort) { // not required
		return nil
	}

	if m.PeerPort != nil {
		if err := m.PeerPort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_port")
			}
			return err
		}
	}

	return nil
}

func (m *StorageSwitchInlineConnectionsInlineArrayItem) validateSourcePort(formats strfmt.Registry) error {
	if swag.IsZero(m.SourcePort) { // not required
		return nil
	}

	if m.SourcePort != nil {
		if err := m.SourcePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source_port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage switch inline connections inline array item based on the context it is used
func (m *StorageSwitchInlineConnectionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePeerPort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSourcePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlineConnectionsInlineArrayItem) contextValidatePeerPort(ctx context.Context, formats strfmt.Registry) error {

	if m.PeerPort != nil {
		if err := m.PeerPort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_port")
			}
			return err
		}
	}

	return nil
}

func (m *StorageSwitchInlineConnectionsInlineArrayItem) contextValidateSourcePort(ctx context.Context, formats strfmt.Registry) error {

	if m.SourcePort != nil {
		if err := m.SourcePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source_port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineConnectionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineConnectionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineConnectionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort storage switch inline connections inline array item inline peer port
//
// swagger:model storage_switch_inline_connections_inline_array_item_inline_peer_port
type StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort struct {

	// Storage switch peer port host and name
	Connection *string `json:"connection,omitempty"`

	// Storage switch peer type
	// Enum: ["unknown","bridge","switch","fcp_adapter","fcvi_adapter"]
	Type *string `json:"type,omitempty"`

	// Storage switch peer unique ID
	UniqueID *string `json:"unique_id,omitempty"`

	// Storage switch peer port world wide name
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage switch inline connections inline array item inline peer port
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","bridge","switch","fcp_adapter","fcvi_adapter"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeTypePropEnum = append(storageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_connections_inline_array_item_inline_peer_port
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort
	// type
	// Type
	// unknown
	// END DEBUGGING
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeUnknown captures enum value "unknown"
	StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch_inline_connections_inline_array_item_inline_peer_port
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort
	// type
	// Type
	// bridge
	// END DEBUGGING
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeBridge captures enum value "bridge"
	StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeBridge string = "bridge"

	// BEGIN DEBUGGING
	// storage_switch_inline_connections_inline_array_item_inline_peer_port
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort
	// type
	// Type
	// switch
	// END DEBUGGING
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeSwitch captures enum value "switch"
	StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeSwitch string = "switch"

	// BEGIN DEBUGGING
	// storage_switch_inline_connections_inline_array_item_inline_peer_port
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort
	// type
	// Type
	// fcp_adapter
	// END DEBUGGING
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeFcpAdapter captures enum value "fcp_adapter"
	StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeFcpAdapter string = "fcp_adapter"

	// BEGIN DEBUGGING
	// storage_switch_inline_connections_inline_array_item_inline_peer_port
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort
	// type
	// Type
	// fcvi_adapter
	// END DEBUGGING
	// StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeFcviAdapter captures enum value "fcvi_adapter"
	StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeFcviAdapter string = "fcvi_adapter"
)

// prop value enum
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlineConnectionsInlineArrayItemInlinePeerPortTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("peer_port"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage switch inline connections inline array item inline peer port based on context it is used
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineConnectionsInlineArrayItemInlinePeerPort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineConnectionsInlineArrayItemInlineSourcePort storage switch inline connections inline array item inline source port
//
// swagger:model storage_switch_inline_connections_inline_array_item_inline_source_port
type StorageSwitchInlineConnectionsInlineArrayItemInlineSourcePort struct {

	// Storage switch port operating mode
	Mode *string `json:"mode,omitempty"`

	// Storage switch port name
	Name *string `json:"name,omitempty"`

	// Storage switch peer port world wide name
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage switch inline connections inline array item inline source port
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlineSourcePort) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage switch inline connections inline array item inline source port based on context it is used
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlineSourcePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlineSourcePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineConnectionsInlineArrayItemInlineSourcePort) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineConnectionsInlineArrayItemInlineSourcePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineErrorsInlineArrayItem storage switch inline errors inline array item
//
// swagger:model storage_switch_inline_errors_inline_array_item
type StorageSwitchInlineErrorsInlineArrayItem struct {

	// component
	Component *StorageSwitchInlineErrorsInlineArrayItemInlineComponent `json:"component,omitempty"`

	// reason
	Reason *Error `json:"reason,omitempty"`

	// Error component severity
	// Enum: ["unknown","notice","warning","error"]
	Severity *string `json:"severity,omitempty"`

	// Error component type
	// Enum: ["switch_unreachable","temp_above_warning_level","temp_above_critical_level","temp_below_warning_level","temp_below_critical_level","temp_sensor_status_failed","fan_status_non_operational","power_supply_status_failed","power_above_warning_level","power_above_critical_level","power_below_warning_level","power_below_critical_level","sfp_rx_power_above_warning_level","sfp_rx_power_above_critical_level","sfp_tx_power_above_warning_level","sfp_tx_power_above_critical_level","sfp_rx_power_below_warning_level","sfp_rx_power_below_critical_level","sfp_tx_power_below_warning_level","sfp_tx_power_below_critical_level","sfp_status_failed","vsan_invalid_frame_delivery_configuration","temp_sensor_status_unavailable","fan_status_unavailable","power_supply_inline_power_failed","power_supply_status_unavailable","unknown","power_supply_off_env_other","power_supply_off_admin","power_supply_off_denied","power_supply_off_env_power","power_supply_off_env_temp","power_supply_off_env_fan","power_supply_on_but_fan_fail","power_supply_off_cooling","power_supply_off_connector_rating","e_ports_down","snmpv3_user_not_configured","incomplete_snmp_data_refresh"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this storage switch inline errors inline array item
func (m *StorageSwitchInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComponent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlineErrorsInlineArrayItem) validateComponent(formats strfmt.Registry) error {
	if swag.IsZero(m.Component) { // not required
		return nil
	}

	if m.Component != nil {
		if err := m.Component.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("component")
			}
			return err
		}
	}

	return nil
}

func (m *StorageSwitchInlineErrorsInlineArrayItem) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	if m.Reason != nil {
		if err := m.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

var storageSwitchInlineErrorsInlineArrayItemTypeSeverityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","notice","warning","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlineErrorsInlineArrayItemTypeSeverityPropEnum = append(storageSwitchInlineErrorsInlineArrayItemTypeSeverityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// severity
	// Severity
	// unknown
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemSeverityUnknown captures enum value "unknown"
	StorageSwitchInlineErrorsInlineArrayItemSeverityUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// severity
	// Severity
	// notice
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemSeverityNotice captures enum value "notice"
	StorageSwitchInlineErrorsInlineArrayItemSeverityNotice string = "notice"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// severity
	// Severity
	// warning
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemSeverityWarning captures enum value "warning"
	StorageSwitchInlineErrorsInlineArrayItemSeverityWarning string = "warning"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// severity
	// Severity
	// error
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemSeverityError captures enum value "error"
	StorageSwitchInlineErrorsInlineArrayItemSeverityError string = "error"
)

// prop value enum
func (m *StorageSwitchInlineErrorsInlineArrayItem) validateSeverityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlineErrorsInlineArrayItemTypeSeverityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlineErrorsInlineArrayItem) validateSeverity(formats strfmt.Registry) error {
	if swag.IsZero(m.Severity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSeverityEnum("severity", "body", *m.Severity); err != nil {
		return err
	}

	return nil
}

var storageSwitchInlineErrorsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["switch_unreachable","temp_above_warning_level","temp_above_critical_level","temp_below_warning_level","temp_below_critical_level","temp_sensor_status_failed","fan_status_non_operational","power_supply_status_failed","power_above_warning_level","power_above_critical_level","power_below_warning_level","power_below_critical_level","sfp_rx_power_above_warning_level","sfp_rx_power_above_critical_level","sfp_tx_power_above_warning_level","sfp_tx_power_above_critical_level","sfp_rx_power_below_warning_level","sfp_rx_power_below_critical_level","sfp_tx_power_below_warning_level","sfp_tx_power_below_critical_level","sfp_status_failed","vsan_invalid_frame_delivery_configuration","temp_sensor_status_unavailable","fan_status_unavailable","power_supply_inline_power_failed","power_supply_status_unavailable","unknown","power_supply_off_env_other","power_supply_off_admin","power_supply_off_denied","power_supply_off_env_power","power_supply_off_env_temp","power_supply_off_env_fan","power_supply_on_but_fan_fail","power_supply_off_cooling","power_supply_off_connector_rating","e_ports_down","snmpv3_user_not_configured","incomplete_snmp_data_refresh"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlineErrorsInlineArrayItemTypeTypePropEnum = append(storageSwitchInlineErrorsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// switch_unreachable
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSwitchUnreachable captures enum value "switch_unreachable"
	StorageSwitchInlineErrorsInlineArrayItemTypeSwitchUnreachable string = "switch_unreachable"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_above_warning_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeTempAboveWarningLevel captures enum value "temp_above_warning_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeTempAboveWarningLevel string = "temp_above_warning_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_above_critical_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeTempAboveCriticalLevel captures enum value "temp_above_critical_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeTempAboveCriticalLevel string = "temp_above_critical_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_below_warning_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeTempBelowWarningLevel captures enum value "temp_below_warning_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeTempBelowWarningLevel string = "temp_below_warning_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_below_critical_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeTempBelowCriticalLevel captures enum value "temp_below_critical_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeTempBelowCriticalLevel string = "temp_below_critical_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_sensor_status_failed
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeTempSensorStatusFailed captures enum value "temp_sensor_status_failed"
	StorageSwitchInlineErrorsInlineArrayItemTypeTempSensorStatusFailed string = "temp_sensor_status_failed"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// fan_status_non_operational
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeFanStatusNonOperational captures enum value "fan_status_non_operational"
	StorageSwitchInlineErrorsInlineArrayItemTypeFanStatusNonOperational string = "fan_status_non_operational"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_status_failed
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyStatusFailed captures enum value "power_supply_status_failed"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyStatusFailed string = "power_supply_status_failed"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_above_warning_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerAboveWarningLevel captures enum value "power_above_warning_level"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerAboveWarningLevel string = "power_above_warning_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_above_critical_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerAboveCriticalLevel captures enum value "power_above_critical_level"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerAboveCriticalLevel string = "power_above_critical_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_below_warning_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerBelowWarningLevel captures enum value "power_below_warning_level"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerBelowWarningLevel string = "power_below_warning_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_below_critical_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerBelowCriticalLevel captures enum value "power_below_critical_level"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerBelowCriticalLevel string = "power_below_critical_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_rx_power_above_warning_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpRxPowerAboveWarningLevel captures enum value "sfp_rx_power_above_warning_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpRxPowerAboveWarningLevel string = "sfp_rx_power_above_warning_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_rx_power_above_critical_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpRxPowerAboveCriticalLevel captures enum value "sfp_rx_power_above_critical_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpRxPowerAboveCriticalLevel string = "sfp_rx_power_above_critical_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_tx_power_above_warning_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpTxPowerAboveWarningLevel captures enum value "sfp_tx_power_above_warning_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpTxPowerAboveWarningLevel string = "sfp_tx_power_above_warning_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_tx_power_above_critical_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpTxPowerAboveCriticalLevel captures enum value "sfp_tx_power_above_critical_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpTxPowerAboveCriticalLevel string = "sfp_tx_power_above_critical_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_rx_power_below_warning_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpRxPowerBelowWarningLevel captures enum value "sfp_rx_power_below_warning_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpRxPowerBelowWarningLevel string = "sfp_rx_power_below_warning_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_rx_power_below_critical_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpRxPowerBelowCriticalLevel captures enum value "sfp_rx_power_below_critical_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpRxPowerBelowCriticalLevel string = "sfp_rx_power_below_critical_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_tx_power_below_warning_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpTxPowerBelowWarningLevel captures enum value "sfp_tx_power_below_warning_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpTxPowerBelowWarningLevel string = "sfp_tx_power_below_warning_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_tx_power_below_critical_level
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpTxPowerBelowCriticalLevel captures enum value "sfp_tx_power_below_critical_level"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpTxPowerBelowCriticalLevel string = "sfp_tx_power_below_critical_level"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// sfp_status_failed
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSfpStatusFailed captures enum value "sfp_status_failed"
	StorageSwitchInlineErrorsInlineArrayItemTypeSfpStatusFailed string = "sfp_status_failed"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// vsan_invalid_frame_delivery_configuration
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeVsanInvalidFrameDeliveryConfiguration captures enum value "vsan_invalid_frame_delivery_configuration"
	StorageSwitchInlineErrorsInlineArrayItemTypeVsanInvalidFrameDeliveryConfiguration string = "vsan_invalid_frame_delivery_configuration"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// temp_sensor_status_unavailable
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeTempSensorStatusUnavailable captures enum value "temp_sensor_status_unavailable"
	StorageSwitchInlineErrorsInlineArrayItemTypeTempSensorStatusUnavailable string = "temp_sensor_status_unavailable"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// fan_status_unavailable
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeFanStatusUnavailable captures enum value "fan_status_unavailable"
	StorageSwitchInlineErrorsInlineArrayItemTypeFanStatusUnavailable string = "fan_status_unavailable"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_inline_power_failed
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyInlinePowerFailed captures enum value "power_supply_inline_power_failed"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyInlinePowerFailed string = "power_supply_inline_power_failed"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_status_unavailable
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyStatusUnavailable captures enum value "power_supply_status_unavailable"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyStatusUnavailable string = "power_supply_status_unavailable"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// unknown
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeUnknown captures enum value "unknown"
	StorageSwitchInlineErrorsInlineArrayItemTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_off_env_other
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffEnvOther captures enum value "power_supply_off_env_other"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffEnvOther string = "power_supply_off_env_other"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_off_admin
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffAdmin captures enum value "power_supply_off_admin"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffAdmin string = "power_supply_off_admin"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_off_denied
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffDenied captures enum value "power_supply_off_denied"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffDenied string = "power_supply_off_denied"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_off_env_power
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffEnvPower captures enum value "power_supply_off_env_power"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffEnvPower string = "power_supply_off_env_power"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_off_env_temp
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffEnvTemp captures enum value "power_supply_off_env_temp"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffEnvTemp string = "power_supply_off_env_temp"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_off_env_fan
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffEnvFan captures enum value "power_supply_off_env_fan"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffEnvFan string = "power_supply_off_env_fan"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_on_but_fan_fail
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOnButFanFail captures enum value "power_supply_on_but_fan_fail"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOnButFanFail string = "power_supply_on_but_fan_fail"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_off_cooling
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffCooling captures enum value "power_supply_off_cooling"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffCooling string = "power_supply_off_cooling"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// power_supply_off_connector_rating
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffConnectorRating captures enum value "power_supply_off_connector_rating"
	StorageSwitchInlineErrorsInlineArrayItemTypePowerSupplyOffConnectorRating string = "power_supply_off_connector_rating"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// e_ports_down
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeEPortsDown captures enum value "e_ports_down"
	StorageSwitchInlineErrorsInlineArrayItemTypeEPortsDown string = "e_ports_down"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// snmpv3_user_not_configured
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeSnmpv3UserNotConfigured captures enum value "snmpv3_user_not_configured"
	StorageSwitchInlineErrorsInlineArrayItemTypeSnmpv3UserNotConfigured string = "snmpv3_user_not_configured"

	// BEGIN DEBUGGING
	// storage_switch_inline_errors_inline_array_item
	// StorageSwitchInlineErrorsInlineArrayItem
	// type
	// Type
	// incomplete_snmp_data_refresh
	// END DEBUGGING
	// StorageSwitchInlineErrorsInlineArrayItemTypeIncompleteSnmpDataRefresh captures enum value "incomplete_snmp_data_refresh"
	StorageSwitchInlineErrorsInlineArrayItemTypeIncompleteSnmpDataRefresh string = "incomplete_snmp_data_refresh"
)

// prop value enum
func (m *StorageSwitchInlineErrorsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlineErrorsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlineErrorsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage switch inline errors inline array item based on the context it is used
func (m *StorageSwitchInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComponent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlineErrorsInlineArrayItem) contextValidateComponent(ctx context.Context, formats strfmt.Registry) error {

	if m.Component != nil {
		if err := m.Component.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("component")
			}
			return err
		}
	}

	return nil
}

func (m *StorageSwitchInlineErrorsInlineArrayItem) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if m.Reason != nil {
		if err := m.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineErrorsInlineArrayItemInlineComponent storage switch inline errors inline array item inline component
//
// swagger:model storage_switch_inline_errors_inline_array_item_inline_component
type StorageSwitchInlineErrorsInlineArrayItemInlineComponent struct {

	// Error component ID
	ID *int64 `json:"id,omitempty"`

	// Error component name
	Name *string `json:"name,omitempty"`
}

// Validate validates this storage switch inline errors inline array item inline component
func (m *StorageSwitchInlineErrorsInlineArrayItemInlineComponent) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage switch inline errors inline array item inline component based on context it is used
func (m *StorageSwitchInlineErrorsInlineArrayItemInlineComponent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineErrorsInlineArrayItemInlineComponent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineErrorsInlineArrayItemInlineComponent) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineErrorsInlineArrayItemInlineComponent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineFansInlineArrayItem storage switch inline fans inline array item
//
// swagger:model storage_switch_inline_fans_inline_array_item
type StorageSwitchInlineFansInlineArrayItem struct {

	// Storage switch fan name
	Name *string `json:"name,omitempty"`

	// Storage switch fan speed
	Speed *int64 `json:"speed,omitempty"`

	// Storage switch fan state
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage switch inline fans inline array item
func (m *StorageSwitchInlineFansInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchInlineFansInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlineFansInlineArrayItemTypeStatePropEnum = append(storageSwitchInlineFansInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_fans_inline_array_item
	// StorageSwitchInlineFansInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// StorageSwitchInlineFansInlineArrayItemStateOk captures enum value "ok"
	StorageSwitchInlineFansInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// storage_switch_inline_fans_inline_array_item
	// StorageSwitchInlineFansInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// StorageSwitchInlineFansInlineArrayItemStateError captures enum value "error"
	StorageSwitchInlineFansInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *StorageSwitchInlineFansInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlineFansInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlineFansInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage switch inline fans inline array item based on context it is used
func (m *StorageSwitchInlineFansInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineFansInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineFansInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineFansInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlinePathsInlineArrayItem storage switch inline paths inline array item
//
// swagger:model storage_switch_inline_paths_inline_array_item
type StorageSwitchInlinePathsInlineArrayItem struct {

	// adapter
	Adapter *StorageSwitchInlinePathsInlineArrayItemInlineAdapter `json:"adapter,omitempty"`

	// node
	Node *StorageSwitchInlinePathsInlineArrayItemInlineNode `json:"node,omitempty"`

	// port
	Port *StorageSwitchInlinePathsInlineArrayItemInlinePort `json:"port,omitempty"`
}

// Validate validates this storage switch inline paths inline array item
func (m *StorageSwitchInlinePathsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAdapter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItem) validateAdapter(formats strfmt.Registry) error {
	if swag.IsZero(m.Adapter) { // not required
		return nil
	}

	if m.Adapter != nil {
		if err := m.Adapter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("adapter")
			}
			return err
		}
	}

	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItem) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if m.Port != nil {
		if err := m.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage switch inline paths inline array item based on the context it is used
func (m *StorageSwitchInlinePathsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAdapter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItem) contextValidateAdapter(ctx context.Context, formats strfmt.Registry) error {

	if m.Adapter != nil {
		if err := m.Adapter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("adapter")
			}
			return err
		}
	}

	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItem) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if m.Port != nil {
		if err := m.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlinePathsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlinePathsInlineArrayItemInlineAdapter storage switch inline paths inline array item inline adapter
//
// swagger:model storage_switch_inline_paths_inline_array_item_inline_adapter
type StorageSwitchInlinePathsInlineArrayItemInlineAdapter struct {

	// Node adapter name
	Name *string `json:"name,omitempty"`

	// Node adapter type
	// Enum: ["unknown","fcp_initiator","fc_vi","fcp_target"]
	Type *string `json:"type,omitempty"`

	// Node adapter world wide name
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage switch inline paths inline array item inline adapter
func (m *StorageSwitchInlinePathsInlineArrayItemInlineAdapter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchInlinePathsInlineArrayItemInlineAdapterTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","fcp_initiator","fc_vi","fcp_target"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlinePathsInlineArrayItemInlineAdapterTypeTypePropEnum = append(storageSwitchInlinePathsInlineArrayItemInlineAdapterTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_paths_inline_array_item_inline_adapter
	// StorageSwitchInlinePathsInlineArrayItemInlineAdapter
	// type
	// Type
	// unknown
	// END DEBUGGING
	// StorageSwitchInlinePathsInlineArrayItemInlineAdapterTypeUnknown captures enum value "unknown"
	StorageSwitchInlinePathsInlineArrayItemInlineAdapterTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch_inline_paths_inline_array_item_inline_adapter
	// StorageSwitchInlinePathsInlineArrayItemInlineAdapter
	// type
	// Type
	// fcp_initiator
	// END DEBUGGING
	// StorageSwitchInlinePathsInlineArrayItemInlineAdapterTypeFcpInitiator captures enum value "fcp_initiator"
	StorageSwitchInlinePathsInlineArrayItemInlineAdapterTypeFcpInitiator string = "fcp_initiator"

	// BEGIN DEBUGGING
	// storage_switch_inline_paths_inline_array_item_inline_adapter
	// StorageSwitchInlinePathsInlineArrayItemInlineAdapter
	// type
	// Type
	// fc_vi
	// END DEBUGGING
	// StorageSwitchInlinePathsInlineArrayItemInlineAdapterTypeFcVi captures enum value "fc_vi"
	StorageSwitchInlinePathsInlineArrayItemInlineAdapterTypeFcVi string = "fc_vi"

	// BEGIN DEBUGGING
	// storage_switch_inline_paths_inline_array_item_inline_adapter
	// StorageSwitchInlinePathsInlineArrayItemInlineAdapter
	// type
	// Type
	// fcp_target
	// END DEBUGGING
	// StorageSwitchInlinePathsInlineArrayItemInlineAdapterTypeFcpTarget captures enum value "fcp_target"
	StorageSwitchInlinePathsInlineArrayItemInlineAdapterTypeFcpTarget string = "fcp_target"
)

// prop value enum
func (m *StorageSwitchInlinePathsInlineArrayItemInlineAdapter) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlinePathsInlineArrayItemInlineAdapterTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItemInlineAdapter) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("adapter"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage switch inline paths inline array item inline adapter based on context it is used
func (m *StorageSwitchInlinePathsInlineArrayItemInlineAdapter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItemInlineAdapter) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItemInlineAdapter) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlinePathsInlineArrayItemInlineAdapter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlinePathsInlineArrayItemInlineNode storage switch inline paths inline array item inline node
//
// swagger:model storage_switch_inline_paths_inline_array_item_inline_node
type StorageSwitchInlinePathsInlineArrayItemInlineNode struct {

	// links
	Links *StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage switch inline paths inline array item inline node
func (m *StorageSwitchInlinePathsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage switch inline paths inline array item inline node based on the context it is used
func (m *StorageSwitchInlinePathsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlinePathsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks storage switch inline paths inline array item inline node inline links
//
// swagger:model storage_switch_inline_paths_inline_array_item_inline_node_inline__links
type StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage switch inline paths inline array item inline node inline links
func (m *StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage switch inline paths inline array item inline node inline links based on the context it is used
func (m *StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlinePathsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlinePathsInlineArrayItemInlinePort storage switch inline paths inline array item inline port
//
// swagger:model storage_switch_inline_paths_inline_array_item_inline_port
type StorageSwitchInlinePathsInlineArrayItemInlinePort struct {

	// Storage switch port name
	Name *string `json:"name,omitempty"`

	// Storage switch port speed, in Gbps
	Speed *int64 `json:"speed,omitempty"`
}

// Validate validates this storage switch inline paths inline array item inline port
func (m *StorageSwitchInlinePathsInlineArrayItemInlinePort) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage switch inline paths inline array item inline port based on context it is used
func (m *StorageSwitchInlinePathsInlineArrayItemInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItemInlinePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlinePathsInlineArrayItemInlinePort) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlinePathsInlineArrayItemInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlinePortsInlineArrayItem storage switch inline ports inline array item
//
// swagger:model storage_switch_inline_ports_inline_array_item
type StorageSwitchInlinePortsInlineArrayItem struct {

	// Indicates whether the storage switch port is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Storage switch port mode
	// Enum: ["unknown","auto","f_port","fl_port","e_port","te_port","u_port","g_port","other","ex_port","d_port","sim_port","ve_port","ae_port","af_port"]
	Mode *string `json:"mode,omitempty"`

	// Storage switch port name
	Name *string `json:"name,omitempty"`

	// sfp
	Sfp *StorageSwitchInlinePortsInlineArrayItemInlineSfp `json:"sfp,omitempty"`

	// Storage switch port speed, in Gbps
	Speed *int64 `json:"speed,omitempty"`

	// Storage switch port state
	// Enum: ["error","online","offline"]
	State *string `json:"state,omitempty"`

	// Storage switch port world wide name
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage switch inline ports inline array item
func (m *StorageSwitchInlinePortsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSfp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchInlinePortsInlineArrayItemTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","auto","f_port","fl_port","e_port","te_port","u_port","g_port","other","ex_port","d_port","sim_port","ve_port","ae_port","af_port"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlinePortsInlineArrayItemTypeModePropEnum = append(storageSwitchInlinePortsInlineArrayItemTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// unknown
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeUnknown captures enum value "unknown"
	StorageSwitchInlinePortsInlineArrayItemModeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// auto
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeAuto captures enum value "auto"
	StorageSwitchInlinePortsInlineArrayItemModeAuto string = "auto"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// f_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeFPort captures enum value "f_port"
	StorageSwitchInlinePortsInlineArrayItemModeFPort string = "f_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// fl_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeFlPort captures enum value "fl_port"
	StorageSwitchInlinePortsInlineArrayItemModeFlPort string = "fl_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// e_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeEPort captures enum value "e_port"
	StorageSwitchInlinePortsInlineArrayItemModeEPort string = "e_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// te_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeTePort captures enum value "te_port"
	StorageSwitchInlinePortsInlineArrayItemModeTePort string = "te_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// u_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeUPort captures enum value "u_port"
	StorageSwitchInlinePortsInlineArrayItemModeUPort string = "u_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// g_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeGPort captures enum value "g_port"
	StorageSwitchInlinePortsInlineArrayItemModeGPort string = "g_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// other
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeOther captures enum value "other"
	StorageSwitchInlinePortsInlineArrayItemModeOther string = "other"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// ex_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeExPort captures enum value "ex_port"
	StorageSwitchInlinePortsInlineArrayItemModeExPort string = "ex_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// d_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeDPort captures enum value "d_port"
	StorageSwitchInlinePortsInlineArrayItemModeDPort string = "d_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// sim_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeSimPort captures enum value "sim_port"
	StorageSwitchInlinePortsInlineArrayItemModeSimPort string = "sim_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// ve_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeVePort captures enum value "ve_port"
	StorageSwitchInlinePortsInlineArrayItemModeVePort string = "ve_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// ae_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeAePort captures enum value "ae_port"
	StorageSwitchInlinePortsInlineArrayItemModeAePort string = "ae_port"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// mode
	// Mode
	// af_port
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemModeAfPort captures enum value "af_port"
	StorageSwitchInlinePortsInlineArrayItemModeAfPort string = "af_port"
)

// prop value enum
func (m *StorageSwitchInlinePortsInlineArrayItem) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlinePortsInlineArrayItemTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlinePortsInlineArrayItem) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *StorageSwitchInlinePortsInlineArrayItem) validateSfp(formats strfmt.Registry) error {
	if swag.IsZero(m.Sfp) { // not required
		return nil
	}

	if m.Sfp != nil {
		if err := m.Sfp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sfp")
			}
			return err
		}
	}

	return nil
}

var storageSwitchInlinePortsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["error","online","offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlinePortsInlineArrayItemTypeStatePropEnum = append(storageSwitchInlinePortsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemStateError captures enum value "error"
	StorageSwitchInlinePortsInlineArrayItemStateError string = "error"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// state
	// State
	// online
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemStateOnline captures enum value "online"
	StorageSwitchInlinePortsInlineArrayItemStateOnline string = "online"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item
	// StorageSwitchInlinePortsInlineArrayItem
	// state
	// State
	// offline
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemStateOffline captures enum value "offline"
	StorageSwitchInlinePortsInlineArrayItemStateOffline string = "offline"
)

// prop value enum
func (m *StorageSwitchInlinePortsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlinePortsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlinePortsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage switch inline ports inline array item based on the context it is used
func (m *StorageSwitchInlinePortsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSfp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlinePortsInlineArrayItem) contextValidateSfp(ctx context.Context, formats strfmt.Registry) error {

	if m.Sfp != nil {
		if err := m.Sfp.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sfp")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlinePortsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlinePortsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlinePortsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlinePortsInlineArrayItemInlineSfp storage switch inline ports inline array item inline sfp
//
// swagger:model storage_switch_inline_ports_inline_array_item_inline_sfp
type StorageSwitchInlinePortsInlineArrayItemInlineSfp struct {

	// Storage switch port SFP serial number
	SerialNumber *string `json:"serial_number,omitempty"`

	// Storage switch port SFP transmitter type
	// Enum: ["unknown","long_wave_laser","short_wave_laser","long_wave_laser_cost_reduced","electrical","ten_gig_base_sr","ten_gig_base_lr","ten_gig_base_er","ten_gig_base_lx4","ten_gig_base_sw","ten_gig_base_lw","ten_gig_base_ew"]
	TransmitterType *string `json:"transmitter_type,omitempty"`

	// Storage switch port SFP type
	// Enum: ["unknown","other","gbic","embedded","glm","gbic_with_serial_id","gbic_without_serial_id","sfp_with_serial_id","sfp_without_serial_id","xfp","x2_short","x2_medium","x2_tall","xpak_short","xpak_medium","xpak_tall","xenpak","sfp_dw_dm","qsfp","x2_dw_dm","gbic_not_installed","small_form_factor"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this storage switch inline ports inline array item inline sfp
func (m *StorageSwitchInlinePortsInlineArrayItemInlineSfp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTransmitterType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchInlinePortsInlineArrayItemInlineSfpTypeTransmitterTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","long_wave_laser","short_wave_laser","long_wave_laser_cost_reduced","electrical","ten_gig_base_sr","ten_gig_base_lr","ten_gig_base_er","ten_gig_base_lx4","ten_gig_base_sw","ten_gig_base_lw","ten_gig_base_ew"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlinePortsInlineArrayItemInlineSfpTypeTransmitterTypePropEnum = append(storageSwitchInlinePortsInlineArrayItemInlineSfpTypeTransmitterTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// unknown
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeUnknown captures enum value "unknown"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// long_wave_laser
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeLongWaveLaser captures enum value "long_wave_laser"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeLongWaveLaser string = "long_wave_laser"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// short_wave_laser
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeShortWaveLaser captures enum value "short_wave_laser"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeShortWaveLaser string = "short_wave_laser"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// long_wave_laser_cost_reduced
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeLongWaveLaserCostReduced captures enum value "long_wave_laser_cost_reduced"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeLongWaveLaserCostReduced string = "long_wave_laser_cost_reduced"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// electrical
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeElectrical captures enum value "electrical"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeElectrical string = "electrical"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// ten_gig_base_sr
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseSr captures enum value "ten_gig_base_sr"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseSr string = "ten_gig_base_sr"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// ten_gig_base_lr
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseLr captures enum value "ten_gig_base_lr"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseLr string = "ten_gig_base_lr"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// ten_gig_base_er
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseEr captures enum value "ten_gig_base_er"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseEr string = "ten_gig_base_er"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// ten_gig_base_lx4
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseLx4 captures enum value "ten_gig_base_lx4"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseLx4 string = "ten_gig_base_lx4"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// ten_gig_base_sw
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseSw captures enum value "ten_gig_base_sw"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseSw string = "ten_gig_base_sw"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// ten_gig_base_lw
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseLw captures enum value "ten_gig_base_lw"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseLw string = "ten_gig_base_lw"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// transmitter_type
	// TransmitterType
	// ten_gig_base_ew
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseEw captures enum value "ten_gig_base_ew"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTransmitterTypeTenGigBaseEw string = "ten_gig_base_ew"
)

// prop value enum
func (m *StorageSwitchInlinePortsInlineArrayItemInlineSfp) validateTransmitterTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlinePortsInlineArrayItemInlineSfpTypeTransmitterTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlinePortsInlineArrayItemInlineSfp) validateTransmitterType(formats strfmt.Registry) error {
	if swag.IsZero(m.TransmitterType) { // not required
		return nil
	}

	// value enum
	if err := m.validateTransmitterTypeEnum("sfp"+"."+"transmitter_type", "body", *m.TransmitterType); err != nil {
		return err
	}

	return nil
}

var storageSwitchInlinePortsInlineArrayItemInlineSfpTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","other","gbic","embedded","glm","gbic_with_serial_id","gbic_without_serial_id","sfp_with_serial_id","sfp_without_serial_id","xfp","x2_short","x2_medium","x2_tall","xpak_short","xpak_medium","xpak_tall","xenpak","sfp_dw_dm","qsfp","x2_dw_dm","gbic_not_installed","small_form_factor"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlinePortsInlineArrayItemInlineSfpTypeTypePropEnum = append(storageSwitchInlinePortsInlineArrayItemInlineSfpTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// unknown
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeUnknown captures enum value "unknown"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// other
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeOther captures enum value "other"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeOther string = "other"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// gbic
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGbic captures enum value "gbic"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGbic string = "gbic"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// embedded
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeEmbedded captures enum value "embedded"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeEmbedded string = "embedded"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// glm
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGlm captures enum value "glm"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGlm string = "glm"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// gbic_with_serial_id
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGbicWithSerialID captures enum value "gbic_with_serial_id"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGbicWithSerialID string = "gbic_with_serial_id"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// gbic_without_serial_id
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGbicWithoutSerialID captures enum value "gbic_without_serial_id"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGbicWithoutSerialID string = "gbic_without_serial_id"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// sfp_with_serial_id
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeSfpWithSerialID captures enum value "sfp_with_serial_id"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeSfpWithSerialID string = "sfp_with_serial_id"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// sfp_without_serial_id
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeSfpWithoutSerialID captures enum value "sfp_without_serial_id"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeSfpWithoutSerialID string = "sfp_without_serial_id"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// xfp
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXfp captures enum value "xfp"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXfp string = "xfp"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// x2_short
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeX2Short captures enum value "x2_short"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeX2Short string = "x2_short"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// x2_medium
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeX2Medium captures enum value "x2_medium"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeX2Medium string = "x2_medium"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// x2_tall
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeX2Tall captures enum value "x2_tall"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeX2Tall string = "x2_tall"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// xpak_short
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXpakShort captures enum value "xpak_short"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXpakShort string = "xpak_short"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// xpak_medium
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXpakMedium captures enum value "xpak_medium"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXpakMedium string = "xpak_medium"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// xpak_tall
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXpakTall captures enum value "xpak_tall"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXpakTall string = "xpak_tall"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// xenpak
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXenpak captures enum value "xenpak"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeXenpak string = "xenpak"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// sfp_dw_dm
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeSfpDwDm captures enum value "sfp_dw_dm"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeSfpDwDm string = "sfp_dw_dm"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// qsfp
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeQsfp captures enum value "qsfp"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeQsfp string = "qsfp"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// x2_dw_dm
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeX2DwDm captures enum value "x2_dw_dm"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeX2DwDm string = "x2_dw_dm"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// gbic_not_installed
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGbicNotInstalled captures enum value "gbic_not_installed"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeGbicNotInstalled string = "gbic_not_installed"

	// BEGIN DEBUGGING
	// storage_switch_inline_ports_inline_array_item_inline_sfp
	// StorageSwitchInlinePortsInlineArrayItemInlineSfp
	// type
	// Type
	// small_form_factor
	// END DEBUGGING
	// StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeSmallFormFactor captures enum value "small_form_factor"
	StorageSwitchInlinePortsInlineArrayItemInlineSfpTypeSmallFormFactor string = "small_form_factor"
)

// prop value enum
func (m *StorageSwitchInlinePortsInlineArrayItemInlineSfp) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlinePortsInlineArrayItemInlineSfpTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlinePortsInlineArrayItemInlineSfp) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("sfp"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage switch inline ports inline array item inline sfp based on context it is used
func (m *StorageSwitchInlinePortsInlineArrayItemInlineSfp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlinePortsInlineArrayItemInlineSfp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlinePortsInlineArrayItemInlineSfp) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlinePortsInlineArrayItemInlineSfp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlinePowerSupplyUnitsInlineArrayItem storage switch inline power supply units inline array item
//
// swagger:model storage_switch_inline_power_supply_units_inline_array_item
type StorageSwitchInlinePowerSupplyUnitsInlineArrayItem struct {

	// Power supply unit name
	Name *string `json:"name,omitempty"`

	// Power supply unit state
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage switch inline power supply units inline array item
func (m *StorageSwitchInlinePowerSupplyUnitsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchInlinePowerSupplyUnitsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlinePowerSupplyUnitsInlineArrayItemTypeStatePropEnum = append(storageSwitchInlinePowerSupplyUnitsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_power_supply_units_inline_array_item
	// StorageSwitchInlinePowerSupplyUnitsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// StorageSwitchInlinePowerSupplyUnitsInlineArrayItemStateOk captures enum value "ok"
	StorageSwitchInlinePowerSupplyUnitsInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// storage_switch_inline_power_supply_units_inline_array_item
	// StorageSwitchInlinePowerSupplyUnitsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// StorageSwitchInlinePowerSupplyUnitsInlineArrayItemStateError captures enum value "error"
	StorageSwitchInlinePowerSupplyUnitsInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *StorageSwitchInlinePowerSupplyUnitsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlinePowerSupplyUnitsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlinePowerSupplyUnitsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage switch inline power supply units inline array item based on context it is used
func (m *StorageSwitchInlinePowerSupplyUnitsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlinePowerSupplyUnitsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlinePowerSupplyUnitsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlinePowerSupplyUnitsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineTemperatureSensorsInlineArrayItem storage switch inline temperature sensors inline array item
//
// swagger:model storage_switch_inline_temperature_sensors_inline_array_item
type StorageSwitchInlineTemperatureSensorsInlineArrayItem struct {

	// Temperature sensor name
	Name *string `json:"name,omitempty"`

	// Temperature sensor reading, in degrees celsius.
	Reading *int64 `json:"reading,omitempty"`

	// Temperature sensor state
	// Enum: ["error","ok"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage switch inline temperature sensors inline array item
func (m *StorageSwitchInlineTemperatureSensorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["error","ok"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum = append(storageSwitchInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_temperature_sensors_inline_array_item
	// StorageSwitchInlineTemperatureSensorsInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// StorageSwitchInlineTemperatureSensorsInlineArrayItemStateError captures enum value "error"
	StorageSwitchInlineTemperatureSensorsInlineArrayItemStateError string = "error"

	// BEGIN DEBUGGING
	// storage_switch_inline_temperature_sensors_inline_array_item
	// StorageSwitchInlineTemperatureSensorsInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// StorageSwitchInlineTemperatureSensorsInlineArrayItemStateOk captures enum value "ok"
	StorageSwitchInlineTemperatureSensorsInlineArrayItemStateOk string = "ok"
)

// prop value enum
func (m *StorageSwitchInlineTemperatureSensorsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlineTemperatureSensorsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlineTemperatureSensorsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage switch inline temperature sensors inline array item based on context it is used
func (m *StorageSwitchInlineTemperatureSensorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineTemperatureSensorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineTemperatureSensorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineTemperatureSensorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineVsansInlineArrayItem storage switch inline vsans inline array item
//
// swagger:model storage_switch_inline_vsans_inline_array_item
type StorageSwitchInlineVsansInlineArrayItem struct {

	// Storage switch VSAN ID
	ID *int64 `json:"id,omitempty"`

	// Indicates whether in-order delivery is set for a zone.
	Iod *bool `json:"iod,omitempty"`

	// Storage switch VSAN load balancing type
	LoadBalancingTypes *string `json:"load_balancing_types,omitempty"`

	// Storage switch VSAN name
	Name *string `json:"name,omitempty"`

	// Storage switch VSAN Port state
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage switch inline vsans inline array item
func (m *StorageSwitchInlineVsansInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageSwitchInlineVsansInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageSwitchInlineVsansInlineArrayItemTypeStatePropEnum = append(storageSwitchInlineVsansInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_switch_inline_vsans_inline_array_item
	// StorageSwitchInlineVsansInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// StorageSwitchInlineVsansInlineArrayItemStateOk captures enum value "ok"
	StorageSwitchInlineVsansInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// storage_switch_inline_vsans_inline_array_item
	// StorageSwitchInlineVsansInlineArrayItem
	// state
	// State
	// error
	// END DEBUGGING
	// StorageSwitchInlineVsansInlineArrayItemStateError captures enum value "error"
	StorageSwitchInlineVsansInlineArrayItemStateError string = "error"
)

// prop value enum
func (m *StorageSwitchInlineVsansInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageSwitchInlineVsansInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageSwitchInlineVsansInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this storage switch inline vsans inline array item based on context it is used
func (m *StorageSwitchInlineVsansInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineVsansInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineVsansInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineVsansInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineZonesInlineArrayItem storage switch inline zones inline array item
//
// swagger:model storage_switch_inline_zones_inline_array_item
type StorageSwitchInlineZonesInlineArrayItem struct {

	// Storage switch zone ID
	ID *int64 `json:"id,omitempty"`

	// Storage switch zone name
	Name *string `json:"name,omitempty"`

	// port
	Port *StorageSwitchInlineZonesInlineArrayItemInlinePort `json:"port,omitempty"`

	// Storage switch zone world wide name
	Wwn *string `json:"wwn,omitempty"`
}

// Validate validates this storage switch inline zones inline array item
func (m *StorageSwitchInlineZonesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlineZonesInlineArrayItem) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if m.Port != nil {
		if err := m.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage switch inline zones inline array item based on the context it is used
func (m *StorageSwitchInlineZonesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageSwitchInlineZonesInlineArrayItem) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if m.Port != nil {
		if err := m.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineZonesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineZonesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineZonesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageSwitchInlineZonesInlineArrayItemInlinePort storage switch inline zones inline array item inline port
//
// swagger:model storage_switch_inline_zones_inline_array_item_inline_port
type StorageSwitchInlineZonesInlineArrayItemInlinePort struct {

	// Storage switch zone port ID
	ID *string `json:"id,omitempty"`

	// Storage switch zone port
	Name *string `json:"name,omitempty"`
}

// Validate validates this storage switch inline zones inline array item inline port
func (m *StorageSwitchInlineZonesInlineArrayItemInlinePort) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage switch inline zones inline array item inline port based on context it is used
func (m *StorageSwitchInlineZonesInlineArrayItemInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageSwitchInlineZonesInlineArrayItemInlinePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageSwitchInlineZonesInlineArrayItemInlinePort) UnmarshalBinary(b []byte) error {
	var res StorageSwitchInlineZonesInlineArrayItemInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
