// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageUnit A storage unit representing either a LUN or a namespace.
//
// swagger:model storage_unit
type StorageUnit struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// anti ransomware
	AntiRansomware *StorageUnitInlineAntiRansomware `json:"anti_ransomware,omitempty"`

	// The class of LUN.
	//
	// Read Only: true
	// Enum: ["regular","vvol"]
	Class *string `json:"class,omitempty"`

	// clone
	Clone *StorageUnitClone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator.
	//
	// Read Only: true
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *StorageUnitInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// The time the storage unit was created.
	//
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the storage unit. Storage units can be disabled to prevent access to the storage unit. Certain error conditions also cause the storage unit to become disabled. If the storage unit is disabled, check the `status.state` property to determine if the storage unit is administratively disabled (_offline_) or has become disabled as a result of an error.<br/>
	// A storage unit in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_ using /api/storage/luns or /api/storage/namespaces. Upon creation, a storage unit is enabled by default.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// encryption
	Encryption *StorageUnitEncryption `json:"encryption,omitempty"`

	// location
	Location *StorageUnitInlineLocation `json:"location,omitempty"`

	// metric
	Metric *StorageUnitInlineMetric `json:"metric,omitempty"`

	// movement
	Movement *StorageUnitInlineMovement `json:"movement,omitempty"`

	// The name of the storage unit. The name must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 203 characters or less in length. Valid in POST.
	//
	// Example: lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the storage unit.<br/>
	//
	// Read Only: true
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// qos policy
	QosPolicy *StorageUnitInlineQosPolicy `json:"qos_policy,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// The LUN serial number encoded in hexadecimal format. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	SerialNumberHex *string `json:"serial_number_hex,omitempty"`

	// space
	Space *StorageUnitInlineSpace `json:"space,omitempty"`

	// statistics
	Statistics *StorageUnitInlineStatistics `json:"statistics,omitempty"`

	// status
	Status *StorageUnitInlineStatus `json:"status,omitempty"`

	// Maps between the storage unit and host groups.
	//
	// Read Only: true
	StorageUnitInlineMaps []*StorageUnitInlineMapsInlineArrayItem `json:"maps,omitempty"`

	// svm
	Svm *StorageUnitInlineSvm `json:"svm,omitempty"`

	// The type of storage unit.
	//
	// Read Only: true
	// Enum: ["lun","namespace"]
	Type *string `json:"type,omitempty"`

	// The unique identifier of the storage unit. The UUID is generated by ONTAP when the storage unit is created. The storage unit UUID is the same as the LUN or namespace UUID.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit
func (m *StorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAntiRansomware(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnitInlineMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnit) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateAntiRansomware(formats strfmt.Registry) error {
	if swag.IsZero(m.AntiRansomware) { // not required
		return nil
	}

	if m.AntiRansomware != nil {
		if err := m.AntiRansomware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware")
			}
			return err
		}
	}

	return nil
}

var storageUnitTypeClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","vvol"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitTypeClassPropEnum = append(storageUnitTypeClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// class
	// Class
	// regular
	// END DEBUGGING
	// StorageUnitClassRegular captures enum value "regular"
	StorageUnitClassRegular string = "regular"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// class
	// Class
	// vvol
	// END DEBUGGING
	// StorageUnitClassVvol captures enum value "vvol"
	StorageUnitClassVvol string = "vvol"
)

// prop value enum
func (m *StorageUnit) validateClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitTypeClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnit) validateClass(formats strfmt.Registry) error {
	if swag.IsZero(m.Class) { // not required
		return nil
	}

	// value enum
	if err := m.validateClassEnum("class", "body", *m.Class); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(m.Clone) { // not required
		return nil
	}

	if m.Clone != nil {
		if err := m.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroup) { // not required
		return nil
	}

	if m.ConsistencyGroup != nil {
		if err := m.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	if m.Encryption != nil {
		if err := m.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(m.Movement) { // not required
		return nil
	}

	if m.Movement != nil {
		if err := m.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

var storageUnitTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitTypeOsTypePropEnum = append(storageUnitTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// StorageUnitOsTypeAix captures enum value "aix"
	StorageUnitOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// StorageUnitOsTypeHpux captures enum value "hpux"
	StorageUnitOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// StorageUnitOsTypeHyperv captures enum value "hyper_v"
	StorageUnitOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// StorageUnitOsTypeLinux captures enum value "linux"
	StorageUnitOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// StorageUnitOsTypeNetware captures enum value "netware"
	StorageUnitOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// StorageUnitOsTypeOpenvms captures enum value "openvms"
	StorageUnitOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// StorageUnitOsTypeSolaris captures enum value "solaris"
	StorageUnitOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// StorageUnitOsTypeSolarisEfi captures enum value "solaris_efi"
	StorageUnitOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// StorageUnitOsTypeVmware captures enum value "vmware"
	StorageUnitOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// StorageUnitOsTypeWindows captures enum value "windows"
	StorageUnitOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// StorageUnitOsTypeWindows2008 captures enum value "windows_2008"
	StorageUnitOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// StorageUnitOsTypeWindowsGpt captures enum value "windows_gpt"
	StorageUnitOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// StorageUnitOsTypeXen captures enum value "xen"
	StorageUnitOsTypeXen string = "xen"
)

// prop value enum
func (m *StorageUnit) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnit) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) validateStorageUnitInlineMaps(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnitInlineMaps) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageUnitInlineMaps); i++ {
		if swag.IsZero(m.StorageUnitInlineMaps[i]) { // not required
			continue
		}

		if m.StorageUnitInlineMaps[i] != nil {
			if err := m.StorageUnitInlineMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageUnit) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var storageUnitTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["lun","namespace"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitTypeTypePropEnum = append(storageUnitTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// type
	// Type
	// lun
	// END DEBUGGING
	// StorageUnitTypeLun captures enum value "lun"
	StorageUnitTypeLun string = "lun"

	// BEGIN DEBUGGING
	// storage_unit
	// StorageUnit
	// type
	// Type
	// namespace
	// END DEBUGGING
	// StorageUnitTypeNamespace captures enum value "namespace"
	StorageUnitTypeNamespace string = "namespace"
)

// prop value enum
func (m *StorageUnit) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnit) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit based on the context it is used
func (m *StorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAntiRansomware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateComment(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOsType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumberHex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnitInlineMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnit) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateAntiRansomware(ctx context.Context, formats strfmt.Registry) error {

	if m.AntiRansomware != nil {
		if err := m.AntiRansomware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateClass(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "class", "body", m.Class); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if m.Clone != nil {
		if err := m.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateComment(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "comment", "body", m.Comment); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ConsistencyGroup != nil {
		if err := m.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.Encryption != nil {
		if err := m.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if m.Movement != nil {
		if err := m.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateOsType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "os_type", "body", m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) contextValidateSerialNumberHex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number_hex", "body", m.SerialNumberHex); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateStorageUnitInlineMaps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "maps", "body", []*StorageUnitInlineMapsInlineArrayItem(m.StorageUnitInlineMaps)); err != nil {
		return err
	}

	for i := 0; i < len(m.StorageUnitInlineMaps); i++ {

		if m.StorageUnitInlineMaps[i] != nil {
			if err := m.StorageUnitInlineMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *StorageUnit) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnit) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnit) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnit) UnmarshalBinary(b []byte) error {
	var res StorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineAntiRansomware The anti-ransomware properties of the storage unit.
//
// swagger:model storage_unit_inline_anti_ransomware
type StorageUnitInlineAntiRansomware struct {

	// The probability of a ransomware attack.<br/>
	// Possible values:
	// * `none` No suspected ransomware activity.
	// * `moderate` Suspected ransomware activity.
	//
	// Read Only: true
	// Enum: ["none","moderate"]
	AttackProbability *string `json:"attack_probability,omitempty"`

	// attack reports
	// Read Only: true
	AttackReports []*StorageUnitAntiRansomwareAttackReportsItems0 `json:"attack_reports,omitempty"`

	// The anti-ransomware state for the storage unit.<br/>
	// Possible values:
	// * `disabled` Anti-ransomware monitoring is disabled for the storage unit. Valid in PATCH and GET.
	// * `disable_in_progress` Anti-ransomware monitoring is being disabled and a clean-up operation is in progress. Valid in GET.
	// * `enabled` Anti-ransomware monitoring is active for the storage unit. Valid in PATCH and GET.
	// * `paused` Anti-ransomware monitoring is paused for the storage unit from its earlier enabled state. Valid in PATCH and GET.
	//
	// Enum: ["disabled","disable_in_progress","enabled","paused"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage unit inline anti ransomware
func (m *StorageUnitInlineAntiRansomware) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAttackProbability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttackReports(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageUnitInlineAntiRansomwareTypeAttackProbabilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","moderate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineAntiRansomwareTypeAttackProbabilityPropEnum = append(storageUnitInlineAntiRansomwareTypeAttackProbabilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// none
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareAttackProbabilityNone captures enum value "none"
	StorageUnitInlineAntiRansomwareAttackProbabilityNone string = "none"

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// moderate
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareAttackProbabilityModerate captures enum value "moderate"
	StorageUnitInlineAntiRansomwareAttackProbabilityModerate string = "moderate"
)

// prop value enum
func (m *StorageUnitInlineAntiRansomware) validateAttackProbabilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineAntiRansomwareTypeAttackProbabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitInlineAntiRansomware) validateAttackProbability(formats strfmt.Registry) error {
	if swag.IsZero(m.AttackProbability) { // not required
		return nil
	}

	// value enum
	if err := m.validateAttackProbabilityEnum("anti_ransomware"+"."+"attack_probability", "body", *m.AttackProbability); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineAntiRansomware) validateAttackReports(formats strfmt.Registry) error {
	if swag.IsZero(m.AttackReports) { // not required
		return nil
	}

	for i := 0; i < len(m.AttackReports); i++ {
		if swag.IsZero(m.AttackReports[i]) { // not required
			continue
		}

		if m.AttackReports[i] != nil {
			if err := m.AttackReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("anti_ransomware" + "." + "attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var storageUnitInlineAntiRansomwareTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","disable_in_progress","enabled","paused"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineAntiRansomwareTypeStatePropEnum = append(storageUnitInlineAntiRansomwareTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// state
	// State
	// disabled
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareStateDisabled captures enum value "disabled"
	StorageUnitInlineAntiRansomwareStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// state
	// State
	// disable_in_progress
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareStateDisableInProgress captures enum value "disable_in_progress"
	StorageUnitInlineAntiRansomwareStateDisableInProgress string = "disable_in_progress"

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// state
	// State
	// enabled
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareStateEnabled captures enum value "enabled"
	StorageUnitInlineAntiRansomwareStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// state
	// State
	// paused
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareStatePaused captures enum value "paused"
	StorageUnitInlineAntiRansomwareStatePaused string = "paused"
)

// prop value enum
func (m *StorageUnitInlineAntiRansomware) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineAntiRansomwareTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitInlineAntiRansomware) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("anti_ransomware"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline anti ransomware based on the context it is used
func (m *StorageUnitInlineAntiRansomware) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAttackProbability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttackReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineAntiRansomware) contextValidateAttackProbability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"attack_probability", "body", m.AttackProbability); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineAntiRansomware) contextValidateAttackReports(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware"+"."+"attack_reports", "body", []*StorageUnitAntiRansomwareAttackReportsItems0(m.AttackReports)); err != nil {
		return err
	}

	for i := 0; i < len(m.AttackReports); i++ {

		if m.AttackReports[i] != nil {
			if err := m.AttackReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("anti_ransomware" + "." + "attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineAntiRansomware) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineAntiRansomware) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineAntiRansomware
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareAttackReportsItems0 storage unit anti ransomware attack reports items0
//
// swagger:model StorageUnitAntiRansomwareAttackReportsItems0
type StorageUnitAntiRansomwareAttackReportsItems0 struct {

	// Timestamp at which ransomware attack is observed.
	//
	// Example: 2021-06-01 20:36:41+05:30
	// Read Only: true
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this storage unit anti ransomware attack reports items0
func (m *StorageUnitAntiRansomwareAttackReportsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareAttackReportsItems0) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("time", "body", "date-time", m.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware attack reports items0 based on the context it is used
func (m *StorageUnitAntiRansomwareAttackReportsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareAttackReportsItems0) contextValidateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time", "body", m.Time); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareAttackReportsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareAttackReportsItems0) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareAttackReportsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineConsistencyGroup The storage unit's consistency group. This property is populated for storage units that are members of a consistency group.
//
// swagger:model storage_unit_inline_consistency_group
type StorageUnitInlineConsistencyGroup struct {

	// links
	Links *StorageUnitInlineConsistencyGroupInlineLinks `json:"_links,omitempty"`

	// The name of the consistency group.
	//
	// Example: cg1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	//
	// Example: 4abc2317-4332-9d37-93a0-20bd29c22df0
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline consistency group
func (m *StorageUnitInlineConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline consistency group based on the context it is used
func (m *StorageUnitInlineConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineConsistencyGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "consistency_group"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineConsistencyGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "consistency_group"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineConsistencyGroupInlineLinks storage unit inline consistency group inline links
//
// swagger:model storage_unit_inline_consistency_group_inline__links
type StorageUnitInlineConsistencyGroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline consistency group inline links
func (m *StorageUnitInlineConsistencyGroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineConsistencyGroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline consistency group inline links based on the context it is used
func (m *StorageUnitInlineConsistencyGroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineConsistencyGroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineConsistencyGroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineConsistencyGroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineConsistencyGroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineLocation storage unit inline location
//
// swagger:model storage_unit_inline_location
type StorageUnitInlineLocation struct {

	// node
	Node *StorageUnitInlineLocationInlineNode `json:"node,omitempty"`

	// storage availability zone
	StorageAvailabilityZone *StorageUnitInlineLocationInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`

	// volume
	Volume *StorageUnitInlineLocationInlineVolume `json:"volume,omitempty"`
}

// Validate validates this storage unit inline location
func (m *StorageUnitInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineLocation) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZone) { // not required
		return nil
	}

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineLocation) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location based on the context it is used
func (m *StorageUnitInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineLocation) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineLocation) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineLocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineLocation) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineLocationInlineNode The cluster node that hosts the storage unit.
//
// swagger:model storage_unit_inline_location_inline_node
type StorageUnitInlineLocationInlineNode struct {

	// links
	Links *StorageUnitInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline location inline node
func (m *StorageUnitInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline node based on the context it is used
func (m *StorageUnitInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineLocationInlineNodeInlineLinks storage unit inline location inline node inline links
//
// swagger:model storage_unit_inline_location_inline_node_inline__links
type StorageUnitInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline location inline node inline links
func (m *StorageUnitInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline node inline links based on the context it is used
func (m *StorageUnitInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineLocationInlineStorageAvailabilityZone The storage availability zone that contains the storage unit.<br/>
// Available in PATCH to initiate a storage unit move operation.
//
// swagger:model storage_unit_inline_location_inline_storage_availability_zone
type StorageUnitInlineLocationInlineStorageAvailabilityZone struct {

	// links
	Links *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline location inline storage availability zone
func (m *StorageUnitInlineLocationInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline storage availability zone based on the context it is used
func (m *StorageUnitInlineLocationInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks storage unit inline location inline storage availability zone inline links
//
// swagger:model storage_unit_inline_location_inline_storage_availability_zone_inline__links
type StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline location inline storage availability zone inline links
func (m *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline storage availability zone inline links based on the context it is used
func (m *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineLocationInlineVolume The legacy ONTAP volume associated with the storage unit.<br/>
// Functionality not supported on the storage-unit endpoint is
// available from the legacy /api/storage/volumes endpoint.
//
// swagger:model storage_unit_inline_location_inline_volume
type StorageUnitInlineLocationInlineVolume struct {

	// links
	Links *StorageUnitInlineLocationInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline location inline volume
func (m *StorageUnitInlineLocationInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline volume based on the context it is used
func (m *StorageUnitInlineLocationInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineVolume) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineLocationInlineVolumeInlineLinks storage unit inline location inline volume inline links
//
// swagger:model storage_unit_inline_location_inline_volume_inline__links
type StorageUnitInlineLocationInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline location inline volume inline links
func (m *StorageUnitInlineLocationInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline volume inline links based on the context it is used
func (m *StorageUnitInlineLocationInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineLocationInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineLocationInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItem A map between the storage unit and a host group. A map is either a LUN map or an NVMe subsystem map.
//
// swagger:model storage_unit_inline_maps_inline_array_item
type StorageUnitInlineMapsInlineArrayItem struct {

	// host group
	HostGroup *StorageUnitInlineMapsInlineArrayItemInlineHostGroup `json:"host_group,omitempty"`

	// lun map
	LunMap *StorageUnitInlineMapsInlineArrayItemInlineLunMap `json:"lun_map,omitempty"`

	// subsystem map
	SubsystemMap *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap `json:"subsystem_map,omitempty"`
}

// Validate validates this storage unit inline maps inline array item
func (m *StorageUnitInlineMapsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHostGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunMap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItem) validateHostGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.HostGroup) { // not required
		return nil
	}

	if m.HostGroup != nil {
		if err := m.HostGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host_group")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItem) validateLunMap(formats strfmt.Registry) error {
	if swag.IsZero(m.LunMap) { // not required
		return nil
	}

	if m.LunMap != nil {
		if err := m.LunMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItem) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(m.SubsystemMap) { // not required
		return nil
	}

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHostGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLunMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItem) contextValidateHostGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.HostGroup != nil {
		if err := m.HostGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host_group")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItem) contextValidateLunMap(ctx context.Context, formats strfmt.Registry) error {

	if m.LunMap != nil {
		if err := m.LunMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItem) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineHostGroup A host group mapped to the storage unit. A host group is either an initiator group or an NVMe subsystem.
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_host_group
type StorageUnitInlineMapsInlineArrayItemInlineHostGroup struct {

	// The name of the mapped host group.
	//
	// Example: host_group1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the mapped host group.
	//
	// Example: 19f8d194-4d24-b1df-f3f7-e7aa68bc53db
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline host group
func (m *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline host group based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_group"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_group"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineHostGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineLunMap A map between the storage unit and an initiator group.
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_lun_map
type StorageUnitInlineMapsInlineArrayItemInlineLunMap struct {

	// links
	Links *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks `json:"_links,omitempty"`

	// igroup
	Igroup *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through Fibre Channel Protocol or iSCSI.
	//
	// Example: 1
	// Read Only: true
	// Maximum: 4095
	// Minimum: 0
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline lun map
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogicalUnitNumber(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) validateLogicalUnitNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.LogicalUnitNumber) { // not required
		return nil
	}

	if err := validate.MinimumInt("lun_map"+"."+"logical_unit_number", "body", *m.LogicalUnitNumber, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("lun_map"+"."+"logical_unit_number", "body", *m.LogicalUnitNumber, 4095, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline lun map based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUnitNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) contextValidateLogicalUnitNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun_map"+"."+"logical_unit_number", "body", m.LogicalUnitNumber); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMap) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineLunMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup storage unit inline maps inline array item inline lun map inline igroup
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_lun_map_inline_igroup
type StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup struct {

	// links
	Links *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline lun map inline igroup
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("lun_map"+"."+"igroup"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("lun_map"+"."+"igroup"+"."+"name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline lun map inline igroup based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks storage unit inline maps inline array item inline lun map inline igroup inline links
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_lun_map_inline_igroup_inline__links
type StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline lun map inline igroup inline links
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline lun map inline igroup inline links based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks storage unit inline maps inline array item inline lun map inline links
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_lun_map_inline__links
type StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline lun map inline links
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline lun map inline links based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap A map between the storage unit and an NVMe subsystem.
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_subsystem_map
type StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap struct {

	// links
	Links *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks `json:"_links,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// subsystem
	Subsystem *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline subsystem map
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline subsystem map based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", m.Nsid); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks storage unit inline maps inline array item inline subsystem map inline links
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_subsystem_map_inline__links
type StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline subsystem map inline links
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline subsystem map inline links based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem An NVMe subsystem maintains configuration state and NVMe namespace access control for a set of NVMe-connected hosts.
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_subsystem_map_inline_subsystem
type StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem struct {

	// links
	Links *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline subsystem map inline subsystem
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("subsystem_map"+"."+"subsystem"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("subsystem_map"+"."+"subsystem"+"."+"name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline subsystem map inline subsystem based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks storage unit inline maps inline array item inline subsystem map inline subsystem inline links
//
// swagger:model storage_unit_inline_maps_inline_array_item_inline_subsystem_map_inline_subsystem_inline__links
type StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline subsystem map inline subsystem inline links
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline subsystem map inline subsystem inline links based on the context it is used
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMetric Performance numbers, such as IOPS latency and throughput.
//
// swagger:model storage_unit_inline_metric
type StorageUnitInlineMetric struct {

	// links
	Links *StorageUnitInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *StorageUnitInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *StorageUnitInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *StorageUnitInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this storage unit inline metric
func (m *StorageUnitInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var storageUnitInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineMetricTypeDurationPropEnum = append(storageUnitInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT15S captures enum value "PT15S"
	StorageUnitInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT4M captures enum value "PT4M"
	StorageUnitInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT30M captures enum value "PT30M"
	StorageUnitInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT2H captures enum value "PT2H"
	StorageUnitInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// StorageUnitInlineMetricDurationP1D captures enum value "P1D"
	StorageUnitInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT5M captures enum value "PT5M"
	StorageUnitInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *StorageUnitInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var storageUnitInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineMetricTypeStatusPropEnum = append(storageUnitInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// StorageUnitInlineMetricStatusOk captures enum value "ok"
	StorageUnitInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// StorageUnitInlineMetricStatusError captures enum value "error"
	StorageUnitInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// StorageUnitInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	StorageUnitInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// StorageUnitInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	StorageUnitInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// StorageUnitInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	StorageUnitInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// StorageUnitInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	StorageUnitInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// StorageUnitInlineMetricStatusNotFound captures enum value "not_found"
	StorageUnitInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// StorageUnitInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	StorageUnitInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// StorageUnitInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	StorageUnitInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// StorageUnitInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	StorageUnitInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// StorageUnitInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	StorageUnitInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *StorageUnitInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline metric based on the context it is used
func (m *StorageUnitInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMetric) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model storage_unit_inline_metric_inline_iops
type StorageUnitInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline metric inline iops
func (m *StorageUnitInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline metric inline iops based on the context it is used
func (m *StorageUnitInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model storage_unit_inline_metric_inline_latency
type StorageUnitInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline metric inline latency
func (m *StorageUnitInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline metric inline latency based on the context it is used
func (m *StorageUnitInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMetricInlineLinks storage unit inline metric inline links
//
// swagger:model storage_unit_inline_metric_inline__links
type StorageUnitInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline metric inline links
func (m *StorageUnitInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline metric inline links based on the context it is used
func (m *StorageUnitInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model storage_unit_inline_metric_inline_throughput
type StorageUnitInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline metric inline throughput
func (m *StorageUnitInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline metric inline throughput based on the context it is used
func (m *StorageUnitInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMovement The properties of a storage unit move operation from one storage availability zone to another.
//
// swagger:model storage_unit_inline_movement
type StorageUnitInlineMovement struct {

	// destination
	Destination *StorageUnitInlineMovementInlineDestination `json:"destination,omitempty"`

	// The percentage complete of the storage unit move operation.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// source
	Source *StorageUnitInlineMovementInlineSource `json:"source,omitempty"`

	// The start date and time of the storage unit move operation.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 2024-12-07 03:45:12-05:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// The state of the storage unit move operation.<br>
	// The state can be updated to influence the progress of an on-going storage unit move operation. The allowed new state depends on the current state:
	// - Update the state to `aborted` to cancel the storage unit move operation.
	// - Update the state to `cutover` to trigger cutover of the storage unit move operation.
	// - Update the state to `paused` to pause an in progress storage unit move operation. If the move operation has just begun replication, an update to `paused` may not be immediately possible, in which case it will fail with error 5376518 and require a retry.
	// - Update the state to `replicating` to resume a paused storage unit move operation.
	// - Update the state to `cutover_wait` to go into cutover for the storage unit move operation, manually.
	// When the storage unit move operation is waiting to go into the `cutover` state, the state is `cutover_pending`.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: replicating
	// Enum: ["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage unit inline movement
func (m *StorageUnitInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovement) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.Destination) { // not required
		return nil
	}

	if m.Destination != nil {
		if err := m.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMovement) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "source")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMovement) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("movement"+"."+"start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var storageUnitInlineMovementTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineMovementTypeStatePropEnum = append(storageUnitInlineMovementTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// aborted
	// END DEBUGGING
	// StorageUnitInlineMovementStateAborted captures enum value "aborted"
	StorageUnitInlineMovementStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// cutover
	// END DEBUGGING
	// StorageUnitInlineMovementStateCutover captures enum value "cutover"
	StorageUnitInlineMovementStateCutover string = "cutover"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// cutover_wait
	// END DEBUGGING
	// StorageUnitInlineMovementStateCutoverWait captures enum value "cutover_wait"
	StorageUnitInlineMovementStateCutoverWait string = "cutover_wait"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// cutover_pending
	// END DEBUGGING
	// StorageUnitInlineMovementStateCutoverPending captures enum value "cutover_pending"
	StorageUnitInlineMovementStateCutoverPending string = "cutover_pending"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// failed
	// END DEBUGGING
	// StorageUnitInlineMovementStateFailed captures enum value "failed"
	StorageUnitInlineMovementStateFailed string = "failed"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// paused
	// END DEBUGGING
	// StorageUnitInlineMovementStatePaused captures enum value "paused"
	StorageUnitInlineMovementStatePaused string = "paused"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// queued
	// END DEBUGGING
	// StorageUnitInlineMovementStateQueued captures enum value "queued"
	StorageUnitInlineMovementStateQueued string = "queued"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// replicating
	// END DEBUGGING
	// StorageUnitInlineMovementStateReplicating captures enum value "replicating"
	StorageUnitInlineMovementStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// success
	// END DEBUGGING
	// StorageUnitInlineMovementStateSuccess captures enum value "success"
	StorageUnitInlineMovementStateSuccess string = "success"
)

// prop value enum
func (m *StorageUnitInlineMovement) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineMovementTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitInlineMovement) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("movement"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline movement based on the context it is used
func (m *StorageUnitInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovement) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.Destination != nil {
		if err := m.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMovement) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineMovement) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "source")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineMovement) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMovement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMovement) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMovementInlineDestination The destination of a storage unit move operation.
//
// swagger:model storage_unit_inline_movement_inline_destination
type StorageUnitInlineMovementInlineDestination struct {

	// storage availability zone
	StorageAvailabilityZone *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`
}

// Validate validates this storage unit inline movement inline destination
func (m *StorageUnitInlineMovementInlineDestination) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineDestination) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZone) { // not required
		return nil
	}

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline destination based on the context it is used
func (m *StorageUnitInlineMovementInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineDestination) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineDestination) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineDestination) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone The storage availability zone to which the storage unit is being moved.
//
// swagger:model storage_unit_inline_movement_inline_destination_inline_storage_availability_zone
type StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone struct {

	// links
	Links *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline movement inline destination inline storage availability zone
func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline destination inline storage availability zone based on the context it is used
func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks storage unit inline movement inline destination inline storage availability zone inline links
//
// swagger:model storage_unit_inline_movement_inline_destination_inline_storage_availability_zone_inline__links
type StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline movement inline destination inline storage availability zone inline links
func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline destination inline storage availability zone inline links based on the context it is used
func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "destination" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMovementInlineSource The source of a storage unit move operation.
//
// swagger:model storage_unit_inline_movement_inline_source
type StorageUnitInlineMovementInlineSource struct {

	// storage availability zone
	StorageAvailabilityZone *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`
}

// Validate validates this storage unit inline movement inline source
func (m *StorageUnitInlineMovementInlineSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineSource) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZone) { // not required
		return nil
	}

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "source" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline source based on the context it is used
func (m *StorageUnitInlineMovementInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineSource) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "source" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineSource) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone The storage availability zone from which the storage unit is being moved.
//
// swagger:model storage_unit_inline_movement_inline_source_inline_storage_availability_zone
type StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone struct {

	// links
	Links *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline movement inline source inline storage availability zone
func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "source" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline source inline storage availability zone based on the context it is used
func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "source" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks storage unit inline movement inline source inline storage availability zone inline links
//
// swagger:model storage_unit_inline_movement_inline_source_inline_storage_availability_zone_inline__links
type StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline movement inline source inline storage availability zone inline links
func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "source" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline source inline storage availability zone inline links based on the context it is used
func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "source" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineQosPolicy The QoS policy for the storage unit. Both traditional and adaptive QoS policies are supported.
//
// swagger:model storage_unit_inline_qos_policy
type StorageUnitInlineQosPolicy struct {

	// links
	Links *StorageUnitInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// The name of the QoS policy.
	//
	// Example: qos1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the QoS policy.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline qos policy
func (m *StorageUnitInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline qos policy based on the context it is used
func (m *StorageUnitInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineQosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos_policy"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineQosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos_policy"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineQosPolicyInlineLinks storage unit inline qos policy inline links
//
// swagger:model storage_unit_inline_qos_policy_inline__links
type StorageUnitInlineQosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline qos policy inline links
func (m *StorageUnitInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline qos policy inline links based on the context it is used
func (m *StorageUnitInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineSpace The storage space related properties of the storage unit.
//
// swagger:model storage_unit_inline_space
type StorageUnitInlineSpace struct {

	// The storage efficiency ratio of the storage unit without snapshots. (Logical Used / Used)
	//
	// Example: 2.5
	// Read Only: true
	EfficiencyRatio *float64 `json:"efficiency_ratio,omitempty"`

	// The number of bytes consumed on the disk by the storage unit, excluding snapshots.
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// The number of bytes consumed on the disk by the storage unit's snapshots.
	// This property has been replaced by `space.snapshot.used`.
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsedBySnapshots *int64 `json:"physical_used_by_snapshots,omitempty"`

	// The total provisioned size of the storage unit. The storage unit size can be increased but not decreased using the /api/storage/luns or /api/storage/namespaces endpoints.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform and the available space.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Read Only: true
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *StorageUnitInlineSpaceInlineSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the storage unit.<br/>
	// This value is the total space consumed, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN or namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN or namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this storage unit inline space
func (m *StorageUnitInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline space based on the context it is used
func (m *StorageUnitInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEfficiencyRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineSpace) contextValidateEfficiencyRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_ratio", "body", m.EfficiencyRatio); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineSpace) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_used", "body", m.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineSpace) contextValidatePhysicalUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_used_by_snapshots", "body", m.PhysicalUsedBySnapshots); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineSpace) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineSpace) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineSpaceInlineSnapshot storage unit inline space inline snapshot
//
// swagger:model storage_unit_inline_space_inline_snapshot
type StorageUnitInlineSpaceInlineSnapshot struct {

	// autodelete
	Autodelete *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete `json:"autodelete,omitempty"`

	// Size available for snapshots within the snapshot reserve, in bytes.
	// Read Only: true
	ReserveAvailable *int64 `json:"reserve_available,omitempty"`

	// The space that has been reserved for snapshot usage, in percent.
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// Size that has been reserved for snapshot usage, in bytes.
	// Read Only: true
	ReserveSize *int64 `json:"reserve_size,omitempty"`

	// Percentage of snapshot reserve size that has been used.
	// Read Only: true
	SpaceUsedPercent *int64 `json:"space_used_percent,omitempty"`

	// The total space used by snapshots, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this storage unit inline space inline snapshot
func (m *StorageUnitInlineSpaceInlineSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutodelete(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineSpaceInlineSnapshot) validateAutodelete(formats strfmt.Registry) error {
	if swag.IsZero(m.Autodelete) { // not required
		return nil
	}

	if m.Autodelete != nil {
		if err := m.Autodelete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot" + "." + "autodelete")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline space inline snapshot based on the context it is used
func (m *StorageUnitInlineSpaceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutodelete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserveAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserveSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpaceUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineSpaceInlineSnapshot) contextValidateAutodelete(ctx context.Context, formats strfmt.Registry) error {

	if m.Autodelete != nil {
		if err := m.Autodelete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot" + "." + "autodelete")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineSpaceInlineSnapshot) contextValidateReserveAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"reserve_available", "body", m.ReserveAvailable); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineSpaceInlineSnapshot) contextValidateReserveSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"reserve_size", "body", m.ReserveSize); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineSpaceInlineSnapshot) contextValidateSpaceUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"space_used_percent", "body", m.SpaceUsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineSpaceInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineSpaceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineSpaceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSpaceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineSpaceInlineSnapshotInlineAutodelete storage unit inline space inline snapshot inline autodelete
//
// swagger:model storage_unit_inline_space_inline_snapshot_inline_autodelete
type StorageUnitInlineSpaceInlineSnapshotInlineAutodelete struct {

	// Specifies whether snapshot autodelete is currently enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this storage unit inline space inline snapshot inline autodelete
func (m *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage unit inline space inline snapshot inline autodelete based on context it is used
func (m *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSpaceInlineSnapshotInlineAutodelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model storage_unit_inline_statistics
type StorageUnitInlineStatistics struct {

	// iops raw
	IopsRaw *StorageUnitInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *StorageUnitInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *StorageUnitInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this storage unit inline statistics
func (m *StorageUnitInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var storageUnitInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineStatisticsTypeStatusPropEnum = append(storageUnitInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusOk captures enum value "ok"
	StorageUnitInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusError captures enum value "error"
	StorageUnitInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	StorageUnitInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	StorageUnitInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	StorageUnitInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	StorageUnitInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusNotFound captures enum value "not_found"
	StorageUnitInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	StorageUnitInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	StorageUnitInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	StorageUnitInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	StorageUnitInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *StorageUnitInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline statistics based on the context it is used
func (m *StorageUnitInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineStatistics) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model storage_unit_inline_statistics_inline_iops_raw
type StorageUnitInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline statistics inline iops raw
func (m *StorageUnitInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline statistics inline iops raw based on the context it is used
func (m *StorageUnitInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model storage_unit_inline_statistics_inline_latency_raw
type StorageUnitInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline statistics inline latency raw
func (m *StorageUnitInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline statistics inline latency raw based on the context it is used
func (m *StorageUnitInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model storage_unit_inline_statistics_inline_throughput_raw
type StorageUnitInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline statistics inline throughput raw
func (m *StorageUnitInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline statistics inline throughput raw based on the context it is used
func (m *StorageUnitInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineStatus Status information about the storage unit.
//
// swagger:model storage_unit_inline_status
type StorageUnitInlineStatus struct {

	// The state of the storage unit and aggregate that contains it. Storage units are only available when their containers are available.
	//
	// Read Only: true
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the storage unit is mapped to one or more hosts.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the storage unit allows only read access.
	//
	// Read Only: true
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the storage unit. Normal states for a storage unit are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Read Only: true
	// Enum: ["foreign_lun_error","nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage unit inline status
func (m *StorageUnitInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageUnitInlineStatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineStatusTypeContainerStatePropEnum = append(storageUnitInlineStatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// StorageUnitInlineStatusContainerStateOnline captures enum value "online"
	StorageUnitInlineStatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// StorageUnitInlineStatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	StorageUnitInlineStatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// StorageUnitInlineStatusContainerStateVolumeOffline captures enum value "volume_offline"
	StorageUnitInlineStatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (m *StorageUnitInlineStatus) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineStatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitInlineStatus) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := m.validateContainerStateEnum("status"+"."+"container_state", "body", *m.ContainerState); err != nil {
		return err
	}

	return nil
}

var storageUnitInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["foreign_lun_error","nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineStatusTypeStatePropEnum = append(storageUnitInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// foreign_lun_error
	// END DEBUGGING
	// StorageUnitInlineStatusStateForeignLunError captures enum value "foreign_lun_error"
	StorageUnitInlineStatusStateForeignLunError string = "foreign_lun_error"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// nvfail
	// END DEBUGGING
	// StorageUnitInlineStatusStateNvfail captures enum value "nvfail"
	StorageUnitInlineStatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// offline
	// END DEBUGGING
	// StorageUnitInlineStatusStateOffline captures enum value "offline"
	StorageUnitInlineStatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// online
	// END DEBUGGING
	// StorageUnitInlineStatusStateOnline captures enum value "online"
	StorageUnitInlineStatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// space_error
	// END DEBUGGING
	// StorageUnitInlineStatusStateSpaceError captures enum value "space_error"
	StorageUnitInlineStatusStateSpaceError string = "space_error"
)

// prop value enum
func (m *StorageUnitInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline status based on the context it is used
func (m *StorageUnitInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContainerState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMapped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReadOnly(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineStatus) contextValidateContainerState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"container_state", "body", m.ContainerState); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineStatus) contextValidateMapped(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"mapped", "body", m.Mapped); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineStatus) contextValidateReadOnly(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"read_only", "body", m.ReadOnly); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitInlineStatus) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineStatus) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineSvm The SVM in which the storage unit is located. Valid in POST.
//
// swagger:model storage_unit_inline_svm
type StorageUnitInlineSvm struct {

	// links
	Links *StorageUnitInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline svm
func (m *StorageUnitInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline svm based on the context it is used
func (m *StorageUnitInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineSvm) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitInlineSvmInlineLinks storage unit inline svm inline links
//
// swagger:model storage_unit_inline_svm_inline__links
type StorageUnitInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline svm inline links
func (m *StorageUnitInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline svm inline links based on the context it is used
func (m *StorageUnitInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
