// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageUnitAntiRansomwareEntropyStats Storage unit data-entropy statistics derived from block analysis.
//
// swagger:model storage_unit_anti_ransomware_entropy_stats
type StorageUnitAntiRansomwareEntropyStats struct {

	// links
	Links *StorageUnitAntiRansomwareEntropyStatsInlineLinks `json:"_links,omitempty"`

	// The amount of data written.
	// Read Only: true
	DataWrittenInBytes *int64 `json:"data_written_in_bytes,omitempty"`

	// The duration of the interval associated with this statistic. The duration is represented in ISO-8601 standard format.
	// Example: PT15M
	// Read Only: true
	Duration *string `json:"duration,omitempty"`

	// The percentage of data that is encrypted.
	// Read Only: true
	EncryptionPercentage *int64 `json:"encryption_percentage,omitempty"`

	// Storage unit metrics are retrieved based on this statistic type.
	// Enum: ["sub_hourly","hourly","daily","high_enc_pct"]
	EntropyStatsType *string `json:"entropy_stats_type,omitempty"`

	// storage unit
	StorageUnit *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit `json:"storage_unit,omitempty"`

	// Start time in date-time format.
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats
func (m *StorageUnitAntiRansomwareEntropyStats) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntropyStatsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var storageUnitAntiRansomwareEntropyStatsTypeEntropyStatsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sub_hourly","hourly","daily","high_enc_pct"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitAntiRansomwareEntropyStatsTypeEntropyStatsTypePropEnum = append(storageUnitAntiRansomwareEntropyStatsTypeEntropyStatsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_anti_ransomware_entropy_stats
	// StorageUnitAntiRansomwareEntropyStats
	// entropy_stats_type
	// EntropyStatsType
	// sub_hourly
	// END DEBUGGING
	// StorageUnitAntiRansomwareEntropyStatsEntropyStatsTypeSubHourly captures enum value "sub_hourly"
	StorageUnitAntiRansomwareEntropyStatsEntropyStatsTypeSubHourly string = "sub_hourly"

	// BEGIN DEBUGGING
	// storage_unit_anti_ransomware_entropy_stats
	// StorageUnitAntiRansomwareEntropyStats
	// entropy_stats_type
	// EntropyStatsType
	// hourly
	// END DEBUGGING
	// StorageUnitAntiRansomwareEntropyStatsEntropyStatsTypeHourly captures enum value "hourly"
	StorageUnitAntiRansomwareEntropyStatsEntropyStatsTypeHourly string = "hourly"

	// BEGIN DEBUGGING
	// storage_unit_anti_ransomware_entropy_stats
	// StorageUnitAntiRansomwareEntropyStats
	// entropy_stats_type
	// EntropyStatsType
	// daily
	// END DEBUGGING
	// StorageUnitAntiRansomwareEntropyStatsEntropyStatsTypeDaily captures enum value "daily"
	StorageUnitAntiRansomwareEntropyStatsEntropyStatsTypeDaily string = "daily"

	// BEGIN DEBUGGING
	// storage_unit_anti_ransomware_entropy_stats
	// StorageUnitAntiRansomwareEntropyStats
	// entropy_stats_type
	// EntropyStatsType
	// high_enc_pct
	// END DEBUGGING
	// StorageUnitAntiRansomwareEntropyStatsEntropyStatsTypeHighEncPct captures enum value "high_enc_pct"
	StorageUnitAntiRansomwareEntropyStatsEntropyStatsTypeHighEncPct string = "high_enc_pct"
)

// prop value enum
func (m *StorageUnitAntiRansomwareEntropyStats) validateEntropyStatsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitAntiRansomwareEntropyStatsTypeEntropyStatsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) validateEntropyStatsType(formats strfmt.Registry) error {
	if swag.IsZero(m.EntropyStatsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateEntropyStatsTypeEnum("entropy_stats_type", "body", *m.EntropyStatsType); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnit) { // not required
		return nil
	}

	if m.StorageUnit != nil {
		if err := m.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStats) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataWrittenInBytes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryptionPercentage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) contextValidateDataWrittenInBytes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_written_in_bytes", "body", m.DataWrittenInBytes); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) contextValidateEncryptionPercentage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption_percentage", "body", m.EncryptionPercentage); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStats) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageUnit != nil {
		if err := m.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStats) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStats) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStats
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareEntropyStatsInlineLinks storage unit anti ransomware entropy stats inline links
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_inline__links
type StorageUnitAntiRansomwareEntropyStatsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats inline links
func (m *StorageUnitAntiRansomwareEntropyStatsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats inline links based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit storage unit anti ransomware entropy stats inline storage unit
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_inline_storage_unit
type StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit struct {

	// links
	Links *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks `json:"_links,omitempty"`

	// The name of the storage unit.
	//
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the storage unit.
	//
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats inline storage unit
func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats inline storage unit based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks storage unit anti ransomware entropy stats inline storage unit inline links
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_inline_storage_unit_inline__links
type StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats inline storage unit inline links
func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats inline storage unit inline links based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsInlineStorageUnitInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
