// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageUnitAntiRansomwareEntropyStatsResponse List of storage unit entropy statistics.
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_response
type StorageUnitAntiRansomwareEntropyStatsResponse struct {

	// links
	Links *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks `json:"_links,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// storage unit anti ransomware entropy stats response inline records
	StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords []*StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats response
func (m *StorageUnitAntiRansomwareEntropyStatsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnitAntiRansomwareEntropyStatsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponse) validateStorageUnitAntiRansomwareEntropyStatsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords); i++ {
		if swag.IsZero(m.StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords[i]) { // not required
			continue
		}

		if m.StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords[i] != nil {
			if err := m.StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats response based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnitAntiRansomwareEntropyStatsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponse) contextValidateStorageUnitAntiRansomwareEntropyStatsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords); i++ {

		if m.StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords[i] != nil {
			if err := m.StorageUnitAntiRansomwareEntropyStatsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponse) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks storage unit anti ransomware entropy stats response inline links
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_response_inline__links
type StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats response inline links
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats response inline links based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem Storage unit data-entropy statistics derived from block analysis.
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_response_inline_records_inline_array_item
type StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The amount of data written.
	// Read Only: true
	DataWrittenInBytes *int64 `json:"data_written_in_bytes,omitempty"`

	// The duration of the interval associated with this statistic. The duration is represented in ISO-8601 standard format.
	// Example: PT15M
	// Read Only: true
	Duration *string `json:"duration,omitempty"`

	// The percentage of data that is encrypted.
	// Read Only: true
	EncryptionPercentage *int64 `json:"encryption_percentage,omitempty"`

	// Storage unit metrics are retrieved based on this statistic type.
	// Enum: ["sub_hourly","hourly","daily","high_enc_pct"]
	EntropyStatsType *string `json:"entropy_stats_type,omitempty"`

	// storage unit
	StorageUnit *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit `json:"storage_unit,omitempty"`

	// Start time in date-time format.
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats response inline records inline array item
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntropyStatsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var storageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemTypeEntropyStatsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sub_hourly","hourly","daily","high_enc_pct"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemTypeEntropyStatsTypePropEnum = append(storageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemTypeEntropyStatsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_anti_ransomware_entropy_stats_response_inline_records_inline_array_item
	// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem
	// entropy_stats_type
	// EntropyStatsType
	// sub_hourly
	// END DEBUGGING
	// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeSubHourly captures enum value "sub_hourly"
	StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeSubHourly string = "sub_hourly"

	// BEGIN DEBUGGING
	// storage_unit_anti_ransomware_entropy_stats_response_inline_records_inline_array_item
	// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem
	// entropy_stats_type
	// EntropyStatsType
	// hourly
	// END DEBUGGING
	// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeHourly captures enum value "hourly"
	StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeHourly string = "hourly"

	// BEGIN DEBUGGING
	// storage_unit_anti_ransomware_entropy_stats_response_inline_records_inline_array_item
	// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem
	// entropy_stats_type
	// EntropyStatsType
	// daily
	// END DEBUGGING
	// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeDaily captures enum value "daily"
	StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeDaily string = "daily"

	// BEGIN DEBUGGING
	// storage_unit_anti_ransomware_entropy_stats_response_inline_records_inline_array_item
	// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem
	// entropy_stats_type
	// EntropyStatsType
	// high_enc_pct
	// END DEBUGGING
	// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeHighEncPct captures enum value "high_enc_pct"
	StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeHighEncPct string = "high_enc_pct"
)

// prop value enum
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) validateEntropyStatsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemTypeEntropyStatsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) validateEntropyStatsType(formats strfmt.Registry) error {
	if swag.IsZero(m.EntropyStatsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateEntropyStatsTypeEnum("entropy_stats_type", "body", *m.EntropyStatsType); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnit) { // not required
		return nil
	}

	if m.StorageUnit != nil {
		if err := m.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats response inline records inline array item based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataWrittenInBytes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryptionPercentage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateDataWrittenInBytes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_written_in_bytes", "body", m.DataWrittenInBytes); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateEncryptionPercentage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption_percentage", "body", m.EncryptionPercentage); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageUnit != nil {
		if err := m.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks storage unit anti ransomware entropy stats response inline records inline array item inline links
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_response_inline_records_inline_array_item_inline__links
type StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats response inline records inline array item inline links
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats response inline records inline array item inline links based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit storage unit anti ransomware entropy stats response inline records inline array item inline storage unit
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_response_inline_records_inline_array_item_inline_storage_unit
type StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit struct {

	// links
	Links *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks `json:"_links,omitempty"`

	// The name of the storage unit.
	//
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the storage unit.
	//
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats response inline records inline array item inline storage unit
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats response inline records inline array item inline storage unit based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks storage unit anti ransomware entropy stats response inline records inline array item inline storage unit inline links
//
// swagger:model storage_unit_anti_ransomware_entropy_stats_response_inline_records_inline_array_item_inline_storage_unit_inline__links
type StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware entropy stats response inline records inline array item inline storage unit inline links
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware entropy stats response inline records inline array item inline storage unit inline links based on the context it is used
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareEntropyStatsResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
