// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// StorageUnitAntiRansomwareSuspectResponse List of storage units.
//
// swagger:model storage_unit_anti_ransomware_suspect_response
type StorageUnitAntiRansomwareSuspectResponse struct {

	// links
	Links *StorageUnitAntiRansomwareSuspectResponseInlineLinks `json:"_links,omitempty"`

	// Number of records.
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// storage unit anti ransomware suspect response inline records
	StorageUnitAntiRansomwareSuspectResponseInlineRecords []*StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response
func (m *StorageUnitAntiRansomwareSuspectResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnitAntiRansomwareSuspectResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponse) validateStorageUnitAntiRansomwareSuspectResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnitAntiRansomwareSuspectResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageUnitAntiRansomwareSuspectResponseInlineRecords); i++ {
		if swag.IsZero(m.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i]) { // not required
			continue
		}

		if m.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i] != nil {
			if err := m.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response based on the context it is used
func (m *StorageUnitAntiRansomwareSuspectResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnitAntiRansomwareSuspectResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponse) contextValidateStorageUnitAntiRansomwareSuspectResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StorageUnitAntiRansomwareSuspectResponseInlineRecords); i++ {

		if m.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i] != nil {
			if err := m.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponse) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareSuspectResponseInlineLinks storage unit anti ransomware suspect response inline links
//
// swagger:model storage_unit_anti_ransomware_suspect_response_inline__links
type StorageUnitAntiRansomwareSuspectResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline links
func (m *StorageUnitAntiRansomwareSuspectResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline links based on the context it is used
func (m *StorageUnitAntiRansomwareSuspectResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem Storage unit details.
//
// swagger:model storage_unit_anti_ransomware_suspect_response_inline_records_inline_array_item
type StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// storage unit
	StorageUnit *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit `json:"storage_unit,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline records inline array item
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnit) { // not required
		return nil
	}

	if m.StorageUnit != nil {
		if err := m.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline records inline array item based on the context it is used
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageUnit != nil {
		if err := m.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks storage unit anti ransomware suspect response inline records inline array item inline links
//
// swagger:model storage_unit_anti_ransomware_suspect_response_inline_records_inline_array_item_inline__links
type StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline records inline array item inline links
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline records inline array item inline links based on the context it is used
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit storage unit anti ransomware suspect response inline records inline array item inline storage unit
//
// swagger:model storage_unit_anti_ransomware_suspect_response_inline_records_inline_array_item_inline_storage_unit
type StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit struct {

	// links
	Links *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks `json:"_links,omitempty"`

	// The name of the storage unit.
	//
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the storage unit.
	//
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline records inline array item inline storage unit
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline records inline array item inline storage unit based on the context it is used
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks storage unit anti ransomware suspect response inline records inline array item inline storage unit inline links
//
// swagger:model storage_unit_anti_ransomware_suspect_response_inline_records_inline_array_item_inline_storage_unit_inline__links
type StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline records inline array item inline storage unit inline links
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline records inline array item inline storage unit inline links based on the context it is used
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
