// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageUnitClone storage unit clone
//
// swagger:model storage_unit_clone
type StorageUnitClone struct {

	// Inherited physical used from the clone's base snapshot.
	//
	// Read Only: true
	InheritedPhysicalUsed *int64 `json:"inherited_physical_used,omitempty"`

	// Inherited savings from the clone's base snapshot.
	//
	// Read Only: true
	InheritedSavings *int64 `json:"inherited_savings,omitempty"`

	// Specifies if this storage unit is a normal FlexVol storage unit or FlexClone storage unit. Valid in POST.
	//
	IsFlexclone *bool `json:"is_flexclone,omitempty"`

	// source
	Source *StorageUnitCloneInlineSource `json:"source,omitempty"`

	// Percentage of FlexClone storage unit blocks split from its parent storage unit.
	//
	// Read Only: true
	SplitCompletePercent *int64 `json:"split_complete_percent,omitempty"`

	// Space required by the containing-aggregate to split the FlexClone storage unit.
	//
	// Read Only: true
	SplitEstimate *int64 `json:"split_estimate,omitempty"`

	// This field is set when a split is executed on a FlexClone storage unit, that is when the FlexClone storage unit is split from its parent FlexVol storage unit. Setting this field initiates a split of a FlexClone storage unit from a FlexVol storage unit. Valid in POST and PATCH.
	//
	SplitInitiated *bool `json:"split_initiated,omitempty"`
}

// Validate validates this storage unit clone
func (m *StorageUnitClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitClone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit clone based on the context it is used
func (m *StorageUnitClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInheritedPhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInheritedSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplitCompletePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplitEstimate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitClone) contextValidateInheritedPhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "inherited_physical_used", "body", m.InheritedPhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitClone) contextValidateInheritedSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "inherited_savings", "body", m.InheritedSavings); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitClone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitClone) contextValidateSplitCompletePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "split_complete_percent", "body", m.SplitCompletePercent); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitClone) contextValidateSplitEstimate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "split_estimate", "body", m.SplitEstimate); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitClone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitClone) UnmarshalBinary(b []byte) error {
	var res StorageUnitClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitCloneInlineSource storage unit clone inline source
//
// swagger:model storage_unit_clone_inline_source
type StorageUnitCloneInlineSource struct {

	// snapshot
	Snapshot *StorageUnitCloneInlineSourceInlineSnapshot `json:"snapshot,omitempty"`

	// storage unit
	StorageUnit *StorageUnitCloneInlineSourceInlineStorageUnit `json:"storage_unit,omitempty"`

	// svm
	Svm *StorageUnitCloneInlineSourceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this storage unit clone inline source
func (m *StorageUnitCloneInlineSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSource) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitCloneInlineSource) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnit) { // not required
		return nil
	}

	if m.StorageUnit != nil {
		if err := m.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitCloneInlineSource) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit clone inline source based on the context it is used
func (m *StorageUnitCloneInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSource) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitCloneInlineSource) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageUnit != nil {
		if err := m.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitCloneInlineSource) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitCloneInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitCloneInlineSource) UnmarshalBinary(b []byte) error {
	var res StorageUnitCloneInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitCloneInlineSourceInlineSnapshot storage unit clone inline source inline snapshot
//
// swagger:model storage_unit_clone_inline_source_inline_snapshot
type StorageUnitCloneInlineSourceInlineSnapshot struct {

	// links
	Links *StorageUnitCloneInlineSourceInlineSnapshotInlineLinks `json:"_links,omitempty"`

	// name
	// Example: this_snapshot
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit clone inline source inline snapshot
func (m *StorageUnitCloneInlineSourceInlineSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineSnapshot) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "snapshot" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit clone inline source inline snapshot based on the context it is used
func (m *StorageUnitCloneInlineSourceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineSnapshot) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "snapshot" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res StorageUnitCloneInlineSourceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitCloneInlineSourceInlineSnapshotInlineLinks storage unit clone inline source inline snapshot inline links
//
// swagger:model storage_unit_clone_inline_source_inline_snapshot_inline__links
type StorageUnitCloneInlineSourceInlineSnapshotInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit clone inline source inline snapshot inline links
func (m *StorageUnitCloneInlineSourceInlineSnapshotInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineSnapshotInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "snapshot" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit clone inline source inline snapshot inline links based on the context it is used
func (m *StorageUnitCloneInlineSourceInlineSnapshotInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineSnapshotInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "snapshot" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineSnapshotInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineSnapshotInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitCloneInlineSourceInlineSnapshotInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitCloneInlineSourceInlineStorageUnit storage unit clone inline source inline storage unit
//
// swagger:model storage_unit_clone_inline_source_inline_storage_unit
type StorageUnitCloneInlineSourceInlineStorageUnit struct {

	// links
	Links *StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks `json:"_links,omitempty"`

	// The name of the storage unit.
	//
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the storage unit.
	//
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit clone inline source inline storage unit
func (m *StorageUnitCloneInlineSourceInlineStorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineStorageUnit) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit clone inline source inline storage unit based on the context it is used
func (m *StorageUnitCloneInlineSourceInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineStorageUnit) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res StorageUnitCloneInlineSourceInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks storage unit clone inline source inline storage unit inline links
//
// swagger:model storage_unit_clone_inline_source_inline_storage_unit_inline__links
type StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit clone inline source inline storage unit inline links
func (m *StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit clone inline source inline storage unit inline links based on the context it is used
func (m *StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitCloneInlineSourceInlineStorageUnitInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitCloneInlineSourceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model storage_unit_clone_inline_source_inline_svm
type StorageUnitCloneInlineSourceInlineSvm struct {

	// links
	Links *StorageUnitCloneInlineSourceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit clone inline source inline svm
func (m *StorageUnitCloneInlineSourceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit clone inline source inline svm based on the context it is used
func (m *StorageUnitCloneInlineSourceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineSvm) UnmarshalBinary(b []byte) error {
	var res StorageUnitCloneInlineSourceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitCloneInlineSourceInlineSvmInlineLinks storage unit clone inline source inline svm inline links
//
// swagger:model storage_unit_clone_inline_source_inline_svm_inline__links
type StorageUnitCloneInlineSourceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit clone inline source inline svm inline links
func (m *StorageUnitCloneInlineSourceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit clone inline source inline svm inline links based on the context it is used
func (m *StorageUnitCloneInlineSourceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitCloneInlineSourceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitCloneInlineSourceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitCloneInlineSourceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
