// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageUnitSnapshot The snapshot object represents a point in time snapshot of a storage unit.
//
// swagger:model storage_unit_snapshot
type StorageUnitSnapshot struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// A comment associated with the snapshot. Valid in POST and PATCH.
	//
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Creation time of the snapshot. It is the storage unit access time when the snapshot was created.
	//
	// Example: 2019-02-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// delta
	// Read Only: true
	Delta *SnapshotDelta `json:"delta,omitempty"`

	// The expiry time for the snapshot. Snapshots with an expiry time set are not allowed to be deleted until the retention time is reached.
	//
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Size of the logical used file system at the time the snapshot is captured.
	//
	// Example: 1228800
	// Read Only: true
	LogicalSize *int64 `json:"logical_size,omitempty"`

	// The name of the snapshot. Snapshot names cannot begin or end with whitespace. Valid in POST and PATCH.
	//
	// Example: this_snapshot
	Name *string `json:"name,omitempty"`

	// owners
	// Read Only: true
	Owners []*string `json:"owners,omitempty"`

	// Space reclaimed when the snapshot is deleted, in bytes.
	//
	// Read Only: true
	ReclaimableSpace *int64 `json:"reclaimable_space,omitempty"`

	// Size of the active file system at the time the snapshot is captured. The actual size of the snapshot also includes those blocks trapped by other snapshots. On a snapshot deletion, the `size` amount of blocks is the maximum number of blocks available. On a snapshot restore, the "AFS used size" value will match the snapshot `size` value.
	//
	// Example: 122880
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// snaplock
	Snaplock *StorageUnitSnapshotInlineSnaplock `json:"snaplock,omitempty"`

	// Label for SnapMirror operations. Valid in POST and PATCH.
	//
	// Max Length: 31
	// Min Length: 0
	SnapmirrorLabel *string `json:"snapmirror_label,omitempty"`

	// State of the FlexGroup volume snapshot. A recently created snapshot can be in the `unknown` state while the system is calculating the state. At all other times, a snapshot is valid.
	//
	// Read Only: true
	// Enum: ["valid","unknown"]
	State *string `json:"state,omitempty"`

	// storage unit
	StorageUnit *StorageUnitSnapshotInlineStorageUnit `json:"storage_unit,omitempty"`

	// svm
	Svm *StorageUnitSnapshotInlineSvm `json:"svm,omitempty"`

	// The UUID of the snapshot in the storage unit that uniquely identifies the snapshot in that storage unit.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// The 128 bit identifier that uniquely identifies a snapshot and its logical data layout.
	//
	// Read Only: true
	VersionUUID *string `json:"version_uuid,omitempty"`
}

// Validate validates this storage unit snapshot
func (m *StorageUnitSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDelta(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwners(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapmirrorLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshot) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 255); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) validateDelta(formats strfmt.Registry) error {
	if swag.IsZero(m.Delta) { // not required
		return nil
	}

	if m.Delta != nil {
		if err := m.Delta.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("delta")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var storageUnitSnapshotOwnersItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","snapmirror","snapmirror_dependent","sync_mirror","volume_clone","volume_clone_dependent","snap_restore","snap_restore_dependent","dump","cifs_share","volume_copy","ndmp","worm_volume","sis_clone","s2c_iron","lun_clone","backup_dependent","snaplock_dependent","file_clone_dependent","volume_move_dependent","svmdr_dependent","anti_ransomware_backup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitSnapshotOwnersItemsEnum = append(storageUnitSnapshotOwnersItemsEnum, v)
	}
}

func (m *StorageUnitSnapshot) validateOwnersItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitSnapshotOwnersItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitSnapshot) validateOwners(formats strfmt.Registry) error {
	if swag.IsZero(m.Owners) { // not required
		return nil
	}

	for i := 0; i < len(m.Owners); i++ {
		if swag.IsZero(m.Owners[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateOwnersItemsEnum("owners"+"."+strconv.Itoa(i), "body", *m.Owners[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *StorageUnitSnapshot) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) validateSnapmirrorLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapmirrorLabel) { // not required
		return nil
	}

	if err := validate.MinLength("snapmirror_label", "body", *m.SnapmirrorLabel, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("snapmirror_label", "body", *m.SnapmirrorLabel, 31); err != nil {
		return err
	}

	return nil
}

var storageUnitSnapshotTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["valid","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitSnapshotTypeStatePropEnum = append(storageUnitSnapshotTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_snapshot
	// StorageUnitSnapshot
	// state
	// State
	// valid
	// END DEBUGGING
	// StorageUnitSnapshotStateValid captures enum value "valid"
	StorageUnitSnapshotStateValid string = "valid"

	// BEGIN DEBUGGING
	// storage_unit_snapshot
	// StorageUnitSnapshot
	// state
	// State
	// unknown
	// END DEBUGGING
	// StorageUnitSnapshotStateUnknown captures enum value "unknown"
	StorageUnitSnapshotStateUnknown string = "unknown"
)

// prop value enum
func (m *StorageUnitSnapshot) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitSnapshotTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *StorageUnitSnapshot) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnit) { // not required
		return nil
	}

	if m.StorageUnit != nil {
		if err := m.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot based on the context it is used
func (m *StorageUnitSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDelta(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwners(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReclaimableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersionUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshot) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateDelta(ctx context.Context, formats strfmt.Registry) error {

	if m.Delta != nil {
		if err := m.Delta.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("delta")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateLogicalSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "logical_size", "body", m.LogicalSize); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateOwners(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owners", "body", []*string(m.Owners)); err != nil {
		return err
	}

	for i := 0; i < len(m.Owners); i++ {

		if err := validate.ReadOnly(ctx, "owners"+"."+strconv.Itoa(i), "body", m.Owners[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateReclaimableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reclaimable_space", "body", m.ReclaimableSpace); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageUnit != nil {
		if err := m.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshot) contextValidateVersionUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version_uuid", "body", m.VersionUUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitSnapshot) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitSnapshotInlineSnaplock storage unit snapshot inline snaplock
//
// swagger:model storage_unit_snapshot_inline_snaplock
type StorageUnitSnapshotInlineSnaplock struct {

	// Indicates whether a SnapLock snapshot has expired.
	//
	// Example: true
	// Read Only: true
	Expired *bool `json:"expired,omitempty"`

	// SnapLock expiry time for the snapshot, if the snapshot is taken on a SnapLock storage unit. A snapshot is not allowed to be deleted or renamed until the SnapLock ComplianceClock time goes beyond this retention time. This option can be set during snapshot POST and snapshot PATCH on snapshot locking enabled volumes. It can also be used to extend the expiry time of a locked snapshot on a SnapLock for SnapVault destination consistency-group.
	//
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Indicates the remaining SnapLock expiry time of a locked snapshot. This field is set only when the remaining time interval is less than 136 years.
	//
	// Example: PT3H27M45S
	// Read Only: true
	TimeUntilExpiry *string `json:"time_until_expiry,omitempty"`
}

// Validate validates this storage unit snapshot inline snaplock
func (m *StorageUnitSnapshotInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline snaplock based on the context it is used
func (m *StorageUnitSnapshotInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExpired(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeUntilExpiry(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineSnaplock) contextValidateExpired(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"expired", "body", m.Expired); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSnapshotInlineSnaplock) contextValidateTimeUntilExpiry(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"time_until_expiry", "body", m.TimeUntilExpiry); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitSnapshotInlineStorageUnit The storage unit in which the snapshot is located. Valid in POST.
//
// swagger:model storage_unit_snapshot_inline_storage_unit
type StorageUnitSnapshotInlineStorageUnit struct {

	// links
	Links *StorageUnitSnapshotInlineStorageUnitInlineLinks `json:"_links,omitempty"`

	// The name of the storage unit.
	//
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the storage unit.
	//
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit snapshot inline storage unit
func (m *StorageUnitSnapshotInlineStorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineStorageUnit) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline storage unit based on the context it is used
func (m *StorageUnitSnapshotInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineStorageUnit) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitSnapshotInlineStorageUnitInlineLinks storage unit snapshot inline storage unit inline links
//
// swagger:model storage_unit_snapshot_inline_storage_unit_inline__links
type StorageUnitSnapshotInlineStorageUnitInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit snapshot inline storage unit inline links
func (m *StorageUnitSnapshotInlineStorageUnitInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineStorageUnitInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline storage unit inline links based on the context it is used
func (m *StorageUnitSnapshotInlineStorageUnitInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineStorageUnitInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineStorageUnitInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineStorageUnitInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineStorageUnitInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitSnapshotInlineSvm The SVM in which the storage unit is located. Valid in POST.
//
// swagger:model storage_unit_snapshot_inline_svm
type StorageUnitSnapshotInlineSvm struct {

	// links
	Links *StorageUnitSnapshotInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit snapshot inline svm
func (m *StorageUnitSnapshotInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline svm based on the context it is used
func (m *StorageUnitSnapshotInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineSvm) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitSnapshotInlineSvmInlineLinks storage unit snapshot inline svm inline links
//
// swagger:model storage_unit_snapshot_inline_svm_inline__links
type StorageUnitSnapshotInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this storage unit snapshot inline svm inline links
func (m *StorageUnitSnapshotInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline svm inline links based on the context it is used
func (m *StorageUnitSnapshotInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSnapshotInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitSnapshotInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
