// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StorageUnitSpaceSnapshot storage unit space snapshot
//
// swagger:model storage_unit_space_snapshot
type StorageUnitSpaceSnapshot struct {

	// autodelete
	Autodelete *StorageUnitSpaceSnapshotInlineAutodelete `json:"autodelete,omitempty"`

	// Size available for snapshots within the snapshot reserve, in bytes.
	// Read Only: true
	ReserveAvailable *int64 `json:"reserve_available,omitempty"`

	// The space that has been reserved for snapshot usage, in percent.
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// Size that has been reserved for snapshot usage, in bytes.
	// Read Only: true
	ReserveSize *int64 `json:"reserve_size,omitempty"`

	// Percentage of snapshot reserve size that has been used.
	// Read Only: true
	SpaceUsedPercent *int64 `json:"space_used_percent,omitempty"`

	// The total space used by snapshots, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this storage unit space snapshot
func (m *StorageUnitSpaceSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutodelete(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSpaceSnapshot) validateAutodelete(formats strfmt.Registry) error {
	if swag.IsZero(m.Autodelete) { // not required
		return nil
	}

	if m.Autodelete != nil {
		if err := m.Autodelete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("autodelete")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit space snapshot based on the context it is used
func (m *StorageUnitSpaceSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutodelete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserveAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserveSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpaceUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageUnitSpaceSnapshot) contextValidateAutodelete(ctx context.Context, formats strfmt.Registry) error {

	if m.Autodelete != nil {
		if err := m.Autodelete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("autodelete")
			}
			return err
		}
	}

	return nil
}

func (m *StorageUnitSpaceSnapshot) contextValidateReserveAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reserve_available", "body", m.ReserveAvailable); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSpaceSnapshot) contextValidateReserveSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reserve_size", "body", m.ReserveSize); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSpaceSnapshot) contextValidateSpaceUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space_used_percent", "body", m.SpaceUsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *StorageUnitSpaceSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitSpaceSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitSpaceSnapshot) UnmarshalBinary(b []byte) error {
	var res StorageUnitSpaceSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// StorageUnitSpaceSnapshotInlineAutodelete storage unit space snapshot inline autodelete
//
// swagger:model storage_unit_space_snapshot_inline_autodelete
type StorageUnitSpaceSnapshotInlineAutodelete struct {

	// Specifies whether snapshot autodelete is currently enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this storage unit space snapshot inline autodelete
func (m *StorageUnitSpaceSnapshotInlineAutodelete) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage unit space snapshot inline autodelete based on context it is used
func (m *StorageUnitSpaceSnapshotInlineAutodelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *StorageUnitSpaceSnapshotInlineAutodelete) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageUnitSpaceSnapshotInlineAutodelete) UnmarshalBinary(b []byte) error {
	var res StorageUnitSpaceSnapshotInlineAutodelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
