// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SupportedAlgorithms WebAuthn supported algorithms.
//
// swagger:model supported_algorithms
type SupportedAlgorithms struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// algorithm
	Algorithm *SupportedAlgorithmsInlineAlgorithm `json:"algorithm,omitempty"`

	// Used to identify a cluster or an SVM.
	// Read Only: true
	Owner *SvmReference `json:"owner,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`
}

// Validate validates this supported algorithms
func (m *SupportedAlgorithms) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAlgorithm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SupportedAlgorithms) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SupportedAlgorithms) validateAlgorithm(formats strfmt.Registry) error {
	if swag.IsZero(m.Algorithm) { // not required
		return nil
	}

	if m.Algorithm != nil {
		if err := m.Algorithm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("algorithm")
			}
			return err
		}
	}

	return nil
}

func (m *SupportedAlgorithms) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

var supportedAlgorithmsTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		supportedAlgorithmsTypeScopePropEnum = append(supportedAlgorithmsTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// supported_algorithms
	// SupportedAlgorithms
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// SupportedAlgorithmsScopeCluster captures enum value "cluster"
	SupportedAlgorithmsScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// supported_algorithms
	// SupportedAlgorithms
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// SupportedAlgorithmsScopeSvm captures enum value "svm"
	SupportedAlgorithmsScopeSvm string = "svm"
)

// prop value enum
func (m *SupportedAlgorithms) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, supportedAlgorithmsTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SupportedAlgorithms) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this supported algorithms based on the context it is used
func (m *SupportedAlgorithms) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAlgorithm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SupportedAlgorithms) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SupportedAlgorithms) contextValidateAlgorithm(ctx context.Context, formats strfmt.Registry) error {

	if m.Algorithm != nil {
		if err := m.Algorithm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("algorithm")
			}
			return err
		}
	}

	return nil
}

func (m *SupportedAlgorithms) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *SupportedAlgorithms) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SupportedAlgorithms) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SupportedAlgorithms) UnmarshalBinary(b []byte) error {
	var res SupportedAlgorithms
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SupportedAlgorithmsInlineAlgorithm supported algorithms inline algorithm
//
// swagger:model supported_algorithms_inline_algorithm
type SupportedAlgorithmsInlineAlgorithm struct {

	// Algorithm ID.
	// Example: -7
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Algorithm name.
	// Example: ES-256
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Algorithm type.
	// Read Only: true
	// Enum: ["public_key"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this supported algorithms inline algorithm
func (m *SupportedAlgorithmsInlineAlgorithm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var supportedAlgorithmsInlineAlgorithmTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["public_key"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		supportedAlgorithmsInlineAlgorithmTypeTypePropEnum = append(supportedAlgorithmsInlineAlgorithmTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// supported_algorithms_inline_algorithm
	// SupportedAlgorithmsInlineAlgorithm
	// type
	// Type
	// public_key
	// END DEBUGGING
	// SupportedAlgorithmsInlineAlgorithmTypePublicKey captures enum value "public_key"
	SupportedAlgorithmsInlineAlgorithmTypePublicKey string = "public_key"
)

// prop value enum
func (m *SupportedAlgorithmsInlineAlgorithm) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, supportedAlgorithmsInlineAlgorithmTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SupportedAlgorithmsInlineAlgorithm) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("algorithm"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this supported algorithms inline algorithm based on the context it is used
func (m *SupportedAlgorithmsInlineAlgorithm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SupportedAlgorithmsInlineAlgorithm) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "algorithm"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *SupportedAlgorithmsInlineAlgorithm) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "algorithm"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *SupportedAlgorithmsInlineAlgorithm) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "algorithm"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SupportedAlgorithmsInlineAlgorithm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SupportedAlgorithmsInlineAlgorithm) UnmarshalBinary(b []byte) error {
	var res SupportedAlgorithmsInlineAlgorithm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
