// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SupportedAlgorithmsResponse supported algorithms response
//
// swagger:model supported_algorithms_response
type SupportedAlgorithmsResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// Number of records.
	NumRecords *int64 `json:"num_records,omitempty"`

	// supported algorithms response inline records
	SupportedAlgorithmsResponseInlineRecords []*SupportedAlgorithms `json:"records,omitempty"`
}

// Validate validates this supported algorithms response
func (m *SupportedAlgorithmsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSupportedAlgorithmsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SupportedAlgorithmsResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SupportedAlgorithmsResponse) validateSupportedAlgorithmsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.SupportedAlgorithmsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.SupportedAlgorithmsResponseInlineRecords); i++ {
		if swag.IsZero(m.SupportedAlgorithmsResponseInlineRecords[i]) { // not required
			continue
		}

		if m.SupportedAlgorithmsResponseInlineRecords[i] != nil {
			if err := m.SupportedAlgorithmsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this supported algorithms response based on the context it is used
func (m *SupportedAlgorithmsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSupportedAlgorithmsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SupportedAlgorithmsResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SupportedAlgorithmsResponse) contextValidateSupportedAlgorithmsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SupportedAlgorithmsResponseInlineRecords); i++ {

		if m.SupportedAlgorithmsResponseInlineRecords[i] != nil {
			if err := m.SupportedAlgorithmsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SupportedAlgorithmsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SupportedAlgorithmsResponse) UnmarshalBinary(b []byte) error {
	var res SupportedAlgorithmsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
