// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Svm svm
//
// swagger:model svm
type Svm struct {

	// links
	Links *SvmInlineLinks `json:"_links,omitempty"`

	// This property is true when the administrator has delegated the aggregates for the SVM volumes.
	// Read Only: true
	AggregatesDelegated *bool `json:"aggregates_delegated,omitempty"`

	// Anti-ransomware related information for the SVM.
	AntiRansomware *ArwVserver `json:"anti_ransomware,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that no new file-extensions are observed in the volume in recent time. This parameter optionally specifies the recent time duration (in days) to be considered during which no new file-extension should be observed in a given volume to automatically switch the anti-ransomware state from “learning” to “enabled”. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchDurationWithoutNewFileExtension *int64 `json:"anti_ransomware_auto_switch_duration_without_new_file_extension,omitempty"`

	// This property specifies whether anti-ransomware state of the volumes in this SVM are automatically switched by the system from “learning” (dry-run) to “enabled” (active) state after sufficient learning. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchFromLearningToEnabled *bool `json:"anti_ransomware_auto_switch_from_learning_to_enabled,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have a minimum file count in “learning” state. This parameter optionally specifies the minimum number of newly created files in “learning” state in a given volume to automatically switch the anti-ransomware state from “learning” to “enabled”. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchMinimumFileCount *int64 `json:"anti_ransomware_auto_switch_minimum_file_count,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have minimum number of file extensions in “learning” state. This parameter optionally specifies the minimum number of new file extensions in “learning” state in a given volume to automatically switch the anti-ransomware state from “learning” to “enabled”. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchMinimumFileExtension *int64 `json:"anti_ransomware_auto_switch_minimum_file_extension,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have sufficient data ingested to do the learning. This parameter optionally specifies the minimum amount of data (in GB) to be written to a given volume during the learning period to automatically switch the anti-ransomware state from “learning” to “enabled”. The amount of data considered as ingested also includes the data that is deleted or overwritten after ingestion. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchMinimumIncomingData *string `json:"anti_ransomware_auto_switch_minimum_incoming_data,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should be in “learning” state for sufficient time period. This parameter optionally specifies the minimum number of days a given volume should be in “learning” state to automatically switch the anti-ransomware state from “learning” to “enabled”. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchMinimumLearningPeriod *int64 `json:"anti_ransomware_auto_switch_minimum_learning_period,omitempty"`

	// Specifies the default anti-ransomware state of the volumes in the SVM. The default "anti_ransomware_default_volume_state" property is disabled for POST operations. If this value is "disabled", anti-ransomware protection is disabled by default on the new volumes that are created in the SVM. If this value is "dry_run", anti-ransomware protection is in learning mode by default on the new volumes that are created in the SVM.  When the anti-ransomware license is not present, this property is ignored and volumes will be created with the "disabled" state. This value "dry_run" will no longer be supported in a future release.
	// Enum: ["disabled","dry_run"]
	AntiRansomwareDefaultVolumeState *string `json:"anti_ransomware_default_volume_state,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have sufficient data ingested to do the learning. This parameter optionally specifies the minimum amount of data (in GB) to be written to a given volume during the learning period to automatically switch the anti-ransomware state from “learning” to “enabled”. The amount of data considered as ingested also includes the data that is deleted or overwritten after ingestion. This field is no longer supported.
	AntiRansomwareIncomingWriteThreshold *string `json:"anti_ransomware_incoming_write_threshold,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have sufficient data ingested to do the learning. This parameter optionally specifies the minimum amount of data (in percentage) to be written to a given volume during the learning period to automatically switch the anti-ransomware state from “learning” to “enabled”. The amount of data considered as ingested also includes the data that is deleted or overwritten after ingestion. This field will no longer be supported in a future release.
	AntiRansomwareIncomingWriteThresholdPercent *string `json:"anti_ransomware_incoming_write_threshold_percent,omitempty"`

	// Specifies whether volume activity tracking is automatically enabled on volumes that are created in the SVM.
	AutoEnableActivityTracking *bool `json:"auto_enable_activity_tracking,omitempty"`

	// Specifies whether file system analytics is automatically enabled on volumes that are created in the SVM.
	AutoEnableAnalytics *bool `json:"auto_enable_analytics,omitempty"`

	// certificate
	Certificate *SvmInlineCertificate `json:"certificate,omitempty"`

	// cifs
	Cifs *SvmInlineCifs `json:"cifs,omitempty"`

	// Comment
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// dns
	DNS *SvmInlineDNS `json:"dns,omitempty"`

	// fcp
	Fcp *SvmInlineFcp `json:"fcp,omitempty"`

	// ipspace
	Ipspace *SvmInlineIpspace `json:"ipspace,omitempty"`

	// Indicates whether logical space enforcement for the SVM is enabled.
	IsSpaceEnforcementLogical *bool `json:"is_space_enforcement_logical,omitempty"`

	// Indicates whether logical space reporting for the SVM is enabled.
	IsSpaceReportingLogical *bool `json:"is_space_reporting_logical,omitempty"`

	// iscsi
	Iscsi *SvmInlineIscsi `json:"iscsi,omitempty"`

	// Default volume language code. UTF-8 encoded languages are valid in POST or PATCH. Non UTF-8 language encodings are for backward compatibility and are not valid input for POST and PATCH requests.
	// Example: c.utf_8
	// Enum: ["c","da","de","en","en_us","es","fi","fr","he","it","ja","ja_jp.pck","ko","no","nl","pt","sv","zh","zh.gbk","zh_tw","zh_tw.big5","c.utf_8","ar","ar.utf_8","cs","cs.utf_8","da.utf_8","de.utf_8","en.utf_8","en_us.utf_8","es.utf_8","fi.utf_8","fr.utf_8","he.utf_8","hr","hr.utf_8","hu","hu.utf_8","it.utf_8","ja.utf_8","ja_v1","ja_v1.utf_8","ja_jp.pck.utf_8","ja_jp.932","ja_jp.932.utf_8","ja_jp.pck_v2","ja_jp.pck_v2.utf_8","ko.utf_8","no.utf_8","nl.utf_8","pl","pl.utf_8","pt.utf_8","ro","ro.utf_8","ru","ru.utf_8","sk","sk.utf_8","sl","sl.utf_8","sv.utf_8","tr","tr.utf_8","zh.utf_8","zh.gbk.utf_8","zh_tw.utf_8","zh_tw.big5.utf_8","utf8mb4"]
	Language *string `json:"language,omitempty"`

	// ldap
	Ldap *SvmInlineLdap `json:"ldap,omitempty"`

	// This property is used by cluster administrator to specify the limit on maximum number of volumes allowed in the SVM. The value can be either the string "unlimited" or a number.
	MaxVolumes *string `json:"max_volumes,omitempty"`

	// The name of the SVM.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// ndmp
	Ndmp *SvmInlineNdmp `json:"ndmp,omitempty"`

	// nfs
	Nfs *SvmInlineNfs `json:"nfs,omitempty"`

	// nis
	Nis *SvmInlineNis `json:"nis,omitempty"`

	// nsswitch
	Nsswitch *SvmInlineNsswitch `json:"nsswitch,omitempty"`

	// Number of volumes in the recovery queue.
	// Read Only: true
	NumberOfVolumesInRecoveryQueue *int64 `json:"number_of_volumes_in_recovery_queue,omitempty"`

	// nvme
	Nvme *SvmInlineNvme `json:"nvme,omitempty"`

	// qos adaptive policy group template
	QosAdaptivePolicyGroupTemplate *SvmInlineQosAdaptivePolicyGroupTemplate `json:"qos_adaptive_policy_group_template,omitempty"`

	// qos policy
	QosPolicy *SvmInlineQosPolicy `json:"qos_policy,omitempty"`

	// qos policy group template
	QosPolicyGroupTemplate *SvmInlineQosPolicyGroupTemplate `json:"qos_policy_group_template,omitempty"`

	// s3
	S3 *SvmInlineS3 `json:"s3,omitempty"`

	// snapmirror
	Snapmirror *SvmInlineSnapmirror `json:"snapmirror,omitempty"`

	// Specifies whether snapshot autodelete is automatically enabled on storage units that are created in the SVM.
	SnapshotAutodeleteEnabled *bool `json:"snapshot_autodelete_enabled,omitempty"`

	// snapshot policy
	SnapshotPolicy *SvmInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// Specifies the amount of space reserved for snapshots on the storage units that are created in the SVM.
	SnapshotReservePercent *int64 `json:"snapshot_reserve_percent,omitempty"`

	// SVM State
	// Example: running
	// Enum: ["starting","running","stopping","stopped","deleting","initializing"]
	State *string `json:"state,omitempty"`

	// storage
	Storage *SvmInlineStorage `json:"storage,omitempty"`

	// SVM subtype. The SVM subtype sync_destination is created automatically when an SVM of subtype sync_source is created on the source MetroCluster cluster. A POST request with sync_destination as SVM subtype is invalid. SVM of subtype data_engine cannot be explicitly created by the admin and most management changes are not allowed on it.
	// Enum: ["default","dp_destination","sync_source","sync_destination","data_engine"]
	Subtype *string `json:"subtype,omitempty"`

	// List of allowed aggregates for SVM volumes. An administrator is allowed to create volumes on these aggregates.
	SvmInlineAggregates []*SvmInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// FC Interface for the SVM
	SvmInlineFcInterfaces []*FcInterfaceSvm `json:"fc_interfaces,omitempty"`

	// IP interfaces for the SVM
	SvmInlineIPInterfaces []*IPInterfaceSvm `json:"ip_interfaces,omitempty"`

	// Optional array of routes for the SVM
	SvmInlineRoutes []*NetworkRouteForSvm `json:"routes,omitempty"`

	// Sum of the sizes of the volumes in the recovery queue.
	// Read Only: true
	TotalVolumeSizeInRecoveryQueue *int64 `json:"total_volume_size_in_recovery_queue,omitempty"`

	// The unique identifier of the SVM.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm
func (m *Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAntiRansomware(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAntiRansomwareDefaultVolumeState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDNS(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFcp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIscsi(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLanguage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLdap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNdmp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNfs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNis(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNsswitch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvme(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosAdaptivePolicyGroupTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicyGroupTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapmirror(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubtype(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmInlineFcInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmInlineIPInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmInlineRoutes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateAntiRansomware(formats strfmt.Registry) error {
	if swag.IsZero(m.AntiRansomware) { // not required
		return nil
	}

	if m.AntiRansomware != nil {
		if err := m.AntiRansomware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware")
			}
			return err
		}
	}

	return nil
}

var svmTypeAntiRansomwareDefaultVolumeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","dry_run"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmTypeAntiRansomwareDefaultVolumeStatePropEnum = append(svmTypeAntiRansomwareDefaultVolumeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm
	// Svm
	// anti_ransomware_default_volume_state
	// AntiRansomwareDefaultVolumeState
	// disabled
	// END DEBUGGING
	// SvmAntiRansomwareDefaultVolumeStateDisabled captures enum value "disabled"
	SvmAntiRansomwareDefaultVolumeStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// anti_ransomware_default_volume_state
	// AntiRansomwareDefaultVolumeState
	// dry_run
	// END DEBUGGING
	// SvmAntiRansomwareDefaultVolumeStateDryRun captures enum value "dry_run"
	SvmAntiRansomwareDefaultVolumeStateDryRun string = "dry_run"
)

// prop value enum
func (m *Svm) validateAntiRansomwareDefaultVolumeStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmTypeAntiRansomwareDefaultVolumeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Svm) validateAntiRansomwareDefaultVolumeState(formats strfmt.Registry) error {
	if swag.IsZero(m.AntiRansomwareDefaultVolumeState) { // not required
		return nil
	}

	// value enum
	if err := m.validateAntiRansomwareDefaultVolumeStateEnum("anti_ransomware_default_volume_state", "body", *m.AntiRansomwareDefaultVolumeState); err != nil {
		return err
	}

	return nil
}

func (m *Svm) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(m.Cifs) { // not required
		return nil
	}

	if m.Cifs != nil {
		if err := m.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 255); err != nil {
		return err
	}

	return nil
}

func (m *Svm) validateDNS(formats strfmt.Registry) error {
	if swag.IsZero(m.DNS) { // not required
		return nil
	}

	if m.DNS != nil {
		if err := m.DNS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateFcp(formats strfmt.Registry) error {
	if swag.IsZero(m.Fcp) { // not required
		return nil
	}

	if m.Fcp != nil {
		if err := m.Fcp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fcp")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateIscsi(formats strfmt.Registry) error {
	if swag.IsZero(m.Iscsi) { // not required
		return nil
	}

	if m.Iscsi != nil {
		if err := m.Iscsi.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iscsi")
			}
			return err
		}
	}

	return nil
}

var svmTypeLanguagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["c","da","de","en","en_us","es","fi","fr","he","it","ja","ja_jp.pck","ko","no","nl","pt","sv","zh","zh.gbk","zh_tw","zh_tw.big5","c.utf_8","ar","ar.utf_8","cs","cs.utf_8","da.utf_8","de.utf_8","en.utf_8","en_us.utf_8","es.utf_8","fi.utf_8","fr.utf_8","he.utf_8","hr","hr.utf_8","hu","hu.utf_8","it.utf_8","ja.utf_8","ja_v1","ja_v1.utf_8","ja_jp.pck.utf_8","ja_jp.932","ja_jp.932.utf_8","ja_jp.pck_v2","ja_jp.pck_v2.utf_8","ko.utf_8","no.utf_8","nl.utf_8","pl","pl.utf_8","pt.utf_8","ro","ro.utf_8","ru","ru.utf_8","sk","sk.utf_8","sl","sl.utf_8","sv.utf_8","tr","tr.utf_8","zh.utf_8","zh.gbk.utf_8","zh_tw.utf_8","zh_tw.big5.utf_8","utf8mb4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmTypeLanguagePropEnum = append(svmTypeLanguagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// c
	// END DEBUGGING
	// SvmLanguageC captures enum value "c"
	SvmLanguageC string = "c"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// da
	// END DEBUGGING
	// SvmLanguageDa captures enum value "da"
	SvmLanguageDa string = "da"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// de
	// END DEBUGGING
	// SvmLanguageDe captures enum value "de"
	SvmLanguageDe string = "de"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// en
	// END DEBUGGING
	// SvmLanguageEn captures enum value "en"
	SvmLanguageEn string = "en"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// en_us
	// END DEBUGGING
	// SvmLanguageEnUs captures enum value "en_us"
	SvmLanguageEnUs string = "en_us"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// es
	// END DEBUGGING
	// SvmLanguageEs captures enum value "es"
	SvmLanguageEs string = "es"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// fi
	// END DEBUGGING
	// SvmLanguageFi captures enum value "fi"
	SvmLanguageFi string = "fi"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// fr
	// END DEBUGGING
	// SvmLanguageFr captures enum value "fr"
	SvmLanguageFr string = "fr"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// he
	// END DEBUGGING
	// SvmLanguageHe captures enum value "he"
	SvmLanguageHe string = "he"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// it
	// END DEBUGGING
	// SvmLanguageIt captures enum value "it"
	SvmLanguageIt string = "it"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja
	// END DEBUGGING
	// SvmLanguageJa captures enum value "ja"
	SvmLanguageJa string = "ja"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja_jp.pck
	// END DEBUGGING
	// SvmLanguageJaJpDotPck captures enum value "ja_jp.pck"
	SvmLanguageJaJpDotPck string = "ja_jp.pck"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ko
	// END DEBUGGING
	// SvmLanguageKo captures enum value "ko"
	SvmLanguageKo string = "ko"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// no
	// END DEBUGGING
	// SvmLanguageNo captures enum value "no"
	SvmLanguageNo string = "no"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// nl
	// END DEBUGGING
	// SvmLanguageNl captures enum value "nl"
	SvmLanguageNl string = "nl"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// pt
	// END DEBUGGING
	// SvmLanguagePt captures enum value "pt"
	SvmLanguagePt string = "pt"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// sv
	// END DEBUGGING
	// SvmLanguageSv captures enum value "sv"
	SvmLanguageSv string = "sv"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// zh
	// END DEBUGGING
	// SvmLanguageZh captures enum value "zh"
	SvmLanguageZh string = "zh"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// zh.gbk
	// END DEBUGGING
	// SvmLanguageZhDotGbk captures enum value "zh.gbk"
	SvmLanguageZhDotGbk string = "zh.gbk"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// zh_tw
	// END DEBUGGING
	// SvmLanguageZhTw captures enum value "zh_tw"
	SvmLanguageZhTw string = "zh_tw"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// zh_tw.big5
	// END DEBUGGING
	// SvmLanguageZhTwDotBig5 captures enum value "zh_tw.big5"
	SvmLanguageZhTwDotBig5 string = "zh_tw.big5"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// c.utf_8
	// END DEBUGGING
	// SvmLanguageCDotUTF8 captures enum value "c.utf_8"
	SvmLanguageCDotUTF8 string = "c.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ar
	// END DEBUGGING
	// SvmLanguageAr captures enum value "ar"
	SvmLanguageAr string = "ar"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ar.utf_8
	// END DEBUGGING
	// SvmLanguageArDotUTF8 captures enum value "ar.utf_8"
	SvmLanguageArDotUTF8 string = "ar.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// cs
	// END DEBUGGING
	// SvmLanguageCs captures enum value "cs"
	SvmLanguageCs string = "cs"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// cs.utf_8
	// END DEBUGGING
	// SvmLanguageCsDotUTF8 captures enum value "cs.utf_8"
	SvmLanguageCsDotUTF8 string = "cs.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// da.utf_8
	// END DEBUGGING
	// SvmLanguageDaDotUTF8 captures enum value "da.utf_8"
	SvmLanguageDaDotUTF8 string = "da.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// de.utf_8
	// END DEBUGGING
	// SvmLanguageDeDotUTF8 captures enum value "de.utf_8"
	SvmLanguageDeDotUTF8 string = "de.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// en.utf_8
	// END DEBUGGING
	// SvmLanguageEnDotUTF8 captures enum value "en.utf_8"
	SvmLanguageEnDotUTF8 string = "en.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// en_us.utf_8
	// END DEBUGGING
	// SvmLanguageEnUsDotUTF8 captures enum value "en_us.utf_8"
	SvmLanguageEnUsDotUTF8 string = "en_us.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// es.utf_8
	// END DEBUGGING
	// SvmLanguageEsDotUTF8 captures enum value "es.utf_8"
	SvmLanguageEsDotUTF8 string = "es.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// fi.utf_8
	// END DEBUGGING
	// SvmLanguageFiDotUTF8 captures enum value "fi.utf_8"
	SvmLanguageFiDotUTF8 string = "fi.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// fr.utf_8
	// END DEBUGGING
	// SvmLanguageFrDotUTF8 captures enum value "fr.utf_8"
	SvmLanguageFrDotUTF8 string = "fr.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// he.utf_8
	// END DEBUGGING
	// SvmLanguageHeDotUTF8 captures enum value "he.utf_8"
	SvmLanguageHeDotUTF8 string = "he.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// hr
	// END DEBUGGING
	// SvmLanguageHr captures enum value "hr"
	SvmLanguageHr string = "hr"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// hr.utf_8
	// END DEBUGGING
	// SvmLanguageHrDotUTF8 captures enum value "hr.utf_8"
	SvmLanguageHrDotUTF8 string = "hr.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// hu
	// END DEBUGGING
	// SvmLanguageHu captures enum value "hu"
	SvmLanguageHu string = "hu"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// hu.utf_8
	// END DEBUGGING
	// SvmLanguageHuDotUTF8 captures enum value "hu.utf_8"
	SvmLanguageHuDotUTF8 string = "hu.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// it.utf_8
	// END DEBUGGING
	// SvmLanguageItDotUTF8 captures enum value "it.utf_8"
	SvmLanguageItDotUTF8 string = "it.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja.utf_8
	// END DEBUGGING
	// SvmLanguageJaDotUTF8 captures enum value "ja.utf_8"
	SvmLanguageJaDotUTF8 string = "ja.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja_v1
	// END DEBUGGING
	// SvmLanguageJaV1 captures enum value "ja_v1"
	SvmLanguageJaV1 string = "ja_v1"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja_v1.utf_8
	// END DEBUGGING
	// SvmLanguageJaV1DotUTF8 captures enum value "ja_v1.utf_8"
	SvmLanguageJaV1DotUTF8 string = "ja_v1.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja_jp.pck.utf_8
	// END DEBUGGING
	// SvmLanguageJaJpDotPckDotUTF8 captures enum value "ja_jp.pck.utf_8"
	SvmLanguageJaJpDotPckDotUTF8 string = "ja_jp.pck.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja_jp.932
	// END DEBUGGING
	// SvmLanguageJaJpDot932 captures enum value "ja_jp.932"
	SvmLanguageJaJpDot932 string = "ja_jp.932"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja_jp.932.utf_8
	// END DEBUGGING
	// SvmLanguageJaJpDot932DotUTF8 captures enum value "ja_jp.932.utf_8"
	SvmLanguageJaJpDot932DotUTF8 string = "ja_jp.932.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja_jp.pck_v2
	// END DEBUGGING
	// SvmLanguageJaJpDotPckV2 captures enum value "ja_jp.pck_v2"
	SvmLanguageJaJpDotPckV2 string = "ja_jp.pck_v2"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ja_jp.pck_v2.utf_8
	// END DEBUGGING
	// SvmLanguageJaJpDotPckV2DotUTF8 captures enum value "ja_jp.pck_v2.utf_8"
	SvmLanguageJaJpDotPckV2DotUTF8 string = "ja_jp.pck_v2.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ko.utf_8
	// END DEBUGGING
	// SvmLanguageKoDotUTF8 captures enum value "ko.utf_8"
	SvmLanguageKoDotUTF8 string = "ko.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// no.utf_8
	// END DEBUGGING
	// SvmLanguageNoDotUTF8 captures enum value "no.utf_8"
	SvmLanguageNoDotUTF8 string = "no.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// nl.utf_8
	// END DEBUGGING
	// SvmLanguageNlDotUTF8 captures enum value "nl.utf_8"
	SvmLanguageNlDotUTF8 string = "nl.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// pl
	// END DEBUGGING
	// SvmLanguagePl captures enum value "pl"
	SvmLanguagePl string = "pl"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// pl.utf_8
	// END DEBUGGING
	// SvmLanguagePlDotUTF8 captures enum value "pl.utf_8"
	SvmLanguagePlDotUTF8 string = "pl.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// pt.utf_8
	// END DEBUGGING
	// SvmLanguagePtDotUTF8 captures enum value "pt.utf_8"
	SvmLanguagePtDotUTF8 string = "pt.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ro
	// END DEBUGGING
	// SvmLanguageRo captures enum value "ro"
	SvmLanguageRo string = "ro"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ro.utf_8
	// END DEBUGGING
	// SvmLanguageRoDotUTF8 captures enum value "ro.utf_8"
	SvmLanguageRoDotUTF8 string = "ro.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ru
	// END DEBUGGING
	// SvmLanguageRu captures enum value "ru"
	SvmLanguageRu string = "ru"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// ru.utf_8
	// END DEBUGGING
	// SvmLanguageRuDotUTF8 captures enum value "ru.utf_8"
	SvmLanguageRuDotUTF8 string = "ru.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// sk
	// END DEBUGGING
	// SvmLanguageSk captures enum value "sk"
	SvmLanguageSk string = "sk"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// sk.utf_8
	// END DEBUGGING
	// SvmLanguageSkDotUTF8 captures enum value "sk.utf_8"
	SvmLanguageSkDotUTF8 string = "sk.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// sl
	// END DEBUGGING
	// SvmLanguageSl captures enum value "sl"
	SvmLanguageSl string = "sl"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// sl.utf_8
	// END DEBUGGING
	// SvmLanguageSlDotUTF8 captures enum value "sl.utf_8"
	SvmLanguageSlDotUTF8 string = "sl.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// sv.utf_8
	// END DEBUGGING
	// SvmLanguageSvDotUTF8 captures enum value "sv.utf_8"
	SvmLanguageSvDotUTF8 string = "sv.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// tr
	// END DEBUGGING
	// SvmLanguageTr captures enum value "tr"
	SvmLanguageTr string = "tr"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// tr.utf_8
	// END DEBUGGING
	// SvmLanguageTrDotUTF8 captures enum value "tr.utf_8"
	SvmLanguageTrDotUTF8 string = "tr.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// zh.utf_8
	// END DEBUGGING
	// SvmLanguageZhDotUTF8 captures enum value "zh.utf_8"
	SvmLanguageZhDotUTF8 string = "zh.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// zh.gbk.utf_8
	// END DEBUGGING
	// SvmLanguageZhDotGbkDotUTF8 captures enum value "zh.gbk.utf_8"
	SvmLanguageZhDotGbkDotUTF8 string = "zh.gbk.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// zh_tw.utf_8
	// END DEBUGGING
	// SvmLanguageZhTwDotUTF8 captures enum value "zh_tw.utf_8"
	SvmLanguageZhTwDotUTF8 string = "zh_tw.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// zh_tw.big5.utf_8
	// END DEBUGGING
	// SvmLanguageZhTwDotBig5DotUTF8 captures enum value "zh_tw.big5.utf_8"
	SvmLanguageZhTwDotBig5DotUTF8 string = "zh_tw.big5.utf_8"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// language
	// Language
	// utf8mb4
	// END DEBUGGING
	// SvmLanguageUtf8mb4 captures enum value "utf8mb4"
	SvmLanguageUtf8mb4 string = "utf8mb4"
)

// prop value enum
func (m *Svm) validateLanguageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmTypeLanguagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Svm) validateLanguage(formats strfmt.Registry) error {
	if swag.IsZero(m.Language) { // not required
		return nil
	}

	// value enum
	if err := m.validateLanguageEnum("language", "body", *m.Language); err != nil {
		return err
	}

	return nil
}

func (m *Svm) validateLdap(formats strfmt.Registry) error {
	if swag.IsZero(m.Ldap) { // not required
		return nil
	}

	if m.Ldap != nil {
		if err := m.Ldap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ldap")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateNdmp(formats strfmt.Registry) error {
	if swag.IsZero(m.Ndmp) { // not required
		return nil
	}

	if m.Ndmp != nil {
		if err := m.Ndmp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ndmp")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateNfs(formats strfmt.Registry) error {
	if swag.IsZero(m.Nfs) { // not required
		return nil
	}

	if m.Nfs != nil {
		if err := m.Nfs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateNis(formats strfmt.Registry) error {
	if swag.IsZero(m.Nis) { // not required
		return nil
	}

	if m.Nis != nil {
		if err := m.Nis.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nis")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateNsswitch(formats strfmt.Registry) error {
	if swag.IsZero(m.Nsswitch) { // not required
		return nil
	}

	if m.Nsswitch != nil {
		if err := m.Nsswitch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nsswitch")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateNvme(formats strfmt.Registry) error {
	if swag.IsZero(m.Nvme) { // not required
		return nil
	}

	if m.Nvme != nil {
		if err := m.Nvme.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvme")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateQosAdaptivePolicyGroupTemplate(formats strfmt.Registry) error {
	if swag.IsZero(m.QosAdaptivePolicyGroupTemplate) { // not required
		return nil
	}

	if m.QosAdaptivePolicyGroupTemplate != nil {
		if err := m.QosAdaptivePolicyGroupTemplate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_adaptive_policy_group_template")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateQosPolicyGroupTemplate(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicyGroupTemplate) { // not required
		return nil
	}

	if m.QosPolicyGroupTemplate != nil {
		if err := m.QosPolicyGroupTemplate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy_group_template")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateS3(formats strfmt.Registry) error {
	if swag.IsZero(m.S3) { // not required
		return nil
	}

	if m.S3 != nil {
		if err := m.S3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateSnapmirror(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapmirror) { // not required
		return nil
	}

	if m.Snapmirror != nil {
		if err := m.Snapmirror.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapmirror")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

var svmTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["starting","running","stopping","stopped","deleting","initializing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmTypeStatePropEnum = append(svmTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm
	// Svm
	// state
	// State
	// starting
	// END DEBUGGING
	// SvmStateStarting captures enum value "starting"
	SvmStateStarting string = "starting"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// state
	// State
	// running
	// END DEBUGGING
	// SvmStateRunning captures enum value "running"
	SvmStateRunning string = "running"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// state
	// State
	// stopping
	// END DEBUGGING
	// SvmStateStopping captures enum value "stopping"
	SvmStateStopping string = "stopping"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// state
	// State
	// stopped
	// END DEBUGGING
	// SvmStateStopped captures enum value "stopped"
	SvmStateStopped string = "stopped"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// state
	// State
	// deleting
	// END DEBUGGING
	// SvmStateDeleting captures enum value "deleting"
	SvmStateDeleting string = "deleting"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// state
	// State
	// initializing
	// END DEBUGGING
	// SvmStateInitializing captures enum value "initializing"
	SvmStateInitializing string = "initializing"
)

// prop value enum
func (m *Svm) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Svm) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Svm) validateStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.Storage) { // not required
		return nil
	}

	if m.Storage != nil {
		if err := m.Storage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage")
			}
			return err
		}
	}

	return nil
}

var svmTypeSubtypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default","dp_destination","sync_source","sync_destination","data_engine"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmTypeSubtypePropEnum = append(svmTypeSubtypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm
	// Svm
	// subtype
	// Subtype
	// default
	// END DEBUGGING
	// SvmSubtypeDefault captures enum value "default"
	SvmSubtypeDefault string = "default"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// subtype
	// Subtype
	// dp_destination
	// END DEBUGGING
	// SvmSubtypeDpDestination captures enum value "dp_destination"
	SvmSubtypeDpDestination string = "dp_destination"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// subtype
	// Subtype
	// sync_source
	// END DEBUGGING
	// SvmSubtypeSyncSource captures enum value "sync_source"
	SvmSubtypeSyncSource string = "sync_source"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// subtype
	// Subtype
	// sync_destination
	// END DEBUGGING
	// SvmSubtypeSyncDestination captures enum value "sync_destination"
	SvmSubtypeSyncDestination string = "sync_destination"

	// BEGIN DEBUGGING
	// svm
	// Svm
	// subtype
	// Subtype
	// data_engine
	// END DEBUGGING
	// SvmSubtypeDataEngine captures enum value "data_engine"
	SvmSubtypeDataEngine string = "data_engine"
)

// prop value enum
func (m *Svm) validateSubtypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmTypeSubtypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Svm) validateSubtype(formats strfmt.Registry) error {
	if swag.IsZero(m.Subtype) { // not required
		return nil
	}

	// value enum
	if err := m.validateSubtypeEnum("subtype", "body", *m.Subtype); err != nil {
		return err
	}

	return nil
}

func (m *Svm) validateSvmInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmInlineAggregates); i++ {
		if swag.IsZero(m.SvmInlineAggregates[i]) { // not required
			continue
		}

		if m.SvmInlineAggregates[i] != nil {
			if err := m.SvmInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Svm) validateSvmInlineFcInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmInlineFcInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmInlineFcInterfaces); i++ {
		if swag.IsZero(m.SvmInlineFcInterfaces[i]) { // not required
			continue
		}

		if m.SvmInlineFcInterfaces[i] != nil {
			if err := m.SvmInlineFcInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fc_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Svm) validateSvmInlineIPInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmInlineIPInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmInlineIPInterfaces); i++ {
		if swag.IsZero(m.SvmInlineIPInterfaces[i]) { // not required
			continue
		}

		if m.SvmInlineIPInterfaces[i] != nil {
			if err := m.SvmInlineIPInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Svm) validateSvmInlineRoutes(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmInlineRoutes) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmInlineRoutes); i++ {
		if swag.IsZero(m.SvmInlineRoutes[i]) { // not required
			continue
		}

		if m.SvmInlineRoutes[i] != nil {
			if err := m.SvmInlineRoutes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("routes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm based on the context it is used
func (m *Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAggregatesDelegated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAntiRansomware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDNS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFcp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIscsi(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLdap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNdmp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNis(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNsswitch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumberOfVolumesInRecoveryQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvme(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosAdaptivePolicyGroupTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicyGroupTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapmirror(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmInlineFcInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmInlineIPInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmInlineRoutes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalVolumeSizeInRecoveryQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateAggregatesDelegated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregates_delegated", "body", m.AggregatesDelegated); err != nil {
		return err
	}

	return nil
}

func (m *Svm) contextValidateAntiRansomware(ctx context.Context, formats strfmt.Registry) error {

	if m.AntiRansomware != nil {
		if err := m.AntiRansomware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("anti_ransomware")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if m.Cifs != nil {
		if err := m.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateDNS(ctx context.Context, formats strfmt.Registry) error {

	if m.DNS != nil {
		if err := m.DNS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateFcp(ctx context.Context, formats strfmt.Registry) error {

	if m.Fcp != nil {
		if err := m.Fcp.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fcp")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateIscsi(ctx context.Context, formats strfmt.Registry) error {

	if m.Iscsi != nil {
		if err := m.Iscsi.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iscsi")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateLdap(ctx context.Context, formats strfmt.Registry) error {

	if m.Ldap != nil {
		if err := m.Ldap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ldap")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateNdmp(ctx context.Context, formats strfmt.Registry) error {

	if m.Ndmp != nil {
		if err := m.Ndmp.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ndmp")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateNfs(ctx context.Context, formats strfmt.Registry) error {

	if m.Nfs != nil {
		if err := m.Nfs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateNis(ctx context.Context, formats strfmt.Registry) error {

	if m.Nis != nil {
		if err := m.Nis.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nis")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateNsswitch(ctx context.Context, formats strfmt.Registry) error {

	if m.Nsswitch != nil {
		if err := m.Nsswitch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nsswitch")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateNumberOfVolumesInRecoveryQueue(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "number_of_volumes_in_recovery_queue", "body", m.NumberOfVolumesInRecoveryQueue); err != nil {
		return err
	}

	return nil
}

func (m *Svm) contextValidateNvme(ctx context.Context, formats strfmt.Registry) error {

	if m.Nvme != nil {
		if err := m.Nvme.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvme")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateQosAdaptivePolicyGroupTemplate(ctx context.Context, formats strfmt.Registry) error {

	if m.QosAdaptivePolicyGroupTemplate != nil {
		if err := m.QosAdaptivePolicyGroupTemplate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_adaptive_policy_group_template")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateQosPolicyGroupTemplate(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicyGroupTemplate != nil {
		if err := m.QosPolicyGroupTemplate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy_group_template")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateS3(ctx context.Context, formats strfmt.Registry) error {

	if m.S3 != nil {
		if err := m.S3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateSnapmirror(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapmirror != nil {
		if err := m.Snapmirror.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapmirror")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.Storage != nil {
		if err := m.Storage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage")
			}
			return err
		}
	}

	return nil
}

func (m *Svm) contextValidateSvmInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmInlineAggregates); i++ {

		if m.SvmInlineAggregates[i] != nil {
			if err := m.SvmInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Svm) contextValidateSvmInlineFcInterfaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmInlineFcInterfaces); i++ {

		if m.SvmInlineFcInterfaces[i] != nil {
			if err := m.SvmInlineFcInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fc_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Svm) contextValidateSvmInlineIPInterfaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmInlineIPInterfaces); i++ {

		if m.SvmInlineIPInterfaces[i] != nil {
			if err := m.SvmInlineIPInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Svm) contextValidateSvmInlineRoutes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmInlineRoutes); i++ {

		if m.SvmInlineRoutes[i] != nil {
			if err := m.SvmInlineRoutes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("routes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Svm) contextValidateTotalVolumeSizeInRecoveryQueue(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_volume_size_in_recovery_queue", "body", m.TotalVolumeSizeInRecoveryQueue); err != nil {
		return err
	}

	return nil
}

func (m *Svm) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Svm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Svm) UnmarshalBinary(b []byte) error {
	var res Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineAggregatesInlineArrayItem svm inline aggregates inline array item
//
// swagger:model svm_inline_aggregates_inline_array_item
type SvmInlineAggregatesInlineArrayItem struct {

	// links
	Links *SvmInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Space available, in bytes.
	// Example: 10156560384
	// Read Only: true
	AvailableSize *int64 `json:"available_size,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// SnapLock type.
	// Read Only: true
	// Enum: ["non_snaplock","compliance","enterprise"]
	SnaplockType *string `json:"snaplock_type,omitempty"`

	// Aggregate state.
	// Read Only: true
	// Enum: ["online","offline","unknown"]
	State *string `json:"state,omitempty"`

	// Type of aggregate.
	// Read Only: true
	// Enum: ["hdd","hybrid","lun","ssd","vmdisk"]
	Type *string `json:"type,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline aggregates inline array item
func (m *SvmInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplockType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var svmInlineAggregatesInlineArrayItemTypeSnaplockTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["non_snaplock","compliance","enterprise"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmInlineAggregatesInlineArrayItemTypeSnaplockTypePropEnum = append(svmInlineAggregatesInlineArrayItemTypeSnaplockTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// snaplock_type
	// SnaplockType
	// non_snaplock
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	SvmInlineAggregatesInlineArrayItemSnaplockTypeNonSnaplock string = "non_snaplock"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// snaplock_type
	// SnaplockType
	// compliance
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemSnaplockTypeCompliance captures enum value "compliance"
	SvmInlineAggregatesInlineArrayItemSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// snaplock_type
	// SnaplockType
	// enterprise
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemSnaplockTypeEnterprise captures enum value "enterprise"
	SvmInlineAggregatesInlineArrayItemSnaplockTypeEnterprise string = "enterprise"
)

// prop value enum
func (m *SvmInlineAggregatesInlineArrayItem) validateSnaplockTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmInlineAggregatesInlineArrayItemTypeSnaplockTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) validateSnaplockType(formats strfmt.Registry) error {
	if swag.IsZero(m.SnaplockType) { // not required
		return nil
	}

	// value enum
	if err := m.validateSnaplockTypeEnum("snaplock_type", "body", *m.SnaplockType); err != nil {
		return err
	}

	return nil
}

var svmInlineAggregatesInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmInlineAggregatesInlineArrayItemTypeStatePropEnum = append(svmInlineAggregatesInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// state
	// State
	// online
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemStateOnline captures enum value "online"
	SvmInlineAggregatesInlineArrayItemStateOnline string = "online"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// state
	// State
	// offline
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemStateOffline captures enum value "offline"
	SvmInlineAggregatesInlineArrayItemStateOffline string = "offline"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// state
	// State
	// unknown
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemStateUnknown captures enum value "unknown"
	SvmInlineAggregatesInlineArrayItemStateUnknown string = "unknown"
)

// prop value enum
func (m *SvmInlineAggregatesInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmInlineAggregatesInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var svmInlineAggregatesInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hdd","hybrid","lun","ssd","vmdisk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmInlineAggregatesInlineArrayItemTypeTypePropEnum = append(svmInlineAggregatesInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// hdd
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeHdd captures enum value "hdd"
	SvmInlineAggregatesInlineArrayItemTypeHdd string = "hdd"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// hybrid
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeHybrid captures enum value "hybrid"
	SvmInlineAggregatesInlineArrayItemTypeHybrid string = "hybrid"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// lun
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeLun captures enum value "lun"
	SvmInlineAggregatesInlineArrayItemTypeLun string = "lun"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// ssd
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeSsd captures enum value "ssd"
	SvmInlineAggregatesInlineArrayItemTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// vmdisk
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeVmdisk captures enum value "vmdisk"
	SvmInlineAggregatesInlineArrayItemTypeVmdisk string = "vmdisk"
)

// prop value enum
func (m *SvmInlineAggregatesInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmInlineAggregatesInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline aggregates inline array item based on the context it is used
func (m *SvmInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAvailableSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplockType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) contextValidateAvailableSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "available_size", "body", m.AvailableSize); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) contextValidateSnaplockType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock_type", "body", m.SnaplockType); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineAggregatesInlineArrayItem) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SvmInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineAggregatesInlineArrayItemInlineLinks svm inline aggregates inline array item inline links
//
// swagger:model svm_inline_aggregates_inline_array_item_inline__links
type SvmInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline aggregates inline array item inline links
func (m *SvmInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline aggregates inline array item inline links based on the context it is used
func (m *SvmInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineCertificate Support for this field will be removed in a future release. Please use /svm/svms/{svm.uuid}/web for this field. Certificate for incoming TLS connection requests.
//
// swagger:model svm_inline_certificate
type SvmInlineCertificate struct {

	// links
	Links *SvmInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline certificate
func (m *SvmInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline certificate based on the context it is used
func (m *SvmInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineCertificate) UnmarshalBinary(b []byte) error {
	var res SvmInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineCertificateInlineLinks svm inline certificate inline links
//
// swagger:model svm_inline_certificate_inline__links
type SvmInlineCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline certificate inline links
func (m *SvmInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline certificate inline links based on the context it is used
func (m *SvmInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineCifs svm inline cifs
//
// swagger:model svm_inline_cifs
type SvmInlineCifs struct {

	// links
	Links *SvmInlineCifsInlineLinks `json:"_links,omitempty"`

	// ad domain
	AdDomain *SvmInlineCifsInlineAdDomain `json:"ad_domain,omitempty"`

	// If this is set to true, an SVM administrator can manage the CIFS service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// Authentication type.
	// Example: domain
	// Read Only: true
	// Enum: ["domain","workgroup"]
	AuthStyle *string `json:"auth-style,omitempty"`

	// The NetBIOS name of the domain or workgroup associated with the CIFS server.
	//
	// Read Only: true
	DomainWorkgroup *string `json:"domain_workgroup,omitempty"`

	// If allowed, setting to true enables the CIFS service.
	Enabled *bool `json:"enabled,omitempty"`

	// The NetBIOS name of the CIFS server.
	// Example: CIFS1
	// Max Length: 15
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The workgroup name.
	// Example: workgrp1
	// Max Length: 15
	// Min Length: 1
	Workgroup *string `json:"workgroup,omitempty"`
}

// Validate validates this svm inline cifs
func (m *SvmInlineCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAdDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineCifs) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineCifs) validateAdDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.AdDomain) { // not required
		return nil
	}

	if m.AdDomain != nil {
		if err := m.AdDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs" + "." + "ad_domain")
			}
			return err
		}
	}

	return nil
}

var svmInlineCifsTypeAuthStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["domain","workgroup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmInlineCifsTypeAuthStylePropEnum = append(svmInlineCifsTypeAuthStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_inline_cifs
	// SvmInlineCifs
	// auth-style
	// AuthStyle
	// domain
	// END DEBUGGING
	// SvmInlineCifsAuthStyleDomain captures enum value "domain"
	SvmInlineCifsAuthStyleDomain string = "domain"

	// BEGIN DEBUGGING
	// svm_inline_cifs
	// SvmInlineCifs
	// auth-style
	// AuthStyle
	// workgroup
	// END DEBUGGING
	// SvmInlineCifsAuthStyleWorkgroup captures enum value "workgroup"
	SvmInlineCifsAuthStyleWorkgroup string = "workgroup"
)

// prop value enum
func (m *SvmInlineCifs) validateAuthStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmInlineCifsTypeAuthStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SvmInlineCifs) validateAuthStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthStyleEnum("cifs"+"."+"auth-style", "body", *m.AuthStyle); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineCifs) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("cifs"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("cifs"+"."+"name", "body", *m.Name, 15); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineCifs) validateWorkgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Workgroup) { // not required
		return nil
	}

	if err := validate.MinLength("cifs"+"."+"workgroup", "body", *m.Workgroup, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("cifs"+"."+"workgroup", "body", *m.Workgroup, 15); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline cifs based on the context it is used
func (m *SvmInlineCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAdDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAuthStyle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDomainWorkgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineCifs) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineCifs) contextValidateAdDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.AdDomain != nil {
		if err := m.AdDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs" + "." + "ad_domain")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineCifs) contextValidateAuthStyle(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cifs"+"."+"auth-style", "body", m.AuthStyle); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineCifs) contextValidateDomainWorkgroup(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cifs"+"."+"domain_workgroup", "body", m.DomainWorkgroup); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineCifs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineCifs) UnmarshalBinary(b []byte) error {
	var res SvmInlineCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineCifsInlineAdDomain svm inline cifs inline ad domain
//
// swagger:model svm_inline_cifs_inline_ad_domain
type SvmInlineCifsInlineAdDomain struct {

	// The default site used by LIFs that do not have a site membership.
	//
	DefaultSite *string `json:"default_site,omitempty"`

	// The fully qualified domain name of the Windows Active Directory to which this CIFS server belongs. A CIFS server appears as a member of Windows server object in the Active Directory store.
	//
	// Example: example.com
	Fqdn *string `json:"fqdn,omitempty"`

	// Specifies the organizational unit within the Active Directory domain to associate with the CIFS server.
	//
	OrganizationalUnit *string `json:"organizational_unit,omitempty"`

	// The account password used to add this CIFS server to the Active Directory. This is not audited. Valid in POST only.
	//
	Password *string `json:"password,omitempty"`

	// The user account used to add this CIFS server to the Active Directory. Valid in POST only.
	//
	User *string `json:"user,omitempty"`
}

// Validate validates this svm inline cifs inline ad domain
func (m *SvmInlineCifsInlineAdDomain) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this svm inline cifs inline ad domain based on context it is used
func (m *SvmInlineCifsInlineAdDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineCifsInlineAdDomain) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineCifsInlineAdDomain) UnmarshalBinary(b []byte) error {
	var res SvmInlineCifsInlineAdDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineCifsInlineLinks svm inline cifs inline links
//
// swagger:model svm_inline_cifs_inline__links
type SvmInlineCifsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline cifs inline links
func (m *SvmInlineCifsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineCifsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline cifs inline links based on the context it is used
func (m *SvmInlineCifsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineCifsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineCifsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineCifsInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineCifsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineDNS svm inline dns
//
// swagger:model svm_inline_dns
type SvmInlineDNS struct {

	// links
	Links *SvmInlineDNSInlineLinks `json:"_links,omitempty"`

	// domains
	Domains DNSDomainsArrayInline `json:"domains,omitempty"`

	// servers
	Servers NameServersArrayInline `json:"servers,omitempty"`
}

// Validate validates this svm inline dns
func (m *SvmInlineDNS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDomains(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineDNS) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineDNS) validateDomains(formats strfmt.Registry) error {
	if swag.IsZero(m.Domains) { // not required
		return nil
	}

	if err := m.Domains.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("dns" + "." + "domains")
		}
		return err
	}

	return nil
}

func (m *SvmInlineDNS) validateServers(formats strfmt.Registry) error {
	if swag.IsZero(m.Servers) { // not required
		return nil
	}

	if err := m.Servers.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("dns" + "." + "servers")
		}
		return err
	}

	return nil
}

// ContextValidate validate this svm inline dns based on the context it is used
func (m *SvmInlineDNS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDomains(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineDNS) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineDNS) contextValidateDomains(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Domains.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("dns" + "." + "domains")
		}
		return err
	}

	return nil
}

func (m *SvmInlineDNS) contextValidateServers(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Servers.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("dns" + "." + "servers")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineDNS) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineDNS) UnmarshalBinary(b []byte) error {
	var res SvmInlineDNS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineDNSInlineLinks svm inline dns inline links
//
// swagger:model svm_inline_dns_inline__links
type SvmInlineDNSInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline dns inline links
func (m *SvmInlineDNSInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineDNSInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline dns inline links based on the context it is used
func (m *SvmInlineDNSInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineDNSInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineDNSInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineDNSInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineDNSInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineFcp <personalities supports=unified>
// Available for GET, POST, and PATCH requests.
// </personalities>
// <personalities supports=asar2>
// Available for GET requests. All SVMs are provisioned with the FCP service configured.
// </personalities>
//
// swagger:model svm_inline_fcp
type SvmInlineFcp struct {

	// links
	Links *SvmInlineFcpInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the FCP service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// If allowed, setting to true enables the FCP service.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this svm inline fcp
func (m *SvmInlineFcp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineFcp) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline fcp based on the context it is used
func (m *SvmInlineFcp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineFcp) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineFcp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineFcp) UnmarshalBinary(b []byte) error {
	var res SvmInlineFcp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineFcpInlineLinks svm inline fcp inline links
//
// swagger:model svm_inline_fcp_inline__links
type SvmInlineFcpInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline fcp inline links
func (m *SvmInlineFcpInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineFcpInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline fcp inline links based on the context it is used
func (m *SvmInlineFcpInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineFcpInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineFcpInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineFcpInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineFcpInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineIpspace Either the UUID or name may be supplied on input.
//
// swagger:model svm_inline_ipspace
type SvmInlineIpspace struct {

	// links
	Links *SvmInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline ipspace
func (m *SvmInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline ipspace based on the context it is used
func (m *SvmInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineIpspace) UnmarshalBinary(b []byte) error {
	var res SvmInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineIpspaceInlineLinks svm inline ipspace inline links
//
// swagger:model svm_inline_ipspace_inline__links
type SvmInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline ipspace inline links
func (m *SvmInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline ipspace inline links based on the context it is used
func (m *SvmInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineIscsi <personalities supports=unified>
// Available for GET, POST, and PATCH requests.
// </personalities>
// <personalities supports=asar2>
// Available for GET requests. All SVMs are provisioned with the iSCSI service configured.
// </personalities>
//
// swagger:model svm_inline_iscsi
type SvmInlineIscsi struct {

	// links
	Links *SvmInlineIscsiInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the iSCSI service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// If allowed, setting to true enables the iSCSI service.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this svm inline iscsi
func (m *SvmInlineIscsi) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineIscsi) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iscsi" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline iscsi based on the context it is used
func (m *SvmInlineIscsi) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineIscsi) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iscsi" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineIscsi) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineIscsi) UnmarshalBinary(b []byte) error {
	var res SvmInlineIscsi
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineIscsiInlineLinks svm inline iscsi inline links
//
// swagger:model svm_inline_iscsi_inline__links
type SvmInlineIscsiInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline iscsi inline links
func (m *SvmInlineIscsiInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineIscsiInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iscsi" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline iscsi inline links based on the context it is used
func (m *SvmInlineIscsiInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineIscsiInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iscsi" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineIscsiInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineIscsiInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineIscsiInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineLdap svm inline ldap
//
// swagger:model svm_inline_ldap
type SvmInlineLdap struct {

	// This parameter specifies the name of the Active Directory domain
	// used to discover LDAP servers for use by this client.
	// This is mutually exclusive with `servers` during POST.
	//
	AdDomain *string `json:"ad_domain,omitempty"`

	// Specifies the default base DN for all searches.
	BaseDn *string `json:"base_dn,omitempty"`

	// Specifies the user that binds to the LDAP servers. SVM API supports anonymous binding. For Simple and SASL LDAP binding, use the LDAP API endpoint.
	BindDn *string `json:"bind_dn,omitempty"`

	// Enable LDAP? Setting to true creates a configuration if not already created.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies whether or not LDAP server discovery is restricted to site-scope.
	//
	RestrictDiscoveryToSite *bool `json:"restrict_discovery_to_site,omitempty"`

	// servers
	Servers []*string `json:"servers,omitempty"`
}

// Validate validates this svm inline ldap
func (m *SvmInlineLdap) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this svm inline ldap based on context it is used
func (m *SvmInlineLdap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineLdap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineLdap) UnmarshalBinary(b []byte) error {
	var res SvmInlineLdap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineLinks svm inline links
//
// swagger:model svm_inline__links
type SvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline links
func (m *SvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline links based on the context it is used
func (m *SvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineNdmp svm inline ndmp
//
// swagger:model svm_inline_ndmp
type SvmInlineNdmp struct {

	// If this is set to true, an SVM administrator can manage the NDMP service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`
}

// Validate validates this svm inline ndmp
func (m *SvmInlineNdmp) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this svm inline ndmp based on context it is used
func (m *SvmInlineNdmp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineNdmp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineNdmp) UnmarshalBinary(b []byte) error {
	var res SvmInlineNdmp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineNfs svm inline nfs
//
// swagger:model svm_inline_nfs
type SvmInlineNfs struct {

	// links
	Links *SvmInlineNfsInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the NFS service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// If allowed, setting to true enables the NFS service.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this svm inline nfs
func (m *SvmInlineNfs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNfs) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nfs based on the context it is used
func (m *SvmInlineNfs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNfs) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineNfs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineNfs) UnmarshalBinary(b []byte) error {
	var res SvmInlineNfs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineNfsInlineLinks svm inline nfs inline links
//
// swagger:model svm_inline_nfs_inline__links
type SvmInlineNfsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline nfs inline links
func (m *SvmInlineNfsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNfsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nfs inline links based on the context it is used
func (m *SvmInlineNfsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNfsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfs" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineNfsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineNfsInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineNfsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineNis svm inline nis
//
// swagger:model svm_inline_nis
type SvmInlineNis struct {

	// links
	Links *SvmInlineNisInlineLinks `json:"_links,omitempty"`

	// domain
	Domain *NisDomain `json:"domain,omitempty"`

	// Enable NIS? Setting to true creates a configuration if not already created.
	Enabled *bool `json:"enabled,omitempty"`

	// servers
	Servers NisServersArrayInline `json:"servers,omitempty"`
}

// Validate validates this svm inline nis
func (m *SvmInlineNis) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNis) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nis" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineNis) validateDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.Domain) { // not required
		return nil
	}

	if m.Domain != nil {
		if err := m.Domain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nis" + "." + "domain")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineNis) validateServers(formats strfmt.Registry) error {
	if swag.IsZero(m.Servers) { // not required
		return nil
	}

	if err := m.Servers.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("nis" + "." + "servers")
		}
		return err
	}

	return nil
}

// ContextValidate validate this svm inline nis based on the context it is used
func (m *SvmInlineNis) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNis) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nis" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineNis) contextValidateDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.Domain != nil {
		if err := m.Domain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nis" + "." + "domain")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineNis) contextValidateServers(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Servers.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("nis" + "." + "servers")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineNis) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineNis) UnmarshalBinary(b []byte) error {
	var res SvmInlineNis
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineNisInlineLinks svm inline nis inline links
//
// swagger:model svm_inline_nis_inline__links
type SvmInlineNisInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline nis inline links
func (m *SvmInlineNisInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNisInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nis" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nis inline links based on the context it is used
func (m *SvmInlineNisInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNisInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nis" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineNisInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineNisInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineNisInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineNsswitch Name service switch configuration
//
// swagger:model svm_inline_nsswitch
type SvmInlineNsswitch struct {

	// Group sources
	Group []*NsswitchSource `json:"group,omitempty"`

	// Host sources
	Hosts []*NsswitchSource `json:"hosts,omitempty"`

	// NameMap sources
	Namemap []*NsswitchSource `json:"namemap,omitempty"`

	// NetGroup sources
	Netgroup []*NsswitchSource `json:"netgroup,omitempty"`

	// Password sources
	Passwd []*NsswitchSource `json:"passwd,omitempty"`
}

// Validate validates this svm inline nsswitch
func (m *SvmInlineNsswitch) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHosts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNamemap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePasswd(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNsswitch) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Group) { // not required
		return nil
	}

	for i := 0; i < len(m.Group); i++ {
		if swag.IsZero(m.Group[i]) { // not required
			continue
		}

		if m.Group[i] != nil {
			if err := m.Group[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "group" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmInlineNsswitch) validateHosts(formats strfmt.Registry) error {
	if swag.IsZero(m.Hosts) { // not required
		return nil
	}

	for i := 0; i < len(m.Hosts); i++ {
		if swag.IsZero(m.Hosts[i]) { // not required
			continue
		}

		if m.Hosts[i] != nil {
			if err := m.Hosts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmInlineNsswitch) validateNamemap(formats strfmt.Registry) error {
	if swag.IsZero(m.Namemap) { // not required
		return nil
	}

	for i := 0; i < len(m.Namemap); i++ {
		if swag.IsZero(m.Namemap[i]) { // not required
			continue
		}

		if m.Namemap[i] != nil {
			if err := m.Namemap[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "namemap" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmInlineNsswitch) validateNetgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Netgroup) { // not required
		return nil
	}

	for i := 0; i < len(m.Netgroup); i++ {
		if swag.IsZero(m.Netgroup[i]) { // not required
			continue
		}

		if m.Netgroup[i] != nil {
			if err := m.Netgroup[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "netgroup" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmInlineNsswitch) validatePasswd(formats strfmt.Registry) error {
	if swag.IsZero(m.Passwd) { // not required
		return nil
	}

	for i := 0; i < len(m.Passwd); i++ {
		if swag.IsZero(m.Passwd[i]) { // not required
			continue
		}

		if m.Passwd[i] != nil {
			if err := m.Passwd[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "passwd" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm inline nsswitch based on the context it is used
func (m *SvmInlineNsswitch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHosts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNamemap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePasswd(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNsswitch) contextValidateGroup(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Group); i++ {

		if m.Group[i] != nil {
			if err := m.Group[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "group" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmInlineNsswitch) contextValidateHosts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Hosts); i++ {

		if m.Hosts[i] != nil {
			if err := m.Hosts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmInlineNsswitch) contextValidateNamemap(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Namemap); i++ {

		if m.Namemap[i] != nil {
			if err := m.Namemap[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "namemap" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmInlineNsswitch) contextValidateNetgroup(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Netgroup); i++ {

		if m.Netgroup[i] != nil {
			if err := m.Netgroup[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "netgroup" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmInlineNsswitch) contextValidatePasswd(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Passwd); i++ {

		if m.Passwd[i] != nil {
			if err := m.Passwd[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nsswitch" + "." + "passwd" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineNsswitch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineNsswitch) UnmarshalBinary(b []byte) error {
	var res SvmInlineNsswitch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineNvme <personalities supports=unified>
// Available for GET, POST, and PATCH requests.
// </personalities>
// <personalities supports=asar2>
// Available for GET requests. All SVMs are provisioned with the NVMe service configured.
// </personalities>
//
// swagger:model svm_inline_nvme
type SvmInlineNvme struct {

	// links
	Links *SvmInlineNvmeInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the NVMe service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// If allowed, setting to true enables the NVMe service.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this svm inline nvme
func (m *SvmInlineNvme) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNvme) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvme" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nvme based on the context it is used
func (m *SvmInlineNvme) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNvme) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvme" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineNvme) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineNvme) UnmarshalBinary(b []byte) error {
	var res SvmInlineNvme
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineNvmeInlineLinks svm inline nvme inline links
//
// swagger:model svm_inline_nvme_inline__links
type SvmInlineNvmeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline nvme inline links
func (m *SvmInlineNvmeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNvmeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvme" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nvme inline links based on the context it is used
func (m *SvmInlineNvmeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineNvmeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvme" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineNvmeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineNvmeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineNvmeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineQosAdaptivePolicyGroupTemplate This optionally specifies which QoS adaptive policy group to apply to the SVM as a template. This policy group will then be assigned to volumes created or rehosted into this SVM. This policy group defines measurable service level objectives (SLOs) and Service Level Agreements (SLAs) that adjust based on the volume allocated space or used space.
//
// swagger:model svm_inline_qos_adaptive_policy_group_template
type SvmInlineQosAdaptivePolicyGroupTemplate struct {

	// links
	Links *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline qos adaptive policy group template
func (m *SvmInlineQosAdaptivePolicyGroupTemplate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosAdaptivePolicyGroupTemplate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_adaptive_policy_group_template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineQosAdaptivePolicyGroupTemplate) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_adaptive_policy_group_template"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_adaptive_policy_group_template"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosAdaptivePolicyGroupTemplate) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_adaptive_policy_group_template"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_adaptive_policy_group_template"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosAdaptivePolicyGroupTemplate) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_adaptive_policy_group_template"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_adaptive_policy_group_template"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosAdaptivePolicyGroupTemplate) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_adaptive_policy_group_template"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_adaptive_policy_group_template"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline qos adaptive policy group template based on the context it is used
func (m *SvmInlineQosAdaptivePolicyGroupTemplate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosAdaptivePolicyGroupTemplate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_adaptive_policy_group_template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineQosAdaptivePolicyGroupTemplate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineQosAdaptivePolicyGroupTemplate) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosAdaptivePolicyGroupTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks svm inline qos adaptive policy group template inline links
//
// swagger:model svm_inline_qos_adaptive_policy_group_template_inline__links
type SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline qos adaptive policy group template inline links
func (m *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_adaptive_policy_group_template" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline qos adaptive policy group template inline links based on the context it is used
func (m *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_adaptive_policy_group_template" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineQosPolicy This optionally specifies which QoS policy group to apply to the Vserver. This policy group defines measurable service level objectives (SLOs) that apply to the storage objects with which the policy group is associated.
//
// swagger:model svm_inline_qos_policy
type SvmInlineQosPolicy struct {

	// links
	Links *SvmInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline qos policy
func (m *SvmInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineQosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline qos policy based on the context it is used
func (m *SvmInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineQosPolicyGroupTemplate This optionally specifies which QoS non-shared policy group to apply to the SVM as a template. This policy group is then assigned to volumes created or rehosted into this SVM. This policy group defines measurable service level objectives (SLOs) and Service Level Agreements (SLAs).
//
// swagger:model svm_inline_qos_policy_group_template
type SvmInlineQosPolicyGroupTemplate struct {

	// links
	Links *SvmInlineQosPolicyGroupTemplateInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline qos policy group template
func (m *SvmInlineQosPolicyGroupTemplate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosPolicyGroupTemplate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy_group_template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineQosPolicyGroupTemplate) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy_group_template"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy_group_template"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosPolicyGroupTemplate) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy_group_template"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy_group_template"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosPolicyGroupTemplate) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy_group_template"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy_group_template"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineQosPolicyGroupTemplate) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy_group_template"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy_group_template"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline qos policy group template based on the context it is used
func (m *SvmInlineQosPolicyGroupTemplate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosPolicyGroupTemplate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy_group_template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineQosPolicyGroupTemplate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineQosPolicyGroupTemplate) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosPolicyGroupTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineQosPolicyGroupTemplateInlineLinks svm inline qos policy group template inline links
//
// swagger:model svm_inline_qos_policy_group_template_inline__links
type SvmInlineQosPolicyGroupTemplateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline qos policy group template inline links
func (m *SvmInlineQosPolicyGroupTemplateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosPolicyGroupTemplateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy_group_template" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline qos policy group template inline links based on the context it is used
func (m *SvmInlineQosPolicyGroupTemplateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosPolicyGroupTemplateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy_group_template" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineQosPolicyGroupTemplateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineQosPolicyGroupTemplateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosPolicyGroupTemplateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineQosPolicyInlineLinks svm inline qos policy inline links
//
// swagger:model svm_inline_qos_policy_inline__links
type SvmInlineQosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline qos policy inline links
func (m *SvmInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline qos policy inline links based on the context it is used
func (m *SvmInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineS3 svm inline s3
//
// swagger:model svm_inline_s3
type SvmInlineS3 struct {

	// links
	Links *SvmInlineS3InlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the S3 service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// certificate
	Certificate *SvmInlineS3InlineCertificate `json:"certificate,omitempty"`

	// Specifies the default UNIX user for NAS Access.
	DefaultUnixUser *string `json:"default_unix_user,omitempty"`

	// Specifies the default Windows user for NAS Access.
	DefaultWinUser *string `json:"default_win_user,omitempty"`

	// Specifies whether or not to enable S3. Setting this value to true creates a service if one is not yet created.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies whether HTTP is enabled on the S3 server. By default, HTTP is disabled on the S3 server.
	IsHTTPEnabled *bool `json:"is_http_enabled,omitempty"`

	// Specifies whether HTTPS is enabled on the S3 server. By default, HTTPS is enabled on the S3 server.
	IsHTTPSEnabled *bool `json:"is_https_enabled,omitempty"`

	// Specifies the name of the S3 server. A server name length can range from 1 to 253 characters and can only contain the following combination of characters 0-9, A-Z, a-z, ".", and "-".
	// Example: s3-server-1
	// Max Length: 253
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Specifies the HTTP listener port for the S3 server. By default, HTTP is enabled on port 80.
	Port *int64 `json:"port,omitempty"`

	// Specifies the HTTPS listener port for the S3 server. By default, HTTPS is enabled on port 443.
	SecurePort *int64 `json:"secure_port,omitempty"`
}

// Validate validates this svm inline s3
func (m *SvmInlineS3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineS3) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineS3) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineS3) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("s3"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("s3"+"."+"name", "body", *m.Name, 253); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline s3 based on the context it is used
func (m *SvmInlineS3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineS3) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmInlineS3) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineS3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineS3) UnmarshalBinary(b []byte) error {
	var res SvmInlineS3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineS3InlineCertificate Specifies the certificate that will be used for creating HTTPS connections to the S3 server.
//
// swagger:model svm_inline_s3_inline_certificate
type SvmInlineS3InlineCertificate struct {

	// links
	Links *SvmInlineS3InlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline s3 inline certificate
func (m *SvmInlineS3InlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineS3InlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline s3 inline certificate based on the context it is used
func (m *SvmInlineS3InlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineS3InlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineS3InlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineS3InlineCertificate) UnmarshalBinary(b []byte) error {
	var res SvmInlineS3InlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineS3InlineCertificateInlineLinks svm inline s3 inline certificate inline links
//
// swagger:model svm_inline_s3_inline_certificate_inline__links
type SvmInlineS3InlineCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline s3 inline certificate inline links
func (m *SvmInlineS3InlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineS3InlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline s3 inline certificate inline links based on the context it is used
func (m *SvmInlineS3InlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineS3InlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineS3InlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineS3InlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineS3InlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineS3InlineLinks svm inline s3 inline links
//
// swagger:model svm_inline_s3_inline__links
type SvmInlineS3InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline s3 inline links
func (m *SvmInlineS3InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineS3InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline s3 inline links based on the context it is used
func (m *SvmInlineS3InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineS3InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineS3InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineS3InlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineS3InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineSnapmirror Specifies attributes for SVM DR protection.
//
// swagger:model svm_inline_snapmirror
type SvmInlineSnapmirror struct {

	// Specifies whether the SVM is a SnapMirror source SVM, using SnapMirror to protect its data.
	// Read Only: true
	IsProtected *bool `json:"is_protected,omitempty"`

	// Specifies the number of SVM DR protected consistency groups in the SVM.
	// Read Only: true
	ProtectedConsistencyGroupCount *int64 `json:"protected_consistency_group_count,omitempty"`

	// Specifies the number of SVM DR protected volumes in the SVM.
	// Read Only: true
	ProtectedVolumesCount *int64 `json:"protected_volumes_count,omitempty"`
}

// Validate validates this svm inline snapmirror
func (m *SvmInlineSnapmirror) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this svm inline snapmirror based on the context it is used
func (m *SvmInlineSnapmirror) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsProtected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectedConsistencyGroupCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectedVolumesCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineSnapmirror) contextValidateIsProtected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapmirror"+"."+"is_protected", "body", m.IsProtected); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineSnapmirror) contextValidateProtectedConsistencyGroupCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapmirror"+"."+"protected_consistency_group_count", "body", m.ProtectedConsistencyGroupCount); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineSnapmirror) contextValidateProtectedVolumesCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapmirror"+"."+"protected_volumes_count", "body", m.ProtectedVolumesCount); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineSnapmirror) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineSnapmirror) UnmarshalBinary(b []byte) error {
	var res SvmInlineSnapmirror
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineSnapshotPolicy This is a reference to the snapshot policy.
//
// swagger:model svm_inline_snapshot_policy
type SvmInlineSnapshotPolicy struct {

	// links
	Links *SvmInlineSnapshotPolicyInlineLinks `json:"_links,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline snapshot policy
func (m *SvmInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineSnapshotPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline snapshot policy based on the context it is used
func (m *SvmInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineSnapshotPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res SvmInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineSnapshotPolicyInlineLinks svm inline snapshot policy inline links
//
// swagger:model svm_inline_snapshot_policy_inline__links
type SvmInlineSnapshotPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm inline snapshot policy inline links
func (m *SvmInlineSnapshotPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineSnapshotPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline snapshot policy inline links based on the context it is used
func (m *SvmInlineSnapshotPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineSnapshotPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineSnapshotPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineSnapshotPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineSnapshotPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmInlineStorage svm inline storage
//
// swagger:model svm_inline_storage
type SvmInlineStorage struct {

	// Total size of the volumes in SVM, in bytes.
	// Read Only: true
	Allocated *int64 `json:"allocated,omitempty"`

	// Currently available storage capacity in SVM, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Maximum storage permitted on a single SVM, in bytes.
	Limit *int64 `json:"limit,omitempty"`

	// Indicates at what percentage of storage capacity an alert message is sent. The default value is 90.
	LimitThresholdAlert *int64 `json:"limit_threshold_alert,omitempty"`

	// Indicates whether the total storage capacity exceeds the alert percentage.
	// Read Only: true
	LimitThresholdExceeded *bool `json:"limit_threshold_exceeded,omitempty"`

	// The percentage of storage capacity used.
	// Read Only: true
	UsedPercentage *int64 `json:"used_percentage,omitempty"`
}

// Validate validates this svm inline storage
func (m *SvmInlineStorage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this svm inline storage based on the context it is used
func (m *SvmInlineStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAllocated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLimitThresholdExceeded(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedPercentage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmInlineStorage) contextValidateAllocated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage"+"."+"allocated", "body", m.Allocated); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineStorage) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineStorage) contextValidateLimitThresholdExceeded(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage"+"."+"limit_threshold_exceeded", "body", m.LimitThresholdExceeded); err != nil {
		return err
	}

	return nil
}

func (m *SvmInlineStorage) contextValidateUsedPercentage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage"+"."+"used_percentage", "body", m.UsedPercentage); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmInlineStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmInlineStorage) UnmarshalBinary(b []byte) error {
	var res SvmInlineStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
