// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SvmCifsServiceReference svm cifs service reference
//
// swagger:model svm_cifs_service_reference
type SvmCifsServiceReference struct {

	// links
	Links *SvmCifsServiceReferenceInlineLinks `json:"_links,omitempty"`

	// ad domain
	AdDomain *SvmCifsServiceReferenceInlineAdDomain `json:"ad_domain,omitempty"`

	// If this is set to true, an SVM administrator can manage the CIFS service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// Authentication type.
	// Example: domain
	// Read Only: true
	// Enum: ["domain","workgroup"]
	AuthStyle *string `json:"auth-style,omitempty"`

	// The NetBIOS name of the domain or workgroup associated with the CIFS server.
	//
	// Read Only: true
	DomainWorkgroup *string `json:"domain_workgroup,omitempty"`

	// If allowed, setting to true enables the CIFS service.
	Enabled *bool `json:"enabled,omitempty"`

	// The NetBIOS name of the CIFS server.
	// Example: CIFS1
	// Max Length: 15
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The workgroup name.
	// Example: workgrp1
	// Max Length: 15
	// Min Length: 1
	Workgroup *string `json:"workgroup,omitempty"`
}

// Validate validates this svm cifs service reference
func (m *SvmCifsServiceReference) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAdDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmCifsServiceReference) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmCifsServiceReference) validateAdDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.AdDomain) { // not required
		return nil
	}

	if m.AdDomain != nil {
		if err := m.AdDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ad_domain")
			}
			return err
		}
	}

	return nil
}

var svmCifsServiceReferenceTypeAuthStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["domain","workgroup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmCifsServiceReferenceTypeAuthStylePropEnum = append(svmCifsServiceReferenceTypeAuthStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_cifs_service_reference
	// SvmCifsServiceReference
	// auth-style
	// AuthStyle
	// domain
	// END DEBUGGING
	// SvmCifsServiceReferenceAuthStyleDomain captures enum value "domain"
	SvmCifsServiceReferenceAuthStyleDomain string = "domain"

	// BEGIN DEBUGGING
	// svm_cifs_service_reference
	// SvmCifsServiceReference
	// auth-style
	// AuthStyle
	// workgroup
	// END DEBUGGING
	// SvmCifsServiceReferenceAuthStyleWorkgroup captures enum value "workgroup"
	SvmCifsServiceReferenceAuthStyleWorkgroup string = "workgroup"
)

// prop value enum
func (m *SvmCifsServiceReference) validateAuthStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmCifsServiceReferenceTypeAuthStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SvmCifsServiceReference) validateAuthStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthStyleEnum("auth-style", "body", *m.AuthStyle); err != nil {
		return err
	}

	return nil
}

func (m *SvmCifsServiceReference) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 15); err != nil {
		return err
	}

	return nil
}

func (m *SvmCifsServiceReference) validateWorkgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Workgroup) { // not required
		return nil
	}

	if err := validate.MinLength("workgroup", "body", *m.Workgroup, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("workgroup", "body", *m.Workgroup, 15); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm cifs service reference based on the context it is used
func (m *SvmCifsServiceReference) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAdDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAuthStyle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDomainWorkgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmCifsServiceReference) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmCifsServiceReference) contextValidateAdDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.AdDomain != nil {
		if err := m.AdDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ad_domain")
			}
			return err
		}
	}

	return nil
}

func (m *SvmCifsServiceReference) contextValidateAuthStyle(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "auth-style", "body", m.AuthStyle); err != nil {
		return err
	}

	return nil
}

func (m *SvmCifsServiceReference) contextValidateDomainWorkgroup(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "domain_workgroup", "body", m.DomainWorkgroup); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmCifsServiceReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmCifsServiceReference) UnmarshalBinary(b []byte) error {
	var res SvmCifsServiceReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmCifsServiceReferenceInlineAdDomain svm cifs service reference inline ad domain
//
// swagger:model svm_cifs_service_reference_inline_ad_domain
type SvmCifsServiceReferenceInlineAdDomain struct {

	// The default site used by LIFs that do not have a site membership.
	//
	DefaultSite *string `json:"default_site,omitempty"`

	// The fully qualified domain name of the Windows Active Directory to which this CIFS server belongs. A CIFS server appears as a member of Windows server object in the Active Directory store.
	//
	// Example: example.com
	Fqdn *string `json:"fqdn,omitempty"`

	// Specifies the organizational unit within the Active Directory domain to associate with the CIFS server.
	//
	OrganizationalUnit *string `json:"organizational_unit,omitempty"`

	// The account password used to add this CIFS server to the Active Directory. This is not audited. Valid in POST only.
	//
	Password *string `json:"password,omitempty"`

	// The user account used to add this CIFS server to the Active Directory. Valid in POST only.
	//
	User *string `json:"user,omitempty"`
}

// Validate validates this svm cifs service reference inline ad domain
func (m *SvmCifsServiceReferenceInlineAdDomain) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this svm cifs service reference inline ad domain based on context it is used
func (m *SvmCifsServiceReferenceInlineAdDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SvmCifsServiceReferenceInlineAdDomain) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmCifsServiceReferenceInlineAdDomain) UnmarshalBinary(b []byte) error {
	var res SvmCifsServiceReferenceInlineAdDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmCifsServiceReferenceInlineLinks svm cifs service reference inline links
//
// swagger:model svm_cifs_service_reference_inline__links
type SvmCifsServiceReferenceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm cifs service reference inline links
func (m *SvmCifsServiceReferenceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmCifsServiceReferenceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm cifs service reference inline links based on the context it is used
func (m *SvmCifsServiceReferenceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmCifsServiceReferenceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmCifsServiceReferenceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmCifsServiceReferenceInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmCifsServiceReferenceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
