// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SvmLdapReference svm ldap reference
//
// swagger:model svm_ldap_reference
type SvmLdapReference struct {

	// This parameter specifies the name of the Active Directory domain
	// used to discover LDAP servers for use by this client.
	// This is mutually exclusive with `servers` during POST.
	//
	AdDomain *string `json:"ad_domain,omitempty"`

	// Specifies the default base DN for all searches.
	BaseDn *string `json:"base_dn,omitempty"`

	// Specifies the user that binds to the LDAP servers. SVM API supports anonymous binding. For Simple and SASL LDAP binding, use the LDAP API endpoint.
	BindDn *string `json:"bind_dn,omitempty"`

	// Enable LDAP? Setting to true creates a configuration if not already created.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies whether or not LDAP server discovery is restricted to site-scope.
	//
	RestrictDiscoveryToSite *bool `json:"restrict_discovery_to_site,omitempty"`

	// svm ldap reference inline servers
	SvmLdapReferenceInlineServers []*string `json:"servers,omitempty"`
}

// Validate validates this svm ldap reference
func (m *SvmLdapReference) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this svm ldap reference based on context it is used
func (m *SvmLdapReference) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SvmLdapReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmLdapReference) UnmarshalBinary(b []byte) error {
	var res SvmLdapReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
