// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SvmMigration Provides information on SVM migration, default and user specified configurations, the state of the migration, and volume transfer metrics.
//
// swagger:model svm_migration
type SvmMigration struct {

	// Optional property that when set to true automatically performs cutover when the migration state reaches "ready for cutover".
	AutoCutover *bool `json:"auto_cutover,omitempty"`

	// Optional property that when set to true automatically cleans up the SVM on the source cluster after the migration cutover.
	AutoSourceCleanup *bool `json:"auto_source_cleanup,omitempty"`

	// Optional property that when set to true performs only migration pre-checks not the actual migration.
	CheckOnly *bool `json:"check_only,omitempty"`

	// current operation
	// Read Only: true
	CurrentOperation *SvmMigrationOperation `json:"current_operation,omitempty"`

	// destination
	Destination *SvmMigrationInlineDestination `json:"destination,omitempty"`

	// Optional property used to specify the IP interface placement in the destination. It is input only and is not returned by a subsequent GET.
	IPInterfacePlacement *SvmMigrationIPInterfacePlacement `json:"ip_interface_placement,omitempty"`

	// last failed state
	// Read Only: true
	LastFailedState *SvmMigrationState `json:"last_failed_state,omitempty"`

	// last operation
	// Read Only: true
	// Enum: ["none","start","resume","pause","cleanup","cutover"]
	LastOperation *string `json:"last_operation,omitempty"`

	// Indicates if the migration has progressed beyond the point of no return. When true, the migration cannot be aborted or paused. When false, the migration can be paused or aborted.
	// Read Only: true
	PointOfNoReturn *bool `json:"point_of_no_return,omitempty"`

	// Number of times the migration restarted after the point of no return.
	// Read Only: true
	PostPonrRetryCount *int64 `json:"post_ponr_retry_count,omitempty"`

	// Number of times migrate restarted the transfer, for example, rollback to transfer after starting the cutover.
	// Read Only: true
	RestartCount *int64 `json:"restart_count,omitempty"`

	// source
	Source *SvmMigrationInlineSource `json:"source,omitempty"`

	// state
	// Read Only: true
	State *SvmMigrationState `json:"state,omitempty"`

	// Errors and warnings returned/displayed during migration.
	// Read Only: true
	SvmMigrationInlineMessages []*SvmMigrationInlineMessagesInlineArrayItem `json:"messages,omitempty"`

	// Optional property to specify a throttle value in KB/s for each individual volume transfer. Defaults to 0 if not set, which is interpreted as unlimited. The minimum throttle value is 4 KB/s, so if you specify a throttle value between 1 and 4, it will be treated as if you specified 4.
	Throttle *int64 `json:"throttle,omitempty"`

	// time metrics
	TimeMetrics *SvmMigrationInlineTimeMetrics `json:"time_metrics,omitempty"`

	// SVM migration UUID
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this svm migration
func (m *SvmMigration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCurrentOperation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPInterfacePlacement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastFailedState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastOperation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmMigrationInlineMessages(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeMetrics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigration) validateCurrentOperation(formats strfmt.Registry) error {
	if swag.IsZero(m.CurrentOperation) { // not required
		return nil
	}

	if m.CurrentOperation != nil {
		if err := m.CurrentOperation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("current_operation")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.Destination) { // not required
		return nil
	}

	if m.Destination != nil {
		if err := m.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) validateIPInterfacePlacement(formats strfmt.Registry) error {
	if swag.IsZero(m.IPInterfacePlacement) { // not required
		return nil
	}

	if m.IPInterfacePlacement != nil {
		if err := m.IPInterfacePlacement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface_placement")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) validateLastFailedState(formats strfmt.Registry) error {
	if swag.IsZero(m.LastFailedState) { // not required
		return nil
	}

	if m.LastFailedState != nil {
		if err := m.LastFailedState.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("last_failed_state")
			}
			return err
		}
	}

	return nil
}

var svmMigrationTypeLastOperationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","start","resume","pause","cleanup","cutover"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmMigrationTypeLastOperationPropEnum = append(svmMigrationTypeLastOperationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_migration
	// SvmMigration
	// last_operation
	// LastOperation
	// none
	// END DEBUGGING
	// SvmMigrationLastOperationNone captures enum value "none"
	SvmMigrationLastOperationNone string = "none"

	// BEGIN DEBUGGING
	// svm_migration
	// SvmMigration
	// last_operation
	// LastOperation
	// start
	// END DEBUGGING
	// SvmMigrationLastOperationStart captures enum value "start"
	SvmMigrationLastOperationStart string = "start"

	// BEGIN DEBUGGING
	// svm_migration
	// SvmMigration
	// last_operation
	// LastOperation
	// resume
	// END DEBUGGING
	// SvmMigrationLastOperationResume captures enum value "resume"
	SvmMigrationLastOperationResume string = "resume"

	// BEGIN DEBUGGING
	// svm_migration
	// SvmMigration
	// last_operation
	// LastOperation
	// pause
	// END DEBUGGING
	// SvmMigrationLastOperationPause captures enum value "pause"
	SvmMigrationLastOperationPause string = "pause"

	// BEGIN DEBUGGING
	// svm_migration
	// SvmMigration
	// last_operation
	// LastOperation
	// cleanup
	// END DEBUGGING
	// SvmMigrationLastOperationCleanup captures enum value "cleanup"
	SvmMigrationLastOperationCleanup string = "cleanup"

	// BEGIN DEBUGGING
	// svm_migration
	// SvmMigration
	// last_operation
	// LastOperation
	// cutover
	// END DEBUGGING
	// SvmMigrationLastOperationCutover captures enum value "cutover"
	SvmMigrationLastOperationCutover string = "cutover"
)

// prop value enum
func (m *SvmMigration) validateLastOperationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmMigrationTypeLastOperationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SvmMigration) validateLastOperation(formats strfmt.Registry) error {
	if swag.IsZero(m.LastOperation) { // not required
		return nil
	}

	// value enum
	if err := m.validateLastOperationEnum("last_operation", "body", *m.LastOperation); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigration) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) validateSvmMigrationInlineMessages(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmMigrationInlineMessages) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmMigrationInlineMessages); i++ {
		if swag.IsZero(m.SvmMigrationInlineMessages[i]) { // not required
			continue
		}

		if m.SvmMigrationInlineMessages[i] != nil {
			if err := m.SvmMigrationInlineMessages[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("messages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmMigration) validateTimeMetrics(formats strfmt.Registry) error {
	if swag.IsZero(m.TimeMetrics) { // not required
		return nil
	}

	if m.TimeMetrics != nil {
		if err := m.TimeMetrics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("time_metrics")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm migration based on the context it is used
func (m *SvmMigration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCurrentOperation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPInterfacePlacement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastFailedState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastOperation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePointOfNoReturn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePostPonrRetryCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRestartCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmMigrationInlineMessages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeMetrics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigration) contextValidateCurrentOperation(ctx context.Context, formats strfmt.Registry) error {

	if m.CurrentOperation != nil {
		if err := m.CurrentOperation.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("current_operation")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.Destination != nil {
		if err := m.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) contextValidateIPInterfacePlacement(ctx context.Context, formats strfmt.Registry) error {

	if m.IPInterfacePlacement != nil {
		if err := m.IPInterfacePlacement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface_placement")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) contextValidateLastFailedState(ctx context.Context, formats strfmt.Registry) error {

	if m.LastFailedState != nil {
		if err := m.LastFailedState.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("last_failed_state")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) contextValidateLastOperation(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_operation", "body", m.LastOperation); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigration) contextValidatePointOfNoReturn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "point_of_no_return", "body", m.PointOfNoReturn); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigration) contextValidatePostPonrRetryCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "post_ponr_retry_count", "body", m.PostPonrRetryCount); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigration) contextValidateRestartCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "restart_count", "body", m.RestartCount); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigration) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) contextValidateSvmMigrationInlineMessages(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "messages", "body", []*SvmMigrationInlineMessagesInlineArrayItem(m.SvmMigrationInlineMessages)); err != nil {
		return err
	}

	for i := 0; i < len(m.SvmMigrationInlineMessages); i++ {

		if m.SvmMigrationInlineMessages[i] != nil {
			if err := m.SvmMigrationInlineMessages[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("messages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmMigration) contextValidateTimeMetrics(ctx context.Context, formats strfmt.Registry) error {

	if m.TimeMetrics != nil {
		if err := m.TimeMetrics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("time_metrics")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigration) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigration) UnmarshalBinary(b []byte) error {
	var res SvmMigration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineDestination Destination cluster details for the SVM migration.
//
// swagger:model svm_migration_inline_destination
type SvmMigrationInlineDestination struct {

	// ipspace
	Ipspace *SvmMigrationInlineDestinationInlineIpspace `json:"ipspace,omitempty"`

	// volume placement
	VolumePlacement *SvmMigrationInlineDestinationInlineVolumePlacement `json:"volume_placement,omitempty"`
}

// Validate validates this svm migration inline destination
func (m *SvmMigrationInlineDestination) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumePlacement(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineDestination) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationInlineDestination) validateVolumePlacement(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumePlacement) { // not required
		return nil
	}

	if m.VolumePlacement != nil {
		if err := m.VolumePlacement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "volume_placement")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline destination based on the context it is used
func (m *SvmMigrationInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumePlacement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineDestination) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationInlineDestination) contextValidateVolumePlacement(ctx context.Context, formats strfmt.Registry) error {

	if m.VolumePlacement != nil {
		if err := m.VolumePlacement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "volume_placement")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineDestination) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineDestination) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineDestinationInlineIpspace Optional property used to specify which IPspace to use for the SVM. By default, the "default" ipspace is used.
//
// swagger:model svm_migration_inline_destination_inline_ipspace
type SvmMigrationInlineDestinationInlineIpspace struct {

	// links
	Links *SvmMigrationInlineDestinationInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration inline destination inline ipspace
func (m *SvmMigrationInlineDestinationInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineDestinationInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline destination inline ipspace based on the context it is used
func (m *SvmMigrationInlineDestinationInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineDestinationInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineDestinationInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineDestinationInlineIpspace) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineDestinationInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineDestinationInlineIpspaceInlineLinks svm migration inline destination inline ipspace inline links
//
// swagger:model svm_migration_inline_destination_inline_ipspace_inline__links
type SvmMigrationInlineDestinationInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm migration inline destination inline ipspace inline links
func (m *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline destination inline ipspace inline links based on the context it is used
func (m *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineDestinationInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineDestinationInlineVolumePlacement Optional property to specify the source volume placement in the destination. It is input only and won't be returned by a subsequent GET. Volume placement is ignored if the migration resumes from the cleanup_failed state.
//
// swagger:model svm_migration_inline_destination_inline_volume_placement
type SvmMigrationInlineDestinationInlineVolumePlacement struct {

	// Optional property used to specify the list of desired aggregates to use for volume creation in the destination.
	Aggregates []*SvmMigrationDestinationVolumePlacementAggregatesItems0 `json:"aggregates,omitempty"`

	// Optional property used to specify the list of desired volume-aggregate pairs in the destination.
	VolumeAggregatePairs []*SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0 `json:"volume_aggregate_pairs,omitempty"`
}

// Validate validates this svm migration inline destination inline volume placement
func (m *SvmMigrationInlineDestinationInlineVolumePlacement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeAggregatePairs(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineDestinationInlineVolumePlacement) validateAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.Aggregates); i++ {
		if swag.IsZero(m.Aggregates[i]) { // not required
			continue
		}

		if m.Aggregates[i] != nil {
			if err := m.Aggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("destination" + "." + "volume_placement" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmMigrationInlineDestinationInlineVolumePlacement) validateVolumeAggregatePairs(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumeAggregatePairs) { // not required
		return nil
	}

	for i := 0; i < len(m.VolumeAggregatePairs); i++ {
		if swag.IsZero(m.VolumeAggregatePairs[i]) { // not required
			continue
		}

		if m.VolumeAggregatePairs[i] != nil {
			if err := m.VolumeAggregatePairs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("destination" + "." + "volume_placement" + "." + "volume_aggregate_pairs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm migration inline destination inline volume placement based on the context it is used
func (m *SvmMigrationInlineDestinationInlineVolumePlacement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeAggregatePairs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineDestinationInlineVolumePlacement) contextValidateAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Aggregates); i++ {

		if m.Aggregates[i] != nil {
			if err := m.Aggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("destination" + "." + "volume_placement" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmMigrationInlineDestinationInlineVolumePlacement) contextValidateVolumeAggregatePairs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VolumeAggregatePairs); i++ {

		if m.VolumeAggregatePairs[i] != nil {
			if err := m.VolumeAggregatePairs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("destination" + "." + "volume_placement" + "." + "volume_aggregate_pairs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineDestinationInlineVolumePlacement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineDestinationInlineVolumePlacement) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineDestinationInlineVolumePlacement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationDestinationVolumePlacementAggregatesItems0 Aggregate
//
// swagger:model SvmMigrationDestinationVolumePlacementAggregatesItems0
type SvmMigrationDestinationVolumePlacementAggregatesItems0 struct {

	// links
	Links *SvmMigrationDestinationVolumePlacementAggregatesItems0Links `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration destination volume placement aggregates items0
func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration destination volume placement aggregates items0 based on the context it is used
func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res SvmMigrationDestinationVolumePlacementAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationDestinationVolumePlacementAggregatesItems0Links svm migration destination volume placement aggregates items0 links
//
// swagger:model SvmMigrationDestinationVolumePlacementAggregatesItems0Links
type SvmMigrationDestinationVolumePlacementAggregatesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm migration destination volume placement aggregates items0 links
func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration destination volume placement aggregates items0 links based on the context it is used
func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementAggregatesItems0Links) UnmarshalBinary(b []byte) error {
	var res SvmMigrationDestinationVolumePlacementAggregatesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0 Volume-aggregate pair information.
//
// swagger:model SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0
type SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0 struct {

	// aggregate
	Aggregate *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate `json:"aggregate,omitempty"`

	// volume
	Volume *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume `json:"volume,omitempty"`
}

// Validate validates this svm migration destination volume placement volume aggregate pairs items0
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregate) { // not required
		return nil
	}

	if m.Aggregate != nil {
		if err := m.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration destination volume placement volume aggregate pairs items0 based on the context it is used
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.Aggregate != nil {
		if err := m.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0) UnmarshalBinary(b []byte) error {
	var res SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate Aggregate to use for volume creation.
//
// swagger:model SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate
type SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate struct {

	// links
	Links *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration destination volume placement volume aggregate pairs items0 aggregate
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration destination volume placement volume aggregate pairs items0 aggregate based on the context it is used
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) UnmarshalBinary(b []byte) error {
	var res SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks svm migration destination volume placement volume aggregate pairs items0 aggregate links
//
// swagger:model SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks
type SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm migration destination volume placement volume aggregate pairs items0 aggregate links
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration destination volume placement volume aggregate pairs items0 aggregate links based on the context it is used
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume Property indicating the source volume.
//
// swagger:model SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume
type SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume struct {

	// links
	Links *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration destination volume placement volume aggregate pairs items0 volume
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration destination volume placement volume aggregate pairs items0 volume based on the context it is used
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume) UnmarshalBinary(b []byte) error {
	var res SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0Volume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks svm migration destination volume placement volume aggregate pairs items0 volume links
//
// swagger:model SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks
type SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm migration destination volume placement volume aggregate pairs items0 volume links
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration destination volume placement volume aggregate pairs items0 volume links based on the context it is used
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineMessagesInlineArrayItem svm migration inline messages inline array item
//
// swagger:model svm_migration_inline_messages_inline_array_item
type SvmMigrationInlineMessagesInlineArrayItem struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this svm migration inline messages inline array item
func (m *SvmMigrationInlineMessagesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this svm migration inline messages inline array item based on the context it is used
func (m *SvmMigrationInlineMessagesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineMessagesInlineArrayItem) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineMessagesInlineArrayItem) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineMessagesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineMessagesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineMessagesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineSource Source cluster details for the SVM migration.
//
// swagger:model svm_migration_inline_source
type SvmMigrationInlineSource struct {

	// cluster
	Cluster *SvmMigrationInlineSourceInlineCluster `json:"cluster,omitempty"`

	// svm
	Svm *SvmMigrationInlineSourceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this svm migration inline source
func (m *SvmMigrationInlineSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSource) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationInlineSource) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline source based on the context it is used
func (m *SvmMigrationInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSource) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationInlineSource) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineSource) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineSourceInlineCluster Source cluster for the SVM migration.
//
// swagger:model svm_migration_inline_source_inline_cluster
type SvmMigrationInlineSourceInlineCluster struct {

	// links
	Links *SvmMigrationInlineSourceInlineClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this svm migration inline source inline cluster
func (m *SvmMigrationInlineSourceInlineCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSourceInlineCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationInlineSourceInlineCluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("source"+"."+"cluster"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm migration inline source inline cluster based on the context it is used
func (m *SvmMigrationInlineSourceInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSourceInlineCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineSourceInlineCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineSourceInlineCluster) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSourceInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineSourceInlineClusterInlineLinks svm migration inline source inline cluster inline links
//
// swagger:model svm_migration_inline_source_inline_cluster_inline__links
type SvmMigrationInlineSourceInlineClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm migration inline source inline cluster inline links
func (m *SvmMigrationInlineSourceInlineClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSourceInlineClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline source inline cluster inline links based on the context it is used
func (m *SvmMigrationInlineSourceInlineClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSourceInlineClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineSourceInlineClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineSourceInlineClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSourceInlineClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineSourceInlineSvm Source SVM
//
// swagger:model svm_migration_inline_source_inline_svm
type SvmMigrationInlineSourceInlineSvm struct {

	// links
	Links *SvmMigrationInlineSourceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration inline source inline svm
func (m *SvmMigrationInlineSourceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSourceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline source inline svm based on the context it is used
func (m *SvmMigrationInlineSourceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSourceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineSourceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineSourceInlineSvm) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSourceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineSourceInlineSvmInlineLinks svm migration inline source inline svm inline links
//
// swagger:model svm_migration_inline_source_inline_svm_inline__links
type SvmMigrationInlineSourceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm migration inline source inline svm inline links
func (m *SvmMigrationInlineSourceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSourceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline source inline svm inline links based on the context it is used
func (m *SvmMigrationInlineSourceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineSourceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineSourceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineSourceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSourceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmMigrationInlineTimeMetrics Various time metrics details
//
// swagger:model svm_migration_inline_time_metrics
type SvmMigrationInlineTimeMetrics struct {

	// Cutover end time
	// Example: 2020-12-02 19:30:19-08:00
	// Read Only: true
	// Format: date-time
	CutoverCompleteTime *strfmt.DateTime `json:"cutover_complete_time,omitempty"`

	// Cutover start time
	// Example: 2020-12-02 18:20:19-08:00
	// Read Only: true
	// Format: date-time
	CutoverStartTime *strfmt.DateTime `json:"cutover_start_time,omitempty"`

	// Cutover trigger time
	// Example: 2020-12-02 19:15:19-08:00
	// Read Only: true
	// Format: date-time
	CutoverTriggerTime *strfmt.DateTime `json:"cutover_trigger_time,omitempty"`

	// Migration end time
	// Example: 2020-12-02 19:36:19-08:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// Last migration pause time
	// Example: 2020-12-02 18:50:19-08:00
	// Read Only: true
	// Format: date-time
	LastPauseTime *strfmt.DateTime `json:"last_pause_time,omitempty"`

	// Last post point of no return retry time
	// Example: 2020-12-02 19:30:19-08:00
	// Read Only: true
	// Format: date-time
	LastPostPonrRetryTime *strfmt.DateTime `json:"last_post_ponr_retry_time,omitempty"`

	// Last migration resume time
	// Example: 2020-12-02 18:54:19-08:00
	// Read Only: true
	// Format: date-time
	LastResumeTime *strfmt.DateTime `json:"last_resume_time,omitempty"`

	// Migration start time
	// Example: 2020-12-02 18:36:19-08:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this svm migration inline time metrics
func (m *SvmMigrationInlineTimeMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCutoverCompleteTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCutoverStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCutoverTriggerTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastPauseTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastPostPonrRetryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastResumeTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineTimeMetrics) validateCutoverCompleteTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CutoverCompleteTime) { // not required
		return nil
	}

	if err := validate.FormatOf("time_metrics"+"."+"cutover_complete_time", "body", "date-time", m.CutoverCompleteTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) validateCutoverStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CutoverStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("time_metrics"+"."+"cutover_start_time", "body", "date-time", m.CutoverStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) validateCutoverTriggerTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CutoverTriggerTime) { // not required
		return nil
	}

	if err := validate.FormatOf("time_metrics"+"."+"cutover_trigger_time", "body", "date-time", m.CutoverTriggerTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("time_metrics"+"."+"end_time", "body", "date-time", m.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) validateLastPauseTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastPauseTime) { // not required
		return nil
	}

	if err := validate.FormatOf("time_metrics"+"."+"last_pause_time", "body", "date-time", m.LastPauseTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) validateLastPostPonrRetryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastPostPonrRetryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("time_metrics"+"."+"last_post_ponr_retry_time", "body", "date-time", m.LastPostPonrRetryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) validateLastResumeTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastResumeTime) { // not required
		return nil
	}

	if err := validate.FormatOf("time_metrics"+"."+"last_resume_time", "body", "date-time", m.LastResumeTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("time_metrics"+"."+"start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm migration inline time metrics based on the context it is used
func (m *SvmMigrationInlineTimeMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCutoverCompleteTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCutoverStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCutoverTriggerTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastPauseTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastPostPonrRetryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastResumeTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationInlineTimeMetrics) contextValidateCutoverCompleteTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_metrics"+"."+"cutover_complete_time", "body", m.CutoverCompleteTime); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) contextValidateCutoverStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_metrics"+"."+"cutover_start_time", "body", m.CutoverStartTime); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) contextValidateCutoverTriggerTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_metrics"+"."+"cutover_trigger_time", "body", m.CutoverTriggerTime); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_metrics"+"."+"end_time", "body", m.EndTime); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) contextValidateLastPauseTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_metrics"+"."+"last_pause_time", "body", m.LastPauseTime); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) contextValidateLastPostPonrRetryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_metrics"+"."+"last_post_ponr_retry_time", "body", m.LastPostPonrRetryTime); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) contextValidateLastResumeTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_metrics"+"."+"last_resume_time", "body", m.LastResumeTime); err != nil {
		return err
	}

	return nil
}

func (m *SvmMigrationInlineTimeMetrics) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_metrics"+"."+"start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationInlineTimeMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationInlineTimeMetrics) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineTimeMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
