// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SvmMigrationCreate svm migration create
//
// swagger:model svm_migration_create
type SvmMigrationCreate struct {

	// job
	// Read Only: true
	Job *JobLink `json:"job,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// svm migration create inline records
	SvmMigrationCreateInlineRecords []*SvmMigration `json:"records,omitempty"`
}

// Validate validates this svm migration create
func (m *SvmMigrationCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmMigrationCreateInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationCreate) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationCreate) validateSvmMigrationCreateInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmMigrationCreateInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmMigrationCreateInlineRecords); i++ {
		if swag.IsZero(m.SvmMigrationCreateInlineRecords[i]) { // not required
			continue
		}

		if m.SvmMigrationCreateInlineRecords[i] != nil {
			if err := m.SvmMigrationCreateInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm migration create based on the context it is used
func (m *SvmMigrationCreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmMigrationCreateInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmMigrationCreate) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *SvmMigrationCreate) contextValidateSvmMigrationCreateInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmMigrationCreateInlineRecords); i++ {

		if m.SvmMigrationCreateInlineRecords[i] != nil {
			if err := m.SvmMigrationCreateInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmMigrationCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmMigrationCreate) UnmarshalBinary(b []byte) error {
	var res SvmMigrationCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
