// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SvmPeer An SVM peer relationship object.
//
// swagger:model svm_peer
type SvmPeer struct {

	// links
	Links *SvmPeerInlineLinks `json:"_links,omitempty"`

	// Use this to suspend, resume or delete the SVM peer relationship even if the remote cluster is not accessible due to, for example, network connectivity issues.
	Force *bool `json:"force,omitempty"`

	// A peer SVM alias name to avoid a name conflict on the local cluster.
	Name *string `json:"name,omitempty"`

	// peer
	Peer *SvmPeerInlinePeer `json:"peer,omitempty"`

	// SVM peering state. To accept a pending SVM peer request, PATCH the state to "peered". To reject a pending SVM peer request, PATCH the state to "rejected". To suspend a peered SVM peer relationship, PATCH the state to "suspended". To resume a suspended SVM peer relationship, PATCH the state to "peered". The states "initiated", "pending", and "initializing" are system-generated and cannot be used for PATCH.
	// Example: peered
	// Enum: ["peered","rejected","suspended","initiated","pending","initializing"]
	State *string `json:"state,omitempty"`

	// svm
	Svm *SvmPeerInlineSvm `json:"svm,omitempty"`

	// A list of applications for an SVM peer relationship.
	// Example: ["snapmirror","lun_copy"]
	SvmPeerInlineApplications []*SvmPeerApplications `json:"applications,omitempty"`

	// SVM peer relationship UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm peer
func (m *SvmPeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmPeerInlineApplications(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmPeer) validatePeer(formats strfmt.Registry) error {
	if swag.IsZero(m.Peer) { // not required
		return nil
	}

	if m.Peer != nil {
		if err := m.Peer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer")
			}
			return err
		}
	}

	return nil
}

var svmPeerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["peered","rejected","suspended","initiated","pending","initializing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmPeerTypeStatePropEnum = append(svmPeerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_peer
	// SvmPeer
	// state
	// State
	// peered
	// END DEBUGGING
	// SvmPeerStatePeered captures enum value "peered"
	SvmPeerStatePeered string = "peered"

	// BEGIN DEBUGGING
	// svm_peer
	// SvmPeer
	// state
	// State
	// rejected
	// END DEBUGGING
	// SvmPeerStateRejected captures enum value "rejected"
	SvmPeerStateRejected string = "rejected"

	// BEGIN DEBUGGING
	// svm_peer
	// SvmPeer
	// state
	// State
	// suspended
	// END DEBUGGING
	// SvmPeerStateSuspended captures enum value "suspended"
	SvmPeerStateSuspended string = "suspended"

	// BEGIN DEBUGGING
	// svm_peer
	// SvmPeer
	// state
	// State
	// initiated
	// END DEBUGGING
	// SvmPeerStateInitiated captures enum value "initiated"
	SvmPeerStateInitiated string = "initiated"

	// BEGIN DEBUGGING
	// svm_peer
	// SvmPeer
	// state
	// State
	// pending
	// END DEBUGGING
	// SvmPeerStatePending captures enum value "pending"
	SvmPeerStatePending string = "pending"

	// BEGIN DEBUGGING
	// svm_peer
	// SvmPeer
	// state
	// State
	// initializing
	// END DEBUGGING
	// SvmPeerStateInitializing captures enum value "initializing"
	SvmPeerStateInitializing string = "initializing"
)

// prop value enum
func (m *SvmPeer) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmPeerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SvmPeer) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *SvmPeer) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SvmPeer) validateSvmPeerInlineApplications(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmPeerInlineApplications) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmPeerInlineApplications); i++ {
		if swag.IsZero(m.SvmPeerInlineApplications[i]) { // not required
			continue
		}

		if m.SvmPeerInlineApplications[i] != nil {
			if err := m.SvmPeerInlineApplications[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm peer based on the context it is used
func (m *SvmPeer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmPeerInlineApplications(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmPeer) contextValidatePeer(ctx context.Context, formats strfmt.Registry) error {

	if m.Peer != nil {
		if err := m.Peer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer")
			}
			return err
		}
	}

	return nil
}

func (m *SvmPeer) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SvmPeer) contextValidateSvmPeerInlineApplications(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmPeerInlineApplications); i++ {

		if m.SvmPeerInlineApplications[i] != nil {
			if err := m.SvmPeerInlineApplications[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmPeer) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeer) UnmarshalBinary(b []byte) error {
	var res SvmPeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmPeerInlineLinks svm peer inline links
//
// swagger:model svm_peer_inline__links
type SvmPeerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm peer inline links
func (m *SvmPeerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer inline links based on the context it is used
func (m *SvmPeerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmPeerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmPeerInlinePeer Details for a peer SVM object.
//
// swagger:model svm_peer_inline_peer
type SvmPeerInlinePeer struct {

	// cluster
	Cluster *SvmPeerInlinePeerInlineCluster `json:"cluster,omitempty"`

	// svm
	Svm *SvmPeerInlinePeerInlineSvm `json:"svm,omitempty"`
}

// Validate validates this svm peer inline peer
func (m *SvmPeerInlinePeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeer) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (m *SvmPeerInlinePeer) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer inline peer based on the context it is used
func (m *SvmPeerInlinePeer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeer) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (m *SvmPeerInlinePeer) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeerInlinePeer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeerInlinePeer) UnmarshalBinary(b []byte) error {
	var res SvmPeerInlinePeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmPeerInlinePeerInlineCluster svm peer inline peer inline cluster
//
// swagger:model svm_peer_inline_peer_inline_cluster
type SvmPeerInlinePeerInlineCluster struct {

	// links
	Links *SvmPeerInlinePeerInlineClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster2
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: ebe27c49-1adf-4496-8335-ab862aebebf2
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm peer inline peer inline cluster
func (m *SvmPeerInlinePeerInlineCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeerInlineCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer inline peer inline cluster based on the context it is used
func (m *SvmPeerInlinePeerInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeerInlineCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeerInlinePeerInlineCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeerInlinePeerInlineCluster) UnmarshalBinary(b []byte) error {
	var res SvmPeerInlinePeerInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmPeerInlinePeerInlineClusterInlineLinks svm peer inline peer inline cluster inline links
//
// swagger:model svm_peer_inline_peer_inline_cluster_inline__links
type SvmPeerInlinePeerInlineClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm peer inline peer inline cluster inline links
func (m *SvmPeerInlinePeerInlineClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeerInlineClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer inline peer inline cluster inline links based on the context it is used
func (m *SvmPeerInlinePeerInlineClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeerInlineClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeerInlinePeerInlineClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeerInlinePeerInlineClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmPeerInlinePeerInlineClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmPeerInlinePeerInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model svm_peer_inline_peer_inline_svm
type SvmPeerInlinePeerInlineSvm struct {

	// links
	Links *SvmPeerInlinePeerInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm peer inline peer inline svm
func (m *SvmPeerInlinePeerInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeerInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer inline peer inline svm based on the context it is used
func (m *SvmPeerInlinePeerInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeerInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeerInlinePeerInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeerInlinePeerInlineSvm) UnmarshalBinary(b []byte) error {
	var res SvmPeerInlinePeerInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmPeerInlinePeerInlineSvmInlineLinks svm peer inline peer inline svm inline links
//
// swagger:model svm_peer_inline_peer_inline_svm_inline__links
type SvmPeerInlinePeerInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm peer inline peer inline svm inline links
func (m *SvmPeerInlinePeerInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeerInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer inline peer inline svm inline links based on the context it is used
func (m *SvmPeerInlinePeerInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlinePeerInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeerInlinePeerInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeerInlinePeerInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmPeerInlinePeerInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmPeerInlineSvm Local SVM details
//
// swagger:model svm_peer_inline_svm
type SvmPeerInlineSvm struct {

	// links
	Links *SvmPeerInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm peer inline svm
func (m *SvmPeerInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer inline svm based on the context it is used
func (m *SvmPeerInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeerInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeerInlineSvm) UnmarshalBinary(b []byte) error {
	var res SvmPeerInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmPeerInlineSvmInlineLinks svm peer inline svm inline links
//
// swagger:model svm_peer_inline_svm_inline__links
type SvmPeerInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm peer inline svm inline links
func (m *SvmPeerInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer inline svm inline links based on the context it is used
func (m *SvmPeerInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmPeerInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmPeerInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmPeerInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmPeerInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
