// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SvmS3ServiceReference svm s3 service reference
//
// swagger:model svm_s3_service_reference
type SvmS3ServiceReference struct {

	// links
	Links *SvmS3ServiceReferenceInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the S3 service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// certificate
	Certificate *SvmS3ServiceReferenceInlineCertificate `json:"certificate,omitempty"`

	// Specifies the default UNIX user for NAS Access.
	DefaultUnixUser *string `json:"default_unix_user,omitempty"`

	// Specifies the default Windows user for NAS Access.
	DefaultWinUser *string `json:"default_win_user,omitempty"`

	// Specifies whether or not to enable S3. Setting this value to true creates a service if one is not yet created.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies whether HTTP is enabled on the S3 server. By default, HTTP is disabled on the S3 server.
	IsHTTPEnabled *bool `json:"is_http_enabled,omitempty"`

	// Specifies whether HTTPS is enabled on the S3 server. By default, HTTPS is enabled on the S3 server.
	IsHTTPSEnabled *bool `json:"is_https_enabled,omitempty"`

	// Specifies the name of the S3 server. A server name length can range from 1 to 253 characters and can only contain the following combination of characters 0-9, A-Z, a-z, ".", and "-".
	// Example: s3-server-1
	// Max Length: 253
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Specifies the HTTP listener port for the S3 server. By default, HTTP is enabled on port 80.
	Port *int64 `json:"port,omitempty"`

	// Specifies the HTTPS listener port for the S3 server. By default, HTTPS is enabled on port 443.
	SecurePort *int64 `json:"secure_port,omitempty"`
}

// Validate validates this svm s3 service reference
func (m *SvmS3ServiceReference) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmS3ServiceReference) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmS3ServiceReference) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *SvmS3ServiceReference) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 253); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm s3 service reference based on the context it is used
func (m *SvmS3ServiceReference) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmS3ServiceReference) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmS3ServiceReference) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmS3ServiceReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmS3ServiceReference) UnmarshalBinary(b []byte) error {
	var res SvmS3ServiceReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmS3ServiceReferenceInlineCertificate Specifies the certificate that will be used for creating HTTPS connections to the S3 server.
//
// swagger:model svm_s3_service_reference_inline_certificate
type SvmS3ServiceReferenceInlineCertificate struct {

	// links
	Links *SvmS3ServiceReferenceInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm s3 service reference inline certificate
func (m *SvmS3ServiceReferenceInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmS3ServiceReferenceInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm s3 service reference inline certificate based on the context it is used
func (m *SvmS3ServiceReferenceInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmS3ServiceReferenceInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmS3ServiceReferenceInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmS3ServiceReferenceInlineCertificate) UnmarshalBinary(b []byte) error {
	var res SvmS3ServiceReferenceInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmS3ServiceReferenceInlineCertificateInlineLinks svm s3 service reference inline certificate inline links
//
// swagger:model svm_s3_service_reference_inline_certificate_inline__links
type SvmS3ServiceReferenceInlineCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm s3 service reference inline certificate inline links
func (m *SvmS3ServiceReferenceInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmS3ServiceReferenceInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm s3 service reference inline certificate inline links based on the context it is used
func (m *SvmS3ServiceReferenceInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmS3ServiceReferenceInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmS3ServiceReferenceInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmS3ServiceReferenceInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmS3ServiceReferenceInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmS3ServiceReferenceInlineLinks svm s3 service reference inline links
//
// swagger:model svm_s3_service_reference_inline__links
type SvmS3ServiceReferenceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm s3 service reference inline links
func (m *SvmS3ServiceReferenceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmS3ServiceReferenceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm s3 service reference inline links based on the context it is used
func (m *SvmS3ServiceReferenceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmS3ServiceReferenceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmS3ServiceReferenceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmS3ServiceReferenceInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmS3ServiceReferenceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
