// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SvmSSHServer svm ssh server
//
// swagger:model svm_ssh_server
type SvmSSHServer struct {

	// links
	Links *SvmSSHServerInlineLinks `json:"_links,omitempty"`

	// Enables or disables the _ssh-rsa_ signature scheme, which uses the SHA-1 hash algorithm, for RSA keys in public key algorithms. If this flag is _false_, older SSH implementations might fail to authenticate using RSA keys. This flag should be enabled only as a temporary measure until legacy SSH client implementations can be upgraded or reconfigured with another key type, for example: ECDSA.
	//
	IsRsaInPublickeyAlgorithmsEnabled *bool `json:"is_rsa_in_publickey_algorithms_enabled,omitempty"`

	// The login grace time allowed for SSH connection request timeout.
	LoginGraceTime *int64 `json:"login_grace_time,omitempty"`

	// Maximum authentication retries allowed before closing the connection.
	// Maximum: 6
	// Minimum: 2
	MaxAuthenticationRetryCount *int64 `json:"max_authentication_retry_count,omitempty"`

	// svm
	Svm *SvmSSHServerInlineSvm `json:"svm,omitempty"`

	// Ciphers for encrypting the data.
	// Example: ["aes256_ctr","aes192_ctr","aes128_ctr"]
	SvmSSHServerInlineCiphers []*Cipher `json:"ciphers,omitempty"`

	// Host key algorithms. The host key algorithms 'ssh_ed25519' and 'ssh_rsa' can be configured only in non-FIPS mode.
	// Example: ["ecdsa_sha2_nistp256","ssh_ed25519","ssh_rsa","rsa_sha2_256","rsa_sha2_512"]
	SvmSSHServerInlineHostKeyAlgorithms []*HostKeyAlgorithm `json:"host_key_algorithms,omitempty"`

	// Key exchange algorithms.
	// Example: ["diffie_hellman_group_exchange_sha256","ecdh_sha2_nistp256"]
	SvmSSHServerInlineKeyExchangeAlgorithms []*KeyExchangeAlgorithm `json:"key_exchange_algorithms,omitempty"`

	// MAC algorithms.
	// Example: ["hmac_sha2_512","hmac_sha2_512_etm"]
	SvmSSHServerInlineMacAlgorithms []*MacAlgorithm `json:"mac_algorithms,omitempty"`
}

// Validate validates this svm ssh server
func (m *SvmSSHServer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxAuthenticationRetryCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmSSHServerInlineCiphers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmSSHServerInlineHostKeyAlgorithms(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmSSHServerInlineKeyExchangeAlgorithms(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvmSSHServerInlineMacAlgorithms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmSSHServer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmSSHServer) validateMaxAuthenticationRetryCount(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxAuthenticationRetryCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("max_authentication_retry_count", "body", *m.MaxAuthenticationRetryCount, 2, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("max_authentication_retry_count", "body", *m.MaxAuthenticationRetryCount, 6, false); err != nil {
		return err
	}

	return nil
}

func (m *SvmSSHServer) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SvmSSHServer) validateSvmSSHServerInlineCiphers(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmSSHServerInlineCiphers) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmSSHServerInlineCiphers); i++ {
		if swag.IsZero(m.SvmSSHServerInlineCiphers[i]) { // not required
			continue
		}

		if m.SvmSSHServerInlineCiphers[i] != nil {
			if err := m.SvmSSHServerInlineCiphers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ciphers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmSSHServer) validateSvmSSHServerInlineHostKeyAlgorithms(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmSSHServerInlineHostKeyAlgorithms) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmSSHServerInlineHostKeyAlgorithms); i++ {
		if swag.IsZero(m.SvmSSHServerInlineHostKeyAlgorithms[i]) { // not required
			continue
		}

		if m.SvmSSHServerInlineHostKeyAlgorithms[i] != nil {
			if err := m.SvmSSHServerInlineHostKeyAlgorithms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("host_key_algorithms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmSSHServer) validateSvmSSHServerInlineKeyExchangeAlgorithms(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmSSHServerInlineKeyExchangeAlgorithms) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmSSHServerInlineKeyExchangeAlgorithms); i++ {
		if swag.IsZero(m.SvmSSHServerInlineKeyExchangeAlgorithms[i]) { // not required
			continue
		}

		if m.SvmSSHServerInlineKeyExchangeAlgorithms[i] != nil {
			if err := m.SvmSSHServerInlineKeyExchangeAlgorithms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("key_exchange_algorithms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmSSHServer) validateSvmSSHServerInlineMacAlgorithms(formats strfmt.Registry) error {
	if swag.IsZero(m.SvmSSHServerInlineMacAlgorithms) { // not required
		return nil
	}

	for i := 0; i < len(m.SvmSSHServerInlineMacAlgorithms); i++ {
		if swag.IsZero(m.SvmSSHServerInlineMacAlgorithms[i]) { // not required
			continue
		}

		if m.SvmSSHServerInlineMacAlgorithms[i] != nil {
			if err := m.SvmSSHServerInlineMacAlgorithms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mac_algorithms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm ssh server based on the context it is used
func (m *SvmSSHServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmSSHServerInlineCiphers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmSSHServerInlineHostKeyAlgorithms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmSSHServerInlineKeyExchangeAlgorithms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmSSHServerInlineMacAlgorithms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmSSHServer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SvmSSHServer) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SvmSSHServer) contextValidateSvmSSHServerInlineCiphers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmSSHServerInlineCiphers); i++ {

		if m.SvmSSHServerInlineCiphers[i] != nil {
			if err := m.SvmSSHServerInlineCiphers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ciphers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmSSHServer) contextValidateSvmSSHServerInlineHostKeyAlgorithms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmSSHServerInlineHostKeyAlgorithms); i++ {

		if m.SvmSSHServerInlineHostKeyAlgorithms[i] != nil {
			if err := m.SvmSSHServerInlineHostKeyAlgorithms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("host_key_algorithms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmSSHServer) contextValidateSvmSSHServerInlineKeyExchangeAlgorithms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmSSHServerInlineKeyExchangeAlgorithms); i++ {

		if m.SvmSSHServerInlineKeyExchangeAlgorithms[i] != nil {
			if err := m.SvmSSHServerInlineKeyExchangeAlgorithms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("key_exchange_algorithms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SvmSSHServer) contextValidateSvmSSHServerInlineMacAlgorithms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SvmSSHServerInlineMacAlgorithms); i++ {

		if m.SvmSSHServerInlineMacAlgorithms[i] != nil {
			if err := m.SvmSSHServerInlineMacAlgorithms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mac_algorithms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmSSHServer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmSSHServer) UnmarshalBinary(b []byte) error {
	var res SvmSSHServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmSSHServerInlineLinks svm ssh server inline links
//
// swagger:model svm_ssh_server_inline__links
type SvmSSHServerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm ssh server inline links
func (m *SvmSSHServerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmSSHServerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm ssh server inline links based on the context it is used
func (m *SvmSSHServerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmSSHServerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmSSHServerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmSSHServerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmSSHServerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmSSHServerInlineSvm SVM name and UUID for which the SSH server is configured.
//
// swagger:model svm_ssh_server_inline_svm
type SvmSSHServerInlineSvm struct {

	// links
	Links *SvmSSHServerInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm ssh server inline svm
func (m *SvmSSHServerInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmSSHServerInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm ssh server inline svm based on the context it is used
func (m *SvmSSHServerInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmSSHServerInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmSSHServerInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmSSHServerInlineSvm) UnmarshalBinary(b []byte) error {
	var res SvmSSHServerInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SvmSSHServerInlineSvmInlineLinks svm ssh server inline svm inline links
//
// swagger:model svm_ssh_server_inline_svm_inline__links
type SvmSSHServerInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this svm ssh server inline svm inline links
func (m *SvmSSHServerInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmSSHServerInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm ssh server inline svm inline links based on the context it is used
func (m *SvmSSHServerInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SvmSSHServerInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SvmSSHServerInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SvmSSHServerInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmSSHServerInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
