// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Switch Ethernet Switch REST API
//
// swagger:model switch
type Switch struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// IP Address.
	Address *string `json:"address,omitempty"`

	// Discovered By ONTAP CDP/LLDP
	// Read Only: true
	Discovered *bool `json:"discovered,omitempty"`

	// Model Number.
	Model *string `json:"model,omitempty"`

	// monitoring
	Monitoring *SwitchInlineMonitoring `json:"monitoring,omitempty"`

	// Name.
	Name *string `json:"name,omitempty"`

	// Switch Network.
	// Enum: ["cluster","storage"]
	Network *string `json:"network,omitempty"`

	// The switch reference configuration file (RCF) version.
	// Example: RCF NX9336C-FX2 v1.13 1-CLUSTER
	// Read Only: true
	RcfVersion *string `json:"rcf_version,omitempty"`

	// Switch role based on the interface configurations. Using '+' to combine multiple roles.
	// Available role types are: cluster, multicluster, storage, multistorage, metrocluster.
	//
	// Example: ["cluster+storage"]
	// Read Only: true
	Role *string `json:"role,omitempty"`

	// Serial Number.
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// snmp
	Snmp *SwitchInlineSnmp `json:"snmp,omitempty"`

	// Software Version.
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this switch
func (m *Switch) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMonitoring(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetwork(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnmp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Switch) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Switch) validateMonitoring(formats strfmt.Registry) error {
	if swag.IsZero(m.Monitoring) { // not required
		return nil
	}

	if m.Monitoring != nil {
		if err := m.Monitoring.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("monitoring")
			}
			return err
		}
	}

	return nil
}

var switchTypeNetworkPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","storage"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchTypeNetworkPropEnum = append(switchTypeNetworkPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch
	// Switch
	// network
	// Network
	// cluster
	// END DEBUGGING
	// SwitchNetworkCluster captures enum value "cluster"
	SwitchNetworkCluster string = "cluster"

	// BEGIN DEBUGGING
	// switch
	// Switch
	// network
	// Network
	// storage
	// END DEBUGGING
	// SwitchNetworkStorage captures enum value "storage"
	SwitchNetworkStorage string = "storage"
)

// prop value enum
func (m *Switch) validateNetworkEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchTypeNetworkPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Switch) validateNetwork(formats strfmt.Registry) error {
	if swag.IsZero(m.Network) { // not required
		return nil
	}

	// value enum
	if err := m.validateNetworkEnum("network", "body", *m.Network); err != nil {
		return err
	}

	return nil
}

func (m *Switch) validateSnmp(formats strfmt.Registry) error {
	if swag.IsZero(m.Snmp) { // not required
		return nil
	}

	if m.Snmp != nil {
		if err := m.Snmp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snmp")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch based on the context it is used
func (m *Switch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDiscovered(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMonitoring(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRcfVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnmp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Switch) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Switch) contextValidateDiscovered(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "discovered", "body", m.Discovered); err != nil {
		return err
	}

	return nil
}

func (m *Switch) contextValidateMonitoring(ctx context.Context, formats strfmt.Registry) error {

	if m.Monitoring != nil {
		if err := m.Monitoring.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("monitoring")
			}
			return err
		}
	}

	return nil
}

func (m *Switch) contextValidateRcfVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rcf_version", "body", m.RcfVersion); err != nil {
		return err
	}

	return nil
}

func (m *Switch) contextValidateRole(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "role", "body", m.Role); err != nil {
		return err
	}

	return nil
}

func (m *Switch) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *Switch) contextValidateSnmp(ctx context.Context, formats strfmt.Registry) error {

	if m.Snmp != nil {
		if err := m.Snmp.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snmp")
			}
			return err
		}
	}

	return nil
}

func (m *Switch) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Switch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Switch) UnmarshalBinary(b []byte) error {
	var res Switch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchInlineMonitoring switch inline monitoring
//
// swagger:model switch_inline_monitoring
type SwitchInlineMonitoring struct {

	// Enable Health Monitoring.
	Enabled *bool `json:"enabled,omitempty"`

	// Is Monitored.
	// Read Only: true
	Monitored *bool `json:"monitored,omitempty"`

	// Reason For Not Monitoring.
	// Read Only: true
	// Enum: ["none","unsupported_model","user_deleted","bad_ip_address","invalid_snmp_settings","bad_model","invalid_software_version","user_disabled","unknown"]
	Reason *string `json:"reason,omitempty"`
}

// Validate validates this switch inline monitoring
func (m *SwitchInlineMonitoring) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var switchInlineMonitoringTypeReasonPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","unsupported_model","user_deleted","bad_ip_address","invalid_snmp_settings","bad_model","invalid_software_version","user_disabled","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchInlineMonitoringTypeReasonPropEnum = append(switchInlineMonitoringTypeReasonPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// none
	// END DEBUGGING
	// SwitchInlineMonitoringReasonNone captures enum value "none"
	SwitchInlineMonitoringReasonNone string = "none"

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// unsupported_model
	// END DEBUGGING
	// SwitchInlineMonitoringReasonUnsupportedModel captures enum value "unsupported_model"
	SwitchInlineMonitoringReasonUnsupportedModel string = "unsupported_model"

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// user_deleted
	// END DEBUGGING
	// SwitchInlineMonitoringReasonUserDeleted captures enum value "user_deleted"
	SwitchInlineMonitoringReasonUserDeleted string = "user_deleted"

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// bad_ip_address
	// END DEBUGGING
	// SwitchInlineMonitoringReasonBadIPAddress captures enum value "bad_ip_address"
	SwitchInlineMonitoringReasonBadIPAddress string = "bad_ip_address"

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// invalid_snmp_settings
	// END DEBUGGING
	// SwitchInlineMonitoringReasonInvalidSnmpSettings captures enum value "invalid_snmp_settings"
	SwitchInlineMonitoringReasonInvalidSnmpSettings string = "invalid_snmp_settings"

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// bad_model
	// END DEBUGGING
	// SwitchInlineMonitoringReasonBadModel captures enum value "bad_model"
	SwitchInlineMonitoringReasonBadModel string = "bad_model"

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// invalid_software_version
	// END DEBUGGING
	// SwitchInlineMonitoringReasonInvalidSoftwareVersion captures enum value "invalid_software_version"
	SwitchInlineMonitoringReasonInvalidSoftwareVersion string = "invalid_software_version"

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// user_disabled
	// END DEBUGGING
	// SwitchInlineMonitoringReasonUserDisabled captures enum value "user_disabled"
	SwitchInlineMonitoringReasonUserDisabled string = "user_disabled"

	// BEGIN DEBUGGING
	// switch_inline_monitoring
	// SwitchInlineMonitoring
	// reason
	// Reason
	// unknown
	// END DEBUGGING
	// SwitchInlineMonitoringReasonUnknown captures enum value "unknown"
	SwitchInlineMonitoringReasonUnknown string = "unknown"
)

// prop value enum
func (m *SwitchInlineMonitoring) validateReasonEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchInlineMonitoringTypeReasonPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchInlineMonitoring) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	// value enum
	if err := m.validateReasonEnum("monitoring"+"."+"reason", "body", *m.Reason); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this switch inline monitoring based on the context it is used
func (m *SwitchInlineMonitoring) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMonitored(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchInlineMonitoring) contextValidateMonitored(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "monitoring"+"."+"monitored", "body", m.Monitored); err != nil {
		return err
	}

	return nil
}

func (m *SwitchInlineMonitoring) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "monitoring"+"."+"reason", "body", m.Reason); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchInlineMonitoring) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchInlineMonitoring) UnmarshalBinary(b []byte) error {
	var res SwitchInlineMonitoring
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchInlineSnmp switch inline snmp
//
// swagger:model switch_inline_snmp
type SwitchInlineSnmp struct {

	// Community String or SNMPv3 Username.
	User *string `json:"user,omitempty"`

	// SNMP Version.
	// Enum: ["snmpv1","snmpv2c","snmpv3"]
	Version *string `json:"version,omitempty"`
}

// Validate validates this switch inline snmp
func (m *SwitchInlineSnmp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var switchInlineSnmpTypeVersionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["snmpv1","snmpv2c","snmpv3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchInlineSnmpTypeVersionPropEnum = append(switchInlineSnmpTypeVersionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch_inline_snmp
	// SwitchInlineSnmp
	// version
	// Version
	// snmpv1
	// END DEBUGGING
	// SwitchInlineSnmpVersionSnmpv1 captures enum value "snmpv1"
	SwitchInlineSnmpVersionSnmpv1 string = "snmpv1"

	// BEGIN DEBUGGING
	// switch_inline_snmp
	// SwitchInlineSnmp
	// version
	// Version
	// snmpv2c
	// END DEBUGGING
	// SwitchInlineSnmpVersionSnmpv2c captures enum value "snmpv2c"
	SwitchInlineSnmpVersionSnmpv2c string = "snmpv2c"

	// BEGIN DEBUGGING
	// switch_inline_snmp
	// SwitchInlineSnmp
	// version
	// Version
	// snmpv3
	// END DEBUGGING
	// SwitchInlineSnmpVersionSnmpv3 captures enum value "snmpv3"
	SwitchInlineSnmpVersionSnmpv3 string = "snmpv3"
)

// prop value enum
func (m *SwitchInlineSnmp) validateVersionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchInlineSnmpTypeVersionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchInlineSnmp) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	// value enum
	if err := m.validateVersionEnum("snmp"+"."+"version", "body", *m.Version); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this switch inline snmp based on context it is used
func (m *SwitchInlineSnmp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SwitchInlineSnmp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchInlineSnmp) UnmarshalBinary(b []byte) error {
	var res SwitchInlineSnmp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
