// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SwitchPort Ethernet Switch Port REST API
//
// swagger:model switch_port
type SwitchPort struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Administrative Status.
	// Read Only: true
	// Enum: ["down","testing","up"]
	Configured *string `json:"configured,omitempty"`

	// Duplex Settings.
	// Read Only: true
	// Enum: ["full_duplex","half_duplex","unknown"]
	DuplexType *string `json:"duplex_type,omitempty"`

	// identity
	Identity *SwitchPortInlineIdentity `json:"identity,omitempty"`

	// Is configured as an ISL link.
	// Read Only: true
	Isl *bool `json:"isl,omitempty"`

	// MAC Address.
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// MTU.
	// Read Only: true
	Mtu *int64 `json:"mtu,omitempty"`

	// remote port
	RemotePort *SwitchPortInlineRemotePort `json:"remote_port,omitempty"`

	// Interface Speed(Mbps).
	// Read Only: true
	Speed *int64 `json:"speed,omitempty"`

	// Operational Status.
	// Read Only: true
	// Enum: ["dormant","down","lower_layer_down","not_present","testing","unknown","up"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *SwitchPortInlineStatistics `json:"statistics,omitempty"`

	// switch
	Switch *SwitchPortInlineSwitch `json:"switch,omitempty"`

	// switch port inline roles
	// Read Only: true
	SwitchPortInlineRoles []*SwitchPortInlineRolesInlineArrayItem `json:"roles,omitempty"`

	// switch port inline vlan id
	SwitchPortInlineVlanID []*int64 `json:"vlan_id,omitempty"`

	// Interface Type.
	// Read Only: true
	// Enum: ["ethernetcsmacd","fastetherfx","fibrechannel","gigabitethernet","ieee8023adlag","other","propvirtual","softwareloopback","tunnel"]
	Type *string `json:"type,omitempty"`

	// Is configured as a Virtual Port Channel (vPC) peer-link.
	// Read Only: true
	VpcPeerLink *bool `json:"vpc_peer_link,omitempty"`
}

// Validate validates this switch port
func (m *SwitchPort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigured(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuplexType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdentity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemotePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSwitch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSwitchPortInlineRoles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var switchPortTypeConfiguredPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","testing","up"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchPortTypeConfiguredPropEnum = append(switchPortTypeConfiguredPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// configured
	// Configured
	// down
	// END DEBUGGING
	// SwitchPortConfiguredDown captures enum value "down"
	SwitchPortConfiguredDown string = "down"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// configured
	// Configured
	// testing
	// END DEBUGGING
	// SwitchPortConfiguredTesting captures enum value "testing"
	SwitchPortConfiguredTesting string = "testing"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// configured
	// Configured
	// up
	// END DEBUGGING
	// SwitchPortConfiguredUp captures enum value "up"
	SwitchPortConfiguredUp string = "up"
)

// prop value enum
func (m *SwitchPort) validateConfiguredEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchPortTypeConfiguredPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchPort) validateConfigured(formats strfmt.Registry) error {
	if swag.IsZero(m.Configured) { // not required
		return nil
	}

	// value enum
	if err := m.validateConfiguredEnum("configured", "body", *m.Configured); err != nil {
		return err
	}

	return nil
}

var switchPortTypeDuplexTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full_duplex","half_duplex","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchPortTypeDuplexTypePropEnum = append(switchPortTypeDuplexTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// duplex_type
	// DuplexType
	// full_duplex
	// END DEBUGGING
	// SwitchPortDuplexTypeFullDuplex captures enum value "full_duplex"
	SwitchPortDuplexTypeFullDuplex string = "full_duplex"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// duplex_type
	// DuplexType
	// half_duplex
	// END DEBUGGING
	// SwitchPortDuplexTypeHalfDuplex captures enum value "half_duplex"
	SwitchPortDuplexTypeHalfDuplex string = "half_duplex"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// duplex_type
	// DuplexType
	// unknown
	// END DEBUGGING
	// SwitchPortDuplexTypeUnknown captures enum value "unknown"
	SwitchPortDuplexTypeUnknown string = "unknown"
)

// prop value enum
func (m *SwitchPort) validateDuplexTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchPortTypeDuplexTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchPort) validateDuplexType(formats strfmt.Registry) error {
	if swag.IsZero(m.DuplexType) { // not required
		return nil
	}

	// value enum
	if err := m.validateDuplexTypeEnum("duplex_type", "body", *m.DuplexType); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) validateIdentity(formats strfmt.Registry) error {
	if swag.IsZero(m.Identity) { // not required
		return nil
	}

	if m.Identity != nil {
		if err := m.Identity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("identity")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPort) validateRemotePort(formats strfmt.Registry) error {
	if swag.IsZero(m.RemotePort) { // not required
		return nil
	}

	if m.RemotePort != nil {
		if err := m.RemotePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port")
			}
			return err
		}
	}

	return nil
}

var switchPortTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["dormant","down","lower_layer_down","not_present","testing","unknown","up"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchPortTypeStatePropEnum = append(switchPortTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// state
	// State
	// dormant
	// END DEBUGGING
	// SwitchPortStateDormant captures enum value "dormant"
	SwitchPortStateDormant string = "dormant"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// state
	// State
	// down
	// END DEBUGGING
	// SwitchPortStateDown captures enum value "down"
	SwitchPortStateDown string = "down"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// state
	// State
	// lower_layer_down
	// END DEBUGGING
	// SwitchPortStateLowerLayerDown captures enum value "lower_layer_down"
	SwitchPortStateLowerLayerDown string = "lower_layer_down"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// state
	// State
	// not_present
	// END DEBUGGING
	// SwitchPortStateNotPresent captures enum value "not_present"
	SwitchPortStateNotPresent string = "not_present"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// state
	// State
	// testing
	// END DEBUGGING
	// SwitchPortStateTesting captures enum value "testing"
	SwitchPortStateTesting string = "testing"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// state
	// State
	// unknown
	// END DEBUGGING
	// SwitchPortStateUnknown captures enum value "unknown"
	SwitchPortStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// state
	// State
	// up
	// END DEBUGGING
	// SwitchPortStateUp captures enum value "up"
	SwitchPortStateUp string = "up"
)

// prop value enum
func (m *SwitchPort) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchPortTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchPort) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPort) validateSwitch(formats strfmt.Registry) error {
	if swag.IsZero(m.Switch) { // not required
		return nil
	}

	if m.Switch != nil {
		if err := m.Switch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("switch")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPort) validateSwitchPortInlineRoles(formats strfmt.Registry) error {
	if swag.IsZero(m.SwitchPortInlineRoles) { // not required
		return nil
	}

	for i := 0; i < len(m.SwitchPortInlineRoles); i++ {
		if swag.IsZero(m.SwitchPortInlineRoles[i]) { // not required
			continue
		}

		if m.SwitchPortInlineRoles[i] != nil {
			if err := m.SwitchPortInlineRoles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("roles" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var switchPortTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ethernetcsmacd","fastetherfx","fibrechannel","gigabitethernet","ieee8023adlag","other","propvirtual","softwareloopback","tunnel"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchPortTypeTypePropEnum = append(switchPortTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// ethernetcsmacd
	// END DEBUGGING
	// SwitchPortTypeEthernetcsmacd captures enum value "ethernetcsmacd"
	SwitchPortTypeEthernetcsmacd string = "ethernetcsmacd"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// fastetherfx
	// END DEBUGGING
	// SwitchPortTypeFastetherfx captures enum value "fastetherfx"
	SwitchPortTypeFastetherfx string = "fastetherfx"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// fibrechannel
	// END DEBUGGING
	// SwitchPortTypeFibrechannel captures enum value "fibrechannel"
	SwitchPortTypeFibrechannel string = "fibrechannel"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// gigabitethernet
	// END DEBUGGING
	// SwitchPortTypeGigabitethernet captures enum value "gigabitethernet"
	SwitchPortTypeGigabitethernet string = "gigabitethernet"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// ieee8023adlag
	// END DEBUGGING
	// SwitchPortTypeIeee8023adlag captures enum value "ieee8023adlag"
	SwitchPortTypeIeee8023adlag string = "ieee8023adlag"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// other
	// END DEBUGGING
	// SwitchPortTypeOther captures enum value "other"
	SwitchPortTypeOther string = "other"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// propvirtual
	// END DEBUGGING
	// SwitchPortTypePropvirtual captures enum value "propvirtual"
	SwitchPortTypePropvirtual string = "propvirtual"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// softwareloopback
	// END DEBUGGING
	// SwitchPortTypeSoftwareloopback captures enum value "softwareloopback"
	SwitchPortTypeSoftwareloopback string = "softwareloopback"

	// BEGIN DEBUGGING
	// switch_port
	// SwitchPort
	// type
	// Type
	// tunnel
	// END DEBUGGING
	// SwitchPortTypeTunnel captures enum value "tunnel"
	SwitchPortTypeTunnel string = "tunnel"
)

// prop value enum
func (m *SwitchPort) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchPortTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchPort) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this switch port based on the context it is used
func (m *SwitchPort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuplexType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIdentity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsl(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMtu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemotePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpeed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSwitch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSwitchPortInlineRoles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSwitchPortInlineVlanID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVpcPeerLink(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPort) contextValidateConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "configured", "body", m.Configured); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) contextValidateDuplexType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duplex_type", "body", m.DuplexType); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) contextValidateIdentity(ctx context.Context, formats strfmt.Registry) error {

	if m.Identity != nil {
		if err := m.Identity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("identity")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPort) contextValidateIsl(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "isl", "body", m.Isl); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mac_address", "body", m.MacAddress); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) contextValidateMtu(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mtu", "body", m.Mtu); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) contextValidateRemotePort(ctx context.Context, formats strfmt.Registry) error {

	if m.RemotePort != nil {
		if err := m.RemotePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPort) contextValidateSpeed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "speed", "body", m.Speed); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPort) contextValidateSwitch(ctx context.Context, formats strfmt.Registry) error {

	if m.Switch != nil {
		if err := m.Switch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("switch")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPort) contextValidateSwitchPortInlineRoles(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "roles", "body", []*SwitchPortInlineRolesInlineArrayItem(m.SwitchPortInlineRoles)); err != nil {
		return err
	}

	for i := 0; i < len(m.SwitchPortInlineRoles); i++ {

		if m.SwitchPortInlineRoles[i] != nil {
			if err := m.SwitchPortInlineRoles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("roles" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SwitchPort) contextValidateSwitchPortInlineVlanID(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SwitchPortInlineVlanID); i++ {

		if err := validate.ReadOnly(ctx, "vlan_id"+"."+strconv.Itoa(i), "body", m.SwitchPortInlineVlanID[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *SwitchPort) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPort) contextValidateVpcPeerLink(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vpc_peer_link", "body", m.VpcPeerLink); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPort) UnmarshalBinary(b []byte) error {
	var res SwitchPort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineIdentity switch port inline identity
//
// swagger:model switch_port_inline_identity
type SwitchPortInlineIdentity struct {

	// breakout
	Breakout *SwitchPortInlineIdentityInlineBreakout `json:"breakout,omitempty"`

	// Interface Index.
	// Read Only: true
	Index *int64 `json:"index,omitempty"`

	// Interface Name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Interface Number.
	// Read Only: true
	Number *int64 `json:"number,omitempty"`
}

// Validate validates this switch port inline identity
func (m *SwitchPortInlineIdentity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBreakout(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineIdentity) validateBreakout(formats strfmt.Registry) error {
	if swag.IsZero(m.Breakout) { // not required
		return nil
	}

	if m.Breakout != nil {
		if err := m.Breakout.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("identity" + "." + "breakout")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch port inline identity based on the context it is used
func (m *SwitchPortInlineIdentity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBreakout(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIndex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineIdentity) contextValidateBreakout(ctx context.Context, formats strfmt.Registry) error {

	if m.Breakout != nil {
		if err := m.Breakout.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("identity" + "." + "breakout")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineIdentity) contextValidateIndex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "identity"+"."+"index", "body", m.Index); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPortInlineIdentity) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "identity"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPortInlineIdentity) contextValidateNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "identity"+"."+"number", "body", m.Number); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineIdentity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineIdentity) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineIdentity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineIdentityInlineBreakout switch port inline identity inline breakout
//
// swagger:model switch_port_inline_identity_inline_breakout
type SwitchPortInlineIdentityInlineBreakout struct {

	// Breakout port sub-interface number.
	// Example: 1
	// Read Only: true
	Number *int64 `json:"number,omitempty"`

	// Breakout physical port name.
	// Example: Ethernet1/9
	// Read Only: true
	PhysicalPort *string `json:"physical_port,omitempty"`
}

// Validate validates this switch port inline identity inline breakout
func (m *SwitchPortInlineIdentityInlineBreakout) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this switch port inline identity inline breakout based on the context it is used
func (m *SwitchPortInlineIdentityInlineBreakout) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalPort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineIdentityInlineBreakout) contextValidateNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "identity"+"."+"breakout"+"."+"number", "body", m.Number); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPortInlineIdentityInlineBreakout) contextValidatePhysicalPort(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "identity"+"."+"breakout"+"."+"physical_port", "body", m.PhysicalPort); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineIdentityInlineBreakout) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineIdentityInlineBreakout) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineIdentityInlineBreakout
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRemotePort Remote port.
//
// swagger:model switch_port_inline_remote_port
type SwitchPortInlineRemotePort struct {

	// device
	Device *SwitchPortInlineRemotePortInlineDevice `json:"device,omitempty"`

	// functional roles
	FunctionalRoles []*string `json:"functional_roles,omitempty"`

	// MTU in octets.
	// Read Only: true
	Mtu *int64 `json:"mtu,omitempty"`

	// Remote port name.
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this switch port inline remote port
func (m *SwitchPortInlineRemotePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFunctionalRoles(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePort) validateDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.Device) { // not required
		return nil
	}

	if m.Device != nil {
		if err := m.Device.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device")
			}
			return err
		}
	}

	return nil
}

var switchPortInlineRemotePortFunctionalRolesItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","ha","storage_ontap","storage_shelf","compute_ontap","compute_node"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchPortInlineRemotePortFunctionalRolesItemsEnum = append(switchPortInlineRemotePortFunctionalRolesItemsEnum, v)
	}
}

func (m *SwitchPortInlineRemotePort) validateFunctionalRolesItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchPortInlineRemotePortFunctionalRolesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchPortInlineRemotePort) validateFunctionalRoles(formats strfmt.Registry) error {
	if swag.IsZero(m.FunctionalRoles) { // not required
		return nil
	}

	for i := 0; i < len(m.FunctionalRoles); i++ {
		if swag.IsZero(m.FunctionalRoles[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateFunctionalRolesItemsEnum("remote_port"+"."+"functional_roles"+"."+strconv.Itoa(i), "body", *m.FunctionalRoles[i]); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validate this switch port inline remote port based on the context it is used
func (m *SwitchPortInlineRemotePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFunctionalRoles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMtu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePort) contextValidateDevice(ctx context.Context, formats strfmt.Registry) error {

	if m.Device != nil {
		if err := m.Device.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineRemotePort) contextValidateFunctionalRoles(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.FunctionalRoles); i++ {

		if err := validate.ReadOnly(ctx, "remote_port"+"."+"functional_roles"+"."+strconv.Itoa(i), "body", m.FunctionalRoles[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *SwitchPortInlineRemotePort) contextValidateMtu(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_port"+"."+"mtu", "body", m.Mtu); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPortInlineRemotePort) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_port"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRemotePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRemotePort) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRemotePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRemotePortInlineDevice Device connected to port.
//
// swagger:model switch_port_inline_remote_port_inline_device
type SwitchPortInlineRemotePortInlineDevice struct {

	// dcn
	Dcn *SwitchPortInlineRemotePortInlineDeviceInlineDcn `json:"dcn,omitempty"`

	// Raw name of the discovered device.
	// Example: stiA400-311
	// Read Only: true
	DiscoveredName *string `json:"discovered_name,omitempty"`

	// node
	Node *SwitchPortInlineRemotePortInlineDeviceInlineNode `json:"node,omitempty"`

	// shelf
	Shelf *SwitchPortInlineRemotePortInlineDeviceInlineShelf `json:"shelf,omitempty"`
}

// Validate validates this switch port inline remote port inline device
func (m *SwitchPortInlineRemotePortInlineDevice) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDcn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDevice) validateDcn(formats strfmt.Registry) error {
	if swag.IsZero(m.Dcn) { // not required
		return nil
	}

	if m.Dcn != nil {
		if err := m.Dcn.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "dcn")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineRemotePortInlineDevice) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineRemotePortInlineDevice) validateShelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Shelf) { // not required
		return nil
	}

	if m.Shelf != nil {
		if err := m.Shelf.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "shelf")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch port inline remote port inline device based on the context it is used
func (m *SwitchPortInlineRemotePortInlineDevice) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDcn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDiscoveredName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDevice) contextValidateDcn(ctx context.Context, formats strfmt.Registry) error {

	if m.Dcn != nil {
		if err := m.Dcn.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "dcn")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineRemotePortInlineDevice) contextValidateDiscoveredName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_port"+"."+"device"+"."+"discovered_name", "body", m.DiscoveredName); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPortInlineRemotePortInlineDevice) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineRemotePortInlineDevice) contextValidateShelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Shelf != nil {
		if err := m.Shelf.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "shelf")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDevice) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDevice) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRemotePortInlineDevice
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRemotePortInlineDeviceInlineDcn Compute node connected to this port.
//
// swagger:model switch_port_inline_remote_port_inline_device_inline_dcn
type SwitchPortInlineRemotePortInlineDeviceInlineDcn struct {

	// links
	Links *SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks `json:"_links,omitempty"`

	// Compute node name.
	// Example: node1
	Name *string `json:"name,omitempty"`

	// Compute node serial number.
	// Example: 4048820-60-9
	SerialNumber *string `json:"serial_number,omitempty"`

	// Compute node UUID.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this switch port inline remote port inline device inline dcn
func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcn) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcn) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "dcn" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcn) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("remote_port"+"."+"device"+"."+"dcn"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this switch port inline remote port inline device inline dcn based on the context it is used
func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcn) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcn) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "dcn" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcn) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcn) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRemotePortInlineDeviceInlineDcn
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks switch port inline remote port inline device inline dcn inline links
//
// swagger:model switch_port_inline_remote_port_inline_device_inline_dcn_inline__links
type SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this switch port inline remote port inline device inline dcn inline links
func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "dcn" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch port inline remote port inline device inline dcn inline links based on the context it is used
func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "dcn" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRemotePortInlineDeviceInlineDcnInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRemotePortInlineDeviceInlineNode switch port inline remote port inline device inline node
//
// swagger:model switch_port_inline_remote_port_inline_device_inline_node
type SwitchPortInlineRemotePortInlineDeviceInlineNode struct {

	// links
	Links *SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this switch port inline remote port inline device inline node
func (m *SwitchPortInlineRemotePortInlineDeviceInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch port inline remote port inline device inline node based on the context it is used
func (m *SwitchPortInlineRemotePortInlineDeviceInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineNode) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRemotePortInlineDeviceInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks switch port inline remote port inline device inline node inline links
//
// swagger:model switch_port_inline_remote_port_inline_device_inline_node_inline__links
type SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this switch port inline remote port inline device inline node inline links
func (m *SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch port inline remote port inline device inline node inline links based on the context it is used
func (m *SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRemotePortInlineDeviceInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRemotePortInlineDeviceInlineShelf Shelf connected to this port.
//
// swagger:model switch_port_inline_remote_port_inline_device_inline_shelf
type SwitchPortInlineRemotePortInlineDeviceInlineShelf struct {

	// links
	Links *SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks `json:"_links,omitempty"`

	// Shelf module connected to this port.
	// Enum: ["A","B"]
	Module *string `json:"module,omitempty"`

	// name
	// Example: 1.1
	Name *string `json:"name,omitempty"`

	// uid
	// Example: 12439000444923584512
	UID *string `json:"uid,omitempty"`
}

// Validate validates this switch port inline remote port inline device inline shelf
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelf) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateModule(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelf) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "shelf" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var switchPortInlineRemotePortInlineDeviceInlineShelfTypeModulePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["A","B"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchPortInlineRemotePortInlineDeviceInlineShelfTypeModulePropEnum = append(switchPortInlineRemotePortInlineDeviceInlineShelfTypeModulePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch_port_inline_remote_port_inline_device_inline_shelf
	// SwitchPortInlineRemotePortInlineDeviceInlineShelf
	// module
	// Module
	// A
	// END DEBUGGING
	// SwitchPortInlineRemotePortInlineDeviceInlineShelfModuleA captures enum value "A"
	SwitchPortInlineRemotePortInlineDeviceInlineShelfModuleA string = "A"

	// BEGIN DEBUGGING
	// switch_port_inline_remote_port_inline_device_inline_shelf
	// SwitchPortInlineRemotePortInlineDeviceInlineShelf
	// module
	// Module
	// B
	// END DEBUGGING
	// SwitchPortInlineRemotePortInlineDeviceInlineShelfModuleB captures enum value "B"
	SwitchPortInlineRemotePortInlineDeviceInlineShelfModuleB string = "B"
)

// prop value enum
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelf) validateModuleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchPortInlineRemotePortInlineDeviceInlineShelfTypeModulePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelf) validateModule(formats strfmt.Registry) error {
	if swag.IsZero(m.Module) { // not required
		return nil
	}

	// value enum
	if err := m.validateModuleEnum("remote_port"+"."+"device"+"."+"shelf"+"."+"module", "body", *m.Module); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this switch port inline remote port inline device inline shelf based on the context it is used
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelf) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "shelf" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelf) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelf) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRemotePortInlineDeviceInlineShelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks switch port inline remote port inline device inline shelf inline links
//
// swagger:model switch_port_inline_remote_port_inline_device_inline_shelf_inline__links
type SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this switch port inline remote port inline device inline shelf inline links
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "shelf" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch port inline remote port inline device inline shelf inline links based on the context it is used
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_port" + "." + "device" + "." + "shelf" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRemotePortInlineDeviceInlineShelfInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineRolesInlineArrayItem Allowed use for this port.
//
// swagger:model switch_port_inline_roles_inline_array_item
type SwitchPortInlineRolesInlineArrayItem struct {

	// DR group.
	DrGroup *string `json:"dr_group,omitempty"`

	// Allowed use type.
	// Enum: ["cluster","storage","metrocluster","local_isl","remote_isl","vpc_peer_link"]
	Type *string `json:"type,omitempty"`

	// Zone ID to differentiate between roles with the same type.
	// Minimum: 1
	Zone *int64 `json:"zone,omitempty"`
}

// Validate validates this switch port inline roles inline array item
func (m *SwitchPortInlineRolesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateZone(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var switchPortInlineRolesInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","storage","metrocluster","local_isl","remote_isl","vpc_peer_link"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		switchPortInlineRolesInlineArrayItemTypeTypePropEnum = append(switchPortInlineRolesInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// switch_port_inline_roles_inline_array_item
	// SwitchPortInlineRolesInlineArrayItem
	// type
	// Type
	// cluster
	// END DEBUGGING
	// SwitchPortInlineRolesInlineArrayItemTypeCluster captures enum value "cluster"
	SwitchPortInlineRolesInlineArrayItemTypeCluster string = "cluster"

	// BEGIN DEBUGGING
	// switch_port_inline_roles_inline_array_item
	// SwitchPortInlineRolesInlineArrayItem
	// type
	// Type
	// storage
	// END DEBUGGING
	// SwitchPortInlineRolesInlineArrayItemTypeStorage captures enum value "storage"
	SwitchPortInlineRolesInlineArrayItemTypeStorage string = "storage"

	// BEGIN DEBUGGING
	// switch_port_inline_roles_inline_array_item
	// SwitchPortInlineRolesInlineArrayItem
	// type
	// Type
	// metrocluster
	// END DEBUGGING
	// SwitchPortInlineRolesInlineArrayItemTypeMetrocluster captures enum value "metrocluster"
	SwitchPortInlineRolesInlineArrayItemTypeMetrocluster string = "metrocluster"

	// BEGIN DEBUGGING
	// switch_port_inline_roles_inline_array_item
	// SwitchPortInlineRolesInlineArrayItem
	// type
	// Type
	// local_isl
	// END DEBUGGING
	// SwitchPortInlineRolesInlineArrayItemTypeLocalIsl captures enum value "local_isl"
	SwitchPortInlineRolesInlineArrayItemTypeLocalIsl string = "local_isl"

	// BEGIN DEBUGGING
	// switch_port_inline_roles_inline_array_item
	// SwitchPortInlineRolesInlineArrayItem
	// type
	// Type
	// remote_isl
	// END DEBUGGING
	// SwitchPortInlineRolesInlineArrayItemTypeRemoteIsl captures enum value "remote_isl"
	SwitchPortInlineRolesInlineArrayItemTypeRemoteIsl string = "remote_isl"

	// BEGIN DEBUGGING
	// switch_port_inline_roles_inline_array_item
	// SwitchPortInlineRolesInlineArrayItem
	// type
	// Type
	// vpc_peer_link
	// END DEBUGGING
	// SwitchPortInlineRolesInlineArrayItemTypeVpcPeerLink captures enum value "vpc_peer_link"
	SwitchPortInlineRolesInlineArrayItemTypeVpcPeerLink string = "vpc_peer_link"
)

// prop value enum
func (m *SwitchPortInlineRolesInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, switchPortInlineRolesInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SwitchPortInlineRolesInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPortInlineRolesInlineArrayItem) validateZone(formats strfmt.Registry) error {
	if swag.IsZero(m.Zone) { // not required
		return nil
	}

	if err := validate.MinimumInt("zone", "body", *m.Zone, 1, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this switch port inline roles inline array item based on context it is used
func (m *SwitchPortInlineRolesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineRolesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineRolesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineRolesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineStatistics These are raw counters for the device associated with the Ethernet port.
//
// swagger:model switch_port_inline_statistics
type SwitchPortInlineStatistics struct {

	// receive raw
	ReceiveRaw *SwitchPortInlineStatisticsInlineReceiveRaw `json:"receive_raw,omitempty"`

	// The time the statistics were gathered.
	// Example: 2024-11-18 15:52:17+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// transmit raw
	TransmitRaw *SwitchPortInlineStatisticsInlineTransmitRaw `json:"transmit_raw,omitempty"`
}

// Validate validates this switch port inline statistics
func (m *SwitchPortInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReceiveRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransmitRaw(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineStatistics) validateReceiveRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ReceiveRaw) { // not required
		return nil
	}

	if m.ReceiveRaw != nil {
		if err := m.ReceiveRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "receive_raw")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SwitchPortInlineStatistics) validateTransmitRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.TransmitRaw) { // not required
		return nil
	}

	if m.TransmitRaw != nil {
		if err := m.TransmitRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "transmit_raw")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch port inline statistics based on the context it is used
func (m *SwitchPortInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReceiveRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransmitRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineStatistics) contextValidateReceiveRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ReceiveRaw != nil {
		if err := m.ReceiveRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "receive_raw")
			}
			return err
		}
	}

	return nil
}

func (m *SwitchPortInlineStatistics) contextValidateTransmitRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.TransmitRaw != nil {
		if err := m.TransmitRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "transmit_raw")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineStatistics) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineStatisticsInlineReceiveRaw Packet receive counters for the Ethernet port.
//
// swagger:model switch_port_inline_statistics_inline_receive_raw
type SwitchPortInlineStatisticsInlineReceiveRaw struct {

	// Total number of discarded packets.
	// Example: 100
	Discards *int64 `json:"discards,omitempty"`

	// Number of packet errors.
	// Example: 200
	Errors *int64 `json:"errors,omitempty"`

	// Total packet count.
	// Example: 500
	Packets *int64 `json:"packets,omitempty"`
}

// Validate validates this switch port inline statistics inline receive raw
func (m *SwitchPortInlineStatisticsInlineReceiveRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this switch port inline statistics inline receive raw based on context it is used
func (m *SwitchPortInlineStatisticsInlineReceiveRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineStatisticsInlineReceiveRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineStatisticsInlineReceiveRaw) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineStatisticsInlineReceiveRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineStatisticsInlineTransmitRaw Packet transmit counters for the Ethernet port.
//
// swagger:model switch_port_inline_statistics_inline_transmit_raw
type SwitchPortInlineStatisticsInlineTransmitRaw struct {

	// Total number of discarded packets.
	// Example: 100
	Discards *int64 `json:"discards,omitempty"`

	// Number of packet errors.
	// Example: 200
	Errors *int64 `json:"errors,omitempty"`

	// Total packet count.
	// Example: 500
	Packets *int64 `json:"packets,omitempty"`
}

// Validate validates this switch port inline statistics inline transmit raw
func (m *SwitchPortInlineStatisticsInlineTransmitRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this switch port inline statistics inline transmit raw based on context it is used
func (m *SwitchPortInlineStatisticsInlineTransmitRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineStatisticsInlineTransmitRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineStatisticsInlineTransmitRaw) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineStatisticsInlineTransmitRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SwitchPortInlineSwitch The name of the specified cluster or storage switch.
//
// swagger:model switch_port_inline_switch
type SwitchPortInlineSwitch struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// name
	// Example: RTP-SS01-510R03(FOC223443KQ)
	Name *string `json:"name,omitempty"`
}

// Validate validates this switch port inline switch
func (m *SwitchPortInlineSwitch) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineSwitch) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("switch" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this switch port inline switch based on the context it is used
func (m *SwitchPortInlineSwitch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SwitchPortInlineSwitch) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("switch" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SwitchPortInlineSwitch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SwitchPortInlineSwitch) UnmarshalBinary(b []byte) error {
	var res SwitchPortInlineSwitch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
