// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// TimezoneCluster Provides the cluster-wide time zone information that localizes time found on messages displayed on each node's:
// * console messages;
// * logging to internal ONTAP log files; and
// * localized REST API full ISO-8601 date, time, and time zone format information.
// Machine-to-machine interfaces, such as file access protocols (NFS, CIFS), block access protocols (SAN), and other protocols
// such as Manage ONTAP (ONTAPI), use second or subsecond time values that are based on world time or UTC.
//
// swagger:model timezone_cluster
type TimezoneCluster struct {

	// The ONTAP time zone name or identification in either IANA time zone format "Area/Location", or an ONTAP traditional time zone.
	// </br>
	// The initial first node in cluster setting for time zone is "Etc/UTC".
	// "Etc/UTC" is the IANA timezone "Area/Location" specifier for
	// Coordinated Universal Time (UTC), which is an offset of 0.
	// ### IANA time zone format
	// The IANA time zone, formatted as "Area/Location", is based on geographic areas that have had the same time zone offset for many years.
	// </br>
	// "Location" represents a compound name using additional forward slashes.
	// </br>
	// An example of the "Area/Location" time zone is "America/New_York" and represents most of the United States Eastern Time Zone.
	// Examples of "Area/Location" with "Location" as a compound name are "America/Argentina/Buenos_Aires" and "America/Indiana/Indianapolis".
	// ### ONTAP traditional time zone
	// Examples of the traditional time zones are "EST5EDT" for the United States Eastern Time Zone and "CET" for Central European Time Zone.
	//
	// Example: America/New_York
	Name *string `json:"name,omitempty"`
}

// Validate validates this timezone cluster
func (m *TimezoneCluster) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this timezone cluster based on context it is used
func (m *TimezoneCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TimezoneCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TimezoneCluster) UnmarshalBinary(b []byte) error {
	var res TimezoneCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
