// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TLS Cluster-wide Transport Layer Security (TLS) configuration information
//
// swagger:model tls
type TLS struct {

	// Names a TLS protocol version that the system can select during TLS handshakes. The use of SSLv3 or TLSv1 is discouraged.
	ProtocolVersions []*string `json:"protocol_versions,omitempty"`

	// Names a cipher suite that the system can select during TLS handshakes. A list of available options can be found on the Internet Assigned Number Authority (IANA) website.
	TLSInlineCipherSuites []*string `json:"cipher_suites,omitempty"`
}

// Validate validates this tls
func (m *TLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProtocolVersions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var tlsProtocolVersionsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSLv3","TLSv1","TLSv1.1","TLSv1.2","TLSv1.3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tlsProtocolVersionsItemsEnum = append(tlsProtocolVersionsItemsEnum, v)
	}
}

func (m *TLS) validateProtocolVersionsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tlsProtocolVersionsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TLS) validateProtocolVersions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtocolVersions) { // not required
		return nil
	}

	for i := 0; i < len(m.ProtocolVersions); i++ {
		if swag.IsZero(m.ProtocolVersions[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateProtocolVersionsItemsEnum("protocol_versions"+"."+strconv.Itoa(i), "body", *m.ProtocolVersions[i]); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validates this tls based on context it is used
func (m *TLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TLS) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TLS) UnmarshalBinary(b []byte) error {
	var res TLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
