// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TopMetricsDirectoryResponse top metrics directory response
//
// swagger:model top_metrics_directory_response
type TopMetricsDirectoryResponse struct {

	// links
	Links *TopMetricsDirectoryResponseInlineLinks `json:"_links,omitempty"`

	// incomplete response reason
	IncompleteResponseReason *TopMetricsDirectoryResponseInlineIncompleteResponseReason `json:"incomplete_response_reason,omitempty"`

	// notice
	Notice *TopMetricsDirectoryResponseInlineNotice `json:"notice,omitempty"`

	// Number of records.
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// partial response reason
	PartialResponseReason *TopMetricsDirectoryResponseInlinePartialResponseReason `json:"partial_response_reason,omitempty"`

	// top metrics directory response inline records
	TopMetricsDirectoryResponseInlineRecords []*TopMetricsDirectory `json:"records,omitempty"`
}

// Validate validates this top metrics directory response
func (m *TopMetricsDirectoryResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIncompleteResponseReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNotice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartialResponseReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTopMetricsDirectoryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsDirectoryResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponse) validateIncompleteResponseReason(formats strfmt.Registry) error {
	if swag.IsZero(m.IncompleteResponseReason) { // not required
		return nil
	}

	if m.IncompleteResponseReason != nil {
		if err := m.IncompleteResponseReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("incomplete_response_reason")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponse) validateNotice(formats strfmt.Registry) error {
	if swag.IsZero(m.Notice) { // not required
		return nil
	}

	if m.Notice != nil {
		if err := m.Notice.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("notice")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponse) validatePartialResponseReason(formats strfmt.Registry) error {
	if swag.IsZero(m.PartialResponseReason) { // not required
		return nil
	}

	if m.PartialResponseReason != nil {
		if err := m.PartialResponseReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partial_response_reason")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponse) validateTopMetricsDirectoryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.TopMetricsDirectoryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.TopMetricsDirectoryResponseInlineRecords); i++ {
		if swag.IsZero(m.TopMetricsDirectoryResponseInlineRecords[i]) { // not required
			continue
		}

		if m.TopMetricsDirectoryResponseInlineRecords[i] != nil {
			if err := m.TopMetricsDirectoryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this top metrics directory response based on the context it is used
func (m *TopMetricsDirectoryResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIncompleteResponseReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNotice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartialResponseReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTopMetricsDirectoryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsDirectoryResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponse) contextValidateIncompleteResponseReason(ctx context.Context, formats strfmt.Registry) error {

	if m.IncompleteResponseReason != nil {
		if err := m.IncompleteResponseReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("incomplete_response_reason")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponse) contextValidateNotice(ctx context.Context, formats strfmt.Registry) error {

	if m.Notice != nil {
		if err := m.Notice.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("notice")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponse) contextValidatePartialResponseReason(ctx context.Context, formats strfmt.Registry) error {

	if m.PartialResponseReason != nil {
		if err := m.PartialResponseReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partial_response_reason")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponse) contextValidateTopMetricsDirectoryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TopMetricsDirectoryResponseInlineRecords); i++ {

		if m.TopMetricsDirectoryResponseInlineRecords[i] != nil {
			if err := m.TopMetricsDirectoryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsDirectoryResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsDirectoryResponse) UnmarshalBinary(b []byte) error {
	var res TopMetricsDirectoryResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsDirectoryResponseInlineIncompleteResponseReason Indicates that the metric report provides incomplete data.
//
// swagger:model top_metrics_directory_response_inline_incomplete_response_reason
type TopMetricsDirectoryResponseInlineIncompleteResponseReason struct {

	// Warning code indicating why partial data was reported.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// A message describing the reason for partial data.
	// Example: Partial data has been returned for this metric report. Reason: Data collection for the large directory report is in progress.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this top metrics directory response inline incomplete response reason
func (m *TopMetricsDirectoryResponseInlineIncompleteResponseReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this top metrics directory response inline incomplete response reason based on the context it is used
func (m *TopMetricsDirectoryResponseInlineIncompleteResponseReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsDirectoryResponseInlineIncompleteResponseReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "incomplete_response_reason"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *TopMetricsDirectoryResponseInlineIncompleteResponseReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "incomplete_response_reason"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsDirectoryResponseInlineIncompleteResponseReason) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsDirectoryResponseInlineIncompleteResponseReason) UnmarshalBinary(b []byte) error {
	var res TopMetricsDirectoryResponseInlineIncompleteResponseReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsDirectoryResponseInlineLinks top metrics directory response inline links
//
// swagger:model top_metrics_directory_response_inline__links
type TopMetricsDirectoryResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this top metrics directory response inline links
func (m *TopMetricsDirectoryResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsDirectoryResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this top metrics directory response inline links based on the context it is used
func (m *TopMetricsDirectoryResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsDirectoryResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsDirectoryResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsDirectoryResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsDirectoryResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res TopMetricsDirectoryResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsDirectoryResponseInlineNotice Optional field that indicates why no records are returned by the volume activity tracking REST API.
//
// swagger:model top_metrics_directory_response_inline_notice
type TopMetricsDirectoryResponseInlineNotice struct {

	// Warning code indicating why no records are returned.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Details why no records are returned.
	// Example: No read/write traffic on volume.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this top metrics directory response inline notice
func (m *TopMetricsDirectoryResponseInlineNotice) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this top metrics directory response inline notice based on the context it is used
func (m *TopMetricsDirectoryResponseInlineNotice) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsDirectoryResponseInlineNotice) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "notice"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *TopMetricsDirectoryResponseInlineNotice) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "notice"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsDirectoryResponseInlineNotice) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsDirectoryResponseInlineNotice) UnmarshalBinary(b []byte) error {
	var res TopMetricsDirectoryResponseInlineNotice
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsDirectoryResponseInlinePartialResponseReason Indicates that the metric report provides partial data.
//
// swagger:model top_metrics_directory_response_inline_partial_response_reason
type TopMetricsDirectoryResponseInlinePartialResponseReason struct {

	// Warning code indicating why partial data was reported.
	// Example: 124518424
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// A message describing the reason for partial data.
	// Example: The top metrics report contains partial data for read operations because NFSv4 reads using Multi-Processor I/O (MPIO) are not tracked.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this top metrics directory response inline partial response reason
func (m *TopMetricsDirectoryResponseInlinePartialResponseReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this top metrics directory response inline partial response reason based on the context it is used
func (m *TopMetricsDirectoryResponseInlinePartialResponseReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsDirectoryResponseInlinePartialResponseReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "partial_response_reason"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *TopMetricsDirectoryResponseInlinePartialResponseReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "partial_response_reason"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsDirectoryResponseInlinePartialResponseReason) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsDirectoryResponseInlinePartialResponseReason) UnmarshalBinary(b []byte) error {
	var res TopMetricsDirectoryResponseInlinePartialResponseReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
