// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TopMetricsSvmClientResponse top metrics svm client response
//
// swagger:model top_metrics_svm_client_response
type TopMetricsSvmClientResponse struct {

	// links
	Links *TopMetricsSvmClientResponseInlineLinks `json:"_links,omitempty"`

	// notice
	Notice *TopMetricsSvmClientResponseInlineNotice `json:"notice,omitempty"`

	// Number of records.
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// partial response reason
	PartialResponseReason *TopMetricsSvmClientResponseInlinePartialResponseReason `json:"partial_response_reason,omitempty"`

	// List of volumes that are not included in the SVM activity tracking REST API.
	TopMetricsSvmClientResponseInlineExcludedVolumes []*TopMetricsSvmClientExcludedVolume `json:"excluded_volumes,omitempty"`

	// top metrics svm client response inline records
	TopMetricsSvmClientResponseInlineRecords []*TopMetricsSvmClient `json:"records,omitempty"`
}

// Validate validates this top metrics svm client response
func (m *TopMetricsSvmClientResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNotice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartialResponseReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTopMetricsSvmClientResponseInlineExcludedVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTopMetricsSvmClientResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmClientResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmClientResponse) validateNotice(formats strfmt.Registry) error {
	if swag.IsZero(m.Notice) { // not required
		return nil
	}

	if m.Notice != nil {
		if err := m.Notice.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("notice")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmClientResponse) validatePartialResponseReason(formats strfmt.Registry) error {
	if swag.IsZero(m.PartialResponseReason) { // not required
		return nil
	}

	if m.PartialResponseReason != nil {
		if err := m.PartialResponseReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partial_response_reason")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmClientResponse) validateTopMetricsSvmClientResponseInlineExcludedVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.TopMetricsSvmClientResponseInlineExcludedVolumes) { // not required
		return nil
	}

	for i := 0; i < len(m.TopMetricsSvmClientResponseInlineExcludedVolumes); i++ {
		if swag.IsZero(m.TopMetricsSvmClientResponseInlineExcludedVolumes[i]) { // not required
			continue
		}

		if m.TopMetricsSvmClientResponseInlineExcludedVolumes[i] != nil {
			if err := m.TopMetricsSvmClientResponseInlineExcludedVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("excluded_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TopMetricsSvmClientResponse) validateTopMetricsSvmClientResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.TopMetricsSvmClientResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.TopMetricsSvmClientResponseInlineRecords); i++ {
		if swag.IsZero(m.TopMetricsSvmClientResponseInlineRecords[i]) { // not required
			continue
		}

		if m.TopMetricsSvmClientResponseInlineRecords[i] != nil {
			if err := m.TopMetricsSvmClientResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this top metrics svm client response based on the context it is used
func (m *TopMetricsSvmClientResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNotice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartialResponseReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTopMetricsSvmClientResponseInlineExcludedVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTopMetricsSvmClientResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmClientResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmClientResponse) contextValidateNotice(ctx context.Context, formats strfmt.Registry) error {

	if m.Notice != nil {
		if err := m.Notice.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("notice")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmClientResponse) contextValidatePartialResponseReason(ctx context.Context, formats strfmt.Registry) error {

	if m.PartialResponseReason != nil {
		if err := m.PartialResponseReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partial_response_reason")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmClientResponse) contextValidateTopMetricsSvmClientResponseInlineExcludedVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TopMetricsSvmClientResponseInlineExcludedVolumes); i++ {

		if m.TopMetricsSvmClientResponseInlineExcludedVolumes[i] != nil {
			if err := m.TopMetricsSvmClientResponseInlineExcludedVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("excluded_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TopMetricsSvmClientResponse) contextValidateTopMetricsSvmClientResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TopMetricsSvmClientResponseInlineRecords); i++ {

		if m.TopMetricsSvmClientResponseInlineRecords[i] != nil {
			if err := m.TopMetricsSvmClientResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsSvmClientResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsSvmClientResponse) UnmarshalBinary(b []byte) error {
	var res TopMetricsSvmClientResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsSvmClientResponseInlineLinks top metrics svm client response inline links
//
// swagger:model top_metrics_svm_client_response_inline__links
type TopMetricsSvmClientResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this top metrics svm client response inline links
func (m *TopMetricsSvmClientResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmClientResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmClientResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this top metrics svm client response inline links based on the context it is used
func (m *TopMetricsSvmClientResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmClientResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmClientResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsSvmClientResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsSvmClientResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res TopMetricsSvmClientResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsSvmClientResponseInlineNotice Optional field that indicates why no records are returned by the SVM activity tracking REST API.
//
// swagger:model top_metrics_svm_client_response_inline_notice
type TopMetricsSvmClientResponseInlineNotice struct {

	// Warning code indicating why no records are returned.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Details why no records are returned.
	// Example: The volume is offline.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this top metrics svm client response inline notice
func (m *TopMetricsSvmClientResponseInlineNotice) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this top metrics svm client response inline notice based on the context it is used
func (m *TopMetricsSvmClientResponseInlineNotice) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmClientResponseInlineNotice) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "notice"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *TopMetricsSvmClientResponseInlineNotice) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "notice"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsSvmClientResponseInlineNotice) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsSvmClientResponseInlineNotice) UnmarshalBinary(b []byte) error {
	var res TopMetricsSvmClientResponseInlineNotice
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsSvmClientResponseInlinePartialResponseReason Indicates that the metric report provides partial data.
//
// swagger:model top_metrics_svm_client_response_inline_partial_response_reason
type TopMetricsSvmClientResponseInlinePartialResponseReason struct {

	// Warning code indicating why partial data was reported.
	// Example: 124518424
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// A message describing the reason for partial data.
	// Example: The top metrics report contains partial data for read operations because NFSv4 reads using Multi-Processor I/O (MPIO) are not tracked.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this top metrics svm client response inline partial response reason
func (m *TopMetricsSvmClientResponseInlinePartialResponseReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this top metrics svm client response inline partial response reason based on the context it is used
func (m *TopMetricsSvmClientResponseInlinePartialResponseReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmClientResponseInlinePartialResponseReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "partial_response_reason"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *TopMetricsSvmClientResponseInlinePartialResponseReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "partial_response_reason"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsSvmClientResponseInlinePartialResponseReason) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsSvmClientResponseInlinePartialResponseReason) UnmarshalBinary(b []byte) error {
	var res TopMetricsSvmClientResponseInlinePartialResponseReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
