// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TopMetricsSvmUserResponse top metrics svm user response
//
// swagger:model top_metrics_svm_user_response
type TopMetricsSvmUserResponse struct {

	// links
	Links *TopMetricsSvmUserResponseInlineLinks `json:"_links,omitempty"`

	// notice
	Notice *TopMetricsSvmUserResponseInlineNotice `json:"notice,omitempty"`

	// Number of records.
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// partial response reason
	PartialResponseReason *TopMetricsSvmUserResponseInlinePartialResponseReason `json:"partial_response_reason,omitempty"`

	// List of volumes that are not included in the SVM activity tracking REST API.
	TopMetricsSvmUserResponseInlineExcludedVolumes []*TopMetricsSvmUserExcludedVolume `json:"excluded_volumes,omitempty"`

	// top metrics svm user response inline records
	TopMetricsSvmUserResponseInlineRecords []*TopMetricsSvmUser `json:"records,omitempty"`
}

// Validate validates this top metrics svm user response
func (m *TopMetricsSvmUserResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNotice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartialResponseReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTopMetricsSvmUserResponseInlineExcludedVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTopMetricsSvmUserResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmUserResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmUserResponse) validateNotice(formats strfmt.Registry) error {
	if swag.IsZero(m.Notice) { // not required
		return nil
	}

	if m.Notice != nil {
		if err := m.Notice.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("notice")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmUserResponse) validatePartialResponseReason(formats strfmt.Registry) error {
	if swag.IsZero(m.PartialResponseReason) { // not required
		return nil
	}

	if m.PartialResponseReason != nil {
		if err := m.PartialResponseReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partial_response_reason")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmUserResponse) validateTopMetricsSvmUserResponseInlineExcludedVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.TopMetricsSvmUserResponseInlineExcludedVolumes) { // not required
		return nil
	}

	for i := 0; i < len(m.TopMetricsSvmUserResponseInlineExcludedVolumes); i++ {
		if swag.IsZero(m.TopMetricsSvmUserResponseInlineExcludedVolumes[i]) { // not required
			continue
		}

		if m.TopMetricsSvmUserResponseInlineExcludedVolumes[i] != nil {
			if err := m.TopMetricsSvmUserResponseInlineExcludedVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("excluded_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TopMetricsSvmUserResponse) validateTopMetricsSvmUserResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.TopMetricsSvmUserResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.TopMetricsSvmUserResponseInlineRecords); i++ {
		if swag.IsZero(m.TopMetricsSvmUserResponseInlineRecords[i]) { // not required
			continue
		}

		if m.TopMetricsSvmUserResponseInlineRecords[i] != nil {
			if err := m.TopMetricsSvmUserResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this top metrics svm user response based on the context it is used
func (m *TopMetricsSvmUserResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNotice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartialResponseReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTopMetricsSvmUserResponseInlineExcludedVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTopMetricsSvmUserResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmUserResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmUserResponse) contextValidateNotice(ctx context.Context, formats strfmt.Registry) error {

	if m.Notice != nil {
		if err := m.Notice.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("notice")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmUserResponse) contextValidatePartialResponseReason(ctx context.Context, formats strfmt.Registry) error {

	if m.PartialResponseReason != nil {
		if err := m.PartialResponseReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partial_response_reason")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmUserResponse) contextValidateTopMetricsSvmUserResponseInlineExcludedVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TopMetricsSvmUserResponseInlineExcludedVolumes); i++ {

		if m.TopMetricsSvmUserResponseInlineExcludedVolumes[i] != nil {
			if err := m.TopMetricsSvmUserResponseInlineExcludedVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("excluded_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TopMetricsSvmUserResponse) contextValidateTopMetricsSvmUserResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TopMetricsSvmUserResponseInlineRecords); i++ {

		if m.TopMetricsSvmUserResponseInlineRecords[i] != nil {
			if err := m.TopMetricsSvmUserResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsSvmUserResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsSvmUserResponse) UnmarshalBinary(b []byte) error {
	var res TopMetricsSvmUserResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsSvmUserResponseInlineLinks top metrics svm user response inline links
//
// swagger:model top_metrics_svm_user_response_inline__links
type TopMetricsSvmUserResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this top metrics svm user response inline links
func (m *TopMetricsSvmUserResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmUserResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmUserResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this top metrics svm user response inline links based on the context it is used
func (m *TopMetricsSvmUserResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmUserResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *TopMetricsSvmUserResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsSvmUserResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsSvmUserResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res TopMetricsSvmUserResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsSvmUserResponseInlineNotice Optional field that indicates why no records are returned by the SVM activity tracking REST API.
//
// swagger:model top_metrics_svm_user_response_inline_notice
type TopMetricsSvmUserResponseInlineNotice struct {

	// Warning code indicating why no records are returned.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Details why no records are returned.
	// Example: The volume is offline.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this top metrics svm user response inline notice
func (m *TopMetricsSvmUserResponseInlineNotice) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this top metrics svm user response inline notice based on the context it is used
func (m *TopMetricsSvmUserResponseInlineNotice) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmUserResponseInlineNotice) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "notice"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *TopMetricsSvmUserResponseInlineNotice) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "notice"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsSvmUserResponseInlineNotice) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsSvmUserResponseInlineNotice) UnmarshalBinary(b []byte) error {
	var res TopMetricsSvmUserResponseInlineNotice
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TopMetricsSvmUserResponseInlinePartialResponseReason Indicates that the metric report provides partial data.
//
// swagger:model top_metrics_svm_user_response_inline_partial_response_reason
type TopMetricsSvmUserResponseInlinePartialResponseReason struct {

	// Warning code indicating why partial data was reported.
	// Example: 124518424
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// A message describing the reason for partial data.
	// Example: The top metrics report contains partial data for read operations because NFSv4 reads using Multi-Processor I/O (MPIO) are not tracked.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this top metrics svm user response inline partial response reason
func (m *TopMetricsSvmUserResponseInlinePartialResponseReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this top metrics svm user response inline partial response reason based on the context it is used
func (m *TopMetricsSvmUserResponseInlinePartialResponseReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TopMetricsSvmUserResponseInlinePartialResponseReason) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "partial_response_reason"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *TopMetricsSvmUserResponseInlinePartialResponseReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "partial_response_reason"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TopMetricsSvmUserResponseInlinePartialResponseReason) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TopMetricsSvmUserResponseInlinePartialResponseReason) UnmarshalBinary(b []byte) error {
	var res TopMetricsSvmUserResponseInlinePartialResponseReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
