// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TotpPost Response object of the TOTP profile creation.
//
// swagger:model totp_post
type TotpPost struct {

	// links
	Links *TotpPostInlineLinks `json:"_links,omitempty"`

	// account
	Account *AccountReference `json:"account,omitempty"`

	// Optional comment for the TOTP profile.
	Comment *string `json:"comment,omitempty"`

	// Status of the TOTP profile.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// TOTP profile installation URL for a user.
	// Read Only: true
	InstallURL *string `json:"install_url,omitempty"`

	// owner
	Owner *TotpPostInlineOwner `json:"owner,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// TOTP profile secret key for a user.
	// Read Only: true
	SecretKey *string `json:"secret_key,omitempty"`

	// SHA fingerprint for the TOTP secret key.
	// Read Only: true
	ShaFingerprint *string `json:"sha_fingerprint,omitempty"`

	// TOTP profile emergency codes for a user. These codes are for emergency use when a user cannot access 2FA codes through other means.
	// Example: 17503785
	// Read Only: true
	TotpPostInlineEmergencyCodes []*string `json:"emergency_codes,omitempty"`

	// TOTP profile verification code for a user.
	// Read Only: true
	VerificationCode *string `json:"verification_code,omitempty"`
}

// Validate validates this totp post
func (m *TotpPost) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TotpPost) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *TotpPost) validateAccount(formats strfmt.Registry) error {
	if swag.IsZero(m.Account) { // not required
		return nil
	}

	if m.Account != nil {
		if err := m.Account.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("account")
			}
			return err
		}
	}

	return nil
}

func (m *TotpPost) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

var totpPostTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		totpPostTypeScopePropEnum = append(totpPostTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// totp_post
	// TotpPost
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// TotpPostScopeCluster captures enum value "cluster"
	TotpPostScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// totp_post
	// TotpPost
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// TotpPostScopeSvm captures enum value "svm"
	TotpPostScopeSvm string = "svm"
)

// prop value enum
func (m *TotpPost) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, totpPostTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TotpPost) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this totp post based on the context it is used
func (m *TotpPost) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInstallURL(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecretKey(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShaFingerprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotpPostInlineEmergencyCodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVerificationCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TotpPost) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *TotpPost) contextValidateAccount(ctx context.Context, formats strfmt.Registry) error {

	if m.Account != nil {
		if err := m.Account.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("account")
			}
			return err
		}
	}

	return nil
}

func (m *TotpPost) contextValidateInstallURL(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "install_url", "body", m.InstallURL); err != nil {
		return err
	}

	return nil
}

func (m *TotpPost) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *TotpPost) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *TotpPost) contextValidateSecretKey(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "secret_key", "body", m.SecretKey); err != nil {
		return err
	}

	return nil
}

func (m *TotpPost) contextValidateShaFingerprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "sha_fingerprint", "body", m.ShaFingerprint); err != nil {
		return err
	}

	return nil
}

func (m *TotpPost) contextValidateTotpPostInlineEmergencyCodes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "emergency_codes", "body", []*string(m.TotpPostInlineEmergencyCodes)); err != nil {
		return err
	}

	return nil
}

func (m *TotpPost) contextValidateVerificationCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "verification_code", "body", m.VerificationCode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TotpPost) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TotpPost) UnmarshalBinary(b []byte) error {
	var res TotpPost
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TotpPostInlineLinks totp post inline links
//
// swagger:model totp_post_inline__links
type TotpPostInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this totp post inline links
func (m *TotpPostInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TotpPostInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this totp post inline links based on the context it is used
func (m *TotpPostInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TotpPostInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TotpPostInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TotpPostInlineLinks) UnmarshalBinary(b []byte) error {
	var res TotpPostInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TotpPostInlineOwner Owner name and UUID that uniquely identifies the TOTP profile.
//
// swagger:model totp_post_inline_owner
type TotpPostInlineOwner struct {

	// links
	Links *TotpPostInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this totp post inline owner
func (m *TotpPostInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TotpPostInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this totp post inline owner based on the context it is used
func (m *TotpPostInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TotpPostInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TotpPostInlineOwner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TotpPostInlineOwner) UnmarshalBinary(b []byte) error {
	var res TotpPostInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TotpPostInlineOwnerInlineLinks totp post inline owner inline links
//
// swagger:model totp_post_inline_owner_inline__links
type TotpPostInlineOwnerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this totp post inline owner inline links
func (m *TotpPostInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TotpPostInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this totp post inline owner inline links based on the context it is used
func (m *TotpPostInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TotpPostInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TotpPostInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TotpPostInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res TotpPostInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
