// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// UniformResourceIdentifier uniform resource identifier
//
// swagger:model uniform_resource_identifier
type UniformResourceIdentifier struct {

	// Password of the specified URI.
	// Max Length: 128
	Password *string `json:"password,omitempty"`

	// URI from which to load the input file containing the CIFS local users and groups. The file must be encrypted using the 7zip utility. URI can be FTP or HTTP.
	// Example: http://web.sample.com/web1/file1.7z
	Path *string `json:"path,omitempty"`

	// Username of the specified URI.
	// Example: user1
	// Max Length: 128
	Username *string `json:"username,omitempty"`
}

// Validate validates this uniform resource identifier
func (m *UniformResourceIdentifier) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsername(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UniformResourceIdentifier) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.MaxLength("password", "body", *m.Password, 128); err != nil {
		return err
	}

	return nil
}

func (m *UniformResourceIdentifier) validateUsername(formats strfmt.Registry) error {
	if swag.IsZero(m.Username) { // not required
		return nil
	}

	if err := validate.MaxLength("username", "body", *m.Username, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this uniform resource identifier based on context it is used
func (m *UniformResourceIdentifier) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *UniformResourceIdentifier) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UniformResourceIdentifier) UnmarshalBinary(b []byte) error {
	var res UniformResourceIdentifier
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
