// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// UnixGroupUsers unix group users
//
// swagger:model unix_group_users
type UnixGroupUsers struct {

	// links
	Links *UnixGroupUsersInlineLinks `json:"_links,omitempty"`

	// UNIX user who belongs to the specified UNIX group and the SVM.
	//
	Name *string `json:"name,omitempty"`

	// Indicates whether or not the validation for the specified UNIX user names is disabled.
	SkipNameValidation *bool `json:"skip_name_validation,omitempty"`

	// svm
	Svm *UnixGroupUsersInlineSvm `json:"svm,omitempty"`

	// unix group
	UnixGroup *UnixGroupUsersInlineUnixGroup `json:"unix_group,omitempty"`

	// An array of UNIX users specified to add multiple users to a UNIX group in a single API call.
	// Not allowed when the `name` property is used.
	//
	UnixGroupUsersInlineRecords []*UnixGroupUsersInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this unix group users
func (m *UnixGroupUsers) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnixGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnixGroupUsersInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UnixGroupUsers) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *UnixGroupUsers) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *UnixGroupUsers) validateUnixGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.UnixGroup) { // not required
		return nil
	}

	if m.UnixGroup != nil {
		if err := m.UnixGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unix_group")
			}
			return err
		}
	}

	return nil
}

func (m *UnixGroupUsers) validateUnixGroupUsersInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.UnixGroupUsersInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.UnixGroupUsersInlineRecords); i++ {
		if swag.IsZero(m.UnixGroupUsersInlineRecords[i]) { // not required
			continue
		}

		if m.UnixGroupUsersInlineRecords[i] != nil {
			if err := m.UnixGroupUsersInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this unix group users based on the context it is used
func (m *UnixGroupUsers) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnixGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnixGroupUsersInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UnixGroupUsers) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *UnixGroupUsers) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *UnixGroupUsers) contextValidateUnixGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.UnixGroup != nil {
		if err := m.UnixGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unix_group")
			}
			return err
		}
	}

	return nil
}

func (m *UnixGroupUsers) contextValidateUnixGroupUsersInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.UnixGroupUsersInlineRecords); i++ {

		if m.UnixGroupUsersInlineRecords[i] != nil {
			if err := m.UnixGroupUsersInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *UnixGroupUsers) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UnixGroupUsers) UnmarshalBinary(b []byte) error {
	var res UnixGroupUsers
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UnixGroupUsersInlineLinks unix group users inline links
//
// swagger:model unix_group_users_inline__links
type UnixGroupUsersInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this unix group users inline links
func (m *UnixGroupUsersInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UnixGroupUsersInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix group users inline links based on the context it is used
func (m *UnixGroupUsersInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UnixGroupUsersInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *UnixGroupUsersInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UnixGroupUsersInlineLinks) UnmarshalBinary(b []byte) error {
	var res UnixGroupUsersInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UnixGroupUsersInlineRecordsInlineArrayItem unix group users inline records inline array item
//
// swagger:model unix_group_users_inline_records_inline_array_item
type UnixGroupUsersInlineRecordsInlineArrayItem struct {

	// UNIX user who belongs to the specified UNIX group and the SVM.
	//
	Name *string `json:"name,omitempty"`
}

// Validate validates this unix group users inline records inline array item
func (m *UnixGroupUsersInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this unix group users inline records inline array item based on context it is used
func (m *UnixGroupUsersInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *UnixGroupUsersInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UnixGroupUsersInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res UnixGroupUsersInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UnixGroupUsersInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model unix_group_users_inline_svm
type UnixGroupUsersInlineSvm struct {

	// links
	Links *UnixGroupUsersInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this unix group users inline svm
func (m *UnixGroupUsersInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UnixGroupUsersInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix group users inline svm based on the context it is used
func (m *UnixGroupUsersInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UnixGroupUsersInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *UnixGroupUsersInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UnixGroupUsersInlineSvm) UnmarshalBinary(b []byte) error {
	var res UnixGroupUsersInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UnixGroupUsersInlineSvmInlineLinks unix group users inline svm inline links
//
// swagger:model unix_group_users_inline_svm_inline__links
type UnixGroupUsersInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this unix group users inline svm inline links
func (m *UnixGroupUsersInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UnixGroupUsersInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix group users inline svm inline links based on the context it is used
func (m *UnixGroupUsersInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *UnixGroupUsersInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *UnixGroupUsersInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UnixGroupUsersInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res UnixGroupUsersInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// UnixGroupUsersInlineUnixGroup unix group users inline unix group
//
// swagger:model unix_group_users_inline_unix_group
type UnixGroupUsersInlineUnixGroup struct {

	// UNIX group name.
	Name *string `json:"name,omitempty"`
}

// Validate validates this unix group users inline unix group
func (m *UnixGroupUsersInlineUnixGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this unix group users inline unix group based on the context it is used
func (m *UnixGroupUsersInlineUnixGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *UnixGroupUsersInlineUnixGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *UnixGroupUsersInlineUnixGroup) UnmarshalBinary(b []byte) error {
	var res UnixGroupUsersInlineUnixGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
